/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.live;

import io.agora.rtc.video.AgoraImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LiveTranscoding {
    public static final String LBHQ = "lbhq";
    public static final String VEO = "veo";
    public int width = 360;
    public int height = 640;
    public int videoBitrate = 400;
    public int videoFramerate = 15;
    @Deprecated
    public boolean lowLatency = false;
    public int videoGop = 30;
    public AgoraImage watermark;
    public AgoraImage backgroundImage;
    public AudioSampleRateType audioSampleRate;
    public int audioBitrate = 48;
    public int audioChannels = 1;
    public AudioCodecProfileType audioCodecProfile;
    public VideoCodecProfileType videoCodecProfile = VideoCodecProfileType.HIGH;
    public VideoCodecType videoCodecType = VideoCodecType.H264;
    @Deprecated
    public int userCount;
    @Deprecated
    public int backgroundColor = -16777216;
    public String userConfigExtraInfo = null;
    @Deprecated
    public String metadata = null;
    private Map<Integer, TranscodingUser> transcodingUsers;
    private Map<String, Boolean> advancedFeatures;

    public LiveTranscoding() {
        this.watermark = new AgoraImage();
        this.backgroundImage = new AgoraImage();
        this.audioSampleRate = AudioSampleRateType.TYPE_44100;
        this.audioCodecProfile = AudioCodecProfileType.LC_AAC;
        this.transcodingUsers = new HashMap<Integer, TranscodingUser>();
        this.advancedFeatures = new HashMap<String, Boolean>();
    }

    public void setAdvancedFeatures(String string2, Boolean bl) {
        this.advancedFeatures.put(string2, bl);
    }

    public Map<String, Boolean> getAdvancedFeatures() {
        return this.advancedFeatures;
    }

    public int addUser(TranscodingUser transcodingUser) {
        int n2;
        if (transcodingUser != null && (n2 = transcodingUser.uid) != 0) {
            LiveTranscoding liveTranscoding = this;
            liveTranscoding.transcodingUsers.put(n2, transcodingUser);
            liveTranscoding.userCount = liveTranscoding.transcodingUsers.size();
            return 0;
        }
        return -2;
    }

    public final ArrayList<TranscodingUser> getUsers() {
        Collection<TranscodingUser> collection = ((LiveTranscoding)((Object)collection)).transcodingUsers.values();
        return new ArrayList<TranscodingUser>(collection);
    }

    public void setUsers(ArrayList<TranscodingUser> object) {
        this.transcodingUsers.clear();
        if (object != null) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                TranscodingUser transcodingUser = (TranscodingUser)object.next();
                this.transcodingUsers.put(transcodingUser.uid, transcodingUser);
            }
        }
        this.userCount = this.transcodingUsers.size();
    }

    public void setUsers(Map<Integer, TranscodingUser> map) {
        this.transcodingUsers.clear();
        if (map != null) {
            this.transcodingUsers.putAll(map);
        }
        this.userCount = this.transcodingUsers.size();
    }

    public int removeUser(int n2) {
        if (!this.transcodingUsers.containsKey(n2)) {
            return -2;
        }
        LiveTranscoding liveTranscoding = this;
        liveTranscoding.transcodingUsers.remove(n2);
        liveTranscoding.userCount = liveTranscoding.transcodingUsers.size();
        return 0;
    }

    public int getUserCount() {
        return this.transcodingUsers.size();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int n2) {
        this.backgroundColor = n2;
    }

    public void setBackgroundColor(int n2, int n3, int n4) {
        this.backgroundColor = n2 << 16 | n3 << 8 | n4 << 0;
    }

    @Deprecated
    public int getRed() {
        return this.backgroundColor >> 16 & 0xFF;
    }

    @Deprecated
    public int getGreen() {
        return this.backgroundColor >> 8 & 0xFF;
    }

    @Deprecated
    public int getBlue() {
        return this.backgroundColor & 0xFF;
    }

    @Deprecated
    public void setRed(int n2) {
        int n3 = n2;
        LiveTranscoding liveTranscoding = this;
        int n4 = liveTranscoding.getGreen();
        n2 = liveTranscoding.getBlue();
        this.backgroundColor = n3 << 16 | n4 << 8 | n2 << 0;
    }

    @Deprecated
    public void setGreen(int n2) {
        int n3 = this.getBlue();
        this.backgroundColor = this.getRed() << 16 | n2 << 8 | n3 << 0;
    }

    @Deprecated
    public void setBlue(int n2) {
        int n3 = this.getGreen();
        this.backgroundColor = this.getRed() << 16 | n3 << 8 | n2 << 0;
    }

    public static class TranscodingUser {
        public int uid;
        public int x;
        public int y;
        public int width;
        public int height;
        public int zOrder;
        public float alpha = 1.0f;
        public int audioChannel;
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        public static final /* enum */ VideoCodecType H264;
        public static final /* enum */ VideoCodecType H265;
        private static final /* synthetic */ VideoCodecType[] $VALUES;
        private int value;

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }

        public static VideoCodecType valueOf(String string2) {
            return Enum.valueOf(VideoCodecType.class, string2);
        }

        private VideoCodecType(int n3) {
            this.value = n3;
        }

        public static int getValue(VideoCodecType videoCodecType) {
            return videoCodecType.value;
        }

        static {
            VideoCodecType videoCodecType;
            H264 = new VideoCodecType(1);
            VideoCodecType videoCodecType2 = videoCodecType;
            H265 = new VideoCodecType(2);
            $VALUES = new VideoCodecType[]{H264, videoCodecType2};
        }
    }

    public static final class AudioCodecProfileType
    extends Enum<AudioCodecProfileType> {
        public static final /* enum */ AudioCodecProfileType LC_AAC;
        public static final /* enum */ AudioCodecProfileType HE_AAC;
        private static final /* synthetic */ AudioCodecProfileType[] $VALUES;
        private int value;

        public static AudioCodecProfileType[] values() {
            return (AudioCodecProfileType[])$VALUES.clone();
        }

        public static AudioCodecProfileType valueOf(String string2) {
            return Enum.valueOf(AudioCodecProfileType.class, string2);
        }

        private AudioCodecProfileType(int n3) {
            this.value = n3;
        }

        public static int getValue(AudioCodecProfileType audioCodecProfileType) {
            return audioCodecProfileType.value;
        }

        static {
            AudioCodecProfileType audioCodecProfileType;
            LC_AAC = new AudioCodecProfileType(0);
            AudioCodecProfileType audioCodecProfileType2 = audioCodecProfileType;
            HE_AAC = new AudioCodecProfileType(1);
            $VALUES = new AudioCodecProfileType[]{LC_AAC, audioCodecProfileType2};
        }
    }

    public static final class VideoCodecProfileType
    extends Enum<VideoCodecProfileType> {
        public static final /* enum */ VideoCodecProfileType BASELINE;
        public static final /* enum */ VideoCodecProfileType MAIN;
        public static final /* enum */ VideoCodecProfileType HIGH;
        private static final /* synthetic */ VideoCodecProfileType[] $VALUES;
        private int value;

        public static VideoCodecProfileType[] values() {
            return (VideoCodecProfileType[])$VALUES.clone();
        }

        public static VideoCodecProfileType valueOf(String string2) {
            return Enum.valueOf(VideoCodecProfileType.class, string2);
        }

        private VideoCodecProfileType(int n3) {
            this.value = n3;
        }

        public static int getValue(VideoCodecProfileType videoCodecProfileType) {
            return videoCodecProfileType.value;
        }

        static {
            VideoCodecProfileType videoCodecProfileType;
            BASELINE = new VideoCodecProfileType(66);
            MAIN = new VideoCodecProfileType(77);
            VideoCodecProfileType videoCodecProfileType2 = videoCodecProfileType;
            HIGH = new VideoCodecProfileType(100);
            $VALUES = new VideoCodecProfileType[]{BASELINE, MAIN, videoCodecProfileType2};
        }
    }

    public static final class AudioSampleRateType
    extends Enum<AudioSampleRateType> {
        public static final /* enum */ AudioSampleRateType TYPE_32000;
        public static final /* enum */ AudioSampleRateType TYPE_44100;
        public static final /* enum */ AudioSampleRateType TYPE_48000;
        private static final /* synthetic */ AudioSampleRateType[] $VALUES;
        private int value;

        public static AudioSampleRateType[] values() {
            return (AudioSampleRateType[])$VALUES.clone();
        }

        public static AudioSampleRateType valueOf(String string2) {
            return Enum.valueOf(AudioSampleRateType.class, string2);
        }

        private AudioSampleRateType(int n3) {
            this.value = n3;
        }

        public static int getValue(AudioSampleRateType audioSampleRateType) {
            return audioSampleRateType.value;
        }

        static {
            AudioSampleRateType audioSampleRateType;
            TYPE_32000 = new AudioSampleRateType(32000);
            TYPE_44100 = new AudioSampleRateType(44100);
            AudioSampleRateType audioSampleRateType2 = audioSampleRateType;
            TYPE_48000 = new AudioSampleRateType(48000);
            $VALUES = new AudioSampleRateType[]{TYPE_32000, TYPE_44100, audioSampleRateType2};
        }
    }
}

