/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.WindowManager;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.mediaio.TextureSource;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.List;

public class AgoraTextureCamera
extends TextureSource {
    private static final String TAG = "AgoraTextureCamera";
    private Context mContext;
    private Camera camera;
    private Camera.CameraInfo info;

    public AgoraTextureCamera(Context context, int n2, int n3) {
        super(null, n2, n3);
        this.mContext = context;
    }

    public AgoraTextureCamera(Context context, int n2, int n3, boolean bl) {
        super(null, n2, n3, bl);
        this.mContext = context;
    }

    private void openCamera() {
        if (this.camera == null) {
            Camera camera;
            Camera.CameraInfo cameraInfo;
            Camera.CameraInfo cameraInfo2 = cameraInfo;
            cameraInfo = new Camera.CameraInfo();
            this.info = cameraInfo2;
            int n2 = Camera.getNumberOfCameras();
            for (int i2 = 0; i2 < n2; ++i2) {
                Camera.getCameraInfo((int)i2, (Camera.CameraInfo)this.info);
                if (this.info.facing != 1) continue;
                this.camera = Camera.open((int)i2);
                break;
            }
            if (this.camera == null) {
                Log.d((String)TAG, (String)"No front-facing camera found; opening default");
                this.camera = Camera.open();
            }
            if ((camera = this.camera) != null) {
                Camera camera2 = camera = camera.getParameters();
                AgoraTextureCamera agoraTextureCamera = this;
                Camera camera3 = camera;
                List list = camera3.getSupportedPreviewFpsRange();
                int n3 = ((int[])list.get(list.size() - 1))[0];
                camera3.setPreviewFpsRange(n3, ((int[])list.get(list.size() - 1))[1]);
                n3 = agoraTextureCamera.mWidth;
                camera2.setPreviewSize(n3, agoraTextureCamera.mHeight);
                camera2.setRecordingHint(true);
                this.camera.setParameters((Camera.Parameters)camera);
                Object object = camera.getPreviewSize();
                object = object.width + "x" + object.height;
                Log.i((String)TAG, (String)("Camera config: " + (String)object));
                return;
            }
            throw new RuntimeException("Unable to open camera");
        }
        throw new RuntimeException("camera already initialized");
    }

    private int getDeviceOrientation() {
        int n2 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        return n2 != 1 ? (n2 != 2 ? (n2 != 3 ? 0 : 270) : 180) : 90;
    }

    private int getFrameOrientation() {
        AgoraTextureCamera agoraTextureCamera = this;
        int n2 = agoraTextureCamera.getDeviceOrientation();
        if (agoraTextureCamera.info.facing == 0) {
            n2 = 360 - n2;
        }
        return (this.info.orientation + n2) % 360;
    }

    private void releaseCamera() {
        Camera camera = this.camera;
        if (camera != null) {
            camera.stopPreview();
            try {
                this.camera.setPreviewTexture(null);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"failed to set Preview Texture");
            }
            this.camera.release();
            this.camera = null;
            Log.d((String)TAG, (String)"releaseCamera -- done");
        }
    }

    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        Object object;
        AgoraTextureCamera agoraTextureCamera = this;
        super.onTextureFrameAvailable(n2, fArray, l2);
        int n3 = agoraTextureCamera.getFrameOrientation();
        if (agoraTextureCamera.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if ((object = this.mConsumer) != null && (object = (IVideoFrameConsumer)((Reference)object).get()) != null) {
            int n4 = n2;
            AgoraTextureCamera agoraTextureCamera2 = this;
            int n5 = MediaIO.PixelFormat.TEXTURE_OES.intValue();
            n2 = agoraTextureCamera2.mWidth;
            int n6 = agoraTextureCamera2.mHeight;
            long l3 = System.currentTimeMillis();
            object.consumeTextureFrame(n4, n5, n2, n6, n3, l3, fArray);
        }
    }

    @Override
    public void onTextureFrameAvailable(int n2, MediaIO.PixelFormat pixelFormat, float[] fArray, long l2) {
        Object object;
        AgoraTextureCamera agoraTextureCamera = this;
        super.onTextureFrameAvailable(n2, pixelFormat, fArray, l2);
        int n3 = agoraTextureCamera.getFrameOrientation();
        if (agoraTextureCamera.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if ((object = this.mConsumer) != null && (object = (IVideoFrameConsumer)((Reference)object).get()) != null) {
            AgoraTextureCamera agoraTextureCamera2 = this;
            int n4 = pixelFormat.intValue();
            int n5 = agoraTextureCamera2.mWidth;
            int n6 = agoraTextureCamera2.mHeight;
            long l3 = System.currentTimeMillis();
            object.consumeTextureFrame(n2, n4, n5, n6, n3, l3, fArray);
        }
    }

    @Override
    protected boolean onCapturerOpened() {
        try {
            AgoraTextureCamera agoraTextureCamera = this;
            agoraTextureCamera.openCamera();
            agoraTextureCamera.camera.setPreviewTexture(this.getSurfaceTexture());
            agoraTextureCamera.camera.startPreview();
            return true;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"initialize: failed to initalize camera device");
            return false;
        }
    }

    @Override
    protected boolean onCapturerStarted() {
        this.camera.startPreview();
        return true;
    }

    @Override
    protected void onCapturerStopped() {
        this.camera.stopPreview();
    }

    @Override
    protected void onCapturerClosed() {
        this.releaseCamera();
    }
}

