/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.BaseVideoRenderer;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;

public class AgoraTextureView
extends TextureView
implements IVideoSink,
TextureView.SurfaceTextureListener {
    private static final String TAG = TextureView.class.getSimpleName();
    private BaseVideoRenderer mRender;
    private EglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private RendererCommon.GlDrawer mDrawer;

    public AgoraTextureView(Context object) {
        super(object);
        BaseVideoRenderer baseVideoRenderer;
        Object object2 = object = baseVideoRenderer;
        super(TAG);
        this.mRender = object2;
        baseVideoRenderer.setRenderView(this, this);
    }

    public AgoraTextureView(Context object, AttributeSet attributeSet) {
        super(object, attributeSet);
        BaseVideoRenderer baseVideoRenderer;
        Object object2 = object = baseVideoRenderer;
        super(TAG);
        this.mRender = object2;
        baseVideoRenderer.setRenderView(this, this);
    }

    public void init(EglBase.Context context) {
        this.mEglContext = context;
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        AgoraTextureView agoraTextureView = this;
        agoraTextureView.mEglContext = context;
        agoraTextureView.mConfigAttributes = nArray;
        agoraTextureView.mDrawer = glDrawer;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType bufferType) {
        this.mRender.setBufferType(bufferType);
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mRender.setPixelFormat(pixelFormat);
    }

    public void setMirror(boolean bl) {
        this.mRender.getEglRender().setMirror(bl);
    }

    @Override
    public boolean onInitialize() {
        RendererCommon.GlDrawer glDrawer;
        int[] nArray = this.mConfigAttributes;
        if (this.mConfigAttributes != null && (glDrawer = this.mDrawer) != null) {
            this.mRender.init(this.mEglContext, nArray, glDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeTextureFrame(int n2, int n3, int n4, int n5, int n6, long l2, float[] fArray) {
        this.mRender.consume(n2, n3, n4, n5, n6, l2, fArray);
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, long l2) {
        this.mRender.consume(byteBuffer, n2, n3, n4, n5, l2);
    }

    @Override
    public void consumeByteArrayFrame(byte[] byArray, int n2, int n3, int n4, int n5, long l2) {
        this.mRender.consume(byArray, n2, n3, n4, n5, l2);
    }

    @Override
    public int getBufferType() {
        int n2 = this.mRender.getBufferType();
        if (n2 != -1) {
            return n2;
        }
        throw new IllegalArgumentException("Buffer type is not set");
    }

    @Override
    public int getPixelFormat() {
        int n2 = this.mRender.getPixelFormat();
        if (n2 != -1) {
            return n2;
        }
        throw new IllegalArgumentException("Pixel format is not set");
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + n2 + ", height: " + n3));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(n4 - n2) / (float)(n5 - n3));
    }
}

