/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglRenderer;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.RgbaBuffer;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class BaseVideoRenderer
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener {
    private static final String TAG = BaseVideoRenderer.class.getSimpleName();
    private static final String ERROR_EGL = "Only one egl surface allowed";
    private final EglRenderer eglRenderer;
    private int mBufferType = -1;
    private int mPixelFormat = -1;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private SurfaceHolder.Callback mSurfaceViewListener;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;
    private boolean mHasEglSurface = false;
    private boolean mStarted = false;

    public BaseVideoRenderer(String string2) {
        EglRenderer eglRenderer;
        EglRenderer eglRenderer2 = eglRenderer;
        eglRenderer = new EglRenderer(string2);
        v1.eglRenderer = eglRenderer2;
    }

    private void rendTextureFrame(int n2, VideoFrame.TextureBuffer.Type type, int n3, int n4, int n5, long l2, float[] object) {
        VideoFrame videoFrame;
        Runnable runnable;
        TextureBufferImpl textureBufferImpl;
        object = RendererCommon.convertMatrixToAndroidGraphicsMatrix(object);
        TextureBufferImpl textureBufferImpl2 = textureBufferImpl;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        textureBufferImpl = new TextureBufferImpl(this.eglRenderer.getEglContext(), n3, n4, type, n2, (Matrix)object, null, null, runnable2);
        VideoFrame videoFrame2 = videoFrame;
        videoFrame2(textureBufferImpl2, n5, l2);
        this.eglRenderer.renderFrame(videoFrame2);
        videoFrame.release();
    }

    private void rendI420Frame(ByteBuffer object, int n2, int n3, int n4, int n5, long l2) {
        VideoFrame videoFrame;
        if (object == null) {
            return;
        }
        n2 = ((Buffer)object).remaining();
        byte[] byArray = new byte[n2];
        ((ByteBuffer)object).get(byArray, 0, n2);
        object = JavaI420Buffer.createYUV(byArray, n3, n4);
        if (object == null) {
            return;
        }
        VideoFrame videoFrame2 = videoFrame;
        videoFrame2((VideoFrame.Buffer)object, n5, l2);
        this.eglRenderer.renderFrame(videoFrame2);
        videoFrame.release();
    }

    private void rendI420Frame(byte[] object, int n2, int n3, int n4, int n5, long l2) {
        if (object != null && ((byte[])object).length != 0) {
            VideoFrame videoFrame;
            JavaI420Buffer javaI420Buffer = JavaI420Buffer.createYUV(object, n3, n4);
            object = javaI420Buffer;
            if (javaI420Buffer == null) {
                return;
            }
            VideoFrame videoFrame2 = videoFrame;
            videoFrame2((VideoFrame.Buffer)object, n5, l2);
            this.eglRenderer.renderFrame(videoFrame2);
            videoFrame.release();
            return;
        }
    }

    private void rendRGBAFrame(ByteBuffer object, int n2, int n3, int n4, int n5, long l2) {
        VideoFrame videoFrame;
        Runnable runnable;
        RgbaBuffer rgbaBuffer;
        if (object == null) {
            return;
        }
        RgbaBuffer rgbaBuffer2 = rgbaBuffer;
        Runnable runnable2 = runnable;
        runnable = new Runnable((ByteBuffer)object){
            final /* synthetic */ ByteBuffer val$data;
            {
                this.val$data = byteBuffer;
            }

            @Override
            public void run() {
                BaseVideoRenderer.this.releaseBuffer(this.val$data);
            }
        };
        rgbaBuffer = new RgbaBuffer((ByteBuffer)object, n3, n4, runnable2);
        object = videoFrame;
        ((VideoFrame)object)(rgbaBuffer2, n5, l2);
        this.eglRenderer.renderFrame((VideoFrame)object);
        videoFrame.release();
    }

    private void rendRGBAFrame(byte[] object, int n2, int n3, int n4, int n5, long l2) {
        if (object != null && ((byte[])object).length != 0) {
            VideoFrame videoFrame;
            Runnable runnable;
            RgbaBuffer rgbaBuffer;
            object = ByteBuffer.wrap(object);
            RgbaBuffer rgbaBuffer2 = rgbaBuffer;
            Runnable runnable2 = runnable;
            runnable = new Runnable((ByteBuffer)object){
                final /* synthetic */ ByteBuffer val$buffer;
                {
                    this.val$buffer = byteBuffer;
                }

                @Override
                public void run() {
                    BaseVideoRenderer.this.releaseBuffer(this.val$buffer);
                }
            };
            rgbaBuffer = new RgbaBuffer((ByteBuffer)object, n3, n4, runnable2);
            object = videoFrame;
            object(rgbaBuffer2, n5, l2);
            this.eglRenderer.renderFrame((VideoFrame)object);
            videoFrame.release();
            return;
        }
    }

    private void releaseBuffer(ByteBuffer byteBuffer) {
    }

    public EglRenderer getEglRender() {
        return this.eglRenderer;
    }

    public long getEGLContextHandle() {
        return this.eglRenderer.getEglContext().getNativeEglContext();
    }

    public void init(EglBase.Context context) {
        GlRectDrawer glRectDrawer;
        BaseVideoRenderer baseVideoRenderer = glRectDrawer2;
        GlRectDrawer glRectDrawer2 = glRectDrawer;
        glRectDrawer = new GlRectDrawer();
        baseVideoRenderer.init(context, EglBase.CONFIG_PLAIN, glRectDrawer2);
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.init(context, nArray, glDrawer);
    }

    public void setRenderView(SurfaceView surfaceView, SurfaceHolder.Callback callback) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.mHasEglSurface) {
            this.mSurfaceView = surfaceView;
            this.mSurfaceViewListener = callback;
            surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
            return;
        }
        throw new IllegalStateException(ERROR_EGL);
    }

    public void setRenderView(TextureView textureView, TextureView.SurfaceTextureListener surfaceTextureListener) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.mHasEglSurface) {
            BaseVideoRenderer baseVideoRenderer = this;
            baseVideoRenderer.mTextureView = textureView;
            baseVideoRenderer.mSurfaceTextureListener = surfaceTextureListener;
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            return;
        }
        throw new IllegalStateException(ERROR_EGL);
    }

    public void setRenderSurface(Surface surface) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.mHasEglSurface) {
            this.mSurface = surface;
            this.eglRenderer.createEglSurface(surface);
            this.mHasEglSurface = true;
            return;
        }
        throw new IllegalStateException(ERROR_EGL);
    }

    public void setRenderSurface(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.mHasEglSurface) {
            this.mSurfaceTexture = surfaceTexture;
            this.eglRenderer.createEglSurface(surfaceTexture);
            this.mHasEglSurface = true;
            return;
        }
        throw new IllegalStateException(ERROR_EGL);
    }

    public void setBufferType(MediaIO.BufferType bufferType) {
        this.mBufferType = bufferType.intValue();
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mPixelFormat = pixelFormat.intValue();
    }

    public void release() {
        this.eglRenderer.release();
    }

    public boolean start() {
        this.mStarted = true;
        return true;
    }

    public void stop() {
        this.mStarted = false;
    }

    public void consume(int n2, int n3, int n4, int n5, int n6, long l2, float[] fArray) {
        block6: {
            VideoFrame.TextureBuffer.Type type;
            block5: {
                block4: {
                    if (!this.mStarted) {
                        return;
                    }
                    if (n3 != 11) break block4;
                    type = VideoFrame.TextureBuffer.Type.OES;
                    break block5;
                }
                if (n3 != 10) break block6;
                type = VideoFrame.TextureBuffer.Type.RGB;
            }
            this.rendTextureFrame(n2, type, n4, n5, n6, l2, fArray);
            return;
        }
    }

    public void consume(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, long l2) {
        if (!this.mStarted) {
            return;
        }
        if (n2 == 1) {
            this.rendI420Frame(byteBuffer, n2, n3, n4, n5, l2);
        } else if (n2 == 4) {
            this.rendRGBAFrame(byteBuffer, n2, n3, n4, n5, l2);
        }
    }

    public void consume(byte[] byArray, int n2, int n3, int n4, int n5, long l2) {
        if (!this.mStarted) {
            return;
        }
        if (n2 == 1) {
            this.rendI420Frame(byArray, n2, n3, n4, n5, l2);
        } else if (n2 == 4) {
            this.rendRGBAFrame(byArray, n2, n3, n4, n5, l2);
        }
    }

    public int getBufferType() {
        int n2 = this.mBufferType;
        if (n2 != -1) {
            return n2;
        }
        throw new IllegalArgumentException("Buffer type is not set");
    }

    public int getPixelFormat() {
        int n2 = this.mPixelFormat;
        if (n2 != -1) {
            return n2;
        }
        throw new IllegalArgumentException("Pixel format is not set");
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer2;
        ThreadUtils.checkIsOnMainThread();
        baseVideoRenderer.eglRenderer.createEglSurface(surfaceHolder.getSurface());
        baseVideoRenderer.mHasEglSurface = true;
        BaseVideoRenderer baseVideoRenderer2 = baseVideoRenderer.mSurfaceViewListener;
        if (baseVideoRenderer2 != null) {
            baseVideoRenderer2.surfaceCreated(surfaceHolder);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        ThreadUtils.checkIsOnMainThread();
        Log.e((String)TAG, (String)("surfaceChanged: format: " + n2 + " size: " + n3 + "x" + n4));
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer.mSurfaceViewListener;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.surfaceChanged(surfaceHolder, n2, n3, n4);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        CountDownLatch countDownLatch;
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        baseVideoRenderer.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                countDownLatch2.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer.mSurfaceViewListener;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.surfaceDestroyed(surfaceHolder);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer2;
        ThreadUtils.checkIsOnMainThread();
        baseVideoRenderer.eglRenderer.createEglSurface(surfaceTexture);
        baseVideoRenderer.mHasEglSurface = true;
        BaseVideoRenderer baseVideoRenderer2 = baseVideoRenderer.mSurfaceTextureListener;
        if (baseVideoRenderer2 != null) {
            baseVideoRenderer2.onSurfaceTextureAvailable(surfaceTexture, n2, n3);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + n2 + ", height: " + n3));
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer.mSurfaceTextureListener;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.onSurfaceTextureSizeChanged(surfaceTexture, n2, n3);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        CountDownLatch countDownLatch;
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        baseVideoRenderer.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                countDownLatch2.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer.mSurfaceTextureListener;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.onSurfaceTextureDestroyed(surfaceTexture);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        BaseVideoRenderer baseVideoRenderer = baseVideoRenderer.mSurfaceTextureListener;
        if (baseVideoRenderer != null) {
            baseVideoRenderer.onSurfaceTextureUpdated(surfaceTexture);
        }
    }
}

