/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.TextureTransformer;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.util.concurrent.Callable;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private static final int MAX_TEXTURE_COPY = 2;
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private YuvConverter yuvConverter;
    private boolean mCopyTo2DTexture = false;
    private TextureTransformer textureTransformer = null;
    private int mWidth;
    private int mHeight;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isTextureInUse = false;
    private boolean isQuitting = false;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            3 v0 = this;
            Log.d((String)SurfaceTextureHelper.TAG, (String)("Setting listener to " + SurfaceTextureHelper.this.pendingListener));
            SurfaceTextureHelper surfaceTextureHelper = v0.SurfaceTextureHelper.this;
            SurfaceTextureHelper.access$302(surfaceTextureHelper, surfaceTextureHelper.pendingListener);
            SurfaceTextureHelper.access$202(v0.SurfaceTextureHelper.this, null);
            if (v0.SurfaceTextureHelper.this.hasPendingTexture) {
                3 v2 = this;
                v2.SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.access$402(v2.SurfaceTextureHelper.this, false);
            }
        }
    };

    public static SurfaceTextureHelper create(final String string2, final EglBase.Context context) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string2).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<SurfaceTextureHelper>(){

            @Override
            public SurfaceTextureHelper call() {
                EglBase.Context context2;
                1 v4;
                SurfaceTextureHelper surfaceTextureHelper;
                SurfaceTextureHelper surfaceTextureHelper2;
                try {
                    SurfaceTextureHelper surfaceTextureHelper3;
                    surfaceTextureHelper2 = surfaceTextureHelper3;
                    surfaceTextureHelper = surfaceTextureHelper3;
                    1 v3 = this;
                    v4 = v3;
                    context2 = v3.context;
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)SurfaceTextureHelper.TAG, (String)(string2 + " create failure"), (Throwable)runtimeException);
                    return null;
                }
                surfaceTextureHelper2(context2, v4.handler2);
                return surfaceTextureHelper;
            }
        });
    }

    public static SurfaceTextureHelper create(final String string2, final EglBase.Context context, final boolean bl, final int n2, final int n3) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string2).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<SurfaceTextureHelper>(){

            @Override
            public SurfaceTextureHelper call() {
                EglBase.Context context2;
                2 v7;
                2 v6;
                2 v5;
                2 v4;
                SurfaceTextureHelper surfaceTextureHelper;
                SurfaceTextureHelper surfaceTextureHelper2;
                try {
                    SurfaceTextureHelper surfaceTextureHelper3;
                    surfaceTextureHelper2 = surfaceTextureHelper3;
                    surfaceTextureHelper = surfaceTextureHelper3;
                    2 v3 = this;
                    v4 = v3;
                    v5 = v3;
                    v6 = v3;
                    v7 = v3;
                    context2 = v3.context;
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)SurfaceTextureHelper.TAG, (String)(string2 + " create failure"), (Throwable)runtimeException);
                    return null;
                }
                Handler handler = v5.handler2;
                boolean bl2 = v6.bl;
                int n22 = v7.n2;
                int n32 = v4.n3;
                surfaceTextureHelper2(context2, handler, bl2, n22, n32);
                return surfaceTextureHelper;
            }
        });
    }

    private SurfaceTextureHelper(EglBase.Context context, Handler handler) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            this.handler = handler;
            this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                this.eglBase.createDummyPbufferSurface();
                this.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)TAG, (String)"SurfaceTextureHelper: failed to create pbufferSurface!!");
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            this.oesTextureId = GlUtil.generateTexture(36197);
            this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    4 v0 = this;
                    SurfaceTextureHelper.access$402(v0.SurfaceTextureHelper.this, true);
                    v0.SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }, handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    private SurfaceTextureHelper(EglBase.Context object, Handler handler, boolean bl, int n2, int n3) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            block3: {
                TextureTransformer textureTransformer;
                this.handler = handler;
                this.eglBase = EglBase.create((EglBase.Context)object, EglBase.CONFIG_PIXEL_BUFFER);
                try {
                    this.eglBase.createDummyPbufferSurface();
                    this.eglBase.makeCurrent();
                    this.mCopyTo2DTexture = bl;
                    if (!bl) break block3;
                    SurfaceTextureHelper surfaceTextureHelper = this;
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)TAG, (String)"SurfaceTextureHelper: failed to create pbufferSurface!!");
                    this.eglBase.release();
                    handler.getLooper().quit();
                    throw runtimeException;
                }
                surfaceTextureHelper.mWidth = n2;
                surfaceTextureHelper.mHeight = n3;
                object = textureTransformer;
                textureTransformer = new TextureTransformer(2);
                surfaceTextureHelper.textureTransformer = object;
            }
            this.oesTextureId = GlUtil.generateTexture(36197);
            this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    5 v0 = this;
                    SurfaceTextureHelper.access$402(v0.SurfaceTextureHelper.this, true);
                    v0.SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }, handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        SurfaceTextureHelper surfaceTextureHelper = this;
        // MONITORENTER : object
        try {
            surfaceTextureHelper.surfaceTexture.updateTexImage();
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object
            try {
                throw throwable;
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)TAG, (String)"SurfaceTextureHelper: failed to updateTexImage!!");
            }
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
                TextureTransformer textureTransformer;
                SurfaceTextureHelper surfaceTextureHelper = this;
                surfaceTextureHelper.isTextureInUse = true;
                surfaceTextureHelper.hasPendingTexture = false;
                surfaceTextureHelper.updateTexImage();
                float[] fArray = new float[16];
                surfaceTextureHelper.surfaceTexture.getTransformMatrix(fArray);
                long l2 = surfaceTextureHelper.surfaceTexture.getTimestamp();
                if (surfaceTextureHelper.mCopyTo2DTexture && (textureTransformer = this.textureTransformer) != null) {
                    SurfaceTextureHelper surfaceTextureHelper2 = this;
                    int n2 = surfaceTextureHelper2.oesTextureId;
                    int n3 = MediaIO.PixelFormat.TEXTURE_OES.intValue();
                    int n4 = surfaceTextureHelper2.mWidth;
                    int n5 = surfaceTextureHelper2.mHeight;
                    n2 = textureTransformer.copy(n2, n3, n4, n5);
                    this.listener.onTextureFrameAvailable(n2, MediaIO.PixelFormat.TEXTURE_2D, fArray, l2);
                } else {
                    this.listener.onTextureFrameAvailable(this.oesTextureId, fArray, l2);
                }
                return;
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void release() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isTextureInUse && this.isQuitting) {
                Object object = this.yuvConverter;
                if (object != null) {
                    ((YuvConverter)object).release();
                }
                if ((object = this.textureTransformer) != null) {
                    ((TextureTransformer)object).release();
                }
                SurfaceTextureHelper surfaceTextureHelper = this;
                int[] nArray = new int[1];
                object = nArray;
                nArray[0] = this.oesTextureId;
                GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
                surfaceTextureHelper.surfaceTexture.release();
                surfaceTextureHelper.eglBase.release();
                surfaceTextureHelper.handler.getLooper().quit();
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$302(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.listener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$202(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.pendingListener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ boolean access$402(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.hasPendingTexture = bl;
        return bl;
    }

    static /* synthetic */ boolean access$702(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.isTextureInUse = bl;
        return bl;
    }

    static /* synthetic */ boolean access$802(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.isQuitting = bl;
        return bl;
    }

    static /* synthetic */ YuvConverter access$1002(SurfaceTextureHelper surfaceTextureHelper, YuvConverter yuvConverter) {
        surfaceTextureHelper.yuvConverter = yuvConverter;
        return yuvConverter;
    }

    public EglBase.Context getEglContext() {
        return this.eglBase.getEglBaseContext();
    }

    public void startListening(OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = onTextureFrameAvailableListener;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        SurfaceTextureHelper surfaceTextureHelper = this;
        Log.d((String)TAG, (String)"stopListening()");
        surfaceTextureHelper.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(surfaceTextureHelper.handler, new Runnable(){

            @Override
            public void run() {
                6 v0 = this;
                SurfaceTextureHelper.access$302(v0.SurfaceTextureHelper.this, null);
                SurfaceTextureHelper.access$202(v0.SurfaceTextureHelper.this, null);
            }
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                7 v0 = this;
                SurfaceTextureHelper.access$702(v0.SurfaceTextureHelper.this, false);
                if (v0.SurfaceTextureHelper.this.isQuitting) {
                    SurfaceTextureHelper.this.release();
                } else {
                    SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Log.d((String)TAG, (String)"dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                8 v0 = this;
                SurfaceTextureHelper.access$802(v0.SurfaceTextureHelper.this, true);
                if (!v0.SurfaceTextureHelper.this.isTextureInUse) {
                    SurfaceTextureHelper.this.release();
                }
            }
        });
    }

    public VideoFrame.I420Buffer textureToYuv(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() == this.oesTextureId) {
            final VideoFrame.I420Buffer[] i420BufferArray = new VideoFrame.I420Buffer[1];
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    if (SurfaceTextureHelper.this.yuvConverter == null) {
                        SurfaceTextureHelper.access$1002(SurfaceTextureHelper.this, new YuvConverter());
                    }
                    i420BufferArray[0] = SurfaceTextureHelper.this.yuvConverter.convert(textureBuffer);
                }
            });
            return i420BufferArray[0];
        }
        throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
    }

    public VideoFrame.TextureBuffer createTextureBuffer(int n2, int n3, Matrix matrix) {
        Runnable runnable;
        SurfaceTextureHelper surfaceTextureHelper = this;
        EglBase.Context context = surfaceTextureHelper.getEglContext();
        VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.OES;
        int n4 = surfaceTextureHelper.oesTextureId;
        Handler handler = surfaceTextureHelper.handler;
        YuvConverter yuvConverter = surfaceTextureHelper.yuvConverter;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.returnTextureFrame();
            }
        };
        return new TextureBufferImpl(context, n2, n3, type, n4, matrix, handler, yuvConverter, runnable2);
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);

        public void onTextureFrameAvailable(int var1, MediaIO.PixelFormat var2, float[] var3, long var4);
    }
}

