/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void checkIsOnMainThread() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Not on main thread!");
    }

    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl = false;
        while (true) {
            try {
                blockingOperation.run();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        boolean bl = false;
        long l4 = l2;
        while (l4 > 0L) {
            try {
                thread.join(l4);
                break;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                l4 = l2 - (SystemClock.elapsedRealtime() - l3);
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return thread.isAlive() ^ true;
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                thread.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        boolean bl = false;
        boolean bl2 = false;
        long l4 = l2;
        while (true) {
            try {
                bl2 = countDownLatch.await(l4, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                if ((l4 = l2 - (SystemClock.elapsedRealtime() - l3)) > 0L) continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    public static void waitUninterruptibly(final Object object) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                object.wait();
            }
        });
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler object, final Callable<V> callable) {
        RuntimeException runtimeException;
        CountDownLatch countDownLatch;
        CaughtException caughtException;
        Result result;
        if (object.getLooper().getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        final Result result2 = result;
        class Result {
            public V value;

            Result() {
            }
        }
        result = new Result();
        final CaughtException caughtException2 = caughtException;
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        caughtException = new CaughtException();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        object.post(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    result2.value = callable.call();
                }
                catch (Exception exception) {
                    caughtException2.e = exception;
                }
                countDownLatch2.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (caughtException.e == null) {
            return result2.value;
        }
        object = runtimeException;
        ((RuntimeException)object)(caughtException2.e);
        runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException2.e.getStackTrace(), ((Throwable)object).getStackTrace()));
        throw runtimeException;
    }

    public static void invokeAtFrontUninterruptibly(Handler object, final Runnable runnable) {
        Callable<Void> callable;
        Handler handler = object;
        object = callable;
        callable = new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        };
        ThreadUtils.invokeAtFrontUninterruptibly(handler, object);
    }

    public static StackTraceElement[] concatStackTraces(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        int n2 = stackTraceElementArray.length;
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, n2);
        n2 = stackTraceElementArray.length;
        int n3 = stackTraceElementArray2.length;
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, n2, n3);
        return stackTraceElementArray3;
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() == this.thread) {
                return;
            }
            throw new IllegalStateException("Wrong thread");
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

