/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.util.Log;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.VideoFrame;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class YuvUtils {
    private static final String TAG = "YuvUtils";
    public static final int I420 = 35;
    public static final int NV21 = 17;

    public static boolean supportedImageFormat(Image image) {
        int n2 = image.getFormat();
        return n2 == 17 || n2 == 35 || n2 == 842094169;
    }

    public static byte[] getImageData(Image image, int n2) {
        if (n2 != 35 && n2 != 17) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (YuvUtils.supportedImageFormat(image)) {
            Image image2 = image;
            Rect rect = image2.getCropRect();
            int n3 = image.getFormat();
            int n4 = rect.width();
            int n5 = rect.height();
            Image.Plane[] planeArray = image2.getPlanes();
            int n6 = n4 * n5;
            byte[] byArray = new byte[n6 * ImageFormat.getBitsPerPixel((int)n3) / 8];
            byte[] byArray2 = new byte[planeArray[0].getRowStride()];
            int n7 = 0;
            int n8 = 1;
            for (int i2 = 0; i2 < planeArray.length; ++i2) {
                if (i2 != 0) {
                    if (i2 != 1) {
                        if (i2 == 2) {
                            if (n2 == 35) {
                                n7 = (int)((double)n6 * 1.25);
                                n8 = 1;
                            } else if (n2 == 17) {
                                n8 = 2;
                                n7 = n6;
                            }
                        }
                    } else if (n2 == 35) {
                        n8 = 1;
                        n7 = n6;
                    } else if (n2 == 17) {
                        n7 = n6 + 1;
                        n8 = 2;
                    }
                } else {
                    n7 = 0;
                    n8 = 1;
                }
                ByteBuffer byteBuffer = planeArray[i2].getBuffer();
                int n9 = planeArray[i2].getRowStride();
                int n10 = planeArray[i2].getPixelStride();
                int n11 = i2 == 0 ? 0 : 1;
                int n12 = n4 >> n11;
                int n13 = n5 >> n11;
                byteBuffer.position(n9 * (rect.top >> n11) + n10 * (rect.left >> n11));
                for (n11 = 0; n11 < n13; ++n11) {
                    int n14;
                    if (n10 == 1 && n8 == 1) {
                        byteBuffer.get(byArray, n7, n12);
                        n7 += n12;
                        n14 = n12;
                    } else {
                        n14 = (n12 - 1) * n10 + 1;
                        byteBuffer.get(byArray2, 0, n14);
                        for (int i3 = 0; i3 < n12; ++i3) {
                            byArray[n7] = byArray2[i3 * n10];
                            n7 += n8;
                        }
                    }
                    if (n11 >= n13 - 1) continue;
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.position(byteBuffer2.position() + n9 - n14);
                }
            }
            return byArray;
        }
        throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
    }

    public static boolean writeNV21ToFile(byte[] object, int n2, int n3, String string2) {
        FileOutputStream fileOutputStream;
        File file;
        Rect rect;
        YuvImage yuvImage;
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(object, 17, n2, n3, null);
        object = rect;
        rect = new Rect(0, 0, n2, n3);
        File file2 = file;
        try {
            new File(string2).createNewFile();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
            return false;
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream2(file2);
        yuvImage2.compressToJpeg((Rect)object, 100, (OutputStream)fileOutputStream2);
        fileOutputStream.flush();
        fileOutputStream.close();
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static void writeRawData(byte[] byArray, String string2) {
        if (byArray != null && byArray.length != 0) {
            Throwable throwable2;
            block9: {
                block8: {
                    File file;
                    File file2 = file;
                    new File(string2).createNewFile();
                    try {
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                        bufferedOutputStream.write(byArray);
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        break block8;
                        catch (Throwable throwable2) {
                            break block9;
                        }
                    }
                    catch (IOException iOException) {
                        Log.e((String)TAG, (String)iOException.toString());
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static void write420ImageToFile(Image image, String string2) {
        Throwable throwable2;
        block13: {
            block12: {
                File file;
                ByteArrayOutputStream byteArrayOutputStream;
                if (image == null) {
                    return;
                }
                byte[] byArray = YuvUtils.yuv420toNV21(image);
                Image image2 = image;
                int n2 = 17;
                int n3 = image2.getWidth();
                int n4 = image2.getHeight();
                YuvImage yuvImage = new YuvImage(byArray, n2, n3, n4, null);
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                Image image3 = image;
                int n5 = 0;
                n3 = 0;
                n4 = image3.getWidth();
                int n6 = image3.getHeight();
                yuvImage.compressToJpeg(new Rect(n5, n3, n4, n6), 100, (OutputStream)byteArrayOutputStream2);
                File file2 = file;
                new File(string2).createNewFile();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byteArrayOutputStream2.toByteArray());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    break block12;
                    catch (Throwable throwable2) {
                        break block13;
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)iOException.toString());
                }
            }
            return;
        }
        throw throwable2;
    }

    public static byte[] yuv420toNV21(Image image) {
        Image image2 = image;
        Rect rect = image2.getCropRect();
        int n2 = image.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        Image.Plane[] planeArray = image2.getPlanes();
        int n5 = n3 * n4;
        byte[] byArray = new byte[n5 * ImageFormat.getBitsPerPixel((int)n2) / 8];
        byte[] byArray2 = new byte[planeArray[0].getRowStride()];
        int n6 = 0;
        int n7 = 1;
        for (int i2 = 0; i2 < planeArray.length; ++i2) {
            if (i2 != 0) {
                if (i2 != 1) {
                    if (i2 == 2) {
                        n7 = 2;
                        n6 = n5;
                    }
                } else {
                    n6 = n5 + 1;
                    n7 = 2;
                }
            } else {
                n6 = 0;
                n7 = 1;
            }
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            int n8 = planeArray[i2].getRowStride();
            int n9 = planeArray[i2].getPixelStride();
            int n10 = i2 == 0 ? 0 : 1;
            int n11 = n3 >> n10;
            int n12 = n4 >> n10;
            byteBuffer.position(n8 * (rect.top >> n10) + n9 * (rect.left >> n10));
            for (n10 = 0; n10 < n12; ++n10) {
                int n13;
                if (n9 == 1 && n7 == 1) {
                    byteBuffer.get(byArray, n6, n11);
                    n6 += n11;
                    n13 = n11;
                } else {
                    n13 = (n11 - 1) * n9 + 1;
                    byteBuffer.get(byArray2, 0, n13);
                    for (int i3 = 0; i3 < n11; ++i3) {
                        byArray[n6] = byArray2[i3 * n9];
                        n6 += n7;
                    }
                }
                if (n10 >= n12 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n8 - n13);
            }
        }
        return byArray;
    }

    public static byte[] yuv420toNV21(byte[] byArray, int n2, int n3) {
        return YuvUtils.yuv420toNV21(JavaI420Buffer.createYUV(byArray, n2, n3), n2, n3);
    }

    public static byte[] yuv420toNV21(VideoFrame.I420Buffer object, int n2, int n3) {
        Plane plane;
        Plane plane2;
        Plane plane3;
        Plane[] planeArray;
        Rect rect;
        Rect rect2 = rect;
        rect = new Rect(0, 0, n2, n3);
        int n4 = 3;
        Plane[] planeArray2 = planeArray = new Plane[3];
        Object object2 = plane3;
        VideoFrame.I420Buffer i420Buffer = object;
        Object object3 = i420Buffer.getDataY();
        plane3 = new Plane((ByteBuffer)object3, i420Buffer.getStrideY(), 1);
        object3 = plane2;
        VideoFrame.I420Buffer i420Buffer2 = object;
        Object object4 = i420Buffer2.getDataU();
        plane2 = new Plane((ByteBuffer)object4, i420Buffer2.getStrideU(), 1);
        object4 = plane;
        VideoFrame.I420Buffer i420Buffer3 = object;
        object = i420Buffer3.getDataV();
        plane = new Plane((ByteBuffer)object, i420Buffer3.getStrideV(), 1);
        planeArray2[0] = object2;
        planeArray2[1] = object3;
        planeArray[2] = object4;
        int n5 = n2 * n3;
        object2 = new byte[n5 * ImageFormat.getBitsPerPixel((int)35) / 8];
        object3 = new byte[planeArray[0].getRowStride()];
        int n6 = 0;
        int n7 = 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 != 0) {
                if (i2 != 1) {
                    if (i2 == 2) {
                        n7 = 2;
                        n6 = n5;
                    }
                } else {
                    n6 = n5 + 1;
                    n7 = 2;
                }
            } else {
                n6 = 0;
                n7 = 1;
            }
            ByteBuffer byteBuffer = planeArray[i2].getBuffer();
            int n8 = planeArray[i2].getRowStride();
            int n9 = planeArray[i2].getPixelStride();
            int n10 = i2 == 0 ? 0 : 1;
            int n11 = n2 >> n10;
            int n12 = n3 >> n10;
            byteBuffer.position(n8 * (rect2.top >> n10) + n9 * (rect2.left >> n10));
            for (n10 = 0; n10 < n12; ++n10) {
                int n13;
                if (n9 == 1 && n7 == 1) {
                    byteBuffer.get((byte[])object2, n6, n11);
                    n6 += n11;
                    n13 = n11;
                } else {
                    n13 = (n11 - 1) * n9 + 1;
                    byteBuffer.get((byte[])object3, 0, n13);
                    for (int i3 = 0; i3 < n11; ++i3) {
                        object2[n6] = object3[i3 * n9];
                        n6 += n7;
                    }
                }
                if (n10 >= n12 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n8 - n13);
            }
        }
        return object2;
    }

    public static void writeRgbaToFile(Buffer buffer, int n2, int n3, String object) {
        FileOutputStream fileOutputStream;
        File file;
        File file2 = file;
        new File((String)object).createNewFile();
        object = fileOutputStream;
        ((FileOutputStream)object)(file2);
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer(buffer);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)object);
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.toString());
        }
    }

    static class Plane {
        private ByteBuffer buffer;
        private int rowStride;
        private int pixelStride;

        public Plane(ByteBuffer byteBuffer, int n2, int n3) {
            this.buffer = byteBuffer;
            this.rowStride = n2;
            this.pixelStride = n3;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getRowStride() {
            return this.rowStride;
        }

        public int getPixelStride() {
            return this.pixelStride;
        }
    }
}

