/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.AgoraSurfaceView;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.video.VideoCapture;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class AgoraVideoDebugger {
    public static final String TAG = "AgoraVideoDebugger";
    public static final boolean ENABLE_DEBUG = false;
    public static final boolean VERBOSE = false;
    public static final boolean VERBOSE_DETAIL = false;
    public static final boolean DIRECT_OES = false;
    static DebugViewHolder capturePreviewHolder;
    static DebugViewHolder observerPreviewHolder;
    static DebugViewHolder i420BufferPreviewHolder;
    static DebugViewHolder textureBufferPreviewHolder;
    static boolean yuvRender = false;
    static int textureFrameCnt = 0;
    static int droppedTextureFrameCnt = 0;

    public static AgoraSurfaceView exampleUsage(Activity activity) {
        AgoraSurfaceView agoraSurfaceView;
        AgoraSurfaceView agoraSurfaceView2 = agoraSurfaceView;
        agoraSurfaceView2((Context)activity);
        ((ViewGroup)activity.findViewById(0x1020002)).addView((View)agoraSurfaceView2, 360, 640);
        agoraSurfaceView.setZOrderOnTop(true);
        AgoraVideoDebugger.setCapturePreview(agoraSurfaceView, false, true, true, false);
        return agoraSurfaceView;
    }

    public static void setCapturePreview(AgoraSurfaceView agoraSurfaceView) {
        AgoraVideoDebugger.setCapturePreview(agoraSurfaceView, true, true, true, false);
    }

    public static void setCapturePreview(AgoraSurfaceView agoraSurfaceView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    static void reset() {
    }

    static void onTextureBufferAvailable(VideoCapture videoCapture, EglBase.Context context, VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
    }

    static void onRawBufferAvailable(VideoCapture videoCapture, byte[] byArray, int n2, int n3, int n4, int n5) {
    }

    static void onTextureAndRawBufferAvailable(VideoCapture videoCapture, VideoFrame.TextureBuffer textureBuffer, int n2, long l2, byte[] byArray, int n3) {
    }

    static void onDropTextureBuffer(long l2) {
    }

    public static void setObserverPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onCaptureVideoFrame(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
    }

    public static void setI420BufferPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onI420Buffer(VideoFrame.I420Buffer i420Buffer, int n2, long l2) {
    }

    public static void setTextureBufferPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onTextureBuffer(VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
    }

    public static ByteBuffer convertI420ToCompactByteBuffer(VideoFrame.I420Buffer i420Buffer) {
        ByteBuffer byteBuffer;
        VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
        int n2 = i420Buffer2.getWidth();
        int n3 = i420Buffer.getHeight();
        int n4 = (n3 + 1) / 2;
        int n5 = (n2 + 1) / 2;
        int n6 = 0;
        int n7 = n2 * n3;
        int n8 = n7 + n6;
        int n9 = n5 * n4;
        int n10 = n8 + n9;
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocateDirect(n7 + n5 * 2 * n4);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.position(n6);
        byteBuffer3.limit(n8);
        ByteBuffer byteBuffer4 = byteBuffer3.slice();
        byteBuffer.position(n8);
        byteBuffer2.limit(n10);
        ByteBuffer byteBuffer5 = byteBuffer2.slice();
        byteBuffer.position(n10);
        byteBuffer.limit(n10 + n9);
        ByteBuffer byteBuffer6 = byteBuffer.slice();
        ByteBuffer byteBuffer7 = i420Buffer2.getDataY();
        for (int i2 = 0; i2 < n3; ++i2) {
            ByteBuffer byteBuffer8 = byteBuffer7;
            int n11 = i2 * i420Buffer.getStrideY();
            byteBuffer8.limit(n11 + n2);
            byteBuffer8.position(n11);
            byteBuffer4.put(byteBuffer8.slice());
        }
        ByteBuffer byteBuffer9 = i420Buffer.getDataU();
        for (n3 = 0; n3 < n4; ++n3) {
            ByteBuffer byteBuffer10 = byteBuffer9;
            int n12 = n3 * i420Buffer.getStrideU();
            byteBuffer10.limit(n12 + n5);
            byteBuffer10.position(n12);
            byteBuffer5.put(byteBuffer10.slice());
        }
        byteBuffer9 = i420Buffer.getDataV();
        for (n3 = 0; n3 < n4; ++n3) {
            ByteBuffer byteBuffer11 = byteBuffer9;
            int n13 = n3 * i420Buffer.getStrideV();
            byteBuffer11.limit(n13 + n5);
            byteBuffer11.position(n13);
            byteBuffer6.put(byteBuffer11.slice());
        }
        ByteBuffer byteBuffer12 = byteBuffer;
        byteBuffer12.position(n6);
        return byteBuffer12;
    }

    public static byte[] convertYv12ToCompactI420(byte[] byArray, int n2, int n3) {
        int n4 = n2 + 15 >> 4 << 4;
        int n5 = n4 * n3;
        int n6 = n4 >> 1 >> 4 << 4;
        int n7 = n5 + (n6 * n3 >> 1);
        int n8 = n2 * n3;
        int n9 = n2 / 2;
        int n10 = n3 / 2;
        int n11 = n8 * 5 / 4;
        byte[] byArray2 = new byte[n8 * 3 / 2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n12 = n4 * i2;
            int n13 = n2 * i2;
            System.arraycopy(byArray, n12, byArray2, n13, n2);
        }
        for (n2 = 0; n2 < n10; ++n2) {
            n3 = n7 + n6 * n2;
            n4 = n8 + n9 * n2;
            System.arraycopy(byArray, n3, byArray2, n4, n9);
        }
        for (n2 = 0; n2 < n10; ++n2) {
            n3 = n5 + n6 * n2;
            n4 = n11 + n9 * n2;
            System.arraycopy(byArray, n3, byArray2, n4, n9);
        }
        return byArray2;
    }

    public static byte[] convertNv21ToCompactI420(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 * n3;
        int n6 = 2;
        int n7 = n5 + 1;
        int n8 = n2 / 2;
        int n9 = n3 / 2;
        int n10 = n5 * 5 / 4;
        byte[] byArray2 = new byte[n5 * 3 / 2];
        for (n4 = 0; n4 < n3; ++n4) {
            int n11 = n2 * n4;
            System.arraycopy(byArray, n11, byArray2, n11, n2);
        }
        for (n3 = 0; n3 < n9; ++n3) {
            for (n4 = 0; n4 < n8; ++n4) {
                int n12 = n5 + n8 * n3 + n4;
                byArray2[n12] = byArray[n7 + n2 * n3 + n6 * n4];
            }
        }
        for (n3 = 0; n3 < n9; ++n3) {
            for (n7 = 0; n7 < n8; ++n7) {
                n4 = n10 + n8 * n3 + n7;
                byArray2[n4] = byArray[n5 + n2 * n3 + n6 * n7];
            }
        }
        return byArray2;
    }

    public static void textureDump(VideoFrame.TextureBuffer object, FileOutputStream fileOutputStream) {
        if (object != null && fileOutputStream != null) {
            if ((object = object.toI420()) == null) {
                return;
            }
            FileOutputStream fileOutputStream2 = fileOutputStream;
            object = AgoraVideoDebugger.convertI420ToCompactByteBuffer((VideoFrame.I420Buffer)object);
            FileChannel fileChannel = fileOutputStream2.getChannel();
            FileChannel fileChannel2 = fileChannel;
            fileChannel.write((ByteBuffer)object);
            try {
                fileChannel2.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public static void rawDataDump(byte[] byArray, FileOutputStream fileOutputStream) {
        if (byArray != null && byArray.length != 0) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public static MediaIO.PixelFormat getMediaIOPixelFormat(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.getType() == VideoFrame.TextureBuffer.Type.OES ? MediaIO.PixelFormat.TEXTURE_OES : MediaIO.PixelFormat.TEXTURE_2D;
    }

    public static int getAgoraVideoFrameFormat(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.getType() == VideoFrame.TextureBuffer.Type.OES ? 11 : 10;
    }

    static class DebugViewHolder {
        AgoraSurfaceView agoraSurfaceView;
        boolean followSourceDimension;
        boolean mirror;
        boolean applyRotation;
        boolean isInitialized = false;
        int lastSourceWidth = 0;
        int lastSourceHeight = 0;

        public DebugViewHolder(AgoraSurfaceView agoraSurfaceView, boolean bl, boolean bl2, boolean bl3) {
            this.agoraSurfaceView = agoraSurfaceView;
            this.followSourceDimension = bl;
            this.mirror = bl2;
            this.applyRotation = bl3;
        }

        void init(EglBase.Context context, MediaIO.BufferType bufferType, MediaIO.PixelFormat pixelFormat) {
            if (this.isInitialized) {
                return;
            }
            DebugViewHolder debugViewHolder = this;
            debugViewHolder.agoraSurfaceView.init(context);
            debugViewHolder.agoraSurfaceView.setBufferType(bufferType);
            debugViewHolder.agoraSurfaceView.setPixelFormat(pixelFormat);
            debugViewHolder.agoraSurfaceView.setMirror(this.mirror);
            debugViewHolder.agoraSurfaceView.onInitialize();
            debugViewHolder.agoraSurfaceView.onStart();
            debugViewHolder.isInitialized = true;
        }

        void setupViewUI(final int n2, final int n3, final int n4) {
            if (this.followSourceDimension && (this.lastSourceWidth != n3 || this.lastSourceHeight != n4)) {
                this.agoraSurfaceView.post(new Runnable(){

                    @Override
                    public void run() {
                        int n22;
                        n22 = DebugViewHolder.this.applyRotation && ((n22 = n2) == 90 || n22 == 270) ? 1 : 0;
                        ViewGroup.LayoutParams layoutParams = DebugViewHolder.this.agoraSurfaceView.getLayoutParams();
                        int n32 = n22 != 0 ? n4 : n3;
                        layoutParams.width = n32;
                        ViewGroup.LayoutParams layoutParams2 = DebugViewHolder.this.agoraSurfaceView.getLayoutParams();
                        int n42 = n22 != 0 ? n3 : n4;
                        layoutParams2.height = n42;
                    }
                });
                this.lastSourceWidth = n3;
                this.lastSourceHeight = n4;
            }
        }

        void reset() {
            AgoraSurfaceView agoraSurfaceView = this.agoraSurfaceView;
            if (agoraSurfaceView != null) {
                if (this.isInitialized) {
                    agoraSurfaceView.onStop();
                    this.agoraSurfaceView.onDispose();
                }
                this.agoraSurfaceView = null;
            }
            DebugViewHolder debugViewHolder = this;
            debugViewHolder.followSourceDimension = false;
            debugViewHolder.mirror = false;
            debugViewHolder.applyRotation = false;
            debugViewHolder.lastSourceWidth = 0;
            debugViewHolder.lastSourceHeight = 0;
            debugViewHolder.isInitialized = false;
        }
    }
}

