/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLDebugHelper;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import io.agora.rtc.internal.Logging;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
View.OnLayoutChangeListener {
    private static final String TAG = "GLTextureView";
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_GL_STATE = false;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private final WeakReference<GLTextureView> mThisWeakRef;
    private GLThread mGLThread;
    private Renderer mRenderer;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;

    public GLTextureView(Context object) {
        WeakReference<GLTextureView> weakReference;
        GLTextureView gLTextureView = this;
        super(object);
        object = weakReference;
        weakReference = new WeakReference<GLTextureView>(this);
        gLTextureView.mThisWeakRef = object;
        gLTextureView.init();
    }

    public GLTextureView(Context object, AttributeSet attributeSet) {
        WeakReference<GLTextureView> weakReference;
        GLTextureView gLTextureView = this;
        super(object, attributeSet);
        object = weakReference;
        weakReference = new WeakReference<GLTextureView>(this);
        gLTextureView.mThisWeakRef = object;
        gLTextureView.init();
    }

    private void init() {
        GLTextureView gLTextureView = this;
        gLTextureView.setSurfaceTextureListener(gLTextureView);
    }

    private void checkRenderThreadState() {
        if (this.mGLThread == null) {
            return;
        }
        throw new IllegalStateException("setRenderer has already been called for this instance.");
    }

    static /* synthetic */ boolean access$900(GLTextureView gLTextureView) {
        return gLTextureView.mPreserveEGLContextOnPause;
    }

    static /* synthetic */ Renderer access$1000(GLTextureView gLTextureView) {
        return gLTextureView.mRenderer;
    }

    protected void finalize() throws Throwable {
        block3: {
            try {
                if (this.mGLThread == null) break block3;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            this.mGLThread.requestExitAndWait();
        }
        super.finalize();
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setDebugFlags(int n2) {
        this.mDebugFlags = n2;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public void setRenderer(Renderer renderer) {
        Object object;
        GLTextureView gLTextureView = this;
        gLTextureView.checkRenderThreadState();
        if (gLTextureView.mEGLConfigChooser == null) {
            SimpleEGLConfigChooser simpleEGLConfigChooser;
            object = simpleEGLConfigChooser;
            simpleEGLConfigChooser = new SimpleEGLConfigChooser(true);
            this.mEGLConfigChooser = object;
        }
        if (this.mEGLContextFactory == null) {
            DefaultContextFactory defaultContextFactory;
            object = defaultContextFactory;
            defaultContextFactory = new DefaultContextFactory();
            this.mEGLContextFactory = object;
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            DefaultWindowSurfaceFactory defaultWindowSurfaceFactory;
            object = defaultWindowSurfaceFactory;
            defaultWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
            this.mEGLWindowSurfaceFactory = object;
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        SimpleEGLConfigChooser simpleEGLConfigChooser;
        SimpleEGLConfigChooser simpleEGLConfigChooser2 = simpleEGLConfigChooser;
        simpleEGLConfigChooser = new SimpleEGLConfigChooser(bl);
        this.setEGLConfigChooser(simpleEGLConfigChooser2);
    }

    public void setEGLConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
        ComponentSizeChooser componentSizeChooser;
        ComponentSizeChooser componentSizeChooser2 = componentSizeChooser;
        componentSizeChooser = new ComponentSizeChooser(this, n2, n3, n4, n5, n6, n7);
        this.setEGLConfigChooser(componentSizeChooser2);
    }

    public void setEGLContextClientVersion(int n2) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n2;
    }

    public void setRenderMode(int n2) {
        this.mGLThread.setRenderMode(n2);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void surfaceCreated(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceTexture surfaceTexture) {
        this.mGLThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceTexture surfaceTexture, int n2, int n3, int n4) {
        this.mGLThread.onWindowResize(n3, n4);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    protected void onAttachedToWindow() {
        GLTextureView gLTextureView = this;
        super.onAttachedToWindow();
        if (gLTextureView.mDetached && this.mRenderer != null) {
            GLThread gLThread;
            int n2 = 1;
            GLThread gLThread2 = this.mGLThread;
            if (gLThread2 != null) {
                n2 = gLThread2.getRenderMode();
            }
            gLThread2 = gLThread;
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n2 != 1) {
                gLThread2.setRenderMode(n2);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        GLThread gLThread = this.mGLThread;
        if (gLThread != null) {
            gLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GLTextureView gLTextureView = gLTextureView2;
        GLTextureView gLTextureView2 = gLTextureView2.getSurfaceTexture();
        int n10 = n4 - n2;
        n2 = n5 - n3;
        gLTextureView.surfaceChanged((SurfaceTexture)gLTextureView2, 0, n10, n2);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        GLTextureView gLTextureView = this;
        gLTextureView.surfaceCreated(surfaceTexture);
        gLTextureView.surfaceChanged(surfaceTexture, 0, n2, n3);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        this.surfaceChanged(surfaceTexture, 0, n2, n3);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.surfaceDestroyed(surfaceTexture);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private boolean mGLESVersionCheckComplete;
        private int mGLESVersion;
        private boolean mGLESDriverCheckComplete;
        private boolean mMultipleGLESContextsAllowed;
        private boolean mLimitedGLESContexts;
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersionCheckComplete = true;
            }
        }

        public synchronized void threadExiting(GLThread gLThread) {
            GLThread.access$1102(gLThread, true);
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            GLThread gLThread2 = ((GLThreadManager)((Object)gLThread3)).mEglOwner;
            if (gLThread2 != gLThread && gLThread2 != null) {
                GLThreadManager gLThreadManager = gLThread3;
                gLThreadManager.checkGLESVersion();
                if (gLThreadManager.mMultipleGLESContextsAllowed) {
                    return true;
                }
                GLThread gLThread3 = ((GLThreadManager)((Object)gLThread3)).mEglOwner;
                if (gLThread3 != null) {
                    gLThread3.requestReleaseEglContextLocked();
                }
                return false;
            }
            ((GLThreadManager)((Object)gLThread3)).mEglOwner = gLThread;
            gLThread3.notifyAll();
            return true;
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            if (this.mEglOwner == gLThread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return this.mLimitedGLESContexts;
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            GLThreadManager gLThreadManager = this;
            gLThreadManager.checkGLESVersion();
            return gLThreadManager.mMultipleGLESContextsAllowed ^ true;
        }

        public synchronized void checkGLDriver(GL10 object) {
            if (!this.mGLESDriverCheckComplete) {
                this.checkGLESVersion();
                object = object.glGetString(7937);
                if (this.mGLESVersion < 131072) {
                    this.mMultipleGLESContextsAllowed = ((String)object).startsWith(kMSM7K_RENDERER_PREFIX) ^ true;
                    this.notifyAll();
                }
                this.mLimitedGLESContexts = this.mMultipleGLESContextsAllowed ^ true;
                this.mGLESDriverCheckComplete = true;
            }
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder;

        LogWriter() {
            StringBuilder stringBuilder;
            Appendable appendable = stringBuilder;
            stringBuilder = new StringBuilder();
            v1.mBuilder = appendable;
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                LogWriter logWriter = this;
                Logging.d(GLTextureView.TAG, logWriter.mBuilder.toString());
                StringBuilder stringBuilder = logWriter.mBuilder;
                stringBuilder.delete(0, stringBuilder.length());
            }
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = cArray[n2 + i2];
                if (c2 == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c2);
            }
        }
    }

    static class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth;
        private int mHeight;
        private int mRenderMode;
        private boolean mRequestRender;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue;
        private boolean mSizeChanged;
        private EglHelper mEglHelper;
        private WeakReference<GLTextureView> mGLSurfaceViewWeakRef;

        GLThread(WeakReference<GLTextureView> weakReference) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.mEventQueue = arrayList2;
            v1.mSizeChanged = true;
            v1.mWidth = 0;
            v1.mHeight = 0;
            v1.mRequestRender = true;
            v1.mRenderMode = 1;
            v1.mGLSurfaceViewWeakRef = weakReference;
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * Exception decompiling
         */
        private void guardedRun() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [72[UNCONDITIONALDOLOOP]], but top level block is 60[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        static /* synthetic */ boolean access$1102(GLThread gLThread, boolean bl) {
            gLThread.mExited = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            GLThread gLThread = this;
            gLThread.setName("GLThread " + this.getId());
            try {
                gLThread.guardedRun();
            }
            catch (Throwable throwable) {
                sGLThreadManager.threadExiting(this);
                throw throwable;
            }
            catch (InterruptedException interruptedException) {}
            sGLThreadManager.threadExiting(this);
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int n2) {
            if (n2 >= 0 && n2 <= 1) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRenderMode = n2;
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("renderMode");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThread gLThread = gLThreadManager;
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return gLThread.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Exception decompiling
         */
        public void surfaceCreated() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 7[WHILELOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void surfaceDestroyed() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 7[WHILELOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void onPause() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 7[WHILELOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void onResume() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 8[WHILELOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void onWindowResize(int var1_1, int var2_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 9[WHILELOOP]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public void requestExitAndWait() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP], 4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable runnable) {
            if (runnable != null) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mEventQueue.add(runnable);
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("r must not be null");
        }
    }

    private static class EglHelper {
        private WeakReference<GLTextureView> mGLSurfaceViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public EglHelper(WeakReference<GLTextureView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        private void destroySurfaceImp() {
            Object object = this.mEglSurface;
            if (object != null && object != (object = EGL10.EGL_NO_SURFACE)) {
                EglHelper eglHelper = this;
                eglHelper.mEgl.eglMakeCurrent(this.mEglDisplay, object, object, EGL10.EGL_NO_CONTEXT);
                object = (GLTextureView)((Object)eglHelper.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    EGLWindowSurfaceFactory eGLWindowSurfaceFactory = ((GLTextureView)((Object)object)).mEGLWindowSurfaceFactory;
                    EglHelper eglHelper2 = this;
                    object = eglHelper2.mEgl;
                    EGLDisplay eGLDisplay = eglHelper2.mEglDisplay;
                    EGLSurface eGLSurface = eglHelper2.mEglSurface;
                    eGLWindowSurfaceFactory.destroySurface((EGL10)object, eGLDisplay, eGLSurface);
                }
                this.mEglSurface = null;
            }
        }

        private void throwEglException(String string2) {
            EglHelper.throwEglException(string2, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string2, int n2) {
            string2 = EglHelper.formatEglError(string2, n2);
            throw new RuntimeException(string2);
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n2) {
            Logging.w(string2, EglHelper.formatEglError(string3, n2));
        }

        public static String formatEglError(String string2, int n2) {
            return string2 + " failed: " + n2;
        }

        public void start() {
            Object object;
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = object = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (object != EGL10.EGL_NO_DISPLAY) {
                Object object2 = new int[2];
                if (this.mEgl.eglInitialize(object, object2)) {
                    object = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
                    if (object == null) {
                        EglHelper eglHelper = this;
                        eglHelper.mEglConfig = null;
                        eglHelper.mEglContext = null;
                    } else {
                        Object object3 = object;
                        EGLConfigChooser eGLConfigChooser = ((GLTextureView)((Object)object)).mEGLConfigChooser;
                        EglHelper eglHelper = this;
                        object = eglHelper.mEgl;
                        this.mEglConfig = eGLConfigChooser.chooseConfig((EGL10)object, eglHelper.mEglDisplay);
                        EglHelper eglHelper2 = this;
                        object = eglHelper2.mEgl;
                        object2 = eglHelper2.mEglDisplay;
                        EGLConfig eGLConfig = eglHelper2.mEglConfig;
                        this.mEglContext = ((GLTextureView)((Object)object3)).mEGLContextFactory.createContext((EGL10)object, (EGLDisplay)object2, eGLConfig);
                    }
                    object = this.mEglContext;
                    if (object == null || object == EGL10.EGL_NO_CONTEXT) {
                        this.mEglContext = null;
                        this.throwEglException("createContext");
                    }
                    this.mEglSurface = null;
                    return;
                }
                throw new RuntimeException("eglInitialize failed");
            }
            throw new RuntimeException("eglGetDisplay failed");
        }

        public boolean createSurface() {
            if (this.mEgl != null) {
                if (this.mEglDisplay != null) {
                    if (this.mEglConfig != null) {
                        EGLConfig eGLConfig;
                        EGLDisplay eGLDisplay;
                        EglHelper eglHelper = this;
                        eglHelper.destroySurfaceImp();
                        GLTextureView gLTextureView = (GLTextureView)((Object)eglHelper.mGLSurfaceViewWeakRef.get());
                        if (gLTextureView != null) {
                            EGLWindowSurfaceFactory eGLWindowSurfaceFactory = gLTextureView.mEGLWindowSurfaceFactory;
                            GLTextureView gLTextureView2 = gLTextureView;
                            EglHelper eglHelper2 = this;
                            gLTextureView = eglHelper2.mEgl;
                            eGLDisplay = eglHelper2.mEglDisplay;
                            eGLConfig = eglHelper2.mEglConfig;
                            SurfaceTexture surfaceTexture = gLTextureView2.getSurfaceTexture();
                            this.mEglSurface = eGLWindowSurfaceFactory.createWindowSurface((EGL10)gLTextureView, eGLDisplay, eGLConfig, surfaceTexture);
                        } else {
                            this.mEglSurface = null;
                        }
                        gLTextureView = this.mEglSurface;
                        if (gLTextureView != null && gLTextureView != EGL10.EGL_NO_SURFACE) {
                            EglHelper eglHelper3 = this;
                            eGLDisplay = eglHelper3.mEglDisplay;
                            eGLConfig = eglHelper3.mEglContext;
                            GLTextureView gLTextureView3 = gLTextureView;
                            if (!this.mEgl.eglMakeCurrent(eGLDisplay, (EGLSurface)gLTextureView3, (EGLSurface)gLTextureView3, (EGLContext)eGLConfig)) {
                                int n2 = this.mEgl.eglGetError();
                                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", n2);
                                return false;
                            }
                            return true;
                        }
                        if (this.mEgl.eglGetError() == 12299) {
                            Logging.e("EglHelper", "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                        }
                        return false;
                    }
                    throw new RuntimeException("mEglConfig not initialized");
                }
                throw new RuntimeException("eglDisplay not initialized");
            }
            throw new RuntimeException("egl not initialized");
        }

        GL createGL() {
            EglHelper eglHelper = eglHelper2;
            EglHelper eglHelper2 = eglHelper.mEglContext.getGL();
            GLTextureView gLTextureView = (GLTextureView)((Object)eglHelper.mGLSurfaceViewWeakRef.get());
            if (gLTextureView != null) {
                if (gLTextureView.mGLWrapper != null) {
                    eglHelper2 = gLTextureView.mGLWrapper.wrap((GL)eglHelper2);
                }
                if ((gLTextureView.mDebugFlags & 3) != 0) {
                    int n2 = 0;
                    LogWriter logWriter = null;
                    if ((gLTextureView.mDebugFlags & 1) != 0) {
                        n2 = 1;
                    }
                    if ((gLTextureView.mDebugFlags & 2) != 0) {
                        LogWriter logWriter2;
                        logWriter = logWriter2;
                        logWriter2 = new LogWriter();
                    }
                    eglHelper2 = GLDebugHelper.wrap((GL)eglHelper2, (int)n2, (Writer)logWriter);
                }
            }
            return eglHelper2;
        }

        public int swap() {
            EglHelper eglHelper = this;
            EGLDisplay eGLDisplay = eglHelper.mEglDisplay;
            if (!this.mEgl.eglSwapBuffers(eGLDisplay, eglHelper.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        public void finish() {
            Object object;
            if (this.mEglContext != null) {
                object = (GLTextureView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    EGLContextFactory eGLContextFactory = ((GLTextureView)((Object)object)).mEGLContextFactory;
                    EglHelper eglHelper = this;
                    object = eglHelper.mEgl;
                    EGLDisplay eGLDisplay = eglHelper.mEglDisplay;
                    EGLContext eGLContext = eglHelper.mEglContext;
                    eGLContextFactory.destroyContext((EGL10)object, eGLDisplay, eGLContext);
                }
                this.mEglContext = null;
            }
            if ((object = this.mEglDisplay) != null) {
                this.mEgl.eglTerminate(object);
                this.mEglDisplay = null;
            }
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean bl) {
            int n2 = 8;
            int n3 = 8;
            int n4 = 8;
            int n5 = 0;
            int n6 = bl ? 16 : 0;
            super(GLTextureView.this, n2, n3, n4, n5, n6, 0);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        final /* synthetic */ GLTextureView this$0;

        public ComponentSizeChooser(GLTextureView gLTextureView, int n2, int n3, int n4, int n5, int n6, int n7) {
            ComponentSizeChooser componentSizeChooser = object;
            ComponentSizeChooser componentSizeChooser2 = object;
            ComponentSizeChooser componentSizeChooser3 = object;
            ComponentSizeChooser componentSizeChooser4 = object;
            ComponentSizeChooser componentSizeChooser5 = object;
            ComponentSizeChooser componentSizeChooser6 = object;
            ComponentSizeChooser componentSizeChooser7 = object;
            ((ComponentSizeChooser)object).this$0 = gLTextureView;
            int[] nArray = new int[13];
            Object object = nArray;
            nArray[0] = 12324;
            nArray[1] = n2;
            nArray[2] = 12323;
            nArray[3] = n3;
            nArray[4] = 12322;
            nArray[5] = n4;
            nArray[6] = 12321;
            nArray[7] = n5;
            nArray[8] = 12325;
            nArray[9] = n6;
            nArray[10] = 12326;
            nArray[11] = n7;
            nArray[12] = 12344;
            super((int[])object);
            componentSizeChooser7.mValue = new int[1];
            componentSizeChooser6.mRedSize = n2;
            componentSizeChooser5.mGreenSize = n3;
            componentSizeChooser4.mBlueSize = n4;
            componentSizeChooser3.mAlphaSize = n5;
            componentSizeChooser2.mDepthSize = n6;
            componentSizeChooser.mStencilSize = n7;
        }

        private int findConfigAttrib(EGL10 object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (object.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, (int[])(object = (Object)this.mValue))) {
                return this.mValue[0];
            }
            return n3;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                ComponentSizeChooser componentSizeChooser = this;
                int n2 = componentSizeChooser.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0) < componentSizeChooser.mDepthSize || n2 < this.mStencilSize) continue;
                ComponentSizeChooser componentSizeChooser2 = this;
                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n4 = componentSizeChooser2.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0) != componentSizeChooser2.mRedSize || n2 != this.mGreenSize || n3 != this.mBlueSize || n4 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        private int[] filterConfigSpec(int[] nArray) {
            if (GLTextureView.this.mEGLContextClientVersion != 2) {
                return nArray;
            }
            int n2 = nArray.length;
            int[] nArray2 = new int[n2 + 2];
            int[] nArray3 = nArray2;
            int n3 = n2;
            int n4 = n2--;
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            nArray3[n2] = 12352;
            nArray3[n4] = 4;
            nArray2[n3 + 1] = 12344;
            return nArray2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                int n2 = nArray[0];
                if (n2 > 0) {
                    EGLConfig[] eGLConfigArray = new EGLConfig[n2];
                    if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n2, nArray)) {
                        if ((this = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray)) != null) {
                            return this;
                        }
                        throw new IllegalArgumentException("No config chosen");
                    }
                    throw new IllegalArgumentException("eglChooseConfig#2 failed");
                }
                throw new IllegalArgumentException("No configs match configSpec");
            }
            throw new IllegalArgumentException("eglChooseConfig failed");
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            DefaultWindowSurfaceFactory defaultWindowSurfaceFactory = null;
            try {
                defaultWindowSurfaceFactory = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(GLTextureView.TAG, "eglCreateWindowSurface", illegalArgumentException);
            }
            return defaultWindowSurfaceFactory;
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            DefaultContextFactory defaultContextFactory = defaultContextFactory2;
            int[] nArray = new int[3];
            int[] nArray2 = nArray;
            nArray2[0] = defaultContextFactory2.EGL_CONTEXT_CLIENT_VERSION;
            nArray[1] = defaultContextFactory2.GLTextureView.this.mEGLContextClientVersion;
            nArray[2] = 12344;
            DefaultContextFactory defaultContextFactory2 = EGL10.EGL_NO_CONTEXT;
            if (defaultContextFactory.GLTextureView.this.mEGLContextClientVersion == 0) {
                nArray2 = null;
            }
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, (EGLContext)defaultContextFactory2, nArray2);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                Logging.e("DefaultContextFactory", "display:" + eGLDisplay + " context: " + eGLContext);
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);

        public void onSurfaceDestroyed(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

