/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.MediaCodecBase;
import io.agora.rtc.video.MediaCodecVideoEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MediaCodecVideoDecoder
extends MediaCodecBase {
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final boolean VERBOSE = false;
    private static final long MAX_DECODE_TIME_MS = 2000L;
    private static final int DEQUEUE_INPUT_TIMEOUT = 100000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static MediaCodecVideoDecoder runningInstance;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static int codecErrors = 0;
    private static Set<String> hwDecoderDisabledTypes;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String H265_MIME_TYPE = "video/hevc";
    private static final String[] supportedVp8HwCodecPrefixes;
    private static final String[] supportedVp9HwCodecPrefixes;
    private static final String[] supportedH264HwCodecPrefixes;
    private static final String[] supportedH265HwCodecPrefixes;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final List<Integer> supportedColorList;
    private static final List<Integer> supportedColorListAddOn;
    private static AtomicInteger currentInstances;
    private static final int MAX_TEXTURE_BUFFER_COUNT = 16;
    private static boolean preferGoogleSoftwareDecoder;
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private boolean useAsyncMode = false;
    ByteBuffer[] inputBuffers;
    ByteBuffer[] outputBuffers;
    private long nativeHandle;
    private MediaCodecDecoderCallback decoderCallback = null;
    private HandlerThread asyncHandlerThread;
    private String codecName;
    private int supportCodecs;
    private int supportInstances = 1;
    private int colorFormat;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private int cropWidth;
    private int cropHeight;
    private boolean hasDecodedFirstFrame;
    private boolean isOMXHisi;
    private final Queue<TimeStamps> decodeStartTimeMsQueue;
    private boolean useSurface;
    private SurfaceTextureHelper surfaceTextureHelper;
    private TextureListener textureListener;
    private int droppedFrames;
    private Surface surface;
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers;

    public MediaCodecVideoDecoder() {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        ConcurrentLinkedQueue concurrentLinkedQueue2;
        Object object = concurrentLinkedQueue2;
        concurrentLinkedQueue2 = new ConcurrentLinkedQueue();
        v1.decodeStartTimeMsQueue = object;
        v1.surface = null;
        object = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        v1.dequeuedSurfaceOutputBuffers = object;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static boolean isAsyncModeSupported() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableH265HwCodec() {
        Logging.w(TAG, "H.265 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H265_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes) != null;
    }

    public static boolean isH265HwSupported() {
        return !hwDecoderDisabledTypes.contains(H265_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H265_MIME_TYPE, supportedH265HwCodecPrefixes) != null;
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            int n2 = ((StackTraceElement[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d(TAG, object[i2].toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static DecoderProperties findDecoder(String var0, String[] var1_1) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Logging.i("MediaCodecVideoDecoder", "Trying to find HW decoder for mime " + var0);
        for (var2_2 = 0; var2_2 < MediaCodecList.getCodecCount(); ++var2_2) {
            var3_3 = null;
            try {
                var3_3 = MediaCodecList.getCodecInfoAt((int)var2_2);
            }
            catch (IllegalArgumentException var4_5) {
                Logging.e("MediaCodecVideoDecoder", "Cannot retrieve decoder codec info", var4_5);
            }
            if (var3_3 == null || var3_3.isEncoder()) continue;
            var4_4 = null;
            var5_6 = var3_3.getSupportedTypes();
            var6_9 = var5_6.length;
            for (var7_10 = 0; var7_10 < var6_9; ++var7_10) {
                if (!var5_6[var7_10].equals(var0)) continue;
                var4_4 = var3_3.getName();
                break;
            }
            if (var4_4 == null) continue;
            Logging.i("MediaCodecVideoDecoder", "Found candidate decoder: " + var4_4);
            var5_7 = false;
            if (MediaCodecVideoDecoder.preferGoogleSoftwareDecoder) {
                if (var4_4.startsWith("OMX.google.")) {
                    while (true) {
                        var5_7 = true;
                        break;
                    }
                }
            } else {
                var6_9 = var1_1.length;
                for (var7_10 = 0; var7_10 < var6_9; ++var7_10) {
                    if (var4_4.startsWith(var1_1[var7_10])) ** continue;
                }
            }
            if (!var5_7) continue;
            var3_3 = var3_3.getCapabilitiesForType(var0);
            var5_8 = var3_3.colorFormats;
            var6_9 = var3_3.colorFormats.length;
            for (var7_10 = 0; var7_10 < var6_9; ++var7_10) {
                Logging.d("MediaCodecVideoDecoder", "   Color: 0x" + Integer.toHexString(var5_8[var7_10]));
            }
            if (var4_4.startsWith("OMX.rk.")) {
                return new DecoderProperties(var4_4, 21);
            }
            var5_8 = MediaCodecVideoDecoder.supportedColorList.iterator();
            while (var5_8.hasNext()) {
                var6_9 = (Integer)var5_8.next();
                var7_11 = var3_3.colorFormats;
                var8_13 = var3_3.colorFormats.length;
                for (var9_14 = 0; var9_14 < var8_13; ++var9_14) {
                    var10_15 = var7_11[var9_14];
                    if (var10_15 != var6_9) continue;
                    Logging.i("MediaCodecVideoDecoder", "Found target decoder " + var4_4 + ". Color: 0x" + Integer.toHexString(var10_15));
                    return new DecoderProperties(var4_4, var10_15);
                }
            }
            if (Build.VERSION.SDK_INT < 21) continue;
            var5_8 = MediaCodecVideoDecoder.supportedColorListAddOn.iterator();
            while (var5_8.hasNext()) {
                var6_9 = (Integer)var5_8.next();
                var7_12 = var3_3.colorFormats;
                var8_13 = var3_3.colorFormats.length;
                for (var9_14 = 0; var9_14 < var8_13; ++var9_14) {
                    var10_15 = var7_12[var9_14];
                    if (var10_15 != var6_9) continue;
                    Logging.d("MediaCodecVideoDecoder", "Found target decoder " + var4_4 + ". Color: 0x" + Integer.toHexString(var10_15));
                    return new DecoderProperties(var4_4, var10_15);
                }
            }
        }
        Logging.i("MediaCodecVideoDecoder", "No HW decoder found for mime " + var0);
        return null;
    }

    private void getDecoderProperties(int n2) {
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = VP8_MIME_TYPE;
        stringArray[1] = VP9_MIME_TYPE;
        stringArray[2] = H264_MIME_TYPE;
        stringArray[3] = H265_MIME_TYPE;
        String string2 = null;
        this.supportCodecs = 0;
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (string3.equals(VP8_MIME_TYPE)) {
                    this.supportCodecs |= 1;
                } else if (string3.equals(H264_MIME_TYPE)) {
                    this.supportCodecs |= 2;
                } else if (string3.equals(H265_MIME_TYPE)) {
                    this.supportCodecs |= 4;
                }
                if (string2 != null || !string3.equals(stringArray2[n2])) continue;
                this.codecName = string2 = mediaCodecInfo.getName();
                string3 = mediaCodecInfo.getCapabilitiesForType(stringArray2[n2]);
                if (Build.VERSION.SDK_INT < 23) continue;
                this.supportInstances = string3.getMaxSupportedInstances();
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"NewApi"})
    private boolean initDecode(int n2, int n3, int n4, SurfaceTextureHelper object, boolean bl, Looper looper, long l2, boolean bl2, EglBase.Context object2, String string2) {
        void var10_18;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        if (currentInstances.get() >= this.supportInstances) {
            return false;
        }
        currentInstances.incrementAndGet();
        if (bl2) {
            this.surfaceTextureHelper = object == null ? SurfaceTextureHelper.create("ahwdectex", (EglBase.Context)object2, 16) : object;
            if (this.surfaceTextureHelper == null) {
                Logging.e(TAG, "failed to init decoder for surface output");
                return false;
            }
        }
        this.useSurface = bl2;
        VideoCodecType videoCodecType = VideoCodecType.values()[n2];
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            object = VP8_MIME_TYPE;
            String[] stringArray = supportedVp8HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            object = VP9_MIME_TYPE;
            String[] stringArray = supportedVp9HwCodecPrefixes;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            object = H264_MIME_TYPE;
            String[] stringArray = supportedH264HwCodecPrefixes;
        } else {
            if (videoCodecType != VideoCodecType.VIDEO_CODEC_H265) {
                throw new RuntimeException("initDecode: Non-supported codec " + (Object)((Object)videoCodecType));
            }
            object = H265_MIME_TYPE;
            String[] stringArray = supportedH265HwCodecPrefixes;
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder((String)object, (String[])var10_18);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + (Object)((Object)videoCodecType));
        }
        Logging.i(TAG, "Java initDecode: " + (Object)((Object)videoCodecType) + " : " + n3 + " x " + n4 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + bl2 + ". Use async mode: " + bl + ". nativeHandle: " + l2);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            void var11_20;
            this.width = n3;
            this.height = n4;
            this.stride = n3;
            this.sliceHeight = n4;
            this.cropWidth = n3;
            this.cropHeight = n4;
            if (decoderProperties.codecName != null && Build.HARDWARE != null && decoderProperties.codecName.startsWith("OMX.hisi.") && Build.HARDWARE.startsWith("bigfish")) {
                this.isOMXHisi = true;
                Logging.d(TAG, " bigfish isOMXHisi: " + this.isOMXHisi);
            } else {
                this.isOMXHisi = false;
            }
            videoCodecType = MediaFormat.createVideoFormat((String)object, (int)n3, (int)n4);
            if (!bl2) {
                String string3 = "color-format";
                videoCodecType.setInteger(string3, decoderProperties.colorFormat);
            }
            if (!TextUtils.isEmpty((CharSequence)var11_20)) {
                this.applyCustomConfig((MediaFormat)videoCodecType, new String(Base64.decode((String)var11_20, (int)0)));
            }
            Logging.d(TAG, "Format: " + (Object)((Object)videoCodecType));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            this.nativeHandle = l2;
            this.useAsyncMode = bl;
            if (bl) {
                this.decoderCallback = new MediaCodecDecoderCallback();
                if (looper == null) {
                    this.asyncHandlerThread = new HandlerThread("decoderAsyncHandler");
                    this.asyncHandlerThread.start();
                    looper = this.asyncHandlerThread.getLooper();
                }
                this.mediaCodec.setCallback((MediaCodec.Callback)this.decoderCallback, new Handler(looper));
            }
            if (bl2) {
                MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
                MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
                SurfaceTextureHelper surfaceTextureHelper = mediaCodecVideoDecoder2.surfaceTextureHelper;
                mediaCodecVideoDecoder.textureListener = new TextureListener(surfaceTextureHelper, mediaCodecVideoDecoder2.decoderCallback);
                mediaCodecVideoDecoder.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.mediaCodec.configure((MediaFormat)videoCodecType, this.surface, null, 0);
            mediaCodecVideoDecoder.mediaCodec.start();
            Logging.d(TAG, "MediaCodec started");
            this.colorFormat = decoderProperties.colorFormat;
            if (!bl) {
                MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
                mediaCodecVideoDecoder3.outputBuffers = mediaCodecVideoDecoder3.mediaCodec.getOutputBuffers();
                mediaCodecVideoDecoder3.inputBuffers = mediaCodecVideoDecoder3.mediaCodec.getInputBuffers();
                Logging.i(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder4 = this;
            mediaCodecVideoDecoder4.decodeStartTimeMsQueue.clear();
            mediaCodecVideoDecoder4.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder4.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder4.droppedFrames = 0;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reset(int n2, int n3) {
        if (this.mediaCodecThread != null && this.mediaCodec != null) {
            Logging.i(TAG, "Java reset: " + n2 + " x " + n3);
            if (this.useAsyncMode) {
                MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
                mediaCodecVideoDecoder.mediaCodec.flush();
                LinkedHashSet<Integer> linkedHashSet = mediaCodecVideoDecoder.decoderCallback.availableInputIndexes;
                synchronized (linkedHashSet) {
                    this.decoderCallback.availableInputIndexes.clear();
                }
                mediaCodecVideoDecoder.mediaCodec.start();
                Logging.d(TAG, "MediaCodec restarted");
            } else {
                this.mediaCodec.flush();
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            this.width = n2;
            mediaCodecVideoDecoder.height = n3;
            mediaCodecVideoDecoder.decodeStartTimeMsQueue.clear();
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.droppedFrames = 0;
            return;
        }
        throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void release() {
        Runnable runnable;
        CountDownLatch countDownLatch;
        Object object;
        Logging.i(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        if (this.useAsyncMode) {
            object = this.asyncHandlerThread;
            if (object != null) {
                object.quit();
                this.asyncHandlerThread = null;
            }
            object = this.decoderCallback;
            synchronized (object) {
                this.decoderCallback.isObsolete = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                this.decoderCallback = null;
            }
        }
        object = countDownLatch;
        ((CountDownLatch)object)(1);
        final MediaCodec mediaCodec = this.mediaCodec;
        Runnable runnable2 = runnable;
        runnable = new Runnable((CountDownLatch)object){
            final /* synthetic */ CountDownLatch val$releaseDone;
            {
                this.val$releaseDone = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    1 v0 = this;
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    v0.mediaCodec.stop();
                    v0.mediaCodec.release();
                    Logging.i(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                this.val$releaseDone.countDown();
            }
        };
        new Thread(runnable2).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        currentInstances.decrementAndGet();
        if (this.useSurface) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.surface.release();
            mediaCodecVideoDecoder.surface = null;
            mediaCodecVideoDecoder.textureListener.release();
            mediaCodecVideoDecoder.surfaceTextureHelper.dispose();
            mediaCodecVideoDecoder.surfaceTextureHelper = null;
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=21)
    private InputBufferInfo dequeueInputBufferAvailable() {
        v0 = this;
        var1_2 = v0.decoderCallback.availableInputIndexes;
        synchronized (var1_2) {
            if (v0.decoderCallback.availableInputIndexes.isEmpty()) {
                try {
                    this.decoderCallback.availableInputIndexes.wait(100000L);
                }
                catch (InterruptedException v1) {
                    v1.printStackTrace();
                }
            }
            var2_3 = this.decoderCallback.availableInputIndexes.iterator();
            {
                block13: {
                    catch (Throwable v2) {
                        throw v2;
                    }
                    {
                        if (var2_3.hasNext()) break block13;
                        Logging.e("MediaCodecVideoDecoder", "no input buffer available");
                    }
                    this = v3;
                    v3 = new InputBufferInfo(-1, null);
                    return this;
                }
                v4 = var2_3;
                var0_1 = (Integer)v4.next();
                v4.remove();
                try {
                    var2_3 = this.mediaCodec.getInputBuffer(var0_1);
                }
                catch (IllegalStateException var2_4) {}
                Logging.e("MediaCodecVideoDecoder", "failed to get input buffer for index " + var0_1 + " : " + var2_4);
                var3_5 = v5;
                {
                    v5 = new InputBufferInfo(-2, null);
lbl30:
                    // 2 sources

                    return var3_5;
                }
                var3_5 = v6;
                v6 = new InputBufferInfo(var0_1, (ByteBuffer)var2_3);
                ** GOTO lbl30
            }
        }
    }

    private int dequeueInputBuffer() {
        try {
            return this.mediaCodec.dequeueInputBuffer(100000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    private boolean queueInputBuffer(int n2, int n3, long l2, long l3, long l4) {
        block7: {
            TimeStamps timeStamps;
            MediaCodecVideoDecoder mediaCodecVideoDecoder;
            MediaCodecVideoDecoder mediaCodecVideoDecoder2;
            try {
                MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
                mediaCodecVideoDecoder2 = mediaCodecVideoDecoder3;
                mediaCodecVideoDecoder = mediaCodecVideoDecoder3;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "decode failed", illegalStateException);
                return false;
            }
            TimeStamps timeStamps2 = timeStamps;
            timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), l3, l4);
            mediaCodecVideoDecoder2.decodeStartTimeMsQueue.add(timeStamps2);
            if (mediaCodecVideoDecoder.useAsyncMode) break block7;
            MediaCodecVideoDecoder mediaCodecVideoDecoder4 = this;
            MediaCodecVideoDecoder mediaCodecVideoDecoder5 = mediaCodecVideoDecoder4;
            mediaCodecVideoDecoder4.inputBuffers[n2].position(0);
            mediaCodecVideoDecoder5.inputBuffers[n2].limit(n3);
        }
        this.mediaCodec.queueInputBuffer(n2, 0, n3, l2, 0);
        return true;
    }

    private DecodedOutputBuffer dequeueOutputBuffer(int n2) {
        MediaCodec.BufferInfo bufferInfo;
        if (((MediaCodecVideoDecoder)((Object)byteBuffer)).decodeStartTimeMsQueue.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            int n3 = ((MediaCodecVideoDecoder)((Object)byteBuffer)).mediaCodec.dequeueOutputBuffer(bufferInfo2, TimeUnit.MILLISECONDS.toMicros(n2));
            switch (n3) {
                default: {
                    MediaCodecVideoDecoder mediaCodecVideoDecoder = byteBuffer;
                    MediaCodecVideoDecoder mediaCodecVideoDecoder2 = byteBuffer;
                    ByteBuffer byteBuffer = ((MediaCodecVideoDecoder)((Object)byteBuffer)).outputBuffers[n3];
                    n2 = mediaCodecVideoDecoder2.getBufferColorFormat(n3);
                    return mediaCodecVideoDecoder.handleOutputBufferAvailable(n3, byteBuffer, bufferInfo2, n2);
                }
                case -1: {
                    return null;
                }
                case -2: {
                    MediaCodecVideoDecoder mediaCodecVideoDecoder = byteBuffer;
                    mediaCodecVideoDecoder.handleOutputFormatChanged(mediaCodecVideoDecoder.mediaCodec.getOutputFormat());
                    continue block5;
                }
                case -3: 
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = byteBuffer;
            mediaCodecVideoDecoder.outputBuffers = mediaCodecVideoDecoder.mediaCodec.getOutputBuffers();
            Logging.i(TAG, "Decoder output buffers changed: " + ((MediaCodecVideoDecoder)((Object)byteBuffer)).outputBuffers.length);
            if (mediaCodecVideoDecoder.hasDecodedFirstFrame) break;
        }
        throw new RuntimeException("Unexpected output buffer change event.");
    }

    private int getBufferColorFormat(int n2) {
        if (n2 < 0) {
            return 0;
        }
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 21 && this.colorFormat == 2135033992) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            n3 = mediaCodecVideoDecoder.mediaCodec.getOutputFormat(n2).getInteger("color-format");
            if (mediaCodecVideoDecoder.isOMXHisi && n3 == 47) {
                n3 = 17;
            }
        }
        return n3;
    }

    private DecodedOutputBuffer handleOutputBufferAvailable(int n2, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n3) {
        TimeStamps timeStamps = this.decodeStartTimeMsQueue.poll();
        if (timeStamps == null) {
            Logging.e(TAG, "decodeStartTimeMs empty, dropping decoded output");
            return null;
        }
        this.hasDecodedFirstFrame = true;
        long l2 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l2 > 2000L) {
            Logging.w(TAG, "Very high decode time: " + l2 + "ms.");
            l2 = 2000L;
        }
        int n4 = n2;
        TimeStamps timeStamps2 = timeStamps;
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        int n5 = bufferInfo2.offset;
        n2 = bufferInfo2.size;
        long l3 = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
        long l4 = timeStamps2.timeStamp;
        long l5 = timeStamps2.ntpTimeStamp;
        long l6 = SystemClock.elapsedRealtime();
        long l7 = this.decodeStartTimeMsQueue.size();
        return new DecodedOutputBuffer(n4, byteBuffer, n5, n2, n3, l3, l4, l5, l2, l6, l7);
    }

    private void handleOutputFormatChanged(MediaFormat mediaFormat) {
        MediaFormat mediaFormat2 = mediaFormat;
        Logging.i(TAG, "Decoder format changed: " + mediaFormat.toString());
        int n2 = mediaFormat2.getInteger("width");
        int n3 = mediaFormat2.getInteger("height");
        if (this.hasDecodedFirstFrame && (n2 != this.width || n3 != this.height)) {
            Logging.w(TAG, "Decoder format changed. Configured " + this.width + "*" + this.height + ". New " + n2 + "*" + n3);
        }
        this.width = mediaFormat.getInteger("width");
        this.height = mediaFormat.getInteger("height");
        if (mediaFormat.containsKey("stride")) {
            this.stride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.sliceHeight = mediaFormat.getInteger("slice-height");
        }
        this.cropWidth = mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right") ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : this.width;
        this.cropHeight = mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top") ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : this.height;
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        Logging.i(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
        Logging.i(TAG, "Crop width and height: " + this.cropWidth + " x " + this.cropHeight);
        mediaCodecVideoDecoder.stride = Math.max(mediaCodecVideoDecoder.width, this.stride);
        mediaCodecVideoDecoder.sliceHeight = Math.max(mediaCodecVideoDecoder.height, this.sliceHeight);
    }

    private void returnDecodedOutputBuffer(int n2) throws IllegalStateException, MediaCodec.CodecException {
        if (!this.useSurface) {
            this.mediaCodec.releaseOutputBuffer(n2, false);
            return;
        }
        throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
    }

    private DecodedTextureBuffer dequeueTextureBuffer(int n2) {
        if (((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).useSurface) {
            Object object = ((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeueOutputBuffer(n2);
            if (object != null) {
                ((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeuedSurfaceOutputBuffers.offer((DecodedOutputBuffer)object);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = decodedOutputBuffer;
            mediaCodecVideoDecoder.MaybeRenderDecodedTextureBuffer();
            object = mediaCodecVideoDecoder.textureListener.dequeueTextureBuffer();
            if (object != null) {
                ((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).MaybeRenderDecodedTextureBuffer();
                return object;
            }
            if (((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeuedSurfaceOutputBuffers.size() >= Math.min(3, ((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).outputBuffers.length)) {
                MediaCodecVideoDecoder mediaCodecVideoDecoder2 = decodedOutputBuffer;
                ++mediaCodecVideoDecoder2.droppedFrames;
                DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder2.dequeuedSurfaceOutputBuffers.poll();
                mediaCodecVideoDecoder2.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, false);
                Object object2 = decodedOutputBuffer;
                long l2 = ((DecodedOutputBuffer)object2).presentationTimeStampMs;
                long l3 = ((DecodedOutputBuffer)object2).timeStamp;
                long l4 = ((DecodedOutputBuffer)object2).ntpTimeStampMs;
                long l5 = ((DecodedOutputBuffer)object2).decodeTimeMs;
                long l6 = SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs;
                long l7 = ((DecodedOutputBuffer)object2).bufferedFrames;
                return new DecodedTextureBuffer(null, l2, l3, l4, l5, l6, null, l7);
            }
            return null;
        }
        throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.poll();
        if (decodedOutputBuffer == null) {
            return;
        }
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.textureListener.addBufferToRender(decodedOutputBuffer);
        MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
        int n2 = mediaCodecVideoDecoder2.cropWidth;
        mediaCodecVideoDecoder.textureListener.updateResolution(n2, mediaCodecVideoDecoder2.cropHeight);
        mediaCodecVideoDecoder.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    private native void deliverOutputYuvReady(DecodedOutputBuffer var1, long var2);

    private native void deliverOutputTextureReady(DecodedTextureBuffer var1, long var2);

    static /* synthetic */ int access$300(MediaCodecVideoDecoder mediaCodecVideoDecoder, int n2) {
        return mediaCodecVideoDecoder.getBufferColorFormat(n2);
    }

    static /* synthetic */ boolean access$400(MediaCodecVideoDecoder mediaCodecVideoDecoder) {
        return mediaCodecVideoDecoder.useSurface;
    }

    static /* synthetic */ MediaCodec access$500(MediaCodecVideoDecoder mediaCodecVideoDecoder) {
        return mediaCodecVideoDecoder.mediaCodec;
    }

    static /* synthetic */ DecodedOutputBuffer access$600(MediaCodecVideoDecoder mediaCodecVideoDecoder, int n2, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n3) {
        return mediaCodecVideoDecoder.handleOutputBufferAvailable(n2, byteBuffer, bufferInfo, n3);
    }

    static /* synthetic */ void access$800(MediaCodecVideoDecoder mediaCodecVideoDecoder, DecodedOutputBuffer decodedOutputBuffer, long l2) {
        mediaCodecVideoDecoder.deliverOutputYuvReady(decodedOutputBuffer, l2);
    }

    static /* synthetic */ Queue access$900(MediaCodecVideoDecoder mediaCodecVideoDecoder) {
        return mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers;
    }

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
        supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
        supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.rk.", "OMX.sprd.", "OMX.amlogic.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.hisi.", "OMX.k3.", "OMX.allwinner.", "OMX.MTK.", "OMX.Nvidia.", "OMX.Intel.", "OMX.MS.", "OMX.NVT."};
        supportedH265HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.rk.", "OMX.sprd.", "OMX.amlogic.", "OMX.IMG.TOPAZ.", "OMX.IMG.MSVDX.", "OMX.hisi.", "OMX.k3.", "OMX.allwinner.", "OMX.MTK.", "OMX.Nvidia.", "OMX.Intel.", "OMX.MS.", "OMX.google."};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391876);
        supportedColorListAddOn = Arrays.asList(2135033992);
        currentInstances = new AtomicInteger(0);
        preferGoogleSoftwareDecoder = false;
    }

    private static class TextureListener
    implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final Object newFrameLock = new Object();
        private final Queue<DecodedOutputBuffer> decodedOutputBuffers = new LinkedList<DecodedOutputBuffer>();
        private final Queue<DecodedTextureBuffer> decodedTextureBuffers = new LinkedList<DecodedTextureBuffer>();
        private int width;
        private int height;
        private final DecodedTextureBufferCallback decodedTextureBufferCallback;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper, DecodedTextureBufferCallback decodedTextureBufferCallback) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
            this.decodedOutputBuffers.clear();
            this.decodedTextureBufferCallback = decodedTextureBufferCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            Object object = this.newFrameLock;
            synchronized (object) {
                this.decodedOutputBuffers.offer(decodedOutputBuffer);
                return;
            }
        }

        public boolean isWaitingForTexture() {
            return false;
        }

        public void updateResolution(int n2, int n3) {
            TextureListener textureListener = this;
            textureListener.width = n2;
            textureListener.height = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
            DecodedTextureBuffer decodedTextureBuffer;
            TextureListener textureListener = this;
            Object object = textureListener.newFrameLock;
            // MONITORENTER : object
            DecodedOutputBuffer decodedOutputBuffer = textureListener.decodedOutputBuffers.poll();
            if (decodedOutputBuffer == null) {
                Logging.d(MediaCodecVideoDecoder.TAG, "texture_dec:null output buffer.");
                // MONITOREXIT : object
                return;
            }
            TextureListener textureListener2 = this;
            TextureListener textureListener3 = textureListener2;
            TextureListener textureListener4 = this;
            int n3 = textureListener4.width;
            int n4 = textureListener4.height;
            Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
            VideoFrame.TextureBuffer textureBuffer = textureListener2.surfaceTextureHelper.createTextureBuffer(n3, n4, matrix);
            VideoFrame.TextureBuffer textureBuffer2 = this.surfaceTextureHelper.textureCopy(textureBuffer);
            textureBuffer.release();
            DecodedTextureBuffer decodedTextureBuffer2 = decodedTextureBuffer;
            float[] fArray2 = fArray;
            DecodedOutputBuffer decodedOutputBuffer2 = decodedOutputBuffer;
            DecodedOutputBuffer decodedOutputBuffer3 = decodedOutputBuffer2;
            long l3 = decodedOutputBuffer2.presentationTimeStampMs;
            long l4 = decodedOutputBuffer2.timeStamp;
            long l5 = decodedOutputBuffer2.ntpTimeStampMs;
            long l6 = decodedOutputBuffer2.decodeTimeMs;
            long l7 = SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs;
            long l8 = decodedOutputBuffer3.bufferedFrames;
            decodedTextureBuffer = new DecodedTextureBuffer(fArray2, l3, l4, l5, l6, l7, textureBuffer2, l8);
            if (textureListener3.decodedTextureBufferCallback != null) {
                this.decodedTextureBufferCallback.onDecodedTextureBufferAvailable(decodedTextureBuffer2);
                return;
            }
            TextureListener textureListener5 = this;
            TextureListener textureListener6 = textureListener5;
            textureListener5.decodedTextureBuffers.offer(decodedTextureBuffer2);
            textureListener6.newFrameLock.notifyAll();
            // MONITOREXIT : object
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public DecodedTextureBuffer dequeueTextureBuffer() {
            v0 = this;
            var1_1 = 6;
            var2_2 = v0.newFrameLock;
            synchronized (var2_2) {
                if (!v0.decodedTextureBuffers.isEmpty()) ** GOTO lbl19
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
                }
                if (this.decodedOutputBuffers.isEmpty()) ** GOTO lbl19
                v2 = this.newFrameLock;
                try {
                    v2.wait(var1_1);
                    ** GOTO lbl19
                }
                catch (InterruptedException v3) {
                    Thread.currentThread().interrupt();
lbl19:
                    // 4 sources

                    return this.decodedTextureBuffers.poll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            TextureListener textureListener = this;
            textureListener.surfaceTextureHelper.stopListening();
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                textureListener.surfaceTextureHelper.returnTextureFrame();
                textureListener.decodedOutputBuffers.clear();
                for (DecodedTextureBuffer decodedTextureBuffer : textureListener.decodedTextureBuffers) {
                    if (decodedTextureBuffer.textureBuffer == null) continue;
                    decodedTextureBuffer.textureBuffer.release();
                }
                this.decodedTextureBuffers.clear();
                return;
            }
        }

        private static interface DecodedTextureBufferCallback {
            public void onDecodedTextureBufferAvailable(DecodedTextureBuffer var1);
        }
    }

    @TargetApi(value=21)
    class MediaCodecDecoderCallback
    extends MediaCodec.Callback
    implements TextureListener.DecodedTextureBufferCallback {
        boolean isObsolete = false;
        final LinkedHashSet<Integer> availableInputIndexes;

        MediaCodecDecoderCallback() {
            LinkedHashSet linkedHashSet;
            LinkedHashSet linkedHashSet2 = linkedHashSet;
            linkedHashSet = new LinkedHashSet();
            v1.availableInputIndexes = linkedHashSet2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInputBufferAvailable(MediaCodec object, int n2) {
            object = this.availableInputIndexes;
            MediaCodecDecoderCallback mediaCodecDecoderCallback = this;
            synchronized (object) {
                mediaCodecDecoderCallback.availableInputIndexes.add(n2);
                mediaCodecDecoderCallback.availableInputIndexes.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onOutputBufferAvailable(MediaCodec var1_1, int var2_6, MediaCodec.BufferInfo var3_7) {
            v0 = this;
            synchronized (v0) {
                if (v0.isObsolete) {
                    Logging.w("MediaCodecVideoDecoder", "discarding output as this callback is obsolete.");
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
                v1 = this;
                var1_2 = MediaCodecVideoDecoder.access$300(v1.MediaCodecVideoDecoder.this, var2_6);
                if (MediaCodecVideoDecoder.access$400(v1.MediaCodecVideoDecoder.this)) ** GOTO lbl30
                var4_8 = MediaCodecVideoDecoder.access$500(MediaCodecVideoDecoder.this).getOutputBuffer(var2_6);
                if (var4_8 != null) ** GOTO lbl25
                ** GOTO lbl22
                {
                    catch (IllegalStateException var1_4) {
                        Logging.e("MediaCodecVideoDecoder", "getOutputBuffer exception, index: " + var2_6, var1_4);
                        // ** MonitorExit[this] (shouldn't be in output)
                        return;
                    }
lbl22:
                    // 1 sources

                    Logging.e("MediaCodecVideoDecoder", "failed to get output buffer, index: " + var2_6);
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
lbl25:
                    // 1 sources

                    var1_3 = MediaCodecVideoDecoder.access$600(MediaCodecVideoDecoder.this, var2_6, var4_8, var3_7, var1_2);
                    if (var1_3 != null) {
                        MediaCodecVideoDecoder.access$800(MediaCodecVideoDecoder.this, var1_3, MediaCodecVideoDecoder.access$700(MediaCodecVideoDecoder.this));
                    }
                    MediaCodecVideoDecoder.access$500(MediaCodecVideoDecoder.this).releaseOutputBuffer(var2_6, false);
                    ** GOTO lbl39
lbl30:
                    // 1 sources

                    var1_5 = MediaCodecVideoDecoder.access$600(MediaCodecVideoDecoder.this, var2_6, null, var3_7, var1_2);
                    if (var1_5 != null) ** GOTO lbl34
                }
                {
                    MediaCodecVideoDecoder.access$500(MediaCodecVideoDecoder.this).releaseOutputBuffer(var2_6, false);
                    ** GOTO lbl39
lbl34:
                    // 1 sources

                    v3 = this;
                    v4 = v3;
                    MediaCodecVideoDecoder.access$900(v3.MediaCodecVideoDecoder.this).offer(var1_5);
                }
                {
                    MediaCodecVideoDecoder.access$1000(v4.MediaCodecVideoDecoder.this);
lbl39:
                    // 3 sources

                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
            }
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Logging.e(MediaCodecVideoDecoder.TAG, "onError " + codecException);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            Logging.w(MediaCodecVideoDecoder.TAG, "onOutputFormatChanged " + mediaFormat);
            MediaCodecVideoDecoder.this.handleOutputFormatChanged(mediaFormat);
        }

        @Override
        public void onDecodedTextureBufferAvailable(DecodedTextureBuffer decodedTextureBuffer) {
            MediaCodecDecoderCallback mediaCodecDecoderCallback = this;
            mediaCodecDecoderCallback.MediaCodecVideoDecoder.this.MaybeRenderDecodedTextureBuffer();
            MediaCodecVideoDecoder mediaCodecVideoDecoder = mediaCodecDecoderCallback.MediaCodecVideoDecoder.this;
            mediaCodecVideoDecoder.deliverOutputTextureReady(decodedTextureBuffer, mediaCodecVideoDecoder.nativeHandle);
        }
    }

    private static class DecodedTextureBuffer {
        private final float[] transformMatrix;
        private final long presentationTimeStampMs;
        private final long timeStamp;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long frameDelayMs;
        private final long bufferedFrames;
        VideoFrame.TextureBuffer textureBuffer;

        public DecodedTextureBuffer(float[] fArray, long l2, long l3, long l4, long l5, long l6, VideoFrame.TextureBuffer textureBuffer, long l7) {
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l2;
            this.timeStamp = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.frameDelayMs = l6;
            this.textureBuffer = textureBuffer;
            this.bufferedFrames = l7;
        }
    }

    private static class DecodedOutputBuffer {
        private final int index;
        private final int offset;
        private final int size;
        private final int imageFormat;
        public final ByteBuffer buffer;
        private final long presentationTimeStampMs;
        private final long timeStamp;
        private final long ntpTimeStampMs;
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;
        private final long bufferedFrames;

        public DecodedOutputBuffer(int n2, ByteBuffer byteBuffer, int n3, int n4, int n5, long l2, long l3, long l4, long l5, long l6, long l7) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.buffer = byteBuffer;
            this.imageFormat = n5;
            this.presentationTimeStampMs = l2;
            this.timeStamp = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.endDecodeTimeMs = l6;
            this.bufferedFrames = l7;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long timeStamp;
        private final long ntpTimeStamp;

        public TimeStamps(long l2, long l3, long l4) {
            this.decodeStartTimeMs = l2;
            this.timeStamp = l3;
            this.ntpTimeStamp = l4;
        }
    }

    static class InputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;

        public InputBufferInfo(int n2, ByteBuffer byteBuffer) {
            this.index = n2;
            this.buffer = byteBuffer;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string2, int n2) {
            this.codecName = string2;
            this.colorFormat = n2;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H265;
        private static final /* synthetic */ VideoCodecType[] $VALUES;

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }

        public static VideoCodecType valueOf(String string2) {
            return Enum.valueOf(VideoCodecType.class, string2);
        }

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_H264 = new VideoCodecType();
            VideoCodecType videoCodecType2 = videoCodecType;
            VIDEO_CODEC_H265 = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_H264, videoCodecType2};
        }
    }
}

