/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Range;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglBase10;
import io.agora.rtc.gl.EglBase14;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.MediaCodecBase;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLContext;

@TargetApi(value=19)
public class MediaCodecVideoEncoder
extends MediaCodecBase {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final boolean VERBOSE = false;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 3000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static int codecErrors = 0;
    private static Set<String> hwEncoderDisabledTypes;
    private static String codecOmxName;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String H265_MIME_TYPE = "video/hevc";
    private static final String[] supportedVp8HwCodecPrefixes;
    private static final String[] supportedVp9HwCodecPrefixes;
    private static final String[] supportedH264HwCodecPrefixes;
    private static final String[] supportedH265HwCodecPrefixes;
    private static final String[] H264_HW_EXCEPTION_MODELS;
    private static final String[] H264_HW_QCOM_EXCEPTION_MODELS;
    private static final String[] MTK_NO_ADJUSTMENT_MODELS;
    private static final String[] INTERVAL_HW_EXCEPTION_MODELS;
    private static final int INT_SETTING_INTERVAL_VALUE = 10;
    private static final int INT_INTERVAL_UPPER_LIMIT = 100;
    private static final String[] H265_HW_EXCEPTION_MODELS;
    private static final String[] H265_HW_EXCEPTION_HARDWARES;
    private static final String[] ASYNC_EXCLUDED_MODELS;
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private static final int BASE_FRAME_RATE_FOR_MTK = 30;
    private static final int BASE_FRAME_RATE_FOR_EXYNOS = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_TOPAZ = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_HISI = 30;
    private static final int BASE_FRAME_RATE_FOR_HIS_K3 = 30;
    private static final int BASE_FRAME_RATE_FOR_AMLOGIC = 30;
    private static final int KBPS_TO_BPS_FACTOR = 900;
    private static final int KBPS_TO_BPS_FACTOR_QCOM = 950;
    private static int mH264SupportProfileHigh;
    private MediaCodec mediaCodec;
    @Deprecated
    private ByteBuffer[] outputBuffers;
    private EglBase eglBase;
    private int width;
    private int height;
    private int outputFrameRotation;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private final Matrix rotateMatrix;
    private long nativeHandle;
    private boolean useAsyncMode;
    private MediaCodecEncoderCallback asyncEncoderCallback;
    private HandlerThread dedicatedHandlerThread;
    private Handler dedicatedHandler;
    private boolean isInitialized;
    private final Object callbackLock;
    private final LinkedHashSet<Integer> availableInputIndexes;
    private VideoCodecType type;
    private ByteBuffer configData;
    private long lastKeyFrameTimeMs;
    private int keyFrameIntervalInMsec;
    private boolean hasPendingKeyFrame;
    private int keyFrameEncodeMinInterval;
    private long lastResetForQcomTimeMs;
    private int converted_bps;
    private int lastSetFps;
    private boolean qcomExceptionModel;
    private String codecName;
    private int colorFormat;
    private int profile;
    private int supportCodecs;
    private int maxSupportedWidth;
    private int maxSupportedHeight;
    private int minSupportedWidth;
    private int minSupportedHeight;
    private int maxSupportedBitrate;
    private int minSupportedBitrate;
    private int widthAlignment;
    private int heightAlignment;
    private int memoryType;
    private int bitrateMode;
    private int bitrateAdjustmentType;
    private int SDKVer;
    private String deviceModel;
    private String cpuModel;
    private boolean eglAttachedOnDedicatedThread;
    private int settingMaxWidth;
    private int settingMaxHeight;
    private int settingMaxFPS;
    private int settingHighProfile;
    private int settingBitrateMode;
    private int settingBitrateAdjustmentType;
    private int settingBitrateBaseFPS;
    private int settingBitrateFactor;
    private int settingAdjustmentReset;
    private String settingInitConfs;
    private String settingAdjustmentConfs;
    private int settingCodecParameterForExynos;
    private ChipProperties chipProperties;
    private FileOutputStream fos;

    public MediaCodecVideoEncoder() {
        LinkedHashSet linkedHashSet;
        Object object;
        Matrix matrix;
        Object object2 = matrix;
        matrix = new Matrix();
        v1.rotateMatrix = object2;
        v1.useAsyncMode = false;
        v1.dedicatedHandler = null;
        v1.isInitialized = false;
        object2 = object;
        object = new Object();
        v1.callbackLock = object2;
        object2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        v1.availableInputIndexes = object2;
        v1.configData = null;
        v1.lastKeyFrameTimeMs = 0L;
        v1.keyFrameIntervalInMsec = 0;
        v1.hasPendingKeyFrame = false;
        v1.keyFrameEncodeMinInterval = 100;
        v1.lastResetForQcomTimeMs = 0L;
        v1.qcomExceptionModel = false;
        v1.profile = 66;
        v1.supportCodecs = 0;
        v1.maxSupportedWidth = 32768;
        v1.maxSupportedHeight = 32768;
        v1.minSupportedWidth = 2;
        v1.minSupportedHeight = 2;
        v1.maxSupportedBitrate = 0;
        v1.minSupportedBitrate = 0;
        v1.widthAlignment = 16;
        v1.heightAlignment = 4;
        v1.memoryType = 0;
        v1.bitrateMode = 2;
        v1.eglAttachedOnDedicatedThread = false;
        v1.settingMaxWidth = -1;
        v1.settingMaxHeight = -1;
        v1.settingMaxFPS = -1;
        v1.settingHighProfile = -1;
        v1.settingBitrateMode = -1;
        v1.settingBitrateAdjustmentType = -1;
        v1.settingBitrateBaseFPS = -1;
        v1.settingBitrateFactor = -1;
        v1.settingAdjustmentReset = -1;
        v1.settingInitConfs = null;
        v1.settingAdjustmentConfs = null;
        v1.settingCodecParameterForExynos = -1;
        v1.chipProperties = null;
        v1.fos = null;
    }

    public static boolean isAsyncModeSupported() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        return !Arrays.asList(ASYNC_EXCLUDED_MODELS).contains(Build.MODEL);
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableH265HwCodec() {
        Logging.w(TAG, "H.265 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H265_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, nArray = supportedColorList) != null;
    }

    public static boolean isVp9HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, nArray = supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        boolean bl;
        block4: {
            block3: {
                try {
                    if (hwEncoderDisabledTypes.contains(H264_MIME_TYPE)) break block3;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "isH264HwSupported failed!");
                    return false;
                }
                if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) == null) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isH265HwSupported() {
        boolean bl;
        block4: {
            block3: {
                try {
                    if (hwEncoderDisabledTypes.contains(H265_MIME_TYPE)) break block3;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "isH265HwSupported failed!");
                    return false;
                }
                if (MediaCodecVideoEncoder.findHwEncoder(H265_MIME_TYPE, supportedH265HwCodecPrefixes, supportedColorList) == null) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, nArray = supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, nArray = supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        boolean bl;
        block4: {
            block3: {
                try {
                    if (hwEncoderDisabledTypes.contains(H264_MIME_TYPE)) break block3;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "isH264HwSupportedUsingTextures failed!");
                    return false;
                }
                if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList) == null) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isH265HwSupportedUsingTextures() {
        boolean bl;
        block4: {
            block3: {
                try {
                    if (hwEncoderDisabledTypes.contains(H265_MIME_TYPE)) break block3;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "isH265HwSupportedUsingTextures failed!");
                    return false;
                }
                if (MediaCodecVideoEncoder.findHwEncoder(H265_MIME_TYPE, supportedH265HwCodecPrefixes, supportedSurfaceColorList) == null) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private static boolean isA50OrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static int isH264HwHighProfileSupported() {
        return mH264SupportProfileHigh;
    }

    private static EncoderProperties findHwEncoder(String string2, String[] stringArray, int[] nArray) {
        try {
            return MediaCodecVideoEncoder.do_findHwEncoder(string2, stringArray, nArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EncoderProperties do_findHwEncoder(String string2, String[] stringArray, int[] nArray) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        boolean bl = nArray[0] == 2130708361;
        Logging.i(TAG, "Model: " + Build.MODEL + ", hardware: " + Build.HARDWARE);
        if (string2.equals(H264_MIME_TYPE)) {
            if (Arrays.asList(H264_HW_EXCEPTION_MODELS).contains(Build.MODEL)) {
                Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
                return null;
            }
            if (Build.HARDWARE.equalsIgnoreCase("kirin970") && !bl) {
                return null;
            }
        } else if (string2.equals(H265_MIME_TYPE) && Arrays.asList(H265_HW_EXCEPTION_HARDWARES).contains(Build.HARDWARE)) {
            Logging.w(TAG, "Hardware: " + Build.HARDWARE + " has black listed H.265 encoder.");
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            int n2;
            int n3;
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String string3 = null;
            String[] stringArray2 = mediaCodecInfo.getSupportedTypes();
            int n4 = stringArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!stringArray2[n3].equals(string2)) continue;
                string3 = mediaCodecInfo.getName();
                break;
            }
            if (string3 == null) continue;
            if (!MediaCodecVideoEncoder.checkMinSDKVersion(string3, bl)) {
                Logging.e(TAG, "Check min sdk version failed, " + string3);
                continue;
            }
            Logging.i(TAG, "Found candidate encoder " + string3);
            if (!string3.startsWith("OMX.") && !bl) continue;
            codecOmxName = string3;
            mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType(string2);
            if (string2.equals(H264_MIME_TYPE)) {
                stringArray2 = mediaCodecInfo.profileLevels;
                n4 = mediaCodecInfo.profileLevels.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (((MediaCodecInfo.CodecProfileLevel)stringArray2[n3]).profile != 8) continue;
                    mH264SupportProfileHigh = 1;
                }
            }
            if (string3.startsWith("OMX.amlogic.")) {
                if (bl) {
                    return new EncoderProperties(string3, 2130708361, true);
                }
                return new EncoderProperties(string3, 19, true);
            }
            boolean bl2 = false;
            String string4 = "   Color:";
            int[] nArray2 = mediaCodecInfo.colorFormats;
            int n52 = mediaCodecInfo.colorFormats.length;
            for (int i3 = 0; i3 < n52; ++i3) {
                n2 = nArray2[i3];
                if (21 == n2) {
                    bl2 = true;
                }
                string4 = string4 + " 0x" + Integer.toHexString(n2) + ", ";
            }
            Logging.d(TAG, string4);
            for (int n52 : nArray) {
                int[] nArray3 = mediaCodecInfo.colorFormats;
                n2 = mediaCodecInfo.colorFormats.length;
                for (int i4 = 0; i4 < n2; ++i4) {
                    int n6 = nArray3[i4];
                    if (n6 != n52) continue;
                    if (n6 == 19 && bl2 && (string3.startsWith("OMX.IMG.TOPAZ.") || string3.startsWith("OMX.hisi.") || string3.startsWith("OMX.k3."))) {
                        Logging.i(TAG, "TOPAZ,force use COLOR_FormatYUV420SemiPlanar");
                        Logging.i(TAG, "Found target encoder for mime " + string2 + " : " + string3 + ". Color: 0x" + Integer.toHexString(21));
                        return new EncoderProperties(string3, 21, true);
                    }
                    Logging.i(TAG, "Found target encoder for mime " + string2 + " : " + string3 + ". Color: 0x" + Integer.toHexString(n6));
                    return new EncoderProperties(string3, n6, true);
                }
            }
        }
        return null;
    }

    private void getEncoderProperties(int n2) {
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = VP8_MIME_TYPE;
        stringArray[1] = VP9_MIME_TYPE;
        stringArray[2] = H264_MIME_TYPE;
        stringArray[3] = H265_MIME_TYPE;
        String string2 = null;
        this.supportCodecs = 0;
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (string3.equals(VP8_MIME_TYPE)) {
                    this.supportCodecs |= 1;
                } else if (string3.equals(H264_MIME_TYPE)) {
                    this.supportCodecs |= 2;
                } else if (string3.equals(H265_MIME_TYPE)) {
                    this.supportCodecs |= 4;
                }
                if (string2 != null || !string3.equals(stringArray2[n2])) continue;
                string2 = mediaCodecInfo.getName();
                string3 = mediaCodecInfo.getCapabilitiesForType(stringArray2[n2]);
                if (!MediaCodecVideoEncoder.isA50OrHigher()) continue;
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                MediaCodecInfo.VideoCapabilities videoCapabilities = string3.getVideoCapabilities();
                String string4 = string3 = videoCapabilities;
                String string5 = string3;
                MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
                String string6 = string3;
                string3 = string6.getSupportedWidths();
                Range range = string6.getSupportedHeights();
                mediaCodecVideoEncoder2.maxSupportedWidth = (Integer)string3.getUpper();
                mediaCodecVideoEncoder2.maxSupportedHeight = (Integer)range.getUpper();
                mediaCodecVideoEncoder2.minSupportedWidth = (Integer)string3.getLower();
                mediaCodecVideoEncoder2.minSupportedHeight = (Integer)range.getLower();
                this.widthAlignment = string5.getWidthAlignment();
                this.heightAlignment = string4.getHeightAlignment();
                string3 = videoCapabilities.getBitrateRange();
                mediaCodecVideoEncoder.maxSupportedBitrate = (Integer)string3.getUpper();
                mediaCodecVideoEncoder.minSupportedBitrate = (Integer)string3.getLower();
                Logging.i(TAG, "max supported size:" + this.maxSupportedWidth + "x" + this.maxSupportedHeight + " min supported size:" + this.minSupportedWidth + "x" + this.minSupportedHeight + " align size: " + this.widthAlignment + "x" + this.heightAlignment + " bitrate range: " + this.maxSupportedBitrate + " -> " + this.minSupportedBitrate);
            }
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.SDKVer = Build.VERSION.SDK_INT;
        mediaCodecVideoEncoder.deviceModel = Build.MODEL;
        mediaCodecVideoEncoder.cpuModel = Build.HARDWARE;
    }

    private int supportedEncoderConfig(int n2, int n3, int n4, int n5) {
        return 0;
    }

    static MediaCodec createByCodecName(String string2) {
        try {
            return MediaCodec.createByCodecName((String)string2);
        }
        catch (Exception exception) {
            Logging.e(TAG, "create media encoder failed, ", exception);
            return null;
        }
    }

    private boolean isOnDedicatedHandlerThread() {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = mediaCodecVideoEncoder.dedicatedHandlerThread;
        return mediaCodecVideoEncoder != null && mediaCodecVideoEncoder.getId() == Thread.currentThread().getId();
    }

    private boolean doInitEncoder(InitParameters initParameters) {
        block9: {
            block8: {
                if (this.isInitialized) {
                    Logging.w(TAG, "already initialized!");
                    return true;
                }
                try {
                    if (this.createEncoder(initParameters)) break block8;
                }
                catch (Exception exception) {
                    Logging.e(TAG, "failed to create hardware encoder,", exception);
                    try {
                        this.release();
                    }
                    catch (Exception exception2) {
                        Logging.e(TAG, "failed to release hardware encoder,", exception2);
                    }
                    return false;
                }
                Logging.e(TAG, "failed to create hardware encoder!!");
                return false;
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            this.isInitialized = true;
            mediaCodecVideoEncoder.initEglForEncoderIfNeeded(initParameters);
            mediaCodecVideoEncoder.mediaCodec.start();
            if (mediaCodecVideoEncoder.useAsyncMode) break block9;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private boolean createEncoder(InitParameters initParameters) throws RuntimeException {
        int n2;
        Logging.i(TAG, "Java initEncode: " + initParameters.toString());
        int n3 = initParameters.width;
        this.width = n2 = n3;
        this.height = n2 = initParameters.height;
        if (n3 >= this.minSupportedWidth && n2 >= this.minSupportedHeight) {
            Object object;
            if (initParameters.fps < 1) {
                initParameters.fps = 1;
            }
            if (initParameters.keyInterval < 1) {
                initParameters.keyInterval = 1;
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            this.lastSetFps = initParameters.fps;
            mediaCodecVideoEncoder.keyFrameIntervalInMsec = initParameters.keyInterval * 1000;
            mediaCodecVideoEncoder.lastKeyFrameTimeMs = 0L;
            mediaCodecVideoEncoder.lastResetForQcomTimeMs = SystemClock.elapsedRealtime();
            this.type = object = VideoCodecType.values()[initParameters.codec];
            Object object2 = null;
            Object object3 = null;
            if (object == VideoCodecType.VIDEO_CODEC_VP8) {
                object3 = VP8_MIME_TYPE;
                object = VP8_MIME_TYPE;
                object2 = supportedVp8HwCodecPrefixes;
                int[] nArray = initParameters.useSurface ? supportedSurfaceColorList : supportedColorList;
                object2 = MediaCodecVideoEncoder.findHwEncoder((String)object, object2, nArray);
            } else if (object == VideoCodecType.VIDEO_CODEC_VP9) {
                object3 = VP9_MIME_TYPE;
                object = VP9_MIME_TYPE;
                object2 = supportedH264HwCodecPrefixes;
                int[] nArray = initParameters.useSurface ? supportedSurfaceColorList : supportedColorList;
                object2 = MediaCodecVideoEncoder.findHwEncoder((String)object, object2, nArray);
            } else if (object == VideoCodecType.VIDEO_CODEC_H264) {
                object3 = H264_MIME_TYPE;
                object = H264_MIME_TYPE;
                object2 = supportedH264HwCodecPrefixes;
                int[] nArray = initParameters.useSurface ? supportedSurfaceColorList : supportedColorList;
                object2 = MediaCodecVideoEncoder.findHwEncoder((String)object, object2, nArray);
            } else if (object == VideoCodecType.VIDEO_CODEC_H265) {
                object3 = H265_MIME_TYPE;
                object = H265_MIME_TYPE;
                object2 = supportedH265HwCodecPrefixes;
                int[] nArray = initParameters.useSurface ? supportedSurfaceColorList : supportedColorList;
                object2 = MediaCodecVideoEncoder.findHwEncoder((String)object, object2, nArray);
            }
            if (object2 != null) {
                int n4;
                MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
                object = object2.codecName;
                object = mediaCodecVideoEncoder2.getChipProperties((String)object, initParameters.fps);
                mediaCodecVideoEncoder2.chipProperties = object;
                if (mediaCodecVideoEncoder2.settingBitrateAdjustmentType > 0) {
                    ((ChipProperties)object).bitrateAdjustmentType = BitrateAdjustmentType.values()[this.settingBitrateAdjustmentType];
                }
                if ((n4 = this.settingBitrateBaseFPS) > 0) {
                    ChipProperties chipProperties = this.chipProperties;
                    chipProperties.baseFrameRate = n4;
                    chipProperties.initFrameRate = n4;
                }
                MediaCodecVideoEncoder mediaCodecVideoEncoder3 = this;
                InitParameters initParameters2 = initParameters;
                n4 = initParameters2.bitrateKbps;
                mediaCodecVideoEncoder3.converted_bps = mediaCodecVideoEncoder3.convertBitRate(n4, initParameters2.fps);
                n4 = mediaCodecVideoEncoder3.width;
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)object3, (int)n4, (int)mediaCodecVideoEncoder3.height);
                if ((this.settingHighProfile > 0 || Build.VERSION.SDK_INT >= this.chipProperties.highProfileMinSdkVersion) && initParameters.profile == 100) {
                    Logging.i(TAG, "Set high profile and level");
                    object3 = this.type;
                    if (object3 == VideoCodecType.VIDEO_CODEC_H264) {
                        MediaFormat mediaFormat2 = mediaFormat;
                        mediaFormat2.setInteger("profile", 8);
                        mediaFormat2.setInteger("level", 512);
                    } else if (object3 == VideoCodecType.VIDEO_CODEC_H265) {
                        MediaFormat mediaFormat3 = mediaFormat;
                        mediaFormat3.setInteger("profile", 1);
                        mediaFormat3.setInteger("level", 256);
                    }
                    this.profile = 100;
                } else {
                    this.profile = 66;
                }
                mediaFormat.setInteger("bitrate", this.converted_bps);
                int n5 = this.settingBitrateMode;
                if (n5 > 0) {
                    this.bitrateMode = n5;
                } else if (!object2.codecName.startsWith("OMX.rk.") && this.type != VideoCodecType.VIDEO_CODEC_H265) {
                    if (!this.qcomExceptionModel) {
                        this.bitrateMode = 1;
                    }
                } else {
                    this.bitrateMode = 2;
                }
                mediaFormat.setInteger("bitrate-mode", this.bitrateMode);
                mediaFormat.setInteger("color-format", object2.colorFormat);
                Object object4 = this.chipProperties;
                if (object4.bitrateAdjustmentType == BitrateAdjustmentType.NO_ADJUSTMENT) {
                    mediaFormat.setInteger("frame-rate", initParameters.init_fps);
                } else {
                    mediaFormat.setInteger("frame-rate", object4.initFrameRate);
                }
                if (Arrays.asList(INTERVAL_HW_EXCEPTION_MODELS).contains(Build.MODEL) && initParameters.keyInterval >= 100) {
                    Logging.i(TAG, "keyInterval: " + initParameters.keyInterval);
                    Logging.i(TAG, "Model: " + Build.MODEL + " ,need to modify interval.");
                    initParameters.keyInterval = 10;
                }
                if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
                    mediaFormat.setInteger("i-frame-interval", initParameters.keyInterval);
                } else {
                    mediaFormat.setInteger("i-frame-interval", initParameters.keyInterval + 1);
                }
                if (!TextUtils.isEmpty((CharSequence)initParameters.customConfigJson)) {
                    this.applyCustomConfig(mediaFormat, initParameters.customConfigJson);
                }
                Logging.d(TAG, "Format: " + mediaFormat);
                this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(object2.codecName);
                if (this.mediaCodec != null) {
                    if (this.useAsyncMode) {
                        MediaCodecEncoderCallback mediaCodecEncoderCallback;
                        object4 = mediaCodecEncoderCallback;
                        this.asyncEncoderCallback = new MediaCodecEncoderCallback();
                        this.mediaCodec.setCallback((MediaCodec.Callback)object4, this.dedicatedHandler);
                    }
                    this.mediaCodec.configure(mediaFormat, null, null, 1);
                    this.codecName = object2.codecName;
                    Logging.i(TAG, "codecName: " + this.codecName);
                    this.colorFormat = object2.colorFormat;
                    this.memoryType = initParameters.useSurface ? 11 : 0;
                    this.bitrateAdjustmentType = this.chipProperties.bitrateAdjustmentType.ordinal();
                    return true;
                }
                throw new RuntimeException("Can not create media encoder");
            }
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)this.type));
        }
        Logging.w(TAG, "Not supported size:" + this.width + "x" + this.height);
        return false;
    }

    private void initEglForEncoderIfNeeded(InitParameters object) {
        if (!((InitParameters)object).useSurface) {
            return;
        }
        this.eglAttachedOnDedicatedThread = false;
        Object object2 = ((InitParameters)object).sharedEgl14Context;
        if (object2 != null) {
            EglBase14 eglBase14;
            EglBase14.Context context;
            object = context;
            context = new EglBase14.Context((android.opengl.EGLContext)object2);
            object2 = eglBase14;
            eglBase14 = new EglBase14((EglBase14.Context)object, EglBase.CONFIG_RECORDABLE);
            this.eglBase = object2;
        } else {
            object = ((InitParameters)object).sharedEgl10Context;
            if (object != null) {
                EglBase10 eglBase10;
                EglBase10.Context context;
                object2 = context;
                context = new EglBase10.Context((EGLContext)object);
                object = eglBase10;
                eglBase10 = new EglBase10((EglBase10.Context)object2, EglBase.CONFIG_RECORDABLE);
                this.eglBase = object;
            }
        }
        if (this.eglBase != null) {
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            object = mediaCodecVideoEncoder.mediaCodec.createInputSurface();
            mediaCodecVideoEncoder.inputSurface = object;
            mediaCodecVideoEncoder.eglBase.createSurface((Surface)object);
            mediaCodecVideoEncoder.drawer = new GlRectDrawer();
            Logging.i(TAG, "init egl done, ctx: " + this.eglBase.getEglBaseContext().getRealEglContext() + " hasSurface: " + this.eglBase.hasSurface());
        } else {
            Logging.e(TAG, "init egl failed, no shared context provided.");
        }
    }

    private void releaseEglForEncoderIfNeeded() {
        Object object;
        if (this.eglBase != null) {
            if (!this.isOnDedicatedHandlerThread() || !this.eglAttachedOnDedicatedThread) {
                this.eglBase.makeCurrent();
            }
            if ((object = this.drawer) != null) {
                ((GlRectDrawer)object).release();
                this.drawer = null;
            }
            this.eglBase.release();
            this.eglBase = null;
        }
        if ((object = this.inputSurface) != null) {
            object.release();
            this.inputSurface = null;
        }
        this.eglAttachedOnDedicatedThread = false;
    }

    private void doReleaseEncoder() {
        RuntimeException runtimeException;
        CaughtException caughtException;
        if (!((MediaCodecVideoEncoder)((Object)runtimeException2)).isInitialized) {
            Logging.e(TAG, "doReleaseEncoder: encoder is not initialized!");
            return;
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder = runtimeException2;
        mediaCodecVideoEncoder.isInitialized = false;
        mediaCodecVideoEncoder.releaseEglForEncoderIfNeeded();
        final CaughtException caughtException2 = caughtException;
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        caughtException = (MediaCodecVideoEncoder)((Object)runtimeException2).new CaughtException();
        boolean bl = false;
        final MediaCodec mediaCodec = mediaCodecVideoEncoder.mediaCodec;
        if (mediaCodec != null) {
            Runnable runnable;
            CountDownLatch countDownLatch;
            final CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch = new CountDownLatch(1);
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                {
                }

                @Override
                public void run() {
                    Logging.i(TAG, "Java releaseEncoder on release thread");
                    try {
                        Logging.i(TAG, "Java releaseEncoder: MediaCodec.stop");
                        mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        Logging.i(TAG, "Java releaseEncoder: MediaCodec.release");
                        mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(TAG, "Media encoder release failed", exception);
                        caughtException2.e = exception;
                    }
                    Logging.i(TAG, "Java releaseEncoder on release thread done");
                    countDownLatch2.countDown();
                }
            };
            new Thread(runnable2).start();
            if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 3000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            ((MediaCodecVideoEncoder)((Object)runtimeException2)).mediaCodec = null;
        }
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException2.e == null) {
            Logging.i(TAG, "Java releaseEncoder done");
            return;
        }
        RuntimeException runtimeException2 = runtimeException;
        runtimeException2(caughtException2.e);
        runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException2.e.getStackTrace(), runtimeException2.getStackTrace()));
        throw runtimeException;
    }

    private static boolean checkMinSDKVersion(String string2, boolean bl) {
        if (bl) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (string2.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (string2.startsWith("OMX.MTK.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string2.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string2.startsWith("OMX.IMG.TOPAZ.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        if (string2.startsWith("OMX.k3.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private ChipProperties getChipProperties(String string2, int n2) {
        if (string2.startsWith("OMX.qcom.")) {
            if (Arrays.asList(H264_HW_QCOM_EXCEPTION_MODELS).contains(Build.MODEL.toLowerCase())) {
                Logging.w(TAG, "Qcom Exception Model: " + Build.MODEL);
                ((MediaCodecVideoEncoder)((Object)string3)).qcomExceptionModel = true;
                int n3 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.NO_ADJUSTMENT, true, n3, n3, 21);
            }
            ((MediaCodecVideoEncoder)((Object)string3)).qcomExceptionModel = false;
            int n4 = n2;
            return new ChipProperties(string2, BitrateAdjustmentType.NO_ADJUSTMENT, false, n4, n4, 21);
        }
        if (string2.startsWith("OMX.MTK.")) {
            String string3 = Build.HARDWARE;
            Logging.i(TAG, "MTK hardware: " + (String)string3);
            if (!string3.equalsIgnoreCase("mt6763") && !string3.equalsIgnoreCase("mt6763t")) {
                if (Arrays.asList(MTK_NO_ADJUSTMENT_MODELS).contains(Build.MODEL)) {
                    int n5 = n2;
                    return new ChipProperties(string2, BitrateAdjustmentType.NO_ADJUSTMENT, false, n5, n5, 21);
                }
                if (!string3.equalsIgnoreCase("mt6735") && !string3.equalsIgnoreCase("mt8167")) {
                    int n6 = n2;
                    return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n6, n6, 21);
                }
                int n7 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n7, n7, Integer.MAX_VALUE);
            }
            int n8 = n2;
            return new ChipProperties(string2, BitrateAdjustmentType.NO_ADJUSTMENT, false, n8, n8, 21);
        }
        if (string2.startsWith("OMX.Exynos.")) {
            if (Build.MODEL.equalsIgnoreCase("MX4 Pro")) {
                int n9 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n9, n9, Integer.MAX_VALUE);
            }
            if (Build.MANUFACTURER.equalsIgnoreCase("vivo") && Build.MODEL.equalsIgnoreCase("V1938CT")) {
                int n10 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n10, n10, 21);
            }
            if (((MediaCodecVideoEncoder)((Object)string3)).settingCodecParameterForExynos > 0 && Build.VERSION.SDK_INT > 28) {
                int n11 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n11, n11, 21);
            }
            return new ChipProperties(string2, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (string2.startsWith("OMX.IMG.TOPAZ.")) {
            if (Build.HARDWARE.equalsIgnoreCase("hi6250")) {
                int n12 = n2;
                return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n12, n12, Integer.MAX_VALUE);
            }
            return new ChipProperties(string2, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (string2.startsWith("OMX.hisi.")) {
            int n13 = n2;
            return new ChipProperties(string2, BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT, false, n13, n13, Integer.MAX_VALUE);
        }
        if (string2.startsWith("OMX.k3.")) {
            return new ChipProperties(string2, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, 21);
        }
        if (string2.startsWith("OMX.amlogic.")) {
            Logging.i(TAG, "getChipProperties for amlogic");
            return new ChipProperties(string2, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        if (string2.startsWith("OMX.rk.")) {
            return new ChipProperties(string2, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT, false, 30, 30, Integer.MAX_VALUE);
        }
        Logging.i(TAG, "getChipProperties from unsupported chip list");
        int n14 = n2;
        return new ChipProperties(string2, BitrateAdjustmentType.NO_ADJUSTMENT, false, n14, n14, 23);
    }

    private int convertBitRate(int n2, int n3) {
        ChipProperties chipProperties = this.chipProperties;
        if (chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT) {
            n2 = n2 * chipProperties.baseFrameRate / n3;
        }
        if ((n3 = this.settingBitrateFactor) <= 0) {
            n3 = !this.chipProperties.chipName.startsWith("OMX.rk.") && this.type != VideoCodecType.VIDEO_CODEC_H265 ? (this.chipProperties.chipName.startsWith("OMX.qcom.") ? 950 : 900) : 1000;
        }
        return n3 * n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int setRates(int var1_2, int var2_6) {
        block34: {
            block35: {
                block36: {
                    block32: {
                        block33: {
                            block31: {
                                block30: {
                                    if (!this.isInitialized) {
                                        Logging.e(MediaCodecVideoEncoder.TAG, "setRates: encoder is not initialized!");
                                        return -1;
                                    }
                                    Logging.d(MediaCodecVideoEncoder.TAG, "setRates: " + var1_2 + " Kbps " + var2_6 + " fps");
                                    var3_9 = var2_6 > 0 && var2_6 != this.lastSetFps;
                                    if (var2_6 <= 0) {
                                        var2_6 = this.lastSetFps;
                                    }
                                    this.lastSetFps = var2_6;
                                    var1_2 = this.convertBitRate(var1_2, var2_6);
                                    if (var3_9) {
                                        block29: {
                                            if (this.settingAdjustmentReset > 0) break block29;
                                            if (this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) break block30;
                                        }
                                        this.converted_bps = var1_2;
                                        return 0;
                                    }
                                }
                                if (var1_2 <= this.converted_bps) break block31;
                                v0 = this;
                                v1 = v0;
                                v2 = v0;
                                v0.converted_bps = var1_2;
                                var1_3 /* !! */  = v3;
                                v4 = this;
                                var1_3 /* !! */ ();
                                var2_7 = "video-bitrate";
                                v3.putInt((String)var2_7, v4.converted_bps);
                                v2.mediaCodec.setParameters(var1_3 /* !! */ );
                                var1_3 /* !! */  = MediaCodecVideoEncoder.TAG;
                                var2_7 = v5;
                                v5 = new StringBuilder();
                                var3_10 = v1.useAsyncMode != false ? "[async] " : "";
                                Logging.i((String)var1_3 /* !! */ , var2_7.append(var3_10).append("setRates up to : ").append(this.converted_bps).append(" bps(converted) ").append(this.lastSetFps).append(" fps").toString());
                                return 1;
                            }
                            var2_6 = 0;
                            if (!this.chipProperties.chipName.startsWith("OMX.qcom.")) break block32;
                            if (!this.qcomExceptionModel) break block33;
                            while (true) {
                                var2_6 = 25000;
                                break block32;
                                break;
                            }
                        }
                        try {
                            if (this.converted_bps > 200000) ** continue;
                            var2_6 = 15000;
                        }
                        catch (IllegalStateException var0_1) {
                            Logging.e(MediaCodecVideoEncoder.TAG, "setRates failed", var0_1);
                            return 0;
                        }
                    }
                    if (var1_2 >= this.converted_bps - var2_6) break block34;
                    this.converted_bps = var1_2;
                    if (!this.chipProperties.isNeedResetWhenDownBps) break block35;
                    var1_4 = SystemClock.elapsedRealtime();
                    if (var1_4 - this.lastResetForQcomTimeMs < 2000L) break block36;
                    this.lastResetForQcomTimeMs = var1_4;
                    return 0;
                }
                return 2;
            }
            v6 = this;
            v7 = v6;
            v8 = v6;
            var1_5 /* !! */  = v9;
            v10 = this;
            var1_5 /* !! */ ();
            var2_8 = "video-bitrate";
            v9.putInt((String)var2_8, v10.converted_bps);
            v7.mediaCodec.setParameters(var1_5 /* !! */ );
            var1_5 /* !! */  = MediaCodecVideoEncoder.TAG;
            var2_8 = v11;
            v11 = new StringBuilder();
            var3_11 = v8.useAsyncMode != false ? "[async] " : "";
            Logging.i((String)var1_5 /* !! */ , var2_8.append(var3_11).append("setRates down to : ").append(this.converted_bps).append(" bps(converted) ").append(this.lastSetFps).append(" fps").toString());
        }
        return 1;
    }

    private OutputBufferInfo createOutputBufferInfo(MediaCodec.BufferInfo bufferInfo, int n2, ByteBuffer byteBuffer) {
        Object object;
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        boolean bl = (bufferInfo.flags & 1) != 0;
        if (bl) {
            Logging.d(TAG, "Sync frame generated");
        }
        if (bl && ((object = ((MediaCodecVideoEncoder)((Object)byteBuffer3)).type) == VideoCodecType.VIDEO_CODEC_H264 || object == VideoCodecType.VIDEO_CODEC_H265)) {
            Logging.d(TAG, "Appending config frame of size " + ((MediaCodecVideoEncoder)((Object)byteBuffer3)).configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
            object = ByteBuffer.allocateDirect(((MediaCodecVideoEncoder)((Object)byteBuffer3)).configData.capacity() + bufferInfo.size);
            ByteBuffer byteBuffer2 = byteBuffer3;
            ((MediaCodecVideoEncoder)((Object)byteBuffer2)).configData.rewind();
            ((ByteBuffer)object).put(((MediaCodecVideoEncoder)((Object)byteBuffer2)).configData);
            ((ByteBuffer)object).put(byteBuffer);
            ((ByteBuffer)object).position(0);
            MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
            long l2 = bufferInfo2.presentationTimeUs;
            int n3 = bufferInfo2.size + ((MediaCodecVideoEncoder)((Object)byteBuffer3)).configData.capacity();
            return new OutputBufferInfo(n2, (ByteBuffer)object, bl, l2, n3);
        }
        MediaCodec.BufferInfo bufferInfo3 = bufferInfo;
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        long l3 = bufferInfo3.presentationTimeUs;
        int n4 = bufferInfo3.size;
        return new OutputBufferInfo(n2, byteBuffer3, bl, l3, n4);
    }

    private native void onAsyncEncodeFrameResult(long var1, boolean var3, OutputBufferInfo var4);

    public static boolean isQcomHWEncoder() {
        String string2 = codecOmxName;
        if (string2 != null && !string2.startsWith("OMX.qcom.")) {
            Logging.i(TAG, "Qualcomm HW encoder false");
            return false;
        }
        Logging.i(TAG, "Qualcomm HW encoder true");
        return true;
    }

    public static int getHWEncoderManufactor() {
        if (codecOmxName.startsWith("OMX.qcom.")) {
            return 0;
        }
        if (codecOmxName.startsWith("OMX.MTK.")) {
            return 1;
        }
        if (codecOmxName.startsWith("OMX.Exynos.")) {
            return 2;
        }
        if (codecOmxName.startsWith("OMX.IMG.TOPAZ.")) {
            return 3;
        }
        if (codecOmxName.startsWith("OMX.k3.")) {
            return 4;
        }
        if (codecOmxName.startsWith("OMX.hisi.")) {
            return 5;
        }
        if (codecOmxName.startsWith("OMX.amlogic.")) {
            return 6;
        }
        if (codecOmxName.startsWith("OMX.rk.")) {
            return 7;
        }
        return -1;
    }

    private void verboseLog(String string2) {
    }

    static /* synthetic */ MediaCodec access$900(MediaCodecVideoEncoder mediaCodecVideoEncoder) {
        return mediaCodecVideoEncoder.mediaCodec;
    }

    static /* synthetic */ ByteBuffer access$1002(MediaCodecVideoEncoder mediaCodecVideoEncoder, ByteBuffer byteBuffer) {
        mediaCodecVideoEncoder.configData = byteBuffer;
        return byteBuffer;
    }

    static /* synthetic */ ByteBuffer access$1000(MediaCodecVideoEncoder mediaCodecVideoEncoder) {
        return mediaCodecVideoEncoder.configData;
    }

    static /* synthetic */ OutputBufferInfo access$1100(MediaCodecVideoEncoder mediaCodecVideoEncoder, MediaCodec.BufferInfo bufferInfo, int n2, ByteBuffer byteBuffer) {
        return mediaCodecVideoEncoder.createOutputBufferInfo(bufferInfo, n2, byteBuffer);
    }

    static /* synthetic */ long access$1200(MediaCodecVideoEncoder mediaCodecVideoEncoder) {
        return mediaCodecVideoEncoder.nativeHandle;
    }

    static /* synthetic */ void access$1300(MediaCodecVideoEncoder mediaCodecVideoEncoder, long l2, boolean bl, OutputBufferInfo outputBufferInfo) {
        mediaCodecVideoEncoder.onAsyncEncodeFrameResult(l2, bl, outputBufferInfo);
    }

    static {
        hwEncoderDisabledTypes = new HashSet<String>();
        codecOmxName = null;
        supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
        supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom."};
        supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.IMG.TOPAZ.", "OMX.hisi.", "OMX.k3.", "OMX.amlogic.", "OMX.rk.", "OMX.MS."};
        supportedH265HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos.", "OMX.MTK.", "OMX.IMG.TOPAZ.", "OMX.hisi.", "OMX.k3.", "OMX.amlogic.", "OMX.rk."};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
        H264_HW_QCOM_EXCEPTION_MODELS = new String[]{"mi note lte", "redmi note 4x", "1605-a01", "aosp on hammerhead", "lm-x210", "oppo r9s"};
        MTK_NO_ADJUSTMENT_MODELS = new String[]{"vivo y83a", "vivo x21i", "vivo X21i A"};
        INTERVAL_HW_EXCEPTION_MODELS = new String[]{"vivo X21A", "MI 8", "MI 6", "MI 8 Lite", "Redmi Note 7"};
        H265_HW_EXCEPTION_MODELS = new String[0];
        H265_HW_EXCEPTION_HARDWARES = new String[]{"mt6771", "mt6762"};
        ASYNC_EXCLUDED_MODELS = new String[]{"SM-G7810"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
        mH264SupportProfileHigh = 0;
    }

    void nativeCreate(long l2) {
        this.nativeHandle = l2;
        Logging.i(TAG, "nativeCreate handle: " + l2);
    }

    void nativeDestroy() {
        Logging.i(TAG, "nativeDestroy");
        HandlerThread handlerThread = this.dedicatedHandlerThread;
        if (handlerThread != null) {
            handlerThread.quit();
            this.dedicatedHandlerThread = null;
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.dedicatedHandler = null;
        mediaCodecVideoEncoder.nativeHandle = 0L;
    }

    boolean initEncoder(InitParameters object) {
        Callable<Boolean> callable;
        Object object2;
        this.useAsyncMode = ((InitParameters)object).useAsyncMode;
        if (this.useAsyncMode || ((InitParameters)object).useSurface) {
            if (this.dedicatedHandlerThread == null) {
                HandlerThread handlerThread;
                object2 = handlerThread;
                object2("encodeHandler");
                this.dedicatedHandlerThread = object2;
                handlerThread.start();
            }
            this.dedicatedHandler = new Handler(this.dedicatedHandlerThread.getLooper());
        }
        object2 = callable;
        callable = new Callable<Boolean>((InitParameters)object){
            final /* synthetic */ InitParameters val$initParams;
            {
                this.val$initParams = initParameters;
            }

            @Override
            public Boolean call() throws Exception {
                boolean bl = MediaCodecVideoEncoder.this.doInitEncoder(this.val$initParams);
                if (!bl) {
                    InitParameters initParameters = this.val$initParams;
                    if (initParameters.fallbackToBaselineProfile && initParameters.profile != 66) {
                        initParameters.profile = 66;
                        Logging.w(TAG, "Init encoder: retry with baseline profile");
                        bl = MediaCodecVideoEncoder.this.doInitEncoder(this.val$initParams);
                    }
                }
                return bl;
            }
        };
        boolean bl = false;
        object = this.dedicatedHandler;
        if (object != null) {
            bl = (Boolean)ThreadUtils.invokeAtFrontUninterruptibly((Handler)object, object2);
        } else {
            try {
                bl = (Boolean)object2.call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = TAG;
        object2 = new StringBuilder().append("Init encoder done: ");
        String string2 = bl ? "success" : "failed";
        Logging.i((String)object, ((StringBuilder)object2).append(string2).toString());
        return bl;
    }

    @Deprecated
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = byteBufferArray.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    int getOutputFrameRotation() {
        return this.outputFrameRotation;
    }

    boolean checkKeyFrame(boolean bl) {
        long l2;
        long l3 = SystemClock.elapsedRealtime();
        if (this.hasPendingKeyFrame) {
            if (l3 - this.lastKeyFrameTimeMs > (long)this.keyFrameEncodeMinInterval) {
                this.hasPendingKeyFrame = false;
                bl = true;
            } else {
                bl = false;
            }
        } else if (bl && (l2 = this.lastKeyFrameTimeMs) != 0L && l3 - l2 <= (long)this.keyFrameEncodeMinInterval) {
            this.hasPendingKeyFrame = true;
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean encodeBuffer(boolean var1_2, int var2_4, int var3_5, int var4_6, long var5_7) {
        block9: {
            block10: {
                v0 = this;
                v0.verboseLog("encodeBuffer isKeyframe: " + var1_2 + " index: " + var2_4);
                if (!v0.isInitialized) {
                    Logging.e(MediaCodecVideoEncoder.TAG, "encodeBuffer: encoder is not initialized!");
                    return false;
                }
                v1 = this;
                var1_2 = v1.checkKeyFrame(var1_2);
                var7_8 = SystemClock.elapsedRealtime();
                if (v1.lastKeyFrameTimeMs == 0L) {
                    this.lastKeyFrameTimeMs = var7_8;
                }
                this.outputFrameRotation = var4_6;
                if (var1_2) break block10;
                try {
                    if (this.chipProperties.bitrateAdjustmentType != BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT) {
                    }
                    ** GOTO lbl27
                }
                catch (IllegalStateException var0_1) {
                    break block9;
                }
                {
                    if (var7_8 - this.lastKeyFrameTimeMs < (long)this.keyFrameIntervalInMsec) ** GOTO lbl27
                }
            }
            if (var1_2) {
                Logging.i(MediaCodecVideoEncoder.TAG, "Sync frame request");
            }
            var1_3 = v2;
            {
                new Bundle().putInt("request-sync", 0);
                this.mediaCodec.setParameters(var1_3);
                this.lastKeyFrameTimeMs = var7_8;
lbl27:
                // 3 sources

                this.mediaCodec.queueInputBuffer(var2_4, 0, var3_5, var5_7, 0);
                return true;
            }
        }
        Logging.e(MediaCodecVideoEncoder.TAG, "encodeBuffer failed", var0_1);
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean encodeTexture(boolean var1_2, int var2_5, int var3_6, float[] var4_10, int var5_13, int var6_14, int var7_15, int var8_16, int var9_17, boolean var10_18, long var11_19, Runnable var13_20) {
        block28: {
            block26: {
                block27: {
                    block25: {
                        block24: {
                            block29: {
                                v0 = this;
                                v0.verboseLog("encode texture, pts_us: " + var11_19);
                                if (!v0.isInitialized) {
                                    Logging.e(MediaCodecVideoEncoder.TAG, "encodeTexture: encoder is not initialized!");
                                    if (var13_20 != null) {
                                        var13_20.run();
                                    }
                                    return false;
                                }
                                v1 = this;
                                var1_2 = v1.checkKeyFrame(var1_2);
                                var14_21 = SystemClock.elapsedRealtime();
                                if (v1.lastKeyFrameTimeMs == 0L) {
                                    this.lastKeyFrameTimeMs = var14_21;
                                }
                                var16_22 = false;
                                if (var1_2) ** GOTO lbl17
                                if (this.chipProperties.bitrateAdjustmentType == BitrateAdjustmentType.ACTUAL_FRAMERATE_ADJUSTMENT || var14_21 - this.lastKeyFrameTimeMs < (long)this.keyFrameIntervalInMsec) ** GOTO lbl27
lbl17:
                                // 2 sources

                                if (var1_2) {
                                    Logging.i(MediaCodecVideoEncoder.TAG, "Sync frame request");
                                }
                                v2 = this;
                                v3 = var14_21;
                                v4 = this;
                                var1_4 = v5;
                                new Bundle().putInt("request-sync", 0);
                                v4.mediaCodec.setParameters(var1_4);
                                v2.lastKeyFrameTimeMs = v3;
lbl27:
                                // 2 sources

                                ATrace.beginSection("makeCurrent@enc");
                                var1_2 = this.isOnDedicatedHandlerThread();
                                if (var1_2) ** GOTO lbl33
                                this.eglBase.makeCurrent();
                                break block29;
lbl33:
                                // 1 sources

                                if (!this.eglAttachedOnDedicatedThread) {
                                    this.eglBase.makeCurrent();
                                    this.eglAttachedOnDedicatedThread = true;
                                }
                            }
                            ATrace.endSection();
                            ATrace.beginSection("glClear@enc");
                            GLES20.glClear((int)16384);
                            ATrace.endSection();
                            var4_10 /* !! */  = (float[])RendererCommon.convertMatrixToAndroidGraphicsMatrix(var4_10 /* !! */ );
                            if (!var10_18) break block24;
                            if (var9_17 != 90 && var9_17 != 270) {
                                v6 = var5_13;
                                var5_13 = var6_14;
                                var6_14 = v6;
                            }
                            if (var9_17 == 0) break block25;
                            v7 /* !! */  = var4_10 /* !! */ ;
                            v8 = this;
                            v9 = v8;
                            v10 = v8;
                            v11 = v8;
                            v8.rotateMatrix.reset();
                            v8.rotateMatrix.preTranslate(0.5f, 0.5f);
                            v12 = v10.rotateMatrix;
                            v12.preRotate((float)var9_17);
                            v11.rotateMatrix.preTranslate(-0.5f, -0.5f);
                            v7 /* !! */ .preConcat(v9.rotateMatrix);
                            break block25;
                        }
                        v13 = var5_13;
                        var5_13 = var6_14;
                        var6_14 = v13;
                    }
                    var3_7 = RendererCommon.convertMatrixFromAndroidGraphicsMatrix((Matrix)var4_10 /* !! */ );
                    ATrace.beginSection("draw@enc");
                    if (var3_6 != 10) ** GOTO lbl89
                    this.memoryType = 10;
                    v14 = this.drawer;
                    v15 = var2_5;
                    v16 = var6_14;
                    v17 = this;
                    var2_5 = 0;
                    var3_8 = 0;
                    var4_11 = v17.width;
                    var6_14 = v17.height;
                    v14.drawRgb(v15, var3_7, v16, var5_13, var2_5, var3_8, var4_11, var6_14, var7_15, var8_16);
                    ** GOTO lbl100
lbl89:
                    // 1 sources

                    this.memoryType = 11;
                    v18 = this.drawer;
                    v19 = var2_5;
                    v20 = var6_14;
                    v21 = this;
                    var2_5 = 0;
                    var3_9 = 0;
                    try {
                        var4_12 = v21.width;
                        var6_14 = v21.height;
                        v18.drawOes(v19, var3_7, v20, var5_13, var2_5, var3_9, var4_12, var6_14, var7_15, var8_16);
lbl100:
                        // 2 sources

                        if (var10_18) {
                            var9_17 = 0;
                        }
                        this.outputFrameRotation = var9_17;
                        ATrace.endSection();
                        ATrace.beginSection("swapBuffers@enc");
                        this.eglBase.swapBuffers();
                        ATrace.endSection();
                        ATrace.beginSection("detachCurrent");
                        if (!var1_2) {
                            this.eglBase.detachCurrent();
                        }
                        ATrace.endSection();
                        var16_22 = true;
                        if (var13_20 == null) break block26;
                        break block27;
                    }
                    catch (Throwable var0_1) {
                        break block28;
                    }
                    catch (RuntimeException var1_3) {}
                    {
                        Logging.e(MediaCodecVideoEncoder.TAG, "encodeTexture failed", var1_3);
                        if (var13_20 == null) break block26;
                    }
                }
                var13_20.run();
            }
            this.verboseLog("done encoding texture, pts_us: " + var11_19);
            return var16_22;
        }
        if (var13_20 != null) {
            var13_20.run();
        }
        throw var0_1;
    }

    boolean encodeTexture(boolean bl, int n2, int n3, float[] fArray, int n4, int n5, int n6, int n7, int n8, long l2) {
        return this.encodeTexture(bl, n2, n3, fArray, n4, n5, n6, n7, n8, true, l2, null);
    }

    boolean encodeTextureBuffer(final VideoFrame.TextureBuffer textureBuffer, final boolean bl, final int n2, final int n3, final int n4, final boolean bl2, final long l2) {
        Callable<Boolean> callable;
        this.verboseLog("encodeTextureBuffer: " + textureBuffer + " isKeyframe: " + bl + " rotation: " + n4 + " pts_us: " + l2 + " this: " + this);
        textureBuffer.retain();
        Callable<Boolean> callable2 = callable;
        callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Runnable runnable;
                2 v0 = this;
                boolean bl3 = v0.bl;
                int n22 = v0.textureBuffer.getTextureId();
                int n32 = VideoFrame.getAgoraFormat(v0.textureBuffer);
                float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(v0.textureBuffer.getTransformMatrix());
                int n42 = v0.textureBuffer.getWidth();
                int n5 = v0.textureBuffer.getHeight();
                int n6 = v0.n2;
                int n7 = v0.n3;
                int n8 = v0.n4;
                boolean bl22 = v0.bl2;
                long l22 = v0.l2;
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        1 v0 = this;
                        v0.MediaCodecVideoEncoder.this.verboseLog("releasing " + textureBuffer);
                        v0.textureBuffer.release();
                    }
                };
                return MediaCodecVideoEncoder.this.encodeTexture(bl3, n22, n32, fArray, n42, n5, n6, n7, n8, bl22, l22, runnable2);
            }
        };
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.dedicatedHandler, callable2);
        }
        catch (Exception exception) {
            Logging.e(TAG, "encode texture buffer exception: " + exception);
            textureBuffer.release();
            return false;
        }
    }

    void release() {
        Runnable runnable;
        Logging.i(TAG, "Java releaseEncoder");
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                if (!MediaCodecVideoEncoder.this.useAsyncMode) {
                    MediaCodecVideoEncoder.this.doReleaseEncoder();
                    return;
                }
                3 v0 = this;
                Object object = v0.MediaCodecVideoEncoder.this.callbackLock;
                synchronized (object) {
                    v0.MediaCodecVideoEncoder.this.availableInputIndexes.clear();
                    if (v0.MediaCodecVideoEncoder.this.asyncEncoderCallback != null) {
                        ((MediaCodecVideoEncoder)MediaCodecVideoEncoder.this).asyncEncoderCallback.stale = true;
                    }
                    MediaCodecVideoEncoder.this.doReleaseEncoder();
                    return;
                }
            }
        };
        MediaCodecVideoEncoder mediaCodecVideoEncoder = mediaCodecVideoEncoder.dedicatedHandler;
        if (mediaCodecVideoEncoder != null) {
            ThreadUtils.invokeAtFrontUninterruptibly((Handler)mediaCodecVideoEncoder, runnable2);
        } else {
            runnable2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @TargetApi(value=21)
    InputBufferInfo dequeueInputBufferAvailable() {
        v0 = this;
        var1_1 = v0.callbackLock;
        synchronized (var1_1) {
            block13: {
                var2_2 = v0.availableInputIndexes.iterator();
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
                }
                if (var2_2.hasNext()) break block13;
                Logging.e(MediaCodecVideoEncoder.TAG, "no input buffer available");
                var2_2 = v2;
                v2 = new InputBufferInfo(-1, null);
                var4_5 = var2_2;
                ** GOTO lbl36
            }
            v3 = this;
            v4 = var2_2;
            v5 = v4;
            var2_3 = (Integer)v4.next();
            v5.remove();
            var3_6 = v3.mediaCodec.getInputBuffer(var2_3);
            var4_5 = v6;
            try {
                v6 = new InputBufferInfo(var2_3, var3_6);
                ** GOTO lbl36
            }
            catch (IllegalStateException var2_4) {
                Logging.e(MediaCodecVideoEncoder.TAG, "codec exception: " + var2_4.getMessage());
                var4_5 = v7;
                v7 = new InputBufferInfo(-2, null);
lbl36:
                // 3 sources

                // MONITOREXIT @DISABLED, blocks:[9, 10, 11] lbl33 : MonitorExitStatement: MONITOREXIT : var1_1
                this.verboseLog("dequeueInputBufferAvailable index: " + var4_5.index);
                return var4_5;
            }
        }
    }

    @Deprecated
    int dequeueInputBuffer() {
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @Deprecated
    OutputBufferInfo dequeueOutputBuffer() {
        int n2;
        MediaCodec.BufferInfo bufferInfo;
        block17: {
            MediaCodec.BufferInfo bufferInfo2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder;
            try {
                mediaCodecVideoEncoder = this;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
                return new OutputBufferInfo(-1, null, false, -1L, 0);
            }
            bufferInfo = bufferInfo2;
            bufferInfo2 = new MediaCodec.BufferInfo();
            n2 = mediaCodecVideoEncoder.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n2 < 0) break block17;
            if (!((bufferInfo.flags & 2) != 0)) break block17;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
            MediaCodecVideoEncoder mediaCodecVideoEncoder3 = mediaCodecVideoEncoder2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder4 = mediaCodecVideoEncoder2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder5 = mediaCodecVideoEncoder2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder6 = mediaCodecVideoEncoder2;
            Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
            mediaCodecVideoEncoder2.configData = ByteBuffer.allocateDirect(bufferInfo.size);
            mediaCodecVideoEncoder2.outputBuffers[n2].position(bufferInfo.offset);
            ByteBuffer byteBuffer = mediaCodecVideoEncoder5.outputBuffers[n2];
            int n3 = bufferInfo.offset + bufferInfo.size;
            byteBuffer.limit(n3);
            mediaCodecVideoEncoder6.configData.put(this.outputBuffers[n2]);
            mediaCodecVideoEncoder3.mediaCodec.releaseOutputBuffer(n2, false);
            n2 = mediaCodecVideoEncoder4.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
        }
        if (n2 >= 0) {
            return this.createOutputBufferInfo(bufferInfo, n2, this.outputBuffers[n2].duplicate());
        }
        if (n2 == -3) {
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            mediaCodecVideoEncoder.outputBuffers = mediaCodecVideoEncoder.mediaCodec.getOutputBuffers();
            return mediaCodecVideoEncoder.dequeueOutputBuffer();
        }
        if (n2 == -2) {
            return this.dequeueOutputBuffer();
        }
        if (n2 == -1) {
            return null;
        }
        throw new RuntimeException("dequeueOutputBuffer: " + n2);
    }

    @Deprecated
    boolean releaseOutputBuffer(int n2) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.verboseLog("releaseOutputBuffer: " + n2);
        try {
            mediaCodecVideoEncoder.mediaCodec.releaseOutputBuffer(n2, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void dumpIntoFile(OutputBufferInfo var1_3, VideoCodecType var2_4) {
        block23: {
            block24: {
                block22: {
                    block21: {
                        if (this.fos != null) break block23;
                        var3_5 = null;
                        if (var2_4 /* !! */  != VideoCodecType.VIDEO_CODEC_H264) break block21;
                        v0 = new Object[2];
                        v0[0] = this.width;
                        v0[1] = this.height;
                        v1 = String.format("/sdcard/java_dump_video_%d_%d.h264", v0);
lbl12:
                        // 3 sources

                        while (true) {
                            continue;
                            break;
                        }
                    }
                    if (var2_4 /* !! */  != VideoCodecType.VIDEO_CODEC_H265) break block22;
                    v2 = new Object[2];
                    v2[0] = this.width;
                    v2[1] = this.height;
                    v1 = String.format("/sdcard/java_dump_video_%d_%d.h265", v2);
                    ** GOTO lbl12
                }
                v3 = new Object[2];
                v3[0] = this.width;
                v3[1] = this.height;
                v1 = String.format("/sdcard/java_dump_video_%d_%d.raw", v3);
                ** continue;
                var2_4 /* !! */  = v1;
                try {
                    this.fos = new FileOutputStream((String)var2_4 /* !! */ , true);
                    break block23;
                }
                catch (Exception v4) {
                    break block24;
                }
                catch (Exception v5) {
                    var2_4 /* !! */  = var3_5;
                }
            }
            Logging.i(MediaCodecVideoEncoder.TAG, "dumpIntoFile: failed to open " + (String)var2_4 /* !! */ );
            return;
        }
        if (var1_3 != null && var1_3.index >= 0) {
            v6 = this;
            v7 = var1_3;
            Logging.i(MediaCodecVideoEncoder.TAG, "Dump nal: " + var1_3.buffer);
            this = new byte[v7.buffer.remaining()];
            v7.buffer.get((byte[])this);
            v8 = v6.fos;
            var0_1 = 0;
            try {
                v8.write((byte[])this, var0_1, var1_3.size);
            }
            catch (Exception var0_2) {
                Logging.e(MediaCodecVideoEncoder.TAG, "Run: 4.1 Exception ", var0_2);
            }
        }
    }

    @TargetApi(value=21)
    private class MediaCodecEncoderCallback
    extends MediaCodec.Callback {
        boolean stale = false;

        private MediaCodecEncoderCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onInputBufferAvailable(MediaCodec object, int n2) {
            void var2_3;
            MediaCodecEncoderCallback mediaCodecEncoderCallback = this;
            mediaCodecEncoderCallback.MediaCodecVideoEncoder.this.verboseLog("onInputBufferAvailable " + (int)var2_3);
            Object object2 = mediaCodecEncoderCallback.MediaCodecVideoEncoder.this.callbackLock;
            synchronized (object2) {
                if (mediaCodecEncoderCallback.stale) {
                    Logging.w(TAG, "discard stale available input buffer");
                    return;
                }
                Object object3 = object2;
                MediaCodecVideoEncoder.this.availableInputIndexes.add((int)var2_3);
                {
                    // ** MonitorExit[v1] (shouldn't be in output)
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onOutputBufferAvailable(MediaCodec var1_2, int var2_3, MediaCodec.BufferInfo var3_4) {
            v0 = this;
            MediaCodecVideoEncoder.access$300(v0.MediaCodecVideoEncoder.this, "onOutputBufferAvailable: " + var2_3);
            var1_2 /* !! */  = MediaCodecVideoEncoder.access$500(v0.MediaCodecVideoEncoder.this);
            synchronized (var1_2 /* !! */ ) {
                if (v0.stale) {
                    Logging.w(MediaCodecVideoEncoder.access$100(), "discard stale available output buffer");
                    return;
                }
                var4_6 = MediaCodecVideoEncoder.access$900(MediaCodecVideoEncoder.this).getOutputBuffer(var2_3);
                if (var4_6 != null) ** GOTO lbl20
                ** GOTO lbl-1000
                {
                    block14: {
                        catch (IllegalStateException var0_1) {
                            Logging.e(MediaCodecVideoEncoder.access$100(), "getOutputBuffer exception, index: " + var2_3, var0_1);
                            return;
                        }
lbl-1000:
                        // 1 sources

                        {
                            Logging.e(MediaCodecVideoEncoder.access$100(), "failed to get output buffer, index: " + var2_3);
                            return;
                        }
lbl20:
                        // 1 sources

                        try {
                            if ((var3_4 /* !! */ .flags & 2) != 0) {
                                v2 = this;
                                v3 = v2;
                                Logging.d(MediaCodecVideoEncoder.access$100(), "[async] Config frame generated. Offset: " + var3_4 /* !! */ .offset + ". Size: " + var3_4 /* !! */ .size);
                                MediaCodecVideoEncoder.access$1002(v2.MediaCodecVideoEncoder.this, ByteBuffer.allocateDirect(var3_4 /* !! */ .size));
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception var3_5) {
                            Logging.e(MediaCodecVideoEncoder.access$100(), "handle output buffer error", var3_5);
                            break block14;
                        }
                        {
                            MediaCodecVideoEncoder.access$1000(v3.MediaCodecVideoEncoder.this).put(var4_6);
                        }
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            v4 = this;
                            var3_4 /* !! */  = MediaCodecVideoEncoder.access$1100(v4.MediaCodecVideoEncoder.this, var3_4 /* !! */ , var2_3, var4_6);
                            MediaCodecVideoEncoder.access$1300(v4.MediaCodecVideoEncoder.this, MediaCodecVideoEncoder.access$1200(MediaCodecVideoEncoder.this), true, (OutputBufferInfo)var3_4 /* !! */ );
                        }
                    }
                    v5 = this;
                    MediaCodecVideoEncoder.access$300(v5.MediaCodecVideoEncoder.this, "releaseOutputBuffer: " + var2_3);
                    MediaCodecVideoEncoder.access$900(v5.MediaCodecVideoEncoder.this).releaseOutputBuffer(var2_3, false);
                    return;
                }
            }
        }

        public void onError(MediaCodec mediaCodec, MediaCodec.CodecException codecException) {
            Logging.e(TAG, "onError " + codecException);
        }

        public void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
            Logging.w(TAG, "onOutputFormatChanged " + mediaFormat);
        }
    }

    static class OutputBufferInfo {
        public final int size;
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n2, ByteBuffer byteBuffer, boolean bl, long l2, int n3) {
            this.index = n2;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l2;
            this.size = n3;
        }
    }

    static class InputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;

        public InputBufferInfo(int n2, ByteBuffer byteBuffer) {
            this.index = n2;
            this.buffer = byteBuffer;
        }
    }

    public static class InitParameters {
        int codec;
        int width;
        int height;
        int bitrateKbps;
        int fps;
        int init_fps;
        int keyInterval;
        int profile;
        boolean fallbackToBaselineProfile;
        boolean useAsyncMode;
        boolean useSurface;
        android.opengl.EGLContext sharedEgl14Context;
        EGLContext sharedEgl10Context;
        String customConfigJson;

        public InitParameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, boolean bl3, android.opengl.EGLContext eGLContext, EGLContext eGLContext2, String string2) {
            this.codec = n2;
            this.width = n3;
            this.height = n4;
            this.bitrateKbps = n5;
            this.fps = n6;
            this.init_fps = n7;
            this.keyInterval = n8;
            this.fallbackToBaselineProfile = bl;
            this.profile = n9;
            this.useAsyncMode = bl2;
            this.useSurface = bl3;
            this.sharedEgl14Context = eGLContext;
            this.sharedEgl10Context = eGLContext2;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.customConfigJson = new String(Base64.decode((String)string2, (int)0));
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append((Object)VideoCodecType.values()[this.codec]).append(" : " + this.width + " x " + this.height).append(" @ " + this.bitrateKbps + " Kbps,").append(" Fps: ").append(this.fps + ",").append(" Key interval: " + this.keyInterval + "s,").append(" Encode from texture : " + this.useSurface + ",").append(" Async mode: " + this.useAsyncMode + ".");
            StringBuilder stringBuilder2 = new StringBuilder().append(" Shared ctx: ");
            android.opengl.EGLContext eGLContext = this.sharedEgl14Context;
            if (eGLContext == null) {
                eGLContext = this.sharedEgl10Context;
            }
            return stringBuilder.append(stringBuilder2.append(eGLContext).append(".").toString()).append(" Custom config: " + this.customConfigJson).toString();
        }
    }

    private static class ChipProperties {
        public String chipName;
        public BitrateAdjustmentType bitrateAdjustmentType;
        public boolean isNeedResetWhenDownBps;
        public int baseFrameRate;
        public int initFrameRate;
        public int highProfileMinSdkVersion;

        ChipProperties(String string2, BitrateAdjustmentType bitrateAdjustmentType, boolean bl, int n2, int n3, int n4) {
            this.chipName = string2;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.isNeedResetWhenDownBps = bl;
            this.baseFrameRate = n2;
            this.initFrameRate = n3;
            this.highProfileMinSdkVersion = n4;
        }
    }

    public static final class BitrateAdjustmentType
    extends Enum<BitrateAdjustmentType> {
        public static final /* enum */ BitrateAdjustmentType NO_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType FRAMERATE_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType ACTUAL_FRAMERATE_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType DYNAMIC_ADJUSTMENT;
        private static final /* synthetic */ BitrateAdjustmentType[] $VALUES;

        public static BitrateAdjustmentType[] values() {
            return (BitrateAdjustmentType[])$VALUES.clone();
        }

        public static BitrateAdjustmentType valueOf(String string2) {
            return Enum.valueOf(BitrateAdjustmentType.class, string2);
        }

        static {
            BitrateAdjustmentType bitrateAdjustmentType;
            NO_ADJUSTMENT = new BitrateAdjustmentType();
            FRAMERATE_ADJUSTMENT = new BitrateAdjustmentType();
            ACTUAL_FRAMERATE_ADJUSTMENT = new BitrateAdjustmentType();
            BitrateAdjustmentType bitrateAdjustmentType2 = bitrateAdjustmentType;
            DYNAMIC_ADJUSTMENT = new BitrateAdjustmentType();
            $VALUES = new BitrateAdjustmentType[]{NO_ADJUSTMENT, FRAMERATE_ADJUSTMENT, ACTUAL_FRAMERATE_ADJUSTMENT, bitrateAdjustmentType2};
        }
    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final boolean supportedList;

        public EncoderProperties(String string2, int n2, boolean bl) {
            this.codecName = string2;
            this.colorFormat = n2;
            this.supportedList = bl;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H265;
        private static final /* synthetic */ VideoCodecType[] $VALUES;

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }

        public static VideoCodecType valueOf(String string2) {
            return Enum.valueOf(VideoCodecType.class, string2);
        }

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_H264 = new VideoCodecType();
            VideoCodecType videoCodecType2 = videoCodecType;
            VIDEO_CODEC_H265 = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_H264, videoCodecType2};
        }
    }
}

