/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TextureRenderer {
    private static final String LOG_TAG = "TextureRenderer";
    static final int COORDS_PER_VERTEX = 2;
    static float[] squareVertices = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private final String mVertexShader;
    private final String mFragmentShaderOes;
    private final String mFragmentShaderRgba;
    private FloatBuffer vertexBuffer;
    private FloatBuffer textureVerticesBuffer;
    private ShortBuffer drawListBuffer;
    private final int mProgram;
    private boolean mOesTexture;
    float[] textureVertices;
    private short[] drawOrder;
    private final int vertexStride;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private float[] mMVPMatrix;
    private float[] mSTMatrix;

    public TextureRenderer(boolean bl) {
        int n2;
        Buffer buffer;
        TextureRenderer textureRenderer = this;
        this.mVertexShader = "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nvarying vec2 textureCoordinate;\nvoid main()\n{\ngl_Position = uMVPMatrix * position;\nvec4 tex4 = vec4(inputTextureCoordinate.xy, 1.0, 1.0);\ntextureCoordinate = (uSTMatrix * tex4).xy;\n}";
        this.mFragmentShaderOes = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}";
        this.mFragmentShaderRgba = "precision mediump float;\nvarying vec2 textureCoordinate;\nuniform sampler2D s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}";
        this.mOesTexture = true;
        this.textureVertices = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        this.drawOrder = new short[]{0, 1, 2, 0, 2, 3};
        this.vertexStride = 8;
        this.mMVPMatrix = new float[16];
        this.mSTMatrix = new float[16];
        textureRenderer.mOesTexture = bl;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(squareVertices.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(squareVertices);
        textureRenderer.vertexBuffer.position(0);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(textureRenderer.drawOrder.length * 2);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.drawListBuffer = buffer = byteBuffer2.asShortBuffer();
        buffer.put(this.drawOrder);
        textureRenderer.drawListBuffer.position(0);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(textureRenderer.textureVertices.length * 4);
        byteBuffer3.order(ByteOrder.nativeOrder());
        buffer = byteBuffer3.asFloatBuffer();
        this.textureVerticesBuffer = buffer;
        ((FloatBuffer)buffer).put(this.textureVertices);
        textureRenderer.textureVerticesBuffer.position(0);
        int n3 = textureRenderer.loadShader(35633, "attribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nvarying vec2 textureCoordinate;\nvoid main()\n{\ngl_Position = uMVPMatrix * position;\nvec4 tex4 = vec4(inputTextureCoordinate.xy, 1.0, 1.0);\ntextureCoordinate = (uSTMatrix * tex4).xy;\n}");
        int n4 = textureRenderer.mOesTexture ? this.loadShader(35632, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 textureCoordinate;\nuniform samplerExternalOES s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}") : this.loadShader(35632, "precision mediump float;\nvarying vec2 textureCoordinate;\nuniform sampler2D s_texture;\nvoid main() {\ngl_FragColor = texture2D(s_texture, textureCoordinate);\n}");
        TextureRenderer textureRenderer2 = this;
        this.mProgram = n2 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n2, (int)n3);
        GLES20.glAttachShader((int)textureRenderer2.mProgram, (int)n4);
        GLES20.glLinkProgram((int)textureRenderer2.mProgram);
        textureRenderer2.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)textureRenderer2.mProgram, (String)"uMVPMatrix");
        textureRenderer2.muSTMatrixHandle = GLES20.glGetUniformLocation((int)textureRenderer2.mProgram, (String)"uSTMatrix");
        Matrix.setIdentityM((float[])textureRenderer2.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])textureRenderer2.mSTMatrix, (int)0);
    }

    private void printMatrix(float[] fArray) {
        for (int i2 = 0; i2 < 4; ++i2) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            int n2 = i2 * 4;
            Log.d((String)LOG_TAG, (String)stringBuilder.append(fArray[n2 + 0]).append(" ").append(fArray[n2 + 1]).append(" ").append(fArray[n2 + 2]).append(" ").append(fArray[n2 + 3]).toString());
        }
    }

    private int loadShader(int n2, String string2) {
        int n3 = GLES20.glCreateShader((int)n2);
        GLES20.glShaderSource((int)n3, (String)string2);
        GLES20.glCompileShader((int)n3);
        return n3;
    }

    public void rotate(int n2) {
        TextureRenderer textureRenderer = this;
        double d2 = (double)n2 / 180.0 * Math.PI;
        textureRenderer.mMVPMatrix[0] = (float)Math.cos(d2);
        textureRenderer.mMVPMatrix[1] = -((float)Math.sin(d2));
        textureRenderer.mMVPMatrix[4] = (float)Math.sin(d2);
        textureRenderer.mMVPMatrix[5] = (float)Math.cos(d2);
    }

    public void flip(boolean bl, boolean bl2) {
        if (bl || bl2) {
            boolean bl3 = bl;
            Object object = ((TextureRenderer)object).mMVPMatrix;
            bl = false;
            float f2 = bl3 ? -1.0f : 1.0f;
            float f3 = bl2 ? -1.0f : 1.0f;
            Matrix.scaleM((float[])object, (int)(bl ? 1 : 0), (float)f2, (float)f3, (float)1.0f);
        }
    }

    public void draw(int n2) {
        TextureRenderer textureRenderer = object2;
        GLES20.glUseProgram((int)textureRenderer.mProgram);
        GLES20.glActiveTexture((int)33984);
        if (textureRenderer.mOesTexture) {
            GLES20.glBindTexture((int)36197, (int)n2);
        } else {
            GLES20.glBindTexture((int)3553, (int)n2);
        }
        TextureRenderer textureRenderer2 = object2;
        n2 = GLES20.glGetAttribLocation((int)textureRenderer2.mProgram, (String)"position");
        GLES20.glEnableVertexAttribArray((int)n2);
        FloatBuffer floatBuffer = ((TextureRenderer)object2).vertexBuffer;
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)floatBuffer);
        int n3 = GLES20.glGetAttribLocation((int)textureRenderer2.mProgram, (String)"inputTextureCoordinate");
        TextureRenderer textureRenderer3 = object2;
        GLES20.glEnableVertexAttribArray((int)n3);
        Object object = ((TextureRenderer)object2).textureVerticesBuffer;
        GLES20.glVertexAttribPointer((int)n3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
        object = ((TextureRenderer)object2).mMVPMatrix;
        GLES20.glUniformMatrix4fv((int)textureRenderer3.muMVPMatrixHandle, (int)1, (boolean)false, (float[])object, (int)0);
        Object object2 = ((TextureRenderer)object2).mSTMatrix;
        GLES20.glUniformMatrix4fv((int)textureRenderer3.muSTMatrixHandle, (int)1, (boolean)false, (float[])object2, (int)0);
        int n4 = textureRenderer3.drawOrder.length;
        object = textureRenderer3.drawListBuffer;
        GLES20.glDrawElements((int)4, (int)n4, (int)5123, (Buffer)object);
        GLES20.glDisableVertexAttribArray((int)n2);
        GLES20.glDisableVertexAttribArray((int)n3);
        GLES20.glUseProgram((int)0);
    }

    public void draw(int n2, float[] fArray) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.mSTMatrix[i2] = fArray[i2];
        }
        this.draw(n2);
    }
}

