/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.GLRendererController;
import io.agora.rtc.video.TextureRenderer;

public class TextureRendererHelper {
    private static String TAG = "TextureRendererHelper";
    private static final boolean VERBOSE = false;
    private EglBase eglBase = null;
    private boolean eglAttached = false;
    private GlRectDrawer drawer = null;
    private int oesTextureId = -1;
    private SurfaceTexture surfaceTexture = null;
    private boolean surfaceTextureRecreated = false;
    private TextureRenderer textureRenderer = null;
    private TextureFrame textureFrame = null;
    private Surface surface = null;
    private int oldWidth = -1;
    private int oldHeight = -1;
    private Object localRealEglContext = null;
    private int localEglType = -1;
    private volatile boolean textureSourceIncoming = false;

    private void setupSurfaceTexture(GLRendererController gLRendererController) {
        if (this.surfaceTexture == null && gLRendererController != null) {
            SurfaceTexture surfaceTexture;
            SurfaceTexture surfaceTexture2;
            TextureRendererHelper textureRendererHelper = this;
            textureRendererHelper.oesTextureId = GlUtil.generateTexture(36197, false);
            SurfaceTexture surfaceTexture3 = surfaceTexture2 = surfaceTexture;
            surfaceTexture3(this.oesTextureId);
            this.surfaceTexture = surfaceTexture3;
            surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)gLRendererController);
            textureRendererHelper.surface = new Surface(this.surfaceTexture);
            textureRendererHelper.surfaceTextureRecreated = true;
        }
    }

    public boolean isTextureSourceIncoming() {
        return this.textureSourceIncoming;
    }

    public void setTextureSourceIncoming(boolean bl) {
        this.textureSourceIncoming = bl;
    }

    public boolean useJavaRender() {
        return false;
    }

    public TextureFrame getTextureFrame() {
        TextureFrame textureFrame = this.textureFrame;
        if (textureFrame != null) {
            TextureFrame textureFrame2 = textureFrame;
            textureFrame2.texId = this.oesTextureId;
            textureFrame2.textureType = 1;
        }
        return this.textureFrame;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTextureFrameArrived(VideoFrame.TextureBuffer textureBuffer, int n2, long l2, long l3, boolean bl) {
        if (textureBuffer == null) {
            Logging.e(TAG, "texture buffer is null.");
            return;
        }
        textureBuffer.retain();
        if (this.surfaceTexture != null && this.surface != null) {
            int n3;
            if (!textureBuffer.getRealEglContext().equals(this.localRealEglContext) || textureBuffer.getEglType() != this.localEglType) {
                this.localRealEglContext = textureBuffer.getRealEglContext();
                this.localEglType = textureBuffer.getEglType();
                this.releaseProducerResourceIfNotYet();
            }
            if (this.oldWidth != textureBuffer.getWidth() || this.oldHeight != textureBuffer.getHeight()) {
                TextureRendererHelper textureRendererHelper = this;
                this.oldWidth = textureBuffer.getWidth();
                textureRendererHelper.oldHeight = textureBuffer.getHeight();
                VideoFrame.TextureBuffer textureBuffer2 = textureBuffer;
                n3 = textureBuffer2.getWidth();
                textureRendererHelper.surfaceTexture.setDefaultBufferSize(n3, textureBuffer2.getHeight());
                textureRendererHelper.releaseProducerResourceIfNotYet();
            }
            if (this.surfaceTextureRecreated) {
                this.releaseProducerResourceIfNotYet();
                this.surfaceTextureRecreated = false;
            }
            TextureRendererHelper textureRendererHelper = this;
            ATrace.beginSection("prepare@render");
            textureRendererHelper.createProducerResourceIfNeeded(textureBuffer.getEglBaseContext());
            ATrace.endSection();
            if (textureRendererHelper.textureFrame == null) {
                TextureFrame textureFrame;
                TextureFrame textureFrame2 = textureFrame;
                textureFrame = new TextureFrame();
                this.textureFrame = textureFrame2;
            }
            TextureRendererHelper textureRendererHelper2 = this;
            VideoFrame.TextureBuffer textureBuffer3 = textureBuffer;
            n3 = textureBuffer3.getTextureId();
            VideoFrame.TextureBuffer.Type type = textureBuffer3.getType();
            int n4 = textureBuffer3.getWidth();
            int n5 = textureBuffer3.getHeight();
            float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer3.getTransformMatrix());
            textureRendererHelper2.textureFrame.frameWidth = textureBuffer.getWidth();
            textureRendererHelper2.textureFrame.frameHeight = textureBuffer.getHeight();
            TextureFrame textureFrame = textureRendererHelper2.textureFrame;
            textureFrame.rotation = n2;
            textureFrame.renderMs = l2;
            textureFrame.firstRecvTimestamp = l3;
            textureRendererHelper2.textureFrame.isDummy = bl;
            try {
                ATrace.beginSection("makeCurrent@render");
                if (!textureRendererHelper2.eglAttached) {
                    Logging.i(TAG, "attaching egl context, this: " + this.hashCode() + ", thread id: " + Thread.currentThread().getId());
                    this.eglBase.makeCurrent();
                    this.eglAttached = true;
                }
                ATrace.endSection();
                ATrace.beginSection("glClear@render");
                GLES20.glClear((int)16384);
                ATrace.endSection();
                ATrace.beginSection("draw@render");
                if (type == VideoFrame.TextureBuffer.Type.RGB) {
                    this.drawer.drawRgb(n3, fArray, n4, n5, 0, 0, n4, n5);
                } else {
                    this.drawer.drawOes(n3, fArray, n4, n5, 0, 0, n4, n5);
                }
                ATrace.endSection();
                ATrace.beginSection("swapBuffers@render");
                this.eglBase.swapBuffers();
                ATrace.endSection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            textureBuffer.release();
            return;
        }
        Logging.w(TAG, "frame is ready, but the gl renderer thread is not ready yet.");
        this.releaseProducerResourceIfNotYet();
        textureBuffer.release();
    }

    public void createProducerResourceIfNeeded(EglBase.Context object) {
        if (((TextureRendererHelper)((Object)glRectDrawer2)).eglBase == null) {
            GlRectDrawer glRectDrawer;
            object = EglBase.create((EglBase.Context)object);
            try {
                ((TextureRendererHelper)((Object)glRectDrawer2)).eglBase = object;
                ((EglBase)object).createSurface(((TextureRendererHelper)((Object)glRectDrawer2)).surface);
            }
            catch (Exception exception) {
                Logging.e(TAG, "got exception when create eglbase:" + exception.toString());
            }
            TextureRendererHelper textureRendererHelper = glRectDrawer2;
            GlRectDrawer glRectDrawer2 = glRectDrawer;
            glRectDrawer = new GlRectDrawer();
            textureRendererHelper.drawer = glRectDrawer2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseProducerResourceIfNotYet() {
        if (this.eglBase == null) {
            return;
        }
        try {
            Logging.i(TAG, "release gl resource, this: " + this.hashCode() + ", thread id: " + Thread.currentThread().getId());
            if (!this.eglAttached) {
                this.eglBase.makeCurrent();
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            this.eglBase.release();
            this.eglBase = null;
            this.eglAttached = false;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void releaseSurfaceTexture() {
        int n2;
        Logging.d(TAG, "release surface texture, this: " + object.hashCode());
        Surface surface = ((TextureRendererHelper)object).surface;
        if (surface != null) {
            surface.release();
            ((TextureRendererHelper)object).surface = null;
        }
        if ((surface = ((TextureRendererHelper)object).surfaceTexture) != null) {
            surface.release();
            ((TextureRendererHelper)object).surfaceTexture = null;
        }
        if ((n2 = ((TextureRendererHelper)object).oesTextureId) >= 0) {
            TextureRendererHelper textureRendererHelper = object;
            int[] nArray = new int[1];
            Object object = nArray;
            nArray[0] = n2;
            GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
            textureRendererHelper.oesTextureId = -1;
        }
    }

    public void onSurfaceChanged(GLRendererController gLRendererController, int n2, int n3) {
        TextureRendererHelper textureRendererHelper = this;
        Logging.i(TAG, "onSurfaceChanged, w: " + n2 + " h: " + n3 + " this: " + this.hashCode());
        this.releaseSurfaceTexture();
        this.oldWidth = -1;
        this.oldHeight = -1;
        textureRendererHelper.setupSurfaceTexture(gLRendererController);
        if (textureRendererHelper.useJavaRender()) {
            GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
        }
    }

    public void onDrawFrame(GLRendererController object) throws Exception {
        TextureRendererHelper textureRendererHelper = this;
        ATrace.beginSection("setupSurfaceTexture");
        textureRendererHelper.setupSurfaceTexture((GLRendererController)object);
        ATrace.endSection();
        if (textureRendererHelper.useJavaRender()) {
            GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLES20.glClear((int)16640);
        }
        if ((object = this.surfaceTexture) != null && this.surface != null) {
            object.updateTexImage();
        }
        if (this.useJavaRender()) {
            if (this.textureRenderer == null) {
                TextureRenderer textureRenderer;
                object = textureRenderer;
                textureRenderer = new TextureRenderer(true);
                this.textureRenderer = object;
            }
            this.textureRenderer.draw(this.oesTextureId);
        }
    }

    public void onFrameAvailable(GLRendererController gLRendererController) {
        if (gLRendererController != null) {
            gLRendererController.ReDraw();
        }
    }

    public class TextureFrame {
        public EglBase.Context context;
        public int texId;
        public int textureType;
        public int frameWidth;
        public int frameHeight;
        public int rotation;
        public long renderMs;
        public long firstRecvTimestamp;
        public boolean isDummy;

        public String toString() {
            return "TextureFrame{context=" + this.context + ", texId=" + this.texId + ", textureType=" + this.textureType + ", frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", rotation=" + this.rotation + ", renderMs=" + this.renderMs + ", firstRecvTimestamp=" + this.firstRecvTimestamp + ", isDummy=" + this.isDummy + '}';
        }
    }
}

