/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Process;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.agora.rtc.internal.Logging;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ViESurfaceRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "ViESurfaceRenderer";
    private Bitmap bitmap = null;
    private ByteBuffer byteBuffer = null;
    private SurfaceHolder surfaceHolder;
    private Rect source = new Rect();
    private Rect dest = new Rect();
    private float topScale = 0.0f;
    private float bottomScale = 1.0f;
    private float leftScale = 0.0f;
    private float rightScale = 1.0f;

    public ViESurfaceRenderer(SurfaceView surfaceView) {
        Logging.i(TAG, "surface view " + surfaceView);
        surfaceView = surfaceView.getHolder();
        this.surfaceHolder = surfaceView;
        if (surfaceView == null) {
            return;
        }
        ViESurfaceRenderer viESurfaceRenderer = this;
        surfaceView.addCallback((SurfaceHolder.Callback)this);
        viESurfaceRenderer.surfaceCreated(viESurfaceRenderer.surfaceHolder);
    }

    private void changeDestRect(int n2, int n3) {
        ViESurfaceRenderer viESurfaceRenderer = this;
        viESurfaceRenderer.dest.right = (int)((float)viESurfaceRenderer.dest.left + Math.abs(this.leftScale - this.rightScale) * (float)n2);
        viESurfaceRenderer.dest.bottom = (int)((float)viESurfaceRenderer.dest.top + Math.abs(this.topScale - this.bottomScale) * (float)n3);
        Logging.i(TAG, "ViESurfaceRender::surfaceChanged in_width:" + n2 + " in_height:" + n3 + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom + " dest scale " + this.rightScale + " bottom scale " + this.bottomScale);
    }

    private void saveBitmapToJPEG(int n2, int n3) {
        FileOutputStream fileOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        ViESurfaceRenderer viESurfaceRenderer = byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        viESurfaceRenderer.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream2);
        FileOutputStream fileOutputStream2 = fileOutputStream;
        Object[] objectArray = new Object[1];
        objectArray[0] = System.currentTimeMillis();
        fileOutputStream2(String.format("/sdcard/render_%d.jpg", objectArray));
        fileOutputStream.write(byteArrayOutputStream2.toByteArray());
        fileOutputStream.flush();
        fileOutputStream.close();
        try {
            Logging.i(TAG, "saved jpg " + fileOutputStream2.toString());
        }
        catch (IOException iOException) {
            Logging.e(TAG, "save jpg failed", iOException);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        this.changeDestRect(n3, n4);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        surfaceHolder = this.surfaceHolder.lockCanvas();
        if (surfaceHolder != null) {
            Rect rect = this.surfaceHolder.getSurfaceFrame();
            if (rect != null) {
                this.changeDestRect(rect.right - rect.left, rect.bottom - rect.top);
                Logging.i(TAG, "ViESurfaceRender::surfaceCreated dst.left:" + rect.left + " dst.top:" + rect.top + " dst.dest:" + rect.right + " dst.bottom:" + rect.bottom + " source.left:" + this.source.left + " source.top:" + this.source.top + " source.dest:" + this.source.right + " source.bottom:" + this.source.bottom + " dest.left:" + this.dest.left + " dest.top:" + this.dest.top + " dest.dest:" + this.dest.right + " dest.bottom:" + this.dest.bottom);
            }
            this.surfaceHolder.unlockCanvasAndPost((Canvas)surfaceHolder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        ViESurfaceRenderer viESurfaceRenderer = this;
        Logging.d(TAG, "ViESurfaceRenderer::surfaceDestroyed");
        viESurfaceRenderer.bitmap = null;
        viESurfaceRenderer.byteBuffer = null;
    }

    public Bitmap CreateBitmap(int n2, int n3) {
        Bitmap bitmap;
        Logging.d(TAG, "CreateByteBitmap " + n2 + ":" + n3);
        if (this.bitmap == null) {
            try {
                Process.setThreadPriority((int)-4);
            }
            catch (Exception exception) {}
        }
        this.bitmap = bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.RGB_565);
        Rect rect = this.source;
        rect.left = 0;
        rect.top = 0;
        rect.bottom = n3;
        rect.right = n2;
        return bitmap;
    }

    public ByteBuffer CreateByteBuffer(int n2, int n3) {
        Logging.i(TAG, "CreateByteBuffer " + n2 + " * " + n3);
        this.bitmap = this.CreateBitmap(n2, n3);
        this.byteBuffer = ByteBuffer.allocateDirect(n2 * n3 * 2);
        return this.byteBuffer;
    }

    public void SetCoordinates(float f2, float f3, float f4, float f5) {
        Logging.i(TAG, "SetCoordinates " + f2 + "," + f3 + " : " + f4 + "," + f5);
        this.leftScale = f2;
        this.topScale = f3;
        this.rightScale = f4;
        this.bottomScale = f5;
    }

    public void DrawByteBuffer() {
        ByteBuffer byteBuffer = this.byteBuffer;
        if (byteBuffer == null) {
            Logging.w(TAG, "DrawByteBuffer null");
            return;
        }
        ViESurfaceRenderer viESurfaceRenderer = this;
        byteBuffer.rewind();
        viESurfaceRenderer.bitmap.copyPixelsFromBuffer((Buffer)this.byteBuffer);
        viESurfaceRenderer.DrawBitmap();
    }

    public void DrawBitmap() {
        if (viESurfaceRenderer3.bitmap == null) {
            return;
        }
        Canvas canvas = viESurfaceRenderer3.surfaceHolder.lockCanvas();
        if (canvas != null) {
            ViESurfaceRenderer viESurfaceRenderer = viESurfaceRenderer3;
            ViESurfaceRenderer viESurfaceRenderer2 = viESurfaceRenderer3;
            ViESurfaceRenderer viESurfaceRenderer3 = viESurfaceRenderer2.bitmap;
            Rect rect = viESurfaceRenderer2.source;
            Rect rect2 = viESurfaceRenderer2.dest;
            canvas.drawBitmap((Bitmap)viESurfaceRenderer3, rect, rect2, null);
            viESurfaceRenderer.surfaceHolder.unlockCanvasAndPost(canvas);
        }
    }
}

