/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.GLRendererController;
import io.agora.rtc.video.GLTextureView;
import io.agora.rtc.video.TextureRendererHelper;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class ViETextureView
extends GLTextureView
implements GLTextureView.Renderer,
GLRendererController {
    private static String TAG = "ViETextureView";
    private static final boolean DEBUG = false;
    private boolean surfaceCreated;
    private boolean openGLCreated;
    private boolean nativeFunctionsRegisted;
    private ReentrantLock nativeFunctionLock;
    private long nativeObject;
    private int viewWidth;
    private int viewHeight;
    private int nativeGLPragram;
    private int[] nativeGLTextureId;
    private int nativeOesGLProgram;
    private boolean nativeGLResourceUpdated;
    private TextureRendererHelper textureRendererHelper;
    private int mLastRotation;

    public static boolean UseOpenGL2(Object object) {
        return ViETextureView.class.isInstance(object);
    }

    public ViETextureView(Context context) {
        TextureRendererHelper textureRendererHelper;
        ReentrantLock reentrantLock;
        ViETextureView viETextureView = object;
        super(context);
        viETextureView.surfaceCreated = false;
        viETextureView.openGLCreated = false;
        viETextureView.nativeFunctionsRegisted = false;
        Object object = reentrantLock;
        reentrantLock = new ReentrantLock();
        viETextureView.nativeFunctionLock = object;
        viETextureView.nativeObject = 0L;
        viETextureView.viewWidth = 0;
        viETextureView.viewHeight = 0;
        viETextureView.nativeGLPragram = 0;
        int[] nArray = new int[3];
        object = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        viETextureView.nativeGLTextureId = (int[])object;
        viETextureView.nativeOesGLProgram = 0;
        viETextureView.nativeGLResourceUpdated = false;
        viETextureView.mLastRotation = -1;
        object = textureRendererHelper;
        textureRendererHelper = new TextureRendererHelper();
        viETextureView.textureRendererHelper = object;
        viETextureView.init(false, 0, 0);
    }

    public ViETextureView(Context context, boolean bl, int n2, int n3) {
        TextureRendererHelper textureRendererHelper;
        ReentrantLock reentrantLock;
        ViETextureView viETextureView = object;
        super(context);
        viETextureView.surfaceCreated = false;
        viETextureView.openGLCreated = false;
        viETextureView.nativeFunctionsRegisted = false;
        Object object = reentrantLock;
        reentrantLock = new ReentrantLock();
        viETextureView.nativeFunctionLock = object;
        viETextureView.nativeObject = 0L;
        viETextureView.viewWidth = 0;
        viETextureView.viewHeight = 0;
        viETextureView.nativeGLPragram = 0;
        int[] nArray = new int[3];
        object = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        viETextureView.nativeGLTextureId = (int[])object;
        viETextureView.nativeOesGLProgram = 0;
        viETextureView.nativeGLResourceUpdated = false;
        viETextureView.mLastRotation = -1;
        object = textureRendererHelper;
        textureRendererHelper = new TextureRendererHelper();
        viETextureView.textureRendererHelper = object;
        viETextureView.init(bl, n2, n3);
    }

    private void init(boolean bl, int n2, int n3) {
        ConfigChooser configChooser;
        this.setEGLContextClientVersion(2);
        if (bl) {
            ConfigChooser configChooser2;
            configChooser = configChooser2;
            configChooser2 = new ConfigChooser(8, 8, 8, 8, n2, n3);
        } else {
            ConfigChooser configChooser3;
            configChooser = configChooser3;
            configChooser3 = new ConfigChooser(5, 6, 5, 0, n2, n3);
        }
        ViETextureView viETextureView = this;
        viETextureView.setEGLConfigChooser(configChooser);
        viETextureView.setRenderer(this);
        viETextureView.setRenderMode(0);
    }

    private static void checkEglError(String string2, EGL10 eGL10) {
        int n2;
        while ((n2 = eGL10.eglGetError()) != 12288) {
            String string3 = TAG;
            Object[] objectArray = new Object[2];
            int n3 = n2;
            objectArray[0] = string2;
            n2 = 1;
            try {
                objectArray[n2] = n3;
                Logging.e(string3, String.format("%s: EGL error: 0x%x", objectArray));
            }
            catch (Exception exception) {
                Logging.e("AGORA_SDK", "egl error!!, video may not displayed!!");
            }
        }
    }

    public static boolean IsSupported(Context context) {
        return ((ActivityManager)context.getSystemService((String)"activity")).getDeviceConfigurationInfo().reqGlEsVersion >= 131072;
    }

    private int checkOrientation() {
        Display display;
        if (this.getContext() != null && this.getContext().getSystemService("window") != null && (display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                return display.getRotation();
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }

    private void updateOrientation() {
        int n2 = this.checkOrientation();
        if (n2 != this.mLastRotation) {
            ViETextureView viETextureView = this;
            viETextureView.nativeFunctionLock.lock();
            if (viETextureView.nativeFunctionsRegisted) {
                ViETextureView viETextureView2 = this;
                viETextureView2.OnCfgChangedNative(viETextureView2.nativeObject, n2);
            }
            this.mLastRotation = n2;
            this.nativeFunctionLock.unlock();
        }
    }

    private native int CreateOpenGLNative(long var1, int var3, int var4);

    private native void DrawNative(long var1);

    private native void OnCfgChangedNative(long var1, int var3);

    private native void DrawNativeTexture(long var1, int var3, int var4, int var5, int var6, int var7, long var8, long var10, boolean var12);

    static /* synthetic */ boolean access$102(ViETextureView viETextureView, boolean bl) {
        viETextureView.surfaceCreated = bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawFrame(GL10 gL10) {
        if (this.textureRendererHelper.isTextureSourceIncoming()) {
            ViETextureView viETextureView = this;
            synchronized (viETextureView) {
                viETextureView.doDrawFrame(true);
            }
        } else {
            this.doDrawFrame(false);
        }
    }

    public void doDrawFrame(boolean bl) {
        if (bl) {
            try {
                this.textureRendererHelper.onDrawFrame(this);
            }
            catch (Exception exception) {
                Logging.e(TAG, "onDrawFrame Exception: " + exception.toString());
            }
            if (this.textureRendererHelper.useJavaRender()) {
                return;
            }
        }
        ViETextureView viETextureView = this;
        viETextureView.updateOrientation();
        viETextureView.nativeFunctionLock.lock();
        if (viETextureView.nativeFunctionsRegisted && this.surfaceCreated) {
            int n2;
            int n3;
            if (!this.openGLCreated) {
                ViETextureView viETextureView2 = this;
                long l2 = viETextureView2.nativeObject;
                n3 = viETextureView2.viewWidth;
                n2 = viETextureView2.viewHeight;
                if (viETextureView2.CreateOpenGLNative(l2, n3, n2) != 0) {
                    this.nativeFunctionLock.unlock();
                    return;
                }
                this.openGLCreated = true;
            }
            if (bl) {
                TextureRendererHelper.TextureFrame textureFrame = this.textureRendererHelper.getTextureFrame();
                if (textureFrame != null) {
                    TextureRendererHelper.TextureFrame textureFrame2 = textureFrame;
                    long l3 = this.nativeObject;
                    int n4 = textureFrame2.textureType;
                    n3 = textureFrame2.texId;
                    n2 = textureFrame2.frameWidth;
                    int n5 = textureFrame2.frameHeight;
                    int n6 = textureFrame2.rotation;
                    long l4 = textureFrame2.renderMs;
                    long l5 = textureFrame2.firstRecvTimestamp;
                    boolean bl2 = textureFrame2.isDummy;
                    this.DrawNativeTexture(l3, n4, n3, n2, n5, n6, l4, l5, bl2);
                }
            } else {
                ViETextureView viETextureView3 = this;
                viETextureView3.DrawNative(viETextureView3.nativeObject);
            }
            this.nativeFunctionLock.unlock();
            return;
        }
        this.nativeFunctionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        ViETextureView viETextureView = this;
        this.surfaceCreated = true;
        this.viewWidth = n2;
        viETextureView.viewHeight = n3;
        synchronized (viETextureView) {
            Throwable throwable2;
            block10: {
                viETextureView.textureRendererHelper.onSurfaceChanged(this, n2, n3);
                if (viETextureView.textureRendererHelper.useJavaRender()) {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
                ViETextureView viETextureView2 = this;
                ViETextureView viETextureView3 = viETextureView2;
                ViETextureView viETextureView4 = viETextureView2;
                // ** MonitorExit[v1] (shouldn't be in output)
                Log.i((String)"AGORA_SDK", (String)("Surface changed to width " + n2 + " height " + n3));
                viETextureView4.nativeFunctionLock.lock();
                if (viETextureView3.nativeFunctionsRegisted) {
                    ViETextureView viETextureView5 = this;
                    if (viETextureView5.CreateOpenGLNative(viETextureView5.nativeObject, n2, n3) == 0) {
                        this.openGLCreated = true;
                    }
                }
                this.nativeFunctionLock.unlock();
                return;
                {
                    catch (Throwable throwable2) {
                        break block10;
                    }
                    catch (Exception exception) {}
                    {
                        Logging.w("AGORA_SDK", "Exception occurs when create RtcEngine");
                        this.nativeFunctionLock.unlock();
                    }
                }
                return;
            }
            this.nativeFunctionLock.unlock();
            throw throwable2;
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        ViETextureView viETextureView = this;
        super.onConfigurationChanged(configuration);
        viETextureView.updateOrientation();
    }

    @Override
    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
    }

    @Override
    public void onSurfaceDestroyed(GL10 gL10) {
    }

    public void RegisterNativeObject(long l2) {
        this.nativeFunctionLock.lock();
        this.nativeObject = l2;
        this.nativeFunctionsRegisted = true;
        this.nativeFunctionLock.unlock();
    }

    public void DeRegisterNativeObject() {
        ViETextureView viETextureView = this;
        viETextureView.nativeFunctionLock.lock();
        viETextureView.nativeFunctionsRegisted = false;
        viETextureView.openGLCreated = false;
        viETextureView.nativeObject = 0L;
        viETextureView.nativeFunctionLock.unlock();
        viETextureView.releaseOpenGLResource();
    }

    @Override
    public void ReDraw() {
        if (this.surfaceCreated) {
            this.requestRender();
        }
    }

    @Override
    public int GetAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    public void UpdateOpenGLResource(int[] nArray) {
        this.nativeGLPragram = nArray[0];
        int n2 = 0;
        while (n2 < 3) {
            this.nativeGLTextureId[n2++] = nArray[n2];
        }
        ViETextureView viETextureView = this;
        viETextureView.nativeOesGLProgram = nArray[4];
        viETextureView.nativeGLResourceUpdated = true;
        Logging.i(TAG, "UpdateOpenGLResource, program = " + nArray[0] + " texture[0~2] = " + nArray[1] + " ," + nArray[2] + " ," + nArray[3]);
    }

    @Override
    public void surfaceDestroyed(SurfaceTexture surfaceTexture) {
        Runnable runnable;
        ViETextureView viETextureView = this;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ViETextureView viETextureView = ViETextureView.this;
                1 v0 = this;
                synchronized (viETextureView) {
                    ViETextureView.access$102(v0.ViETextureView.this, false);
                    v0.ViETextureView.this.textureRendererHelper.releaseSurfaceTexture();
                    return;
                }
            }
        };
        viETextureView.queueEvent(runnable2);
        super.surfaceDestroyed(surfaceTexture);
    }

    public void releaseOpenGLResource() {
        Runnable runnable;
        if (!this.nativeGLResourceUpdated) {
            return;
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                int n2;
                Logging.i(TAG, "releaseOpenGLResource, value = " + ViETextureView.this.nativeGLPragram + " ," + ViETextureView.this.nativeGLTextureId[0] + " ," + ViETextureView.this.nativeGLTextureId[1] + " ," + ViETextureView.this.nativeGLTextureId[2] + ", " + ViETextureView.this.nativeOesGLProgram);
                if (ViETextureView.this.nativeGLPragram > 0) {
                    GLES20.glDeleteProgram((int)ViETextureView.this.nativeGLPragram);
                }
                if (ViETextureView.this.nativeGLTextureId[0] > 0) {
                    GLES20.glDeleteTextures((int)3, (int[])ViETextureView.this.nativeGLTextureId, (int)0);
                }
                if (ViETextureView.this.nativeOesGLProgram > 0) {
                    GLES20.glDeleteProgram((int)ViETextureView.this.nativeOesGLProgram);
                }
                if ((n2 = GLES20.glGetError()) != 0) {
                    Logging.e(TAG, "glDelete error: " + n2);
                }
            }
        };
        this.queueEvent(runnable2);
        this.nativeGLResourceUpdated = false;
    }

    public void reDrawNativeI420() {
        ViETextureView viETextureView = this;
        viETextureView.textureRendererHelper.setTextureSourceIncoming(false);
        viETextureView.ReDraw();
    }

    public void reDrawJavaI420(VideoFrame.I420Buffer i420Buffer, int n2, long l2) {
        this.textureRendererHelper.setTextureSourceIncoming(false);
        AgoraVideoDebugger.onI420Buffer(i420Buffer, n2, l2);
        this.ReDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverVideoTextureFrame(VideoFrame.TextureBuffer textureBuffer, int n2, long l2, long l3, boolean bl) {
        ViETextureView viETextureView = this;
        viETextureView.textureRendererHelper.setTextureSourceIncoming(true);
        synchronized (viETextureView) {
            viETextureView.textureRendererHelper.onTextureFrameArrived(textureBuffer, n2, l2, l3, bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textureRenderThreadWillExit() {
        ViETextureView viETextureView = this;
        synchronized (viETextureView) {
            Logging.i(TAG, "texture render thread will exit");
            viETextureView.textureRendererHelper.releaseProducerResourceIfNotYet();
            return;
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.textureRendererHelper.isTextureSourceIncoming()) {
            this.textureRendererHelper.onFrameAvailable(this);
        }
    }

    private static class ConfigChooser
    implements GLTextureView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            this.mRedSize = n2;
            this.mGreenSize = n3;
            this.mBlueSize = n4;
            this.mAlphaSize = n5;
            this.mDepthSize = n6;
            this.mStencilSize = n7;
        }

        private int findConfigAttrib(EGL10 object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (object.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, (int[])(object = (Object)this.mValue))) {
                return this.mValue[0];
            }
            return n3;
        }

        private void printConfigs(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            int n2 = eGLConfigArray.length;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            Logging.w(TAG, String.format("%d configurations", objectArray2));
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = i2;
                Logging.w(TAG, String.format("Configuration %d:\n", objectArray4));
                this.printConfig(eGL10, eGLDisplay, eGLConfigArray[i2]);
            }
        }

        private void printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int n2 = 33;
            int[] nArray = new int[33];
            int[] nArray2 = nArray;
            nArray[0] = 12320;
            nArray[1] = 12321;
            nArray[2] = 12322;
            nArray[3] = 12323;
            nArray[4] = 12324;
            nArray[5] = 12325;
            nArray[6] = 12326;
            nArray[7] = 12327;
            nArray[8] = 12328;
            nArray[9] = 12329;
            nArray[10] = 12330;
            nArray[11] = 12331;
            nArray[12] = 12332;
            nArray[13] = 12333;
            nArray[14] = 12334;
            nArray[15] = 12335;
            nArray[16] = 12336;
            nArray[17] = 12337;
            nArray[18] = 12338;
            nArray[19] = 12339;
            nArray[20] = 12340;
            nArray[21] = 12343;
            nArray[22] = 12342;
            nArray[23] = 12341;
            nArray[24] = 12345;
            nArray[25] = 12346;
            nArray[26] = 12347;
            nArray[27] = 12348;
            nArray[28] = 12349;
            nArray[29] = 12350;
            nArray[30] = 12351;
            nArray[31] = 12352;
            nArray[32] = 12354;
            String[] stringArray = new String[33];
            String[] stringArray2 = stringArray;
            stringArray[0] = "EGL_BUFFER_SIZE";
            stringArray[1] = "EGL_ALPHA_SIZE";
            stringArray[2] = "EGL_BLUE_SIZE";
            stringArray[3] = "EGL_GREEN_SIZE";
            stringArray[4] = "EGL_RED_SIZE";
            stringArray[5] = "EGL_DEPTH_SIZE";
            stringArray[6] = "EGL_STENCIL_SIZE";
            stringArray[7] = "EGL_CONFIG_CAVEAT";
            stringArray[8] = "EGL_CONFIG_ID";
            stringArray[9] = "EGL_LEVEL";
            stringArray[10] = "EGL_MAX_PBUFFER_HEIGHT";
            stringArray[11] = "EGL_MAX_PBUFFER_PIXELS";
            stringArray[12] = "EGL_MAX_PBUFFER_WIDTH";
            stringArray[13] = "EGL_NATIVE_RENDERABLE";
            stringArray[14] = "EGL_NATIVE_VISUAL_ID";
            stringArray[15] = "EGL_NATIVE_VISUAL_TYPE";
            stringArray[16] = "EGL_PRESERVED_RESOURCES";
            stringArray[17] = "EGL_SAMPLES";
            stringArray[18] = "EGL_SAMPLE_BUFFERS";
            stringArray[19] = "EGL_SURFACE_TYPE";
            stringArray[20] = "EGL_TRANSPARENT_TYPE";
            stringArray[21] = "EGL_TRANSPARENT_RED_VALUE";
            stringArray[22] = "EGL_TRANSPARENT_GREEN_VALUE";
            stringArray[23] = "EGL_TRANSPARENT_BLUE_VALUE";
            stringArray[24] = "EGL_BIND_TO_TEXTURE_RGB";
            stringArray[25] = "EGL_BIND_TO_TEXTURE_RGBA";
            stringArray[26] = "EGL_MIN_SWAP_INTERVAL";
            stringArray[27] = "EGL_MAX_SWAP_INTERVAL";
            stringArray[28] = "EGL_LUMINANCE_SIZE";
            stringArray[29] = "EGL_ALPHA_MASK_SIZE";
            stringArray[30] = "EGL_COLOR_BUFFER_TYPE";
            stringArray[31] = "EGL_RENDERABLE_TYPE";
            stringArray[32] = "EGL_CONFORMANT";
            int[] nArray3 = new int[1];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray2[i2];
                String string2 = stringArray2[i2];
                if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n3, nArray3)) {
                    Object[] objectArray = new Object[2];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = string2;
                    objectArray[1] = nArray3[0];
                    Logging.w(TAG, String.format("  %s: %d\n", objectArray2));
                    continue;
                }
                while (eGL10.eglGetError() != 12288) {
                }
            }
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, null, 0, nArray);
            int n2 = nArray[0];
            if (n2 <= 0) {
                Logging.w(TAG, "no configurations found");
                return null;
            }
            EGLConfig[] eGLConfigArray = eGLConfigArray2;
            EGLConfig[] eGLConfigArray2 = new EGLConfig[n2];
            eGL10.eglChooseConfig(eGLDisplay, s_configAttribs2, eGLConfigArray2, n2, nArray);
            return eGLConfigArray.chooseConfig(eGL10, eGLDisplay, eGLConfigArray2);
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                ConfigChooser configChooser = this;
                int n2 = configChooser.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0) < configChooser.mDepthSize || n2 < this.mStencilSize) continue;
                ConfigChooser configChooser2 = this;
                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n4 = configChooser2.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0) != configChooser2.mRedSize || n2 != this.mGreenSize || n3 != this.mBlueSize || n4 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }
}

