/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.RectF;
import android.os.Build;
import android.view.WindowManager;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.ATrace;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public abstract class VideoCapture {
    private static final String TAG = "VideoCapture";
    private static final int kVideoI420 = 0;
    private static final int kVideoYV12 = 1;
    private static final int kVideoYUY2 = 2;
    private static final int kVideoNV12 = 11;
    private static final int kVideoNV21 = 12;
    private static final int kVideoUnknown = 99;
    protected static final int MAX_BUFFER_CNT = 8;
    public static final int kCaptureFpsUnknown = -1;
    public static final int kCaptureFpsDefault = 0;
    public static final int kCaptureFpsLowPower = 1;
    public static boolean FORCE_TEXTURE_OES = false;
    protected int mCameraNativeOrientation;
    protected final Context mContext;
    protected final int mId;
    protected long mNativeVideoCaptureDeviceAndroid;
    @CaptureOutputDataType
    protected int mCaptureOutputDataType = 0;
    protected int mExpectedRawBufferSize = 0;
    protected final EglBase.Context mShareContext;
    protected EglBase.Context mEglContext;
    protected SurfaceTextureHelper mSurfaceTextureHelper;
    protected TextureAndRawBufferSynchronizer mTextureAndRawBufferSynchronizer = null;
    protected int mDroppedTextureBufferCount = 0;
    private int mLastRotation = -1;
    protected int mPQFirst = -1;

    VideoCapture(Context context, int n2, int n3, EglBase.Context context2, long l2) {
        this.mNativeVideoCaptureDeviceAndroid = l2;
        this.mContext = context;
        this.mId = n2;
        this.mPQFirst = n3;
        this.mShareContext = context2;
    }

    public static native int ConvertFrameToI420(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7, byte[] var8);

    private native void ProvideCameraTexture(VideoFrame.TextureBuffer var1, int var2, long var3, long var5);

    private native void ProvideCameraTextureAndRaw(VideoFrame.TextureBuffer var1, int var2, long var3, byte[] var5, int var6, long var7);

    public static String fetchCapability(int n2, Context context, String string2) {
        String string3 = (context = context.getSharedPreferences("CamCaps2", 0)).getString("CaptureName", null);
        if (string3 != null && string3.equals(string2)) {
            return context.getString("Cam_" + n2, null);
        }
        SharedPreferences.Editor editor = context.edit();
        editor.clear();
        editor.commit();
        return null;
    }

    public static void clearCapabilityCache(Context context) {
        context.getSharedPreferences("CamCaps2", 0).edit().clear().commit();
    }

    public static void cacheCapability(int n2, Context context, String string2, String string3) {
        SharedPreferences.Editor editor = context.getSharedPreferences("CamCaps2", 0).edit();
        editor.putString("Cam_" + n2, string2);
        editor.putString("CaptureName", string3);
        editor.commit();
    }

    public static int translateToEngineFormat(int n2) {
        if (n2 != 17) {
            if (n2 != 20) {
                if (n2 != 35) {
                    if (n2 != 842094169) {
                        return 99;
                    }
                    return 1;
                }
                return 0;
            }
            return 2;
        }
        return 12;
    }

    public static int translateToAndroidFormat(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 12) {
                        return 0;
                    }
                    return 17;
                }
                return 20;
            }
            return 842094169;
        }
        return 35;
    }

    @CaptureOutputDataType
    public static int translateToCaptureOutputDataType(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isEmulator() {
        if ("nokia".equalsIgnoreCase(Build.MANUFACTURER) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
            return false;
        }
        var0 = Build.FINGERPRINT;
        if (Build.FINGERPRINT != null && (var0.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys"))) {
            return true;
        }
        var0 = Build.MODEL;
        if (var0 != null && (var0.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MODEL.equalsIgnoreCase("MuMu"))) {
            return true;
        }
        var0 = Build.MANUFACTURER;
        if (var0 != null && var0.contains("Genymotion")) {
            return true;
        }
        var0 = Build.BRAND;
        if (var0 != null && var0.startsWith("generic") && (var0 = Build.DEVICE) != null && var0.startsWith("generic")) {
            return true;
        }
        if ("google_sdk".equalsIgnoreCase(Build.PRODUCT)) {
            return true;
        }
        v0 = new String[2];
        var0 = v0;
        v0[0] = "/system/bin/cat";
        v0[1] = "/proc/cpuinfo";
        var0 = new ProcessBuilder((String[])var0).start();
        var1_1 = v1;
        v1 = new StringBuffer();
        var2_2 = v2;
        v2 = new BufferedReader(new InputStreamReader(var0.getInputStream(), "utf-8"));
        ** while ((var0 = var2_2.readLine()) != null)
lbl-1000:
        // 1 sources

        {
            var1_1.append((String)var0);
            continue;
        }
lbl35:
        // 1 sources

        try {
            var2_2.close();
            var0 = var1_1.toString().toLowerCase();
            return var0.contains("intel") || var0.contains("amd");
            {
            }
        }
        catch (Exception v3) {
            return false;
        }
        catch (IOException v4) {
            return false;
        }
    }

    public static boolean checkVideoPermission(Context context) {
        return context != null && context.checkCallingOrSelfPermission("android.permission.CAMERA") == 0;
        {
        }
    }

    public abstract int allocate();

    public abstract int setCaptureFormat(int var1, int var2, boolean var3);

    public abstract int startCapture(int var1, int var2, int var3);

    public abstract int stopCapture();

    public abstract boolean isTorchSupported();

    public abstract boolean isFocusSupported();

    public abstract boolean isZoomSupported();

    public abstract boolean isAutoFaceFocusSupported();

    public abstract int setZoom(float var1);

    public abstract float getMaxZoom();

    public abstract int setTorchMode(boolean var1);

    public abstract int setFocus(float var1, float var2, boolean var3);

    public abstract int setAutoFaceFocus(boolean var1);

    public abstract int setFaceDetection(boolean var1);

    public abstract boolean isExposureSupported();

    public abstract int setExposure(float var1, float var2, boolean var3);

    public abstract int setAntiBandingMode(int var1);

    public abstract int setExposureCompensation(int var1);

    public abstract int setNoiseReductionMode(int var1);

    public abstract int setEdgeEnhanceMode(int var1);

    public abstract int setVideoStabilityMode(int var1);

    public abstract int UnRegisterNativeHandle();

    public abstract void deallocate();

    public native void ProvideCameraFrame(byte[] var1, int var2, long var3);

    public native boolean isAutoFaceFocusEnabled(long var1);

    public native boolean isFaceDetectionEnabled(long var1);

    public native void NotifyCameraFocusAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyCameraExposureAreaChanged(float var1, float var2, float var3, float var4, long var5);

    public native void NotifyFaceDetection(int var1, int var2, RectF[] var3, long var4, long var6);

    public native void onCameraError(long var1, String var3);

    protected int checkOrientation() {
        Context context = this.mContext;
        if (context != null && context.getSystemService("window") != null && (context = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay()) != null) {
            try {
                return context.getRotation();
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "video capture checkOrientation display getRotation throwout exception");
                return this.mLastRotation;
            }
        }
        return this.mLastRotation;
    }

    protected void onRawBufferAvailable(byte[] byArray, int n2, int n3, int n4, int n5) {
        VideoCapture videoCapture = this;
        AgoraVideoDebugger.onRawBufferAvailable(videoCapture, byArray, n2, n3, n4, n5);
        n3 = videoCapture.mCaptureOutputDataType;
        if (n3 == 0) {
            VideoCapture videoCapture2 = this;
            long l2 = videoCapture2.mNativeVideoCaptureDeviceAndroid;
            videoCapture2.ProvideCameraFrame(byArray, n2, l2);
        } else if (n3 == 2) {
            this.mTextureAndRawBufferSynchronizer.onRawBufferAvailable(byArray, n2);
        }
    }

    protected void onTextureBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
        VideoFrame.TextureBuffer textureBuffer2 = null;
        SurfaceTextureHelper surfaceTextureHelper = this.mSurfaceTextureHelper;
        if (surfaceTextureHelper != null) {
            textureBuffer2 = FORCE_TEXTURE_OES ? textureBuffer : surfaceTextureHelper.textureCopy(textureBuffer);
        }
        if (textureBuffer2 == null) {
            if (++this.mDroppedTextureBufferCount % 50 == 1) {
                Logging.w(TAG, "Dropped texture buffer count: " + this.mDroppedTextureBufferCount);
            }
            if (this.mCaptureOutputDataType == 2) {
                this.mTextureAndRawBufferSynchronizer.onDropTextureBuffer(l2);
            }
            AgoraVideoDebugger.onDropTextureBuffer(l2);
            return;
        }
        VideoCapture videoCapture = this;
        ATrace.beginSection("onTextureBufferAvailable");
        AgoraVideoDebugger.onTextureBufferAvailable(videoCapture, videoCapture.mEglContext, textureBuffer2, n2, l2);
        int n3 = videoCapture.mCaptureOutputDataType;
        if (n3 == 1) {
            VideoCapture videoCapture2 = this;
            long l3 = videoCapture2.mNativeVideoCaptureDeviceAndroid;
            videoCapture2.ProvideCameraTexture(textureBuffer2, n2, l2, l3);
        } else if (n3 == 2) {
            this.mTextureAndRawBufferSynchronizer.onTextureBufferAvailable(textureBuffer2, n2, l2);
        }
        ATrace.endSection();
        textureBuffer2.release();
    }

    protected void onTextureAndRawBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n2, long l2, byte[] byArray, int n3) {
        VideoCapture videoCapture = this;
        AgoraVideoDebugger.onTextureAndRawBufferAvailable(videoCapture, textureBuffer, n2, l2, byArray, n3);
        long l3 = videoCapture.mNativeVideoCaptureDeviceAndroid;
        videoCapture.ProvideCameraTextureAndRaw(textureBuffer, n2, l2, byArray, n3, l3);
    }

    protected static class TexBuffer {
        VideoFrame.TextureBuffer textureBuffer;
        int rotation;
        long timestampNs;

        TexBuffer(VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
            this.textureBuffer = textureBuffer;
            this.rotation = n2;
            this.timestampNs = l2;
        }
    }

    protected static class RawBuffer {
        byte[] data;
        int length;

        RawBuffer(byte[] byArray, int n2) {
            this.data = byArray;
            this.length = n2;
        }
    }

    protected class TextureAndRawBufferSynchronizer {
        Queue<RawBuffer> rawBufferQueue;
        Queue<TexBuffer> texBufferQueue;
        int pendingRemoveRawBufferCount;

        protected TextureAndRawBufferSynchronizer() {
            LinkedList linkedList;
            LinkedList linkedList2;
            Object object = linkedList2;
            linkedList2 = new LinkedList();
            v1.rawBufferQueue = object;
            object = linkedList;
            linkedList = new LinkedList();
            v1.texBufferQueue = object;
            v1.pendingRemoveRawBufferCount = 0;
        }

        private void checkAndResetIfNeeded() {
            if (this.texBufferQueue.size() > 16 || this.rawBufferQueue.size() > 16) {
                String string2 = this.texBufferQueue.size() > 16 ? "raw" : "texture";
                Logging.e(TAG, string2 + " buffer stall, something is broken!");
                this.reset();
            }
        }

        void onRawBufferAvailable(byte[] byArray, int n2) {
            TextureAndRawBufferSynchronizer textureAndRawBufferSynchronizer = textureBuffer;
            textureAndRawBufferSynchronizer.checkAndResetIfNeeded();
            int n3 = textureAndRawBufferSynchronizer.pendingRemoveRawBufferCount;
            if (n3 > 0) {
                ((TextureAndRawBufferSynchronizer)((Object)textureBuffer)).pendingRemoveRawBufferCount = n3 - 1;
                return;
            }
            TexBuffer texBuffer = ((TextureAndRawBufferSynchronizer)((Object)textureBuffer)).texBufferQueue.poll();
            if (texBuffer != null) {
                TexBuffer texBuffer2 = texBuffer;
                VideoFrame.TextureBuffer textureBuffer = texBuffer2.textureBuffer;
                int n4 = texBuffer2.rotation;
                long l2 = texBuffer2.timestampNs;
                ((TextureAndRawBufferSynchronizer)((Object)textureBuffer)).VideoCapture.this.onTextureAndRawBufferAvailable(textureBuffer, n4, l2, byArray, n2);
                texBuffer.textureBuffer.release();
            } else {
                ((TextureAndRawBufferSynchronizer)((Object)textureBuffer)).rawBufferQueue.offer(new RawBuffer(Arrays.copyOf(byArray, n2), n2));
            }
        }

        void onTextureBufferAvailable(VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
            TextureAndRawBufferSynchronizer textureAndRawBufferSynchronizer = object;
            textureAndRawBufferSynchronizer.checkAndResetIfNeeded();
            RawBuffer rawBuffer = textureAndRawBufferSynchronizer.rawBufferQueue.poll();
            if (rawBuffer != null) {
                RawBuffer rawBuffer2 = rawBuffer;
                Object object = rawBuffer2.data;
                int n3 = rawBuffer2.length;
                ((TextureAndRawBufferSynchronizer)object).VideoCapture.this.onTextureAndRawBufferAvailable(textureBuffer, n2, l2, (byte[])object, n3);
            } else {
                textureBuffer.retain();
                ((TextureAndRawBufferSynchronizer)object).texBufferQueue.offer(new TexBuffer(textureBuffer, n2, l2));
            }
        }

        void onDropTextureBuffer(long l2) {
            if (this.rawBufferQueue.poll() == null) {
                ++this.pendingRemoveRawBufferCount;
            }
        }

        void reset() {
            TextureAndRawBufferSynchronizer textureAndRawBufferSynchronizer = this;
            Logging.i(TAG, "TextureAndRawBufferSynchronizer reset");
            textureAndRawBufferSynchronizer.rawBufferQueue.clear();
            Iterator iterator = textureAndRawBufferSynchronizer.texBufferQueue.iterator();
            while (iterator.hasNext()) {
                ((TexBuffer)iterator.next()).textureBuffer.release();
            }
            this.texBufferQueue.clear();
            this.pendingRemoveRawBufferCount = 0;
        }
    }

    static @interface CaptureOutputDataType {
        public static final int CAPTURE_OUTPUT_RAW = 0;
        public static final int CAPTURE_OUTPUT_TEXTURE = 1;
        public static final int CAPTURE_OUTPUT_TEXTURE_AND_RAW = 2;
    }
}

