/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.utils.ThreadUtils;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class VideoCaptureCamera
extends VideoCapture
implements Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "CAMERA1";
    private static final boolean VERBOSE = false;
    private static final int CAMERA_ALLOCATE_TIMEOUT_MS = 6000;
    private static final long CAMERA_OPEN_REQUEST_INTERVAL = 2000L;
    private static final int NUM_OF_CAPTURE_BUFFERS = 3;
    protected Camera mCamera;
    protected ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private ReentrantLock mCaptureLock = new ReentrantLock();
    private boolean isCaptureStarted = false;
    private boolean isCaptureRunning = false;
    private boolean isSurfaceReady = false;
    private boolean isFaceDetectionStarted = false;
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 17;
    private HandlerThread mCameraRecoverHandlerThread = null;
    private Handler mHandler = null;
    private Object mRecoverThreadObjectLock = new Object();
    private HandlerThread mCameraPreviewHandlerThread = null;
    private Handler mPreviewHandler = null;
    private volatile int mAllocated;
    private Object mObjectLock = new Object();
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDetectEnabled = false;
    private String mAntiBandingMode = "auto";
    private final boolean mIsCameraFacingFront;
    private SurfaceTexture mDummySurfaceTexture = null;

    VideoCaptureCamera(Context context, int n2, int n3, EglBase.Context context2, long l2) {
        super(context, n2, n3, context2, l2);
        this.mIsCameraFacingFront = VideoCaptureCamera.isCameraFacingFront(n2);
    }

    static boolean isCameraFacingFront(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo != null) {
            return cameraInfo.facing == 1;
        }
        return true;
    }

    protected static Camera.CameraInfo getCameraInfo(int n2) {
        if (n2 >= 0 && n2 <= Camera.getNumberOfCameras() - 1) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
                return cameraInfo;
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: ", runtimeException);
                return null;
            }
        }
        return null;
    }

    public static int getFrontCameraIndex() {
        int n2 = 0;
        try {
            n2 = Camera.getNumberOfCameras() > 1 ? 1 : 0;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
        return n2;
    }

    static int getNumberOfCameras() {
        int n2 = Camera.getNumberOfCameras();
        Logging.e(TAG, "camera1 listCount:" + n2);
        return n2;
    }

    static String getName(int n2) {
        Object object = VideoCaptureCamera.getCameraInfo(n2);
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("camera ").append(n2).append(", facing ");
        object = object.facing == 1 ? "front" : "back";
        return stringBuilder.append((String)object).toString();
    }

    static String getCaptureName() {
        return "camera1";
    }

    static int getSensorOrientation(int n2) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera.getCameraInfo(n2);
        if (cameraInfo == null) {
            return -1;
        }
        return cameraInfo.orientation;
    }

    private int allocate_l() {
        Camera.CameraInfo cameraInfo;
        block4: {
            try {
                VideoCaptureCamera videoCaptureCamera = this;
                videoCaptureCamera.mCamera = Camera.open((int)videoCaptureCamera.mId);
                cameraInfo = VideoCaptureCamera.getCameraInfo(videoCaptureCamera.mId);
                if (cameraInfo != null) break block4;
            }
            catch (RuntimeException runtimeException) {
                Logging.e(TAG, "allocate: Camera.open: ", runtimeException);
                return -1;
            }
            this.mCamera.release();
            this.mCamera = null;
            return -2;
        }
        if (VideoCapture.fetchCapability(this.mId, this.mContext, VideoCaptureCamera.getCaptureName()) == null) {
            this.createCapabilities();
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        long l2 = this.mNativeVideoCaptureDeviceAndroid;
        if (l2 != 0L) {
            this.mIsAutoFaceFocusEnabled = this.isAutoFaceFocusEnabled(l2);
        }
        VideoCaptureCamera videoCaptureCamera = this;
        videoCaptureCamera.faceDetectEnabled = videoCaptureCamera.isFaceDetectionEnabled(videoCaptureCamera.mNativeVideoCaptureDeviceAndroid);
        return 0;
    }

    private int tryStartCapture(int n2, int n3, int n4) {
        if (this.mCamera == null) {
            Logging.e(TAG, "Camera not initialized %d" + this.mId);
            return -1;
        }
        Logging.i(TAG, "tryStartCapture: " + n2 + "*" + n3 + ", frameRate: " + n4 + ", isCaptureRunning: " + this.isCaptureRunning + ", isSurfaceReady: " + this.isSurfaceReady + ", isCaptureStarted: " + this.isCaptureStarted + ", outputDataType: " + this.mCaptureOutputDataType);
        if (!this.isCaptureRunning && this.isCaptureStarted) {
            VideoCaptureCamera videoCaptureCamera = this;
            Camera.Parameters parameters = videoCaptureCamera.mCamera.getParameters();
            parameters.setPreviewSize(n2, n3);
            parameters.setPreviewFormat(this.mCaptureFormat);
            if (videoCaptureCamera.mPQFirst < 1) {
                Logging.i(TAG, "camera1::fps first");
                List list = parameters.getSupportedPreviewFpsRange();
                if (list.size() <= 0) {
                    parameters.setPreviewFrameRate(n4);
                } else {
                    int n5;
                    for (n5 = 0; n5 < list.size(); ++n5) {
                        if (((int[])list.get(n5))[0] < n4 * 1000) continue;
                        n4 = ((int[])list.get(n5))[0];
                        parameters.setPreviewFpsRange(n4, ((int[])list.get(n5))[1]);
                        break;
                    }
                    if (n5 == list.size()) {
                        List list2 = list;
                        n4 = n5 - 1;
                        int n6 = ((int[])list2.get(n4))[0];
                        parameters.setPreviewFpsRange(n6, ((int[])list2.get(n4))[1]);
                    }
                }
            } else {
                Logging.i(TAG, "camera1::PQ first");
                parameters.setPreviewFrameRate(n4);
            }
            VideoCaptureCamera videoCaptureCamera2 = this;
            this.setAdvancedCameraParameters(parameters);
            videoCaptureCamera2.setDeviceSpecificParameters(parameters);
            videoCaptureCamera2.mCamera.setParameters(parameters);
            n4 = 0;
            int n7 = videoCaptureCamera2.mCaptureOutputDataType;
            if (n7 == 0 || n7 == 2) {
                n4 = n2 * n3 * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8 + 4096;
                for (n2 = 0; n2 < 3; ++n2) {
                    byte[] byArray = new byte[n4];
                    this.mCamera.addCallbackBuffer(byArray);
                }
                this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            }
            VideoCaptureCamera videoCaptureCamera3 = this;
            videoCaptureCamera3.mCamera.setErrorCallback(new Camera.ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void onError(int n2, Camera camera) {
                    block15: {
                        block14: {
                            Object object;
                            block13: {
                                Logging.e(VideoCaptureCamera.TAG, "onError: error code" + n2);
                                if (n2 != 2 && n2 != 100) {
                                    if (n2 != 1) return;
                                }
                                object = VideoCaptureCamera.this;
                                if (((VideoCaptureCamera)object).mCamera != null) {
                                    Throwable throwable2;
                                    2 v0 = this;
                                    ((VideoCaptureCamera)object).stopCapture();
                                    v0.VideoCaptureCamera.this.mCaptureLock.lock();
                                    if (v0.VideoCaptureCamera.this.mCamera != null) {
                                        VideoCaptureCamera.this.mCamera.release();
                                        VideoCaptureCamera.this.mCamera = null;
                                    }
                                    VideoCaptureCamera.this.mCaptureLock.unlock();
                                    break block13;
                                    {
                                        catch (Throwable throwable2) {
                                        }
                                        catch (Exception exception) {}
                                        {
                                            Logging.e(VideoCaptureCamera.TAG, "Camera release failed, " + exception);
                                            VideoCaptureCamera.this.mCaptureLock.unlock();
                                            break block13;
                                        }
                                    }
                                    VideoCaptureCamera.this.mCaptureLock.unlock();
                                    throw throwable2;
                                }
                            }
                            2 v2 = this;
                            object = v2.VideoCaptureCamera.this.mRecoverThreadObjectLock;
                            // MONITORENTER : object
                            if (v2.VideoCaptureCamera.this.mCameraRecoverHandlerThread != null) break block14;
                            2 v3 = this;
                            2 v4 = v3;
                            2 v5 = v3;
                            VideoCaptureCamera.access$402(v3.VideoCaptureCamera.this, new HandlerThread("camera-recover-thread"));
                            v5.VideoCaptureCamera.this.mCameraRecoverHandlerThread.start();
                            if (v4.VideoCaptureCamera.this.mCameraRecoverHandlerThread == null) break block14;
                            VideoCaptureCamera.access$502(VideoCaptureCamera.this, new Handler(VideoCaptureCamera.this.mCameraRecoverHandlerThread.getLooper()));
                        }
                        if (VideoCaptureCamera.this.mHandler == null) break block15;
                        VideoCaptureCamera.this.mHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            @Override
                            public void run() {
                                v0 = this;
                                var1_2 = VideoCaptureCamera.access$300(VideoCaptureCamera.this);
                                synchronized (var1_2) {
                                    block11: {
                                        Logging.i("CAMERA1", "native handle = " + VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid);
                                        if (!VideoCaptureCamera.access$600(VideoCaptureCamera.this)) ** GOTO lbl31
                                        if (VideoCaptureCamera.this.mCamera != null) ** GOTO lbl31
                                        if (VideoCaptureCamera.this.mNativeVideoCaptureDeviceAndroid == 0L) ** GOTO lbl31
                                        v2 = var1_2;
                                        v3 = this;
                                        v4 = v3;
                                        VideoCaptureCamera.this.allocate();
                                        v5 = VideoCaptureCamera.this;
                                        v6 = VideoCaptureCamera.access$700(VideoCaptureCamera.this);
                                        v7 = this;
                                        v8 = v7;
                                        var0_1 = VideoCaptureCamera.access$800(VideoCaptureCamera.this);
                                        v5.startCapture(v6, var0_1, VideoCaptureCamera.access$900(VideoCaptureCamera.this));
                                        // ** MonitorExit[v2] (shouldn't be in output)
                                        return;
lbl31:
                                        // 3 sources

                                        if (VideoCaptureCamera.access$500(VideoCaptureCamera.this) == null) break block11;
                                        VideoCaptureCamera.access$500(VideoCaptureCamera.this).postDelayed((Runnable)this, 2000L);
                                    }
                                    return;
                                }
                            }
                        }, 2000L);
                    }
                    // MONITOREXIT : object
                }
            });
            videoCaptureCamera3.mCamera.startPreview();
            if (videoCaptureCamera3.isAutoFaceFocusSupported()) {
                VideoCaptureCamera videoCaptureCamera4 = this;
                videoCaptureCamera4.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){
                    private long mLastFocusedTs;

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                        ArrayList<Camera.Area> arrayList;
                        Camera camera2;
                        if (VideoCaptureCamera.this.faceDetectEnabled) {
                            VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                        }
                        if (faceArray == null) return;
                        if (faceArray.length == 0) return;
                        if (camera == null) return;
                        if (!VideoCaptureCamera.this.mIsAutoFaceFocusEnabled) {
                            return;
                        }
                        if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                            if (faceArray[0].score <= 20) return;
                            VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                            return;
                        }
                        if (faceArray[0].score <= 50) {
                            Logging.i(VideoCaptureCamera.TAG, "face score = " + faceArray[0].score);
                            return;
                        }
                        try {
                            camera2 = camera;
                        }
                        catch (RuntimeException runtimeException) {
                            Logging.w(VideoCaptureCamera.TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)runtimeException));
                            return;
                        }
                        ArrayList<Camera.Area> arrayList2 = arrayList;
                        {
                            new ArrayList<Camera.Area>().add(new Camera.Area(faceArray[0].rect, 1000));
                        }
                        {
                            if (camera2.getParameters().getMaxNumFocusAreas() > 0) {
                                camera.getParameters().setFocusAreas(arrayList2);
                            }
                            if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                                camera.getParameters().setMeteringAreas(arrayList2);
                            }
                            VideoCaptureCamera.this.notifyCameraFocusAreaChanged(faceArray[0].rect);
                            camera.autoFocus(new Camera.AutoFocusCallback(){

                                public void onAutoFocus(boolean bl, Camera camera) {
                                    Logging.d(VideoCaptureCamera.TAG, "auto face focus called api1 every 3 seconds");
                                    if (camera != null) {
                                        try {
                                            camera.cancelAutoFocus();
                                        }
                                        catch (RuntimeException runtimeException) {
                                            Logging.w(VideoCaptureCamera.TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)runtimeException));
                                        }
                                    }
                                }
                            });
                            this.mLastFocusedTs = System.currentTimeMillis();
                            return;
                        }
                    }
                });
                if (videoCaptureCamera4.mIsAutoFaceFocusEnabled || this.faceDetectEnabled) {
                    this.startFaceDetection();
                }
            } else if (this.isFaceDetectedSupported()) {
                VideoCaptureCamera videoCaptureCamera5 = this;
                videoCaptureCamera5.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

                    public void onFaceDetection(Camera.Face[] faceArray, Camera camera) {
                        if (VideoCaptureCamera.this.faceDetectEnabled) {
                            VideoCaptureCamera.this.notifyFaceDetection(faceArray);
                        }
                    }
                });
                if (videoCaptureCamera5.faceDetectEnabled) {
                    this.startFaceDetection();
                }
            }
            VideoCaptureCamera videoCaptureCamera6 = this;
            this.mPreviewBufferLock.lock();
            videoCaptureCamera6.mExpectedRawBufferSize = n4;
            videoCaptureCamera6.isCaptureRunning = true;
            videoCaptureCamera6.mPreviewBufferLock.unlock();
            Logging.i(TAG, "Params: " + videoCaptureCamera6.mCamera.getParameters().flatten());
            return 0;
        }
        Logging.w(TAG, "tryStartCapture return");
        return 0;
    }

    private void startFaceDetection() {
        Object object = this.mPreviewHandler;
        if (object != null) {
            Runnable runnable;
            Handler handler = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.startFaceDetection_l();
                }
            };
            ThreadUtils.invokeAtFrontUninterruptibly(handler, (Runnable)object);
        }
    }

    private void startFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        try {
            Logging.i(TAG, "enable face detection");
            this.mCamera.startFaceDetection();
            this.isFaceDetectionStarted = true;
        }
        catch (Exception exception) {
            Logging.e(TAG, "start face detection failed:" + exception);
            this.mCamera.stopFaceDetection();
            this.isFaceDetectionStarted = false;
        }
    }

    private void stopFaceDetection() {
        Object object = this.mPreviewHandler;
        if (object != null) {
            Runnable runnable;
            Handler handler = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.stopFaceDetection_l();
                }
            };
            ThreadUtils.invokeAtFrontUninterruptibly(handler, (Runnable)object);
        }
    }

    private void stopFaceDetection_l() {
        if (this.mCamera == null) {
            return;
        }
        Logging.i(TAG, "disable face detection");
        this.mCamera.stopFaceDetection();
        this.isFaceDetectionStarted = false;
    }

    private void notifyCameraFocusAreaChanged(Rect rect) {
        boolean bl = false;
        if (videoCaptureCamera2.mId == 1) {
            bl = true;
        }
        VideoCaptureCamera videoCaptureCamera = videoCaptureCamera2;
        VideoCaptureCamera videoCaptureCamera2 = CoordinatesTransform.normalizedFaceRect(rect, 0, bl);
        float f2 = ((RectF)videoCaptureCamera2).left;
        float f3 = ((RectF)videoCaptureCamera2).top;
        float f4 = videoCaptureCamera2.width();
        float f5 = videoCaptureCamera2.height();
        Logging.d(TAG, "auto face focus left =" + ((RectF)videoCaptureCamera2).left + " top = " + ((RectF)videoCaptureCamera2).top + " right = " + ((RectF)videoCaptureCamera2).right + " bottom = " + ((RectF)videoCaptureCamera2).bottom);
        long l2 = videoCaptureCamera.mNativeVideoCaptureDeviceAndroid;
        videoCaptureCamera.NotifyCameraFocusAreaChanged(f2, f3, f4, f5, l2);
    }

    private void notifyFaceDetection(Camera.Face[] faceArray) {
        this.rectArray = null;
        int n2 = 0;
        boolean bl = false;
        if (this.mId == 1) {
            bl = true;
        }
        if (faceArray != null && faceArray.length > 0) {
            VideoCaptureCamera videoCaptureCamera = this;
            n2 = faceArray.length;
            videoCaptureCamera.rectArray = new RectF[n2];
            videoCaptureCamera.distanceArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                VideoCaptureCamera videoCaptureCamera2 = this;
                videoCaptureCamera2.rectArray[i2] = CoordinatesTransform.normalizedFaceRect(faceArray[i2].rect, 0, bl);
                videoCaptureCamera2.distanceArray[i2] = 5;
            }
        } else {
            this.rectArray = new RectF[0];
        }
        VideoCaptureCamera videoCaptureCamera = this;
        VideoCaptureCamera videoCaptureCamera3 = this;
        int n3 = videoCaptureCamera3.mCaptureWidth;
        int n4 = videoCaptureCamera3.mCaptureHeight;
        RectF[] rectFArray = videoCaptureCamera3.rectArray;
        long l2 = n2;
        long l3 = videoCaptureCamera.mNativeVideoCaptureDeviceAndroid;
        videoCaptureCamera.NotifyFaceDetection(n3, n4, rectFArray, l2, l3);
    }

    private int setZoom_l(float f2) {
        int n2;
        block9: {
            if (f2 < 0.0f) {
                return -1;
            }
            int n3 = (int)(f2 * 100.0f + 0.5f);
            List<Integer> list = this.getZoomRatios();
            if (list == null) {
                return -1;
            }
            int n4 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                if (n3 > list.get(n2)) {
                    continue;
                }
                break block9;
            }
            n2 = n4;
        }
        if (this.mCamera != null) {
            VideoCaptureCamera videoCaptureCamera = this;
            Camera.Parameters parameters = videoCaptureCamera.getCameraParameters();
            if (videoCaptureCamera.isZoomSupported(parameters)) {
                if (n2 > parameters.getMaxZoom()) {
                    Logging.w(TAG, "zoom value is larger than maxZoom value");
                    return -1;
                }
                parameters.setZoom(n2);
                try {
                    this.mCamera.setParameters(parameters);
                }
                catch (Exception exception) {
                    Logging.w(TAG, "setParameters failed, zoomLevel: " + n2 + ", " + exception);
                }
            }
        }
        return 0;
    }

    private float getMaxZoom_l() {
        if (((VideoCaptureCamera)this).mCamera != null) {
            VideoCaptureCamera videoCaptureCamera = this;
            Camera.Parameters parameters = videoCaptureCamera.getCameraParameters();
            int n2 = 0;
            if (videoCaptureCamera.isZoomSupported(parameters)) {
                n2 = parameters.getMaxZoom();
            }
            if ((this = ((VideoCaptureCamera)this).getZoomRatios()) != null && this.size() > n2) {
                return (float)((Integer)this.get(n2)).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    private int setTorchMode_l(boolean bl) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            List list = parameters.getSupportedFlashModes();
            if (list != null && list.contains("torch")) {
                if (bl) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setFocus_l(float f2, float f3, boolean bl) {
        Logging.d(TAG, "setFocus called camera api1");
        if (this.mCamera == null) {
            return -1;
        }
        if (!(f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f)) {
            Camera.Area area;
            Object object = VideoCaptureCamera.calculateTapArea(f2, f3, 1.0f);
            Object object2 = VideoCaptureCamera.calculateTapArea(f2, f3, 1.5f);
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {
                Logging.w(TAG, "Failed to cancle AutoFocus" + runtimeException);
            }
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters == null) {
                return -1;
            }
            if (parameters.getMaxNumFocusAreas() > 0) {
                Camera.Area area2;
                Camera.Area area3;
                area = area3;
                Camera.Area area4 = area2;
                area2 = new Camera.Area(object, 800);
                new ArrayList().add(area4);
                parameters.setFocusAreas((List)area);
            } else {
                Logging.i(TAG, "focus areas not supported");
            }
            if (parameters.getMaxNumMeteringAreas() > 0) {
                Camera.Area area5;
                ArrayList<Camera.Area> arrayList;
                object = arrayList;
                area = area5;
                area5 = new Camera.Area(object2, 800);
                new ArrayList<Camera.Area>().add(area);
                parameters.setMeteringAreas((List)object);
            } else {
                Logging.i(TAG, "metering areas not supported");
            }
            Camera.Parameters parameters2 = parameters;
            object = parameters2.getFocusMode();
            if (VideoCaptureCamera.isSupported("macro", parameters2.getSupportedFocusModes())) {
                parameters.setFocusMode("macro");
                object2 = this.mObjectLock;
                synchronized (object2) {
                    this.mCamera.setParameters(parameters);
                }
            } else {
                Logging.i("focus", "FOCUS_MODE_MACRO is not supported");
            }
            try {
                VideoCaptureCamera videoCaptureCamera = this;
                videoCaptureCamera.mCamera.autoFocus(new Camera.AutoFocusCallback((String)object){
                    final /* synthetic */ String val$currentFocusMode;
                    {
                        this.val$currentFocusMode = string2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onAutoFocus(boolean bl, Camera camera) {
                        if (object.VideoCaptureCamera.this.mCamera == null) {
                            return;
                        }
                        Camera.Parameters parameters = camera.getParameters();
                        parameters.setFocusMode(object.val$currentFocusMode);
                        Object object = object.VideoCaptureCamera.this.mObjectLock;
                        synchronized (object) {
                            camera.setParameters(parameters);
                            return;
                        }
                    }
                });
                long l2 = videoCaptureCamera.mNativeVideoCaptureDeviceAndroid;
                if (l2 != 0L) {
                    this.NotifyCameraFocusAreaChanged(f2, f3, 0.0f, 0.0f, l2);
                }
                return 0;
            }
            catch (Exception exception) {
                Logging.w(TAG, "mCamera.autoFocus Exception: " + exception);
                return -1;
            }
        }
        Logging.e(TAG, "set focus unreasonable inputs");
        return -1;
    }

    private int setExposure_l(float f2, float f3, boolean bl) {
        Logging.d(TAG, "setExposure called camera api1 x = " + f2 + " y = " + f3);
        if (this.mCamera == null) {
            return -1;
        }
        if (!(f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f)) {
            long l2;
            Rect rect = VideoCaptureCamera.calculateTapArea(f2, f3, 1.5f);
            if (this.mCamera != null) {
                Camera.Parameters parameters = this.getCameraParameters();
                if (parameters == null) {
                    return -1;
                }
                if (parameters.getMaxNumMeteringAreas() > 0) {
                    Camera.Area area;
                    ArrayList<Camera.Area> arrayList;
                    ArrayList<Camera.Area> arrayList2 = arrayList;
                    Camera.Area area2 = area;
                    area = new Camera.Area(rect, 800);
                    new ArrayList<Camera.Area>().add(area2);
                    parameters.setMeteringAreas(arrayList2);
                } else {
                    Logging.i(TAG, "metering areas not supported");
                }
                try {
                    VideoCaptureCamera videoCaptureCamera = this;
                    videoCaptureCamera.mCamera.setParameters(parameters);
                    videoCaptureCamera.mCamera.startPreview();
                }
                catch (Exception exception) {
                    Logging.e(TAG, "setExposure failed, " + exception);
                    return -1;
                }
            }
            if ((l2 = this.mNativeVideoCaptureDeviceAndroid) != 0L) {
                this.NotifyCameraExposureAreaChanged(f2, f3, 0.0f, 0.0f, l2);
            }
            return 0;
        }
        Logging.e(TAG, "set exposure unreasonable inputs");
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int startCapture_l(int n2, int n3, int n4) {
        Throwable throwable2;
        block19: {
            int n5;
            Logging.i(TAG, "startCapture, w=" + n2 + ", h=" + n3 + ", fps=" + n4);
            if (this.mCamera == null) {
                Logging.e(TAG, "startCapture: camera is null!!");
                return -1;
            }
            SurfaceTexture surfaceTexture = null;
            int n6 = this.mCaptureOutputDataType;
            if (n6 == 1 || n6 == 2) {
                Object object = SurfaceTextureHelper.create("Camera1Tex-" + this.mId, this.mShareContext, 8);
                this.mSurfaceTextureHelper = object;
                if (object == null) {
                    Logging.e(TAG, "Failed to create SurfaceTextureHelper, force fallback to raw data type");
                    this.mCaptureOutputDataType = 0;
                } else {
                    VideoCaptureCamera videoCaptureCamera = this;
                    ((SurfaceTextureHelper)object).getSurfaceTexture().setDefaultBufferSize(n2, n3);
                    videoCaptureCamera.mSurfaceTextureHelper.startListening(this);
                    videoCaptureCamera.mEglContext = videoCaptureCamera.mSurfaceTextureHelper.getEglContext();
                    surfaceTexture = videoCaptureCamera.mSurfaceTextureHelper.getSurfaceTexture();
                    if (videoCaptureCamera.mCaptureOutputDataType == 2 && this.mTextureAndRawBufferSynchronizer == null) {
                        VideoCapture.TextureAndRawBufferSynchronizer textureAndRawBufferSynchronizer;
                        object = textureAndRawBufferSynchronizer;
                        textureAndRawBufferSynchronizer = new VideoCapture.TextureAndRawBufferSynchronizer();
                        this.mTextureAndRawBufferSynchronizer = object;
                    }
                }
            }
            n6 = 0;
            if (this.mCaptureOutputDataType == 0) {
                if (this.mDummySurfaceTexture == null) {
                    try {
                        this.mDummySurfaceTexture = new SurfaceTexture(42);
                    }
                    catch (Surface.OutOfResourcesException outOfResourcesException) {
                        Logging.e(TAG, "failed to create dummy SurfaceTexture!");
                    }
                }
                surfaceTexture = this.mDummySurfaceTexture;
            }
            if (surfaceTexture == null) {
                return -1;
            }
            VideoCaptureCamera videoCaptureCamera = this;
            videoCaptureCamera.mCaptureLock.lock();
            videoCaptureCamera.mCamera.setPreviewTexture(surfaceTexture);
            videoCaptureCamera.mCaptureLock.unlock();
            {
                catch (Throwable throwable2) {
                    break block19;
                }
                catch (Exception exception) {}
                {
                    Logging.e(TAG, "failed to set preview texture, invalid surfaceTexture!");
                    this.mDummySurfaceTexture = null;
                    n6 = -1;
                    this.mCaptureLock.unlock();
                }
            }
            if (n6 != 0) {
                return n6;
            }
            VideoCaptureCamera videoCaptureCamera2 = this;
            this.mCaptureLock.lock();
            this.isCaptureStarted = true;
            this.mCaptureWidth = n2;
            this.mCaptureHeight = n3;
            this.mCaptureFps = n4;
            try {
                n5 = videoCaptureCamera2.tryStartCapture(n2, n3, n4);
                videoCaptureCamera2.mCaptureLock.unlock();
                return n5;
            }
            catch (Throwable throwable3) {
                try {
                    Logging.e(TAG, "try start capture failed " + throwable3);
                    n5 = -1;
                    this.mCaptureLock.unlock();
                    return n5;
                }
                catch (Throwable throwable4) {
                    this.mCaptureLock.unlock();
                    throw throwable4;
                }
            }
        }
        this.mCaptureLock.unlock();
        throw throwable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int stopCapture_l() {
        if (!this.isCaptureStarted) {
            Logging.w(TAG, "already stop capture");
            return 0;
        }
        try {
            if (this.isFaceDetectionStarted) {
                VideoCaptureCamera videoCaptureCamera = this;
                videoCaptureCamera.stopFaceDetection();
                videoCaptureCamera.mCamera.setFaceDetectionListener(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop face detection", runtimeException);
        }
        int n2 = 0;
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to cancle AutoFocus", runtimeException);
        }
        try {
            VideoCaptureCamera videoCaptureCamera = this;
            videoCaptureCamera.mPreviewBufferLock.lock();
            videoCaptureCamera.isCaptureRunning = false;
            videoCaptureCamera.mCamera.stopPreview();
            videoCaptureCamera.mCamera.setErrorCallback(null);
            AgoraVideoDebugger.reset();
            videoCaptureCamera.mDroppedTextureBufferCount = 0;
            if (videoCaptureCamera.mTextureAndRawBufferSynchronizer != null) {
                this.mTextureAndRawBufferSynchronizer.reset();
            }
            if (this.mSurfaceTextureHelper != null) {
                VideoCaptureCamera videoCaptureCamera2 = this;
                videoCaptureCamera2.mSurfaceTextureHelper.stopListening();
                videoCaptureCamera2.mSurfaceTextureHelper.dispose();
                videoCaptureCamera2.mSurfaceTextureHelper = null;
            }
            this.mEglContext = null;
            if (this.mCaptureOutputDataType == 0 || this.mCaptureOutputDataType == 2) {
                this.mCamera.setPreviewCallbackWithBuffer(null);
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Failed to stop camera", runtimeException);
            n2 = -1;
        }
        this.mPreviewBufferLock.unlock();
        if (n2 == 0) {
            this.isCaptureStarted = false;
        }
        return n2;
    }

    private boolean isTorchSupported_l() {
        if (this.mCamera != null && (this = this.getCameraParameters()) != null) {
            return VideoCaptureCamera.isSupported("torch", this.getSupportedFlashModes());
        }
        return false;
    }

    private boolean isFocusSupported_l() {
        if (this.mCamera != null && (this = this.getCameraParameters()) != null) {
            return this.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", this.getSupportedFocusModes());
        }
        return false;
    }

    private boolean isExposureSupported_l() {
        boolean bl = false;
        boolean bl2 = this.mCamera != null && (this = this.getCameraParameters()) != null ? this.getMaxNumMeteringAreas() > 0 : bl;
        return bl2;
    }

    private boolean isZoomSupported_l() {
        if (this.mCamera != null && (this = this.getCameraParameters()) != null) {
            return this.isZoomSupported();
        }
        return false;
    }

    private boolean isAutoFaceFocusSupported_l() {
        return this.mCamera != null && (this = this.getCameraParameters()) != null && this.getMaxNumDetectedFaces() > 0 && this.getMaxNumFocusAreas() > 0 && VideoCaptureCamera.isSupported("auto", this.getSupportedFocusModes());
    }

    private boolean isFaceDetectedSupported() {
        return this.mCamera != null && (this = this.getCameraParameters()) != null && this.getMaxNumDetectedFaces() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deallocate_l() {
        v0 = this;
        var1_1 = v0.mRecoverThreadObjectLock;
        synchronized (var1_1) {
            v0.mNativeVideoCaptureDeviceAndroid = 0L;
            v0.stopCapture();
            v0.mCaptureLock.lock();
            if (v0.mCamera == null) ** GOTO lbl16
            this.mCamera.release();
            this.mCamera = null;
lbl16:
            // 2 sources

            v2 = this;
            v2.mCaptureLock.unlock();
            if (v2.mHandler == null) ** GOTO lbl21
            this.mHandler.removeCallbacksAndMessages(null);
lbl21:
            // 2 sources

            if (this.mCameraRecoverHandlerThread == null) ** GOTO lbl31
            v3 = this;
            v4 = v3;
            v5 = v3;
            v3.mCameraRecoverHandlerThread.quit();
            v5.mCameraRecoverHandlerThread = null;
            v4.mHandler = null;
lbl31:
            // 2 sources

            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSupported(String string2, List<String> list) {
        if (list == null) {
            return false;
        }
        if (list.indexOf(string2) < 0) return false;
        return true;
    }

    private void setAdvancedCameraParameters(Camera.Parameters parameters) {
        String string2 = "off";
        if (VideoCaptureCamera.isSupported("off", parameters.getSupportedFlashModes())) {
            Logging.i(TAG, "AgoraVideo set flash mode = FLASH_MODE_OFF");
            parameters.setFlashMode(string2);
        }
        string2 = "auto";
        if (VideoCaptureCamera.isSupported("auto", parameters.getSupportedWhiteBalance())) {
            Logging.i(TAG, "AgoraVideo set white blance = WHITE_BALANCE_AUTO");
            parameters.setWhiteBalance(string2);
        }
        string2 = "continuous-video";
        if (VideoCaptureCamera.isSupported("continuous-video", parameters.getSupportedFocusModes())) {
            Logging.i(TAG, "AgoraVideo set Focus mode = FOCUS_MODE_CONTINUOUS_VIDEO");
            parameters.setFocusMode(string2);
        }
        if (VideoCaptureCamera.isSupported(string2 = ((VideoCaptureCamera)((Object)string3)).mAntiBandingMode, parameters.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + ((VideoCaptureCamera)((Object)string3)).mAntiBandingMode);
            parameters.setAntibanding(string2);
        }
        String string3 = "auto";
        if (VideoCaptureCamera.isSupported("auto", parameters.getSupportedSceneModes())) {
            Logging.i(TAG, "AgoraVideo set sence mode = " + (String)string3);
            if (parameters.getSceneMode() != string3) {
                parameters.setSceneMode(string3);
            }
        }
    }

    private void setDeviceSpecificParameters(Camera.Parameters parameters) {
        String string2 = DeviceUtils.buildDeviceId();
        String string3 = DeviceUtils.getCpuName();
        String string4 = DeviceUtils.getCpuABI();
        int n2 = DeviceUtils.getNumberOfCPUCores();
        int n3 = DeviceUtils.getCPUMaxFreqKHz();
        Logging.i(TAG, "Current Device: " + (String)string2);
        Logging.i(TAG, "CPU name: " + string3 + ", with " + n2 + " cores, arch: " + string4 + ", max Freq: " + n3);
        if (string2.contains("xiaomi/mi note")) {
            Camera.Parameters parameters2 = parameters;
            Logging.i(TAG, "set MiNote config");
            parameters2.set("scene-detect", "on");
            parameters2.set("xiaomi-still-beautify-values", "i:3");
            parameters2.set("skinToneEnhancement", "enable");
            parameters2.set("auto-exposure", "center-weighted");
        }
        if (string2.contains("oppo/r7c/r7c")) {
            Camera.Parameters parameters3 = parameters;
            Logging.i(TAG, "set oppo r7c config");
            parameters3.set("skinToneEnhancement", 1);
            parameters3.set("face-beautify", 100);
            parameters3.set("auto-exposure", "center-weighted");
        }
    }

    private List<Integer> getZoomRatios() {
        if (videoCaptureCamera2.mCamera != null) {
            VideoCaptureCamera videoCaptureCamera = videoCaptureCamera2;
            VideoCaptureCamera videoCaptureCamera2 = videoCaptureCamera.getCameraParameters();
            if (videoCaptureCamera.isZoomSupported((Camera.Parameters)videoCaptureCamera2)) {
                return videoCaptureCamera2.getZoomRatios();
            }
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            if (parameters.isZoomSupported()) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported ");
            return false;
        }
        return false;
    }

    private static Rect calculateTapArea(float f2, float f3, float f4) {
        RectF rectF;
        int n2 = (int)(f2 * 2000.0f - 1000.0f);
        int n3 = (int)(f3 * 2000.0f - 1000.0f);
        int n4 = Float.valueOf(f4 * 300.0f).intValue() / 2;
        RectF rectF2 = rectF;
        float f5 = VideoCaptureCamera.clamp(n2 - n4, -1000, 1000);
        float f6 = VideoCaptureCamera.clamp(n3 - n4, -1000, 1000);
        float f7 = VideoCaptureCamera.clamp(n2 + n4, -1000, 1000);
        float f8 = VideoCaptureCamera.clamp(n3 + n4, -1000, 1000);
        rectF = new RectF(f5, f6, f7, f8);
        RectF rectF3 = rectF2;
        int n5 = Math.round(rectF3.top);
        int n6 = Math.round(rectF3.right);
        int n7 = Math.round(rectF3.bottom);
        return new Rect(Math.round(rectF2.left), n5, n6, n7);
    }

    private static int clamp(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n4, n2));
    }

    private boolean isForeground() {
        Object object = this.mContext;
        if (object != null) {
            if ((object = ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses()) == null) {
                Logging.e(TAG, "List of RunningAppProcessInfo is null");
                return false;
            }
            for (int i2 = 0; i2 < object.size(); ++i2) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.get(i2);
                if (runningAppProcessInfo == null) {
                    Logging.e(TAG, "ActivityManager.RunningAppProcessInfo is null");
                    continue;
                }
                if (!runningAppProcessInfo.processName.equals(this.mContext.getPackageName()) || runningAppProcessInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }

    private int getFrameOrientation() {
        VideoCaptureCamera videoCaptureCamera = this;
        int n2 = videoCaptureCamera.checkOrientation();
        if (!videoCaptureCamera.mIsCameraFacingFront) {
            n2 = 360 - n2;
        }
        return (VideoCaptureCamera.getSensorOrientation(this.mId) + n2) % 360;
    }

    private String toCamera1ABMode(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return "auto";
                }
                return "60hz";
            }
            return "50hz";
        }
        return "off";
    }

    private int setAntiBandingMode_l(int n2) {
        VideoCaptureCamera videoCaptureCamera = this;
        videoCaptureCamera.mAntiBandingMode = videoCaptureCamera.toCamera1ABMode(n2);
        Camera camera = videoCaptureCamera.mCamera;
        if (camera == null) {
            return -1;
        }
        if ((camera = camera.getParameters()) == null) {
            return -1;
        }
        String string2 = this.mAntiBandingMode;
        if (VideoCaptureCamera.isSupported(string2, camera.getSupportedAntibanding())) {
            Logging.i(TAG, "AgoraVideo set anti-banding = " + string2);
            camera.setAntibanding(string2);
            try {
                this.mCamera.setParameters((Camera.Parameters)camera);
            }
            catch (Exception exception) {
                Logging.e(TAG, "anti banding got exception:" + exception);
            }
            return 0;
        }
        Logging.i(TAG, "not supported anti-banding = " + string2);
        return -1;
    }

    private void setExposureCompensation_l(int n2) {
        Logging.i(TAG, "setExposureCompensation:" + n2);
        Camera camera = this.mCamera;
        if (camera != null && (camera = camera.getParameters()) != null) {
            Camera camera2 = camera;
            float f2 = camera2.getExposureCompensationStep();
            int n3 = camera2.getMinExposureCompensation();
            int n4 = camera2.getMaxExposureCompensation();
            int n5 = camera2.getExposureCompensation();
            Logging.i(TAG, "compensation step=" + f2 + ", min=" + n3 + ", max=" + n4 + ", cur index=" + n5);
            if (n2 <= n4) {
                n4 = n2;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            camera.setExposureCompensation(n4);
            try {
                this.mCamera.setParameters((Camera.Parameters)camera);
            }
            catch (Exception exception) {
                Logging.e(TAG, "exposure compensation got exception:" + exception);
            }
            int n6 = camera.getExposureCompensation();
            Logging.i(TAG, "cur index=" + n6 + ", ev=" + f2 * (float)n6);
        }
    }

    static /* synthetic */ int access$002(VideoCaptureCamera videoCaptureCamera, int n2) {
        videoCaptureCamera.mAllocated = n2;
        return n2;
    }

    static /* synthetic */ HandlerThread access$402(VideoCaptureCamera videoCaptureCamera, HandlerThread handlerThread) {
        videoCaptureCamera.mCameraRecoverHandlerThread = handlerThread;
        return handlerThread;
    }

    static /* synthetic */ Handler access$502(VideoCaptureCamera videoCaptureCamera, Handler handler) {
        videoCaptureCamera.mHandler = handler;
        return handler;
    }

    static /* synthetic */ boolean access$600(VideoCaptureCamera videoCaptureCamera) {
        return videoCaptureCamera.isForeground();
    }

    static /* synthetic */ int access$700(VideoCaptureCamera videoCaptureCamera) {
        return videoCaptureCamera.mCaptureWidth;
    }

    static /* synthetic */ int access$800(VideoCaptureCamera videoCaptureCamera) {
        return videoCaptureCamera.mCaptureHeight;
    }

    static /* synthetic */ int access$900(VideoCaptureCamera videoCaptureCamera) {
        return videoCaptureCamera.mCaptureFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int UnRegisterNativeHandle() {
        Logging.d(TAG, "UnRegisterNativeHandle called");
        Object object = this.mRecoverThreadObjectLock;
        synchronized (object) {
            this.mNativeVideoCaptureDeviceAndroid = 0L;
            return 0;
        }
    }

    @Override
    public int allocate() {
        if (this.mCameraPreviewHandlerThread == null) {
            this.mCameraPreviewHandlerThread = new HandlerThread("camera-preview-thread");
            this.mCameraPreviewHandlerThread.start();
            if (this.mCameraPreviewHandlerThread != null) {
                this.mPreviewHandler = new Handler(this.mCameraPreviewHandlerThread.getLooper());
            }
        }
        this.mAllocated = -1;
        if (this.mPreviewHandler != null) {
            CountDownLatch countDownLatch;
            final CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch2(1);
            this.mPreviewHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    VideoCaptureCamera videoCaptureCamera = v0.VideoCaptureCamera.this;
                    VideoCaptureCamera.access$002(videoCaptureCamera, videoCaptureCamera.allocate_l());
                    v0.countDownLatch2.countDown();
                }
            });
            try {
                countDownLatch.await(6000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.mAllocated;
    }

    @Override
    public int setCaptureFormat(int n2, int n3, boolean bl) {
        Logging.i(TAG, "setCaptureFormat: " + n2 + " type: " + n3 + " force texture oes: " + bl);
        VideoCapture.FORCE_TEXTURE_OES = bl;
        this.mCaptureOutputDataType = VideoCapture.translateToCaptureOutputDataType(n3);
        this.mCaptureFormat = VideoCapture.translateToAndroidFormat(n2);
        if (this.mCaptureFormat == 0) {
            Logging.e(TAG, "setCaptureFormat failed, unkonwn format: " + n2);
            return -1;
        }
        return 0;
    }

    @Override
    public int setZoom(final float f2) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    return VideoCaptureCamera.this.setZoom_l(f2);
                }
            });
        }
        return -1;
    }

    @Override
    public float getMaxZoom() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Float>(){

                @Override
                public Float call() {
                    return Float.valueOf(VideoCaptureCamera.this.getMaxZoom_l());
                }
            }).floatValue();
        }
        return -1.0f;
    }

    @Override
    public int setTorchMode(final boolean bl) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    return VideoCaptureCamera.this.setTorchMode_l(bl);
                }
            });
        }
        return -1;
    }

    @Override
    public int setFocus(final float f2, final float f3, final boolean bl) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    10 v0 = this;
                    float f22 = v0.f2;
                    float f32 = v0.f3;
                    boolean bl2 = v0.bl;
                    return VideoCaptureCamera.this.setFocus_l(f22, f32, bl2);
                }
            });
        }
        return -1;
    }

    @Override
    public int setExposure(final float f2, final float f3, final boolean bl) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    12 v0 = this;
                    float f22 = v0.f2;
                    float f32 = v0.f3;
                    boolean bl2 = v0.bl;
                    return VideoCaptureCamera.this.setExposure_l(f22, f32, bl2);
                }
            });
        }
        return -1;
    }

    @Override
    public int setAutoFaceFocus(boolean bl) {
        Logging.d(TAG, "setAutoFaceFocus: " + bl);
        boolean bl2 = this.mIsAutoFaceFocusEnabled != bl;
        this.mIsAutoFaceFocusEnabled = bl;
        if (this.isAutoFaceFocusSupported() && bl2) {
            if (this.mIsAutoFaceFocusEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.mIsAutoFaceFocusEnabled && this.isFaceDetectionStarted && !this.faceDetectEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int setFaceDetection(boolean bl) {
        Logging.d(TAG, "setFaceDetection: " + bl);
        boolean bl2 = this.faceDetectEnabled != bl;
        this.faceDetectEnabled = bl;
        if (this.isFaceDetectedSupported() && bl2) {
            if (this.faceDetectEnabled && !this.isFaceDetectionStarted) {
                this.startFaceDetection();
            } else if (!this.faceDetectEnabled && this.isFaceDetectionStarted && !this.mIsAutoFaceFocusEnabled) {
                this.stopFaceDetection();
            }
        }
        return 0;
    }

    @Override
    public int startCapture(final int n2, final int n3, final int n4) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    13 v0 = this;
                    int n22 = v0.n2;
                    int n32 = v0.n3;
                    int n42 = v0.n4;
                    return VideoCaptureCamera.this.startCapture_l(n22, n32, n42);
                }
            });
        }
        return -1;
    }

    @Override
    public int stopCapture() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    return VideoCaptureCamera.this.stopCapture_l();
                }
            });
        }
        return -1;
    }

    @Override
    public boolean isTorchSupported() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return VideoCaptureCamera.this.isTorchSupported_l();
                }
            });
        }
        return false;
    }

    @Override
    public boolean isFocusSupported() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return VideoCaptureCamera.this.isFocusSupported_l();
                }
            });
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return VideoCaptureCamera.this.isExposureSupported_l();
                }
            });
        }
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return VideoCaptureCamera.this.isZoomSupported_l();
                }
            });
        }
        return false;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return VideoCaptureCamera.this.isAutoFaceFocusSupported_l();
                }
            });
        }
        return false;
    }

    @Override
    public void deallocate() {
        Object object = this.mPreviewHandler;
        if (object != null) {
            Runnable runnable;
            Handler handler = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    VideoCaptureCamera.this.deallocate_l();
                }
            };
            ThreadUtils.invokeAtFrontUninterruptibly(handler, (Runnable)object);
        }
        if ((object = this.mPreviewHandler) != null) {
            object.removeCallbacksAndMessages(null);
        }
        if ((object = this.mCameraPreviewHandlerThread) != null) {
            VideoCaptureCamera videoCaptureCamera = this;
            object.quit();
            videoCaptureCamera.mCameraPreviewHandlerThread = null;
            videoCaptureCamera.mPreviewHandler = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        try {
            this.mPreviewBufferLock.lock();
            if (byArray == null) return;
            if (!this.isCaptureRunning) {
                return;
            }
            if (byArray.length == this.mExpectedRawBufferSize && this.mNativeVideoCaptureDeviceAndroid != 0L) {
                VideoCaptureCamera videoCaptureCamera = this;
                int n2 = videoCaptureCamera.mExpectedRawBufferSize;
                int n3 = videoCaptureCamera.mCaptureWidth;
                int n4 = videoCaptureCamera.mCaptureHeight;
                int n5 = videoCaptureCamera.mCaptureFormat;
                this.onRawBufferAvailable(byArray, n2, n3, n4, n5);
                return;
            }
            if (this.mNativeVideoCaptureDeviceAndroid != 0L) return;
            Logging.w(TAG, "warning mNativeVideoCaptureDeviceAndroid = 0, error");
            return;
        }
        finally {
            if (camera != null && this.isCaptureRunning) {
                camera.addCallbackBuffer(byArray);
            }
            this.mPreviewBufferLock.unlock();
        }
    }

    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        VideoCaptureCamera videoCaptureCamera = this;
        n2 = videoCaptureCamera.getFrameOrientation();
        if (videoCaptureCamera.mIsCameraFacingFront) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        VideoCaptureCamera videoCaptureCamera2 = this;
        int n3 = videoCaptureCamera2.mCaptureWidth;
        int n4 = videoCaptureCamera2.mCaptureHeight;
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        VideoFrame.TextureBuffer textureBuffer = this.mSurfaceTextureHelper.createTextureBuffer(n3, n4, matrix);
        this.onTextureBufferAvailable(textureBuffer, n2, l2);
        textureBuffer.release();
    }

    public Camera.Parameters getCameraParameters() {
        try {
            return this.mCamera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", runtimeException);
            Camera camera = this.mCamera;
            if (camera != null) {
                camera.release();
                this.mCamera = null;
            }
            return null;
        }
    }

    public int createCapabilities() {
        String string2 = null;
        Object object = this.getCameraParameters();
        if (object != null) {
            Object object2;
            int n2;
            string2 = "\"id\":" + this.mId + ",";
            String string3 = "\"resolution\":";
            Object object3 = "";
            Object object4 = object.getSupportedPreviewSizes();
            for (int i2 = 0; i2 < object4.size(); ++i2) {
                int n3 = ((Camera.Size)object4.get((int)i2)).width;
                n2 = ((Camera.Size)object4.get((int)i2)).height;
                if (n3 >= 240 && n2 >= 240 && (n3 >= 320 || n2 >= 320)) {
                    object2 = "{\"w\":" + n3 + ",\"h\":" + n2 + "}";
                    if (!((String)object3).isEmpty()) {
                        object2 = (String)object3 + "," + (String)object2;
                    }
                } else {
                    object2 = object3;
                }
                object3 = object2;
            }
            object4 = "\"format\":";
            String string4 = "";
            object2 = object.getSupportedPreviewFormats();
            n2 = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                String[] stringArray = Build.SUPPORTED_ABIS;
                if (Build.SUPPORTED_ABIS != null && stringArray[0].startsWith("x86")) {
                    n2 = 1;
                }
            }
            if (VideoCapture.isEmulator() || n2 != 0 && object2.size() > 1) {
                object2.remove((Object)842094169);
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                Object object5 = object2;
                int n4 = VideoCapture.translateToEngineFormat((Integer)object5.get(n2));
                string4 = n2 != object5.size() - 1 ? string4 + n4 + "," : string4 + n4;
            }
            Camera.Parameters parameters = object;
            object = "\"fps\":";
            object2 = "";
            List list = parameters.getSupportedPreviewFrameRates();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                List list2 = list;
                int n5 = (Integer)list2.get(i3);
                object2 = i3 != list2.size() - 1 ? (String)object2 + n5 + "," : (String)object2 + n5;
            }
            string2 = "{" + string2 + string3 + "[" + (String)object3 + "]," + (String)object4 + "[" + string4 + "]," + (String)object + "[" + (String)object2 + "]}";
        }
        VideoCapture.cacheCapability(this.mId, this.mContext, string2, VideoCaptureCamera.getCaptureName());
        return 0;
    }

    @Override
    public int setAntiBandingMode(final int n2) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    return VideoCaptureCamera.this.setAntiBandingMode_l(n2);
                }
            });
        }
        return -1;
    }

    @Override
    public int setExposureCompensation(final int n2) {
        Handler handler = this.mPreviewHandler;
        if (handler != null) {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Integer>(){

                @Override
                public Integer call() {
                    VideoCaptureCamera.this.setExposureCompensation_l(n2);
                    return 0;
                }
            });
        }
        return -1;
    }

    @Override
    public int setNoiseReductionMode(int n2) {
        Logging.e(TAG, "NoiseReduction not supported in camera1 ");
        return -1;
    }

    @Override
    public int setEdgeEnhanceMode(int n2) {
        Logging.e(TAG, "EdgeEnhancement not supported in camera1 ");
        return -1;
    }

    @Override
    public int setVideoStabilityMode(int n2) {
        Logging.e(TAG, "VideoStability not supported in camera1 ");
        return -1;
    }
}

