/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.SurfaceTextureHelper;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.AgoraVideoDebugger;
import io.agora.rtc.video.CoordinatesTransform;
import io.agora.rtc.video.VideoCapture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture
implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "CAMERA2";
    private static final boolean VERBOSE = false;
    private static final double kNanoSecondsToFps = 1.0E-9;
    private static final int DEFAULT_MATCH_FPS = 15;
    private static boolean usingLibyuv = false;
    private static final MeteringRectangle[] ZERO_WEIGHT_3A_REGION;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 1.0f;
    private static final float DEFAULT_VALUE = -1.0f;
    private CameraDevice mCameraDevice = null;
    private CaptureRequest.Builder mPreviewBuilder = null;
    private CameraCaptureSession mCaptureSession = null;
    private CameraState mCameraState = CameraState.STOPPED;
    private CameraManager mManager = null;
    private Handler mStateHandler = null;
    private HandlerThread mCameraStateThread = null;
    private HandlerThread mPreviewThread = null;
    private final Object mCameraStateLock = new Object();
    private int mCaptureWidth = -1;
    private int mCaptureHeight = -1;
    private int mCaptureFps = -1;
    private int mCaptureFormat = 35;
    private boolean mFaceDetectSupported;
    private int mFaceDetectMode;
    private boolean mIsAutoFaceFocusEnabled = false;
    private RectF[] rectArray = null;
    private int[] distanceArray = null;
    private boolean faceDistaneEnabled = false;
    private MeteringRectangle[] mAFAERegions = ZERO_WEIGHT_3A_REGION;
    private float mLastZoomRatio = -1.0f;
    private float mCurZoomRatio = 1.0f;
    private float mMaxZoom = -1.0f;
    private Rect mSensorRect = null;
    private int mAntiBandingMode = 3;
    private int mNoiseReductionMode = 1;
    private int mEdgeEnhanceMode = 0;
    private int mVideoStabilityMode = 0;
    private final Object mCaptureSessionLock = new Object();
    private final boolean mIsCameraFacingFront;
    private byte[] mCaptureData;
    private ImageReader mImageReader = null;
    private final Object mImageReaderLock = new Object();
    private Surface mTextureOutputSurface;
    public CameraManager.AvailabilityCallback mAvailabilityCallback = new CameraManager.AvailabilityCallback(){

        public synchronized void onCameraAvailable(String string2) {
            1 v0 = videoCaptureCamera2;
            super.onCameraAvailable(string2);
            if (v0.VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                if (videoCaptureCamera2.VideoCaptureCamera2.this.tryOpenCamera() == 0) {
                    VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera2.VideoCaptureCamera2.this;
                    long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
                    if (l2 != 0L) {
                        videoCaptureCamera2.onCameraError(l2, "no error");
                    }
                } else {
                    Logging.e(VideoCaptureCamera2.TAG, "start capture failed");
                }
            }
        }

        public synchronized void onCameraUnavailable(String string2) {
            super.onCameraUnavailable(string2);
            Logging.e(VideoCaptureCamera2.TAG, "Camera " + string2 + " unavailable");
        }
    };
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        private void notifyCameraFocusAreaChanged(Rect rect, Rect rect2) {
            rect = CoordinatesTransform.sensorToNormalizedPreview(rect2, VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, rect);
            Logging.d(VideoCaptureCamera2.TAG, "face bound = " + rect2.toString());
            Logging.d(VideoCaptureCamera2.TAG, "rect (-1000, 1000) = " + rect.toString());
            boolean bl = false;
            if (VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            rect = CoordinatesTransform.normalizedFaceRect(rect, 0, bl);
            Logging.d(VideoCaptureCamera2.TAG, "preview size width = " + VideoCaptureCamera2.this.mCaptureWidth + " height = " + VideoCaptureCamera2.this.mCaptureHeight);
            Logging.d(VideoCaptureCamera2.TAG, "auto face focus left =" + rect.left + " top = " + rect.top + " right = " + rect.right + " bottom = " + rect.bottom + "isMirror =" + bl);
            float f2 = rect.left;
            float f3 = rect.top;
            float f4 = rect.width();
            float f5 = rect.height();
            VideoCaptureCamera2 videoCaptureCamera2 = VideoCaptureCamera2.this;
            long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
            if (l2 != 0L) {
                videoCaptureCamera2.NotifyCameraFocusAreaChanged(f2, f3, f4, f5, l2);
            }
        }

        private void notifyFaceDetection(Rect object, Face[] faceArray) {
            2 v0 = this;
            VideoCaptureCamera2.access$402(v0.VideoCaptureCamera2.this, null);
            int n2 = 0;
            boolean bl = false;
            if (v0.VideoCaptureCamera2.this.mId == 1) {
                bl = true;
            }
            if (faceArray != null && faceArray.length > 0) {
                2 v1 = this;
                n2 = faceArray.length;
                VideoCaptureCamera2.access$402(v1.VideoCaptureCamera2.this, new RectF[n2]);
                VideoCaptureCamera2.access$502(v1.VideoCaptureCamera2.this, new int[n2]);
                for (int i2 = 0; i2 < n2; ++i2) {
                    2 v2 = this;
                    Rect rect = CoordinatesTransform.sensorToNormalizedPreview(faceArray[i2].getBounds(), VideoCaptureCamera2.this.mCaptureWidth, VideoCaptureCamera2.this.mCaptureHeight, object);
                    ((VideoCaptureCamera2)v2.VideoCaptureCamera2.this).rectArray[i2] = CoordinatesTransform.normalizedFaceRect(rect, 0, bl);
                    ((VideoCaptureCamera2)v2.VideoCaptureCamera2.this).distanceArray[i2] = 5;
                }
            } else {
                VideoCaptureCamera2.access$402(VideoCaptureCamera2.this, new RectF[0]);
            }
            Logging.d(VideoCaptureCamera2.TAG, "before notify face");
            object = VideoCaptureCamera2.this;
            2 v3 = this;
            int n3 = ((VideoCaptureCamera2)object).mCaptureWidth;
            int n4 = v3.VideoCaptureCamera2.this.mCaptureHeight;
            RectF[] rectFArray = v3.VideoCaptureCamera2.this.rectArray;
            long l2 = n2;
            long l3 = VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid;
            object.NotifyFaceDetection(n3, n4, rectFArray, l2, l3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void process(CaptureResult var1_2) {
            var2_3 = (Face[])var1_2 /* !! */ .get(CaptureResult.STATISTICS_FACES);
            if (var2_3 != null && var2_3.length > 0) {
                block13: {
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (var2_3[0].getScore() <= 20) return;
                        v0 = this;
                        this = (Rect)var1_2 /* !! */ .get(CaptureResult.SCALER_CROP_REGION);
                        v0.notifyCameraFocusAreaChanged((Rect)this, var2_3[0].getBounds());
                        return;
                    }
                    if (var2_3[0].getScore() <= 50) {
                        return;
                    }
                    v1 = this;
                    v2 = new MeteringRectangle[1];
                    var3_4 = v3;
                    v3 = new MeteringRectangle(var2_3[0].getBounds(), 1000);
                    v2[0] = var3_4;
                    VideoCaptureCamera2.access$602(v1.VideoCaptureCamera2.this, v2);
                    if (VideoCaptureCamera2.access$700(v1.VideoCaptureCamera2.this) == null) {
                        return;
                    }
                    v4 = this;
                    v5 = v4.VideoCaptureCamera2.this;
                    VideoCaptureCamera2.access$800(v5, VideoCaptureCamera2.access$700(v5));
                    if (VideoCaptureCamera2.access$000(v4.VideoCaptureCamera2.this) != CameraState.STARTED) {
                        return;
                    }
                    v6 = this;
                    var1_2 /* !! */  = (Rect)var1_2 /* !! */ .get(CaptureResult.SCALER_CROP_REGION);
                    Logging.d("CAMERA2", "cropRegion = " + var1_2 /* !! */ .toString());
                    Logging.d("CAMERA2", "capture size wxh = " + VideoCaptureCamera2.access$200(VideoCaptureCamera2.this) + " x " + VideoCaptureCamera2.access$300(VideoCaptureCamera2.this));
                    v6.notifyCameraFocusAreaChanged((Rect)var1_2 /* !! */ , var2_3[0].getBounds());
                    if (VideoCaptureCamera2.access$900(v6.VideoCaptureCamera2.this) == null) break block13;
                    v7 = this;
                    v8 = v7;
                    var1_2 /* !! */  = VideoCaptureCamera2.access$1000(v7.VideoCaptureCamera2.this);
                    {
                        catch (Exception var0_1) {
                            Logging.e("CAMERA2", "capture: " + var0_1);
                            return;
                        }
                        {
                            ** synchronized (var1_2 /* !! */ )
                        }
lbl-1000:
                        // 1 sources

                        {
                            block14: {
                                if (VideoCaptureCamera2.access$900(v8.VideoCaptureCamera2.this) == null) break block14;
                                VideoCaptureCamera2.access$900(VideoCaptureCamera2.this).capture(VideoCaptureCamera2.access$700(VideoCaptureCamera2.this).build(), VideoCaptureCamera2.access$1100(VideoCaptureCamera2.this), null);
                            }
                            try {
                            }
                            catch (Throwable v9) {}
                            {
                                throw v9;
                            }
                        }
                    }
                }
                VideoCaptureCamera2.access$1200(VideoCaptureCamera2.this);
                this.mLastFocusedTs = System.currentTimeMillis();
                return;
            }
            VideoCaptureCamera2.access$602(VideoCaptureCamera2.this, VideoCaptureCamera2.access$1300());
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            if (this_.VideoCaptureCamera2.this.mIsAutoFaceFocusEnabled && this_.VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this_.process((CaptureResult)totalCaptureResult);
            }
            if (this_.VideoCaptureCamera2.this.faceDistaneEnabled) {
                2 v0 = this_;
                TotalCaptureResult totalCaptureResult2 = totalCaptureResult;
                2 this_ = (Rect)totalCaptureResult2.get(CaptureResult.SCALER_CROP_REGION);
                v0.notifyFaceDetection((Rect)this_, (Face[])totalCaptureResult2.get(CaptureResult.STATISTICS_FACES));
            }
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult object) {
            if ((object = (Integer)object.get(CaptureResult.CONTROL_AF_STATE)) == null) {
                return;
            }
            if (VideoCaptureCamera2.this.mPreviewBuilder == null) {
                return;
            }
            if (4 == (Integer)object || 5 == (Integer)object) {
                3 v0 = this;
                v0.VideoCaptureCamera2.this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                v0.VideoCaptureCamera2.this.startNormalPreview();
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };

    static boolean isCameraFacingFront(Context context, int n2) {
        if ((context = VideoCaptureCamera2.getCameraCharacteristics(context, n2)) != null) {
            return Integer.valueOf(0).equals(context.get(CameraCharacteristics.LENS_FACING));
        }
        return true;
    }

    private static CameraCharacteristics getCameraCharacteristics(Context context, int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            Logging.i(TAG, "getCameraCharacteristics error,  camera id: " + n2);
            return null;
        }
        try {
            return ((CameraManager)context.getSystemService("camera")).getCameraCharacteristics(Integer.toString(n2));
        }
        catch (Exception exception) {
            Logging.i(TAG, "getNumberOfCameras: got exception: " + exception);
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.i(TAG, "getNumberOfCameras: getCameraIdList(): " + (Object)((Object)cameraAccessException));
        }
        return null;
    }

    public static int getFrontCameraIndex(Context context) {
        context = (CameraManager)context.getSystemService("camera");
        String[] stringArray = context.getCameraIdList();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Context context2 = context;
            String string2 = stringArray[i2];
            Integer n3 = (Integer)context2.getCameraCharacteristics(string2).get(CameraCharacteristics.LENS_FACING);
            if (n3 == null) continue;
            if (n3 != 0) continue;
            try {
                Logging.d(TAG, "getFrontCameraIndex str= " + string2 + ", int = " + Integer.parseInt(string2));
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                Logging.e(TAG, "getFrontCameraIndex: ", exception);
                break;
            }
        }
        return 0;
    }

    static boolean isLegacyDevice(Context context, int n2) {
        boolean bl;
        block4: {
            block3: {
                try {
                    context = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
                    if (context == null) break block3;
                }
                catch (Throwable throwable) {
                    Logging.w(TAG, "this is a legacy camera device");
                    return true;
                }
                if ((Integer)context.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2) break block3;
                bl = false;
                break block4;
            }
            bl = true;
        }
        return bl;
    }

    static int getNumberOfCameras(Context context) {
        int n2;
        try {
            n2 = ((CameraManager)context.getSystemService("camera")).getCameraIdList().length;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): ", exception);
            return 0;
        }
        Logging.i(TAG, "VideoCaptureCamera2 listCount:" + n2);
        return n2;
    }

    static String getName(int n2, Context object) {
        if ((object = VideoCaptureCamera2.getCameraCharacteristics(object, n2)) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("camera2 ").append(n2).append(", facing ");
        object = (Integer)object.get(CameraCharacteristics.LENS_FACING) == 0 ? "front" : "back";
        return stringBuilder.append((String)object).toString();
    }

    static String getCaptureName() {
        return "camera2";
    }

    static int getSensorOrientation(int n2, Context context) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
        if (cameraCharacteristics == null) {
            return -1;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    VideoCaptureCamera2(Context context, int n2, int n3, EglBase.Context context2, long l2) {
        super(context, n2, n3, context2, l2);
        this.mIsCameraFacingFront = VideoCaptureCamera2.isCameraFacingFront(context, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void startNormalPreview() {
        block10: {
            Handler handler;
            if (videoCaptureCamera26.mPreviewBuilder == null) return;
            if (videoCaptureCamera26.mPreviewThread == null) return;
            if (videoCaptureCamera26.mCaptureSession == null) {
                return;
            }
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera26;
            VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera2;
            Object object = videoCaptureCamera2.mCaptureSessionLock;
            if (videoCaptureCamera22.mPreviewBuilder == null || videoCaptureCamera26.mPreviewThread == null || videoCaptureCamera26.mCaptureSession == null) break block10;
            VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera26;
            VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23;
            videoCaptureCamera23.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            videoCaptureCamera23.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            Handler handler2 = handler;
            handler = new Handler(videoCaptureCamera26.mPreviewThread.getLooper());
            VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera26;
            VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera25.mPreviewBuilder.build();
            videoCaptureCamera24.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera26, videoCaptureCamera25.mCaptureCallback, handler2);
        }
        try {
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : object
            try {
                throw throwable;
            }
            catch (CameraAccessException cameraAccessException) {
                Logging.e(TAG, "setRepeatingRequest failed, error message : " + cameraAccessException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(CameraState cameraState) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = cameraState;
            this.mCameraStateLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int createCaptureRequest() {
        block12: {
            if (videoCaptureCamera24.mPreviewBuilder == null) {
                return -1;
            }
            if (videoCaptureCamera24.mCaptureSession == null) return 0;
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera24;
            VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera2;
            Object object = videoCaptureCamera2.mCaptureSessionLock;
            try {
                if (videoCaptureCamera22.mCaptureSession == null) break block12;
                VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera24;
                VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23.mPreviewBuilder.build();
                videoCaptureCamera24.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera24, videoCaptureCamera23.mCaptureCallback, null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT : object
                try {
                    throw throwable;
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "capture:" + illegalStateException);
                    return -4;
                }
                catch (SecurityException securityException) {
                    Logging.e(TAG, "setRepeatingRequest: ", securityException);
                    return -3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.e(TAG, "setRepeatingRequest: ", illegalArgumentException);
                    return -2;
                }
                catch (CameraAccessException cameraAccessException) {
                    Logging.e(TAG, "setRepeatingRequest: ", cameraAccessException);
                    return -1;
                }
            }
        }
        // MONITOREXIT : object
        return 0;
    }

    private static void setUsingLibyuv(boolean bl) {
        usingLibyuv = bl;
    }

    private static void readImageIntoBuffer(Image image, byte[] byArray) {
        int n2;
        int n3;
        ByteBuffer byteBuffer;
        int n4;
        Image image2 = image;
        int n5 = image2.getWidth();
        int n6 = image2.getHeight();
        Image.Plane[] planeArray = image2.getPlanes();
        if (usingLibyuv) {
            ByteBuffer byteBuffer2;
            Object object = planeArray[0];
            Image.Plane plane = planeArray[1];
            Image.Plane plane2 = object;
            object = plane2.getBuffer();
            if (VideoCapture.ConvertFrameToI420(n5, n6, (ByteBuffer)object, n4 = plane2.getRowStride(), byteBuffer = plane.getBuffer(), byteBuffer2 = planeArray[2].getBuffer(), n3 = plane.getRowStride(), n2 = plane.getPixelStride(), byArray) == 0) {
                return;
            }
            Logging.w(TAG, "readImageIntoBuffer: native convert I420 failed, using java method instead");
        }
        int n7 = 0;
        for (n4 = 0; n4 < planeArray.length; ++n4) {
            int n8;
            byteBuffer = planeArray[n4].getBuffer();
            if (byteBuffer == null) {
                Logging.e(TAG, "plane " + n4 + " buffer is null ");
                break;
            }
            int n9 = planeArray[n4].getRowStride();
            n3 = planeArray[n4].getPixelStride();
            n2 = n4 == 0 ? n5 : n5 / 2;
            int n10 = n4 == 0 ? n6 : n6 / 2;
            if (n3 == 1 && n9 == n2) {
                n8 = n2 * n10;
                byteBuffer.get(byArray, n7, n8);
                n7 += n8;
                continue;
            }
            byte[] byArray2 = new byte[n9];
            for (int i2 = 0; i2 < n10 - 1; ++i2) {
                byteBuffer.get(byArray2, 0, n9);
                for (int i3 = 0; i3 < n2; ++i3) {
                    byArray[n7++] = byArray2[i3 * n3];
                }
            }
            byteBuffer.get(byArray2, 0, Math.min(n9, byteBuffer.remaining()));
            for (n8 = 0; n8 < n2; ++n8) {
                byArray[n7++] = byArray2[n8 * n3];
            }
        }
    }

    private int tryOpenCamera() {
        CrStateListener crStateListener;
        CrStateListener crStateListener2 = crStateListener;
        crStateListener = (VideoCaptureCamera2)((Object)string2).new CrStateListener();
        CameraManager cameraManager = ((VideoCaptureCamera2)((Object)string2)).mManager;
        VideoCaptureCamera2 videoCaptureCamera2 = string2;
        VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera2;
        String string2 = Integer.toString(videoCaptureCamera2.mId);
        Handler handler = videoCaptureCamera22.mStateHandler;
        try {
            cameraManager.openCamera(string2, (CameraDevice.StateCallback)crStateListener2, handler);
            return 0;
        }
        catch (Exception exception) {
            Logging.e(TAG, "unknown error", exception);
            return -4;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", securityException);
            return -3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", illegalArgumentException);
            return -2;
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "allocate: manager.openCamera: ", cameraAccessException);
            return -1;
        }
    }

    private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder) {
        CaptureRequest.Builder builder2 = builder;
        VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera23;
        VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera23;
        builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        VideoCaptureCamera2 videoCaptureCamera23 = CaptureRequest.CONTROL_AE_REGIONS;
        builder.set((CaptureRequest.Key)videoCaptureCamera23, (Object)videoCaptureCamera22.mAFAERegions);
        videoCaptureCamera23 = CaptureRequest.CONTROL_AF_REGIONS;
        builder2.set((CaptureRequest.Key)videoCaptureCamera23, (Object)videoCaptureCamera2.mAFAERegions);
        builder2.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        builder2.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        builder2.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doStartCapture() {
        CaptureSessionListener captureSessionListener;
        int n2;
        ArrayList arrayList;
        Object object;
        int n3;
        int n4;
        CaptureRequest.Builder builder;
        if (this.mPreviewThread == null) {
            this.mPreviewThread = new HandlerThread("CameraPreview");
            this.mPreviewThread.start();
        }
        try {
            builder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureRequest ", securityException);
            return -3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureRequest: ", illegalArgumentException);
            return -2;
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureRequest: ", cameraAccessException);
            return -1;
        }
        {
            this.mPreviewBuilder = builder;
        }
        if (builder == null) {
            Logging.e(TAG, "mPreviewBuilder error");
            return -4;
        }
        Object object2 = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        if (object2 != null && (object2 = (CaptureRequest.Builder)object2.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) != null) {
            if (this.mPQFirst < 1) {
                CaptureRequest.Builder builder2 = object2;
                Arrays.sort(builder2, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getLower() - (Integer)range2.getLower();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object2));
                n4 = ((CaptureRequest.Builder)builder2).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    object = object2[n3];
                    if ((Integer)object.getLower() < Math.max(this.mCaptureFps, 15)) continue;
                    Logging.i(TAG, "set fps :" + object.toString() + " to camera2::fps first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object);
                    break;
                }
            } else {
                CaptureRequest.Builder builder3 = object2;
                Arrays.sort(builder3, new Comparator<Range<Integer>>(){

                    @Override
                    public int compare(Range<Integer> range, Range<Integer> range2) {
                        return (Integer)range.getUpper() - (Integer)range2.getUpper();
                    }
                });
                Logging.i(TAG, "sorted fps Ranges List:" + Arrays.toString((Object[])object2));
                n4 = ((CaptureRequest.Builder)builder3).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    object = object2[n3];
                    if ((Integer)object.getUpper() < this.mCaptureFps) continue;
                    Logging.i(TAG, "set fps :" + object.toString() + " to camera2::PQ first, request:" + this.mCaptureFps);
                    this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, object);
                    break;
                }
            }
        }
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        videoCaptureCamera2.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        videoCaptureCamera2.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        videoCaptureCamera2.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        object2 = videoCaptureCamera2.mPreviewBuilder;
        videoCaptureCamera2.setFaceDetect((CaptureRequest.Builder)object2, videoCaptureCamera2.mFaceDetectMode);
        object2 = arrayList;
        arrayList = new ArrayList();
        n4 = videoCaptureCamera2.mCaptureOutputDataType;
        if (n4 == 1 || n4 == 2) {
            SurfaceTextureHelper surfaceTextureHelper;
            this.mSurfaceTextureHelper = surfaceTextureHelper = SurfaceTextureHelper.create("Camera2Tex-" + this.mId, this.mShareContext, 8);
            if (surfaceTextureHelper == null) {
                Logging.e(TAG, "Failed to create SurfaceTextureHelper, force fallback to raw data type");
                this.mCaptureOutputDataType = 0;
            } else {
                Surface surface;
                VideoCaptureCamera2 videoCaptureCamera22 = this;
                VideoCaptureCamera2 videoCaptureCamera23 = this;
                int n5 = videoCaptureCamera23.mCaptureWidth;
                surfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(n5, videoCaptureCamera23.mCaptureHeight);
                videoCaptureCamera22.mSurfaceTextureHelper.startListening(this);
                videoCaptureCamera22.mEglContext = videoCaptureCamera22.mSurfaceTextureHelper.getEglContext();
                Object object3 = surface;
                videoCaptureCamera22.mTextureOutputSurface = new Surface(this.mSurfaceTextureHelper.getSurfaceTexture());
                videoCaptureCamera22.mPreviewBuilder.addTarget(object3);
                object2.add(videoCaptureCamera22.mTextureOutputSurface);
                if (this.mCaptureOutputDataType == 2 && this.mTextureAndRawBufferSynchronizer == null) {
                    VideoCapture.TextureAndRawBufferSynchronizer textureAndRawBufferSynchronizer;
                    object3 = textureAndRawBufferSynchronizer;
                    textureAndRawBufferSynchronizer = new VideoCapture.TextureAndRawBufferSynchronizer(this);
                    this.mTextureAndRawBufferSynchronizer = object3;
                }
            }
        }
        if ((n2 = this.mCaptureOutputDataType) == 0 || n2 == 2) {
            VideoCaptureCamera2 videoCaptureCamera24 = this;
            videoCaptureCamera24.mExpectedRawBufferSize = n2 = videoCaptureCamera24.mCaptureWidth * this.mCaptureHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat) / 8;
            videoCaptureCamera24.mCaptureData = new byte[n2];
            Object object4 = videoCaptureCamera24.mImageReaderLock;
            VideoCaptureCamera2 videoCaptureCamera25 = this;
            synchronized (object4) {
                ImageReaderListener imageReaderListener;
                Handler handler;
                VideoCaptureCamera2 videoCaptureCamera26 = this;
                n3 = videoCaptureCamera26.mCaptureHeight;
                videoCaptureCamera25.mImageReader = ImageReader.newInstance((int)videoCaptureCamera25.mCaptureWidth, (int)n3, (int)videoCaptureCamera26.mCaptureFormat, (int)2);
                Handler handler2 = handler;
                {
                    handler = new Handler(this.mPreviewThread.getLooper());
                }
                object = imageReaderListener;
                {
                    imageReaderListener = new ImageReaderListener();
                    videoCaptureCamera25.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)object, handler2);
                }
            }
            Surface surface = videoCaptureCamera24.mImageReader.getSurface();
            this.mPreviewBuilder.addTarget(surface);
            object2.add(surface);
        }
        CaptureSessionListener captureSessionListener2 = captureSessionListener;
        captureSessionListener = new CaptureSessionListener();
        try {
            this.mCameraDevice.createCaptureSession((List)object2, (CameraCaptureSession.StateCallback)captureSessionListener2, null);
            return 0;
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "createCaptureSession :", securityException);
            return -3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e(TAG, "createCaptureSession :", illegalArgumentException);
            return -2;
        }
        catch (CameraAccessException cameraAccessException) {
            Logging.e(TAG, "createCaptureSession :", cameraAccessException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doStopCapture() {
        block20: {
            v0 = this;
            Logging.i("CAMERA2", "doStopCapture");
            var1_1 = 0;
            var2_7 = v0.mCaptureSessionLock;
            synchronized (var2_7) {
                if (v0.mPreviewThread != null) {
                    v1 = this;
                    v2 = v1;
                    v1.mPreviewThread.quitSafely();
                }
                ** GOTO lbl16
                {
                    block19: {
                        v2.mPreviewThread = null;
lbl16:
                        // 2 sources

                        try {
                            if (this.mCaptureSession != null) {
                                this.mCaptureSession.abortCaptures();
                                this.mCaptureSession = null;
                            }
                            break block19;
                        }
                        catch (Exception var1_2) {
                            Logging.e("CAMERA2", "abortCaptures: ", var1_2);
                        }
                        catch (IllegalArgumentException var1_3) {
                            Logging.e("CAMERA2", "abortCaptures: ", var1_3);
                        }
                        catch (IllegalStateException var1_4) {
                            Logging.e("CAMERA2", "abortCaptures: ", var1_4);
                        }
                        catch (CameraAccessException var1_5) {
                            Logging.e("CAMERA2", "abortCaptures: ", var1_5);
                        }
                        var1_1 = -1;
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 4] lbl34 : MonitorExitStatement: MONITOREXIT : var2_7
                    if (this.mImageReader == null) break block20;
                    v4 = this;
                    var2_7 = v4.mImageReaderLock;
                }
            }
            synchronized (var2_7) {
                if (v4.mImageReader != null) {
                    v5 = this;
                    v5.mImageReader.setOnImageAvailableListener(null, null);
                    v5.mImageReader.close();
                    v5.mImageReader = null;
                }
            }
        }
        AgoraVideoDebugger.reset();
        this.mDroppedTextureBufferCount = 0;
        var2_7 = this.mTextureAndRawBufferSynchronizer;
        if (var2_7 != null) {
            var2_7.reset();
        }
        if ((var2_7 = this.mSurfaceTextureHelper) != null) {
            var2_7.stopListening();
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
            this.mEglContext = null;
        }
        if ((var2_7 = this.mTextureOutputSurface) != null) {
            var2_7.release();
            this.mTextureOutputSurface = null;
        }
        if ((var2_7 = this.mCameraDevice) != null) {
            var2_7.close();
            this.mCameraDevice = null;
        }
        return var1_1;
    }

    private void setFaceDetect(CaptureRequest.Builder builder, int n2) {
        if (videoCaptureCamera2.mFaceDetectSupported && (videoCaptureCamera2.mIsAutoFaceFocusEnabled || videoCaptureCamera2.faceDistaneEnabled)) {
            VideoCaptureCamera2 videoCaptureCamera2 = CaptureRequest.STATISTICS_FACE_DETECT_MODE;
            builder.set((CaptureRequest.Key)videoCaptureCamera2, (Object)n2);
        }
    }

    public static int createCapabilities(int n2, Context context) {
        Object object;
        int n3;
        ArrayList<Size> arrayList;
        Object object2 = VideoCaptureCamera2.getCameraCharacteristics(context, n2);
        if (object2 == null) {
            return -1;
        }
        Object object3 = (StreamConfigurationMap)object2.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (object3 == null) {
            Logging.e(TAG, "Failed to create capabilities");
            return -1;
        }
        try {
            Logging.i(TAG, "dump configuration map:" + object3.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object object4 = arrayList;
        arrayList = new ArrayList<Size>(Arrays.asList(object3.getOutputSizes(35)));
        if ("SM-G9300".equals(Build.MODEL)) {
            ArrayList arrayList2;
            object3 = arrayList2;
            arrayList2 = new ArrayList();
            for (int i2 = 0; i2 < object4.size(); ++i2) {
                if (((Size)object4.get(i2)).getHeight() < 720) continue;
                object3.add(object4.get(i2));
            }
        } else {
            object3 = object4;
        }
        CameraCharacteristics cameraCharacteristics = object2;
        object2 = "\"id\":" + n2 + ",";
        object4 = "\"resolution\":";
        Object object5 = "";
        Object object6 = String.valueOf(15);
        Object object7 = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (object7 != null) {
            StringBuilder stringBuilder;
            ArrayList arrayList3;
            object6 = arrayList3;
            arrayList3 = new ArrayList();
            int n4 = ((Range[])object7).length;
            for (n3 = 0; n3 < n4; ++n3) {
                ((ArrayList)object6).add(object7[n3].getUpper());
            }
            object7 = stringBuilder;
            stringBuilder = new StringBuilder();
            object = ((ArrayList)object6).iterator();
            while (object.hasNext()) {
                Integer n5 = (Integer)object.next();
                ((StringBuilder)object7).append(n5 + ",");
            }
            if (((ArrayList)object6).size() > 0) {
                Object object8 = object7;
                ((StringBuilder)object8).deleteCharAt(((StringBuilder)object8).length() - 1);
            }
            object6 = ((StringBuilder)object7).toString();
        }
        for (int i3 = 0; i3 < object3.size(); ++i3) {
            int n6 = ((Size)object3.get(i3)).getWidth();
            n3 = ((Size)object3.get(i3)).getHeight();
            if (n6 >= 240 && n3 >= 240 && (n6 >= 320 || n3 >= 320)) {
                object = "{\"w\":" + n6 + ",\"h\":" + n3 + "}";
                if (!((String)object5).isEmpty()) {
                    object = (String)object5 + "," + (String)object;
                }
            } else {
                object = object5;
            }
            object5 = object;
        }
        VideoCapture.cacheCapability(n2, context, "{" + (String)object2 + (String)object4 + "[" + (String)object5 + "]," + "\"format\":" + "[" + ("" + VideoCapture.translateToEngineFormat(35)) + "]," + "\"fps\":" + "[" + (String)object6 + "]}", VideoCaptureCamera2.getCaptureName());
        return 0;
    }

    private Rect cropRegionForZoom(float f2) {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        int n2 = videoCaptureCamera2.mSensorRect.width() / 2;
        int n3 = videoCaptureCamera2.mSensorRect.height() / 2;
        int n4 = (int)((float)videoCaptureCamera2.mSensorRect.width() * 0.5f / f2);
        int n5 = (int)((float)videoCaptureCamera2.mSensorRect.height() * 0.5f / f2);
        int n6 = n3;
        int n7 = n5;
        int n8 = n2;
        n2 -= n4;
        n5 = n3 - n5;
        n3 = n8 + n4;
        n4 = n6 + n7;
        return new Rect(n2, n5, n3, n4);
    }

    private static int clamp(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n4, n2));
    }

    private boolean isMeteringAreaAFSupported() {
        VideoCaptureCamera2 videoCaptureCamera2 = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera2.mId);
        if (videoCaptureCamera2 == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (Integer)videoCaptureCamera2.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF) >= 1;
    }

    private int getFrameOrientation() {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        int n2 = videoCaptureCamera2.checkOrientation();
        if (!videoCaptureCamera2.mIsCameraFacingFront) {
            n2 = 360 - n2;
        }
        return (VideoCaptureCamera2.getSensorOrientation(this.mId, this.mContext) + n2) % 360;
    }

    private int toCamera2ABMode(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            return n2;
        }
        return 3;
    }

    private int toCamera2NoiseMode(int n2) {
        if (n2 >= 0 && n2 <= 4) {
            return n2;
        }
        return 0;
    }

    private int toCamera2EdgeEnhanceMode(int n2) {
        if (n2 >= 0 && n2 <= 3) {
            return n2;
        }
        return 0;
    }

    private int toCamera2VideoStabilityMode(int n2) {
        if (n2 >= 0 && n2 <= 1) {
            return n2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setExposureCompensation_l(int n2) {
        Logging.i(TAG, "setExposureCompensation:" + n2);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera29.mContext, videoCaptureCamera29.mId);
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics cameraCharacteristics2 = cameraCharacteristics;
        cameraCharacteristics = (Rational)cameraCharacteristics2.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        Range range = (Range)cameraCharacteristics2.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        int n3 = (Integer)range.getUpper();
        int n4 = (Integer)range.getLower();
        Logging.i(TAG, "compensation step=" + cameraCharacteristics + ", min=" + n4 + ", max=" + n3);
        if (n2 <= n3) {
            n3 = n2;
        }
        if (n3 < n4) {
            n3 = n4;
        }
        if (videoCaptureCamera29.mPreviewThread == null || videoCaptureCamera29.mPreviewBuilder == null || videoCaptureCamera29.mCaptureSession == null) return;
        VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera29;
        Object object = videoCaptureCamera2.mCameraStateLock;
        synchronized (object) {
            block20: {
                Handler handler;
                if (videoCaptureCamera2.mPreviewThread == null) return;
                if (videoCaptureCamera29.mPreviewBuilder == null) return;
                if (videoCaptureCamera29.mCaptureSession == null) return;
                VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera29;
                VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera22;
                VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera22;
                VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera22;
                VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera22;
                Handler handler2 = handler;
                handler = new Handler(videoCaptureCamera29.mPreviewThread.getLooper());
                int n5 = (Integer)videoCaptureCamera23.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
                Logging.i(TAG, "bf cur index=" + n5);
                CaptureRequest.Builder builder = videoCaptureCamera24.mPreviewBuilder;
                int n6 = n3;
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION;
                builder.set(key, (Object)n6);
                CameraCaptureSession cameraCaptureSession = videoCaptureCamera25.mCaptureSession;
                VideoCaptureCamera2 videoCaptureCamera27 = videoCaptureCamera29;
                VideoCaptureCamera2 videoCaptureCamera28 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera29 = videoCaptureCamera27.mPreviewBuilder.build();
                cameraCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera29, videoCaptureCamera28.mCaptureCallback, handler2);
                int n7 = (Integer)videoCaptureCamera26.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
                StringBuilder stringBuilder = new StringBuilder().append("af cur index=").append(n7).append(", ev=");
                int n8 = n7 * cameraCharacteristics.getNumerator();
                Logging.i(TAG, stringBuilder.append(n8 / cameraCharacteristics.getDenominator()).toString());
                {
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        break block20;
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }
            }
            return;
        }
    }

    private static boolean isSupported(int n2, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ RectF[] access$402(VideoCaptureCamera2 videoCaptureCamera2, RectF[] rectFArray) {
        videoCaptureCamera2.rectArray = rectFArray;
        return rectFArray;
    }

    static /* synthetic */ int[] access$502(VideoCaptureCamera2 videoCaptureCamera2, int[] nArray) {
        videoCaptureCamera2.distanceArray = nArray;
        return nArray;
    }

    static /* synthetic */ MeteringRectangle[] access$602(VideoCaptureCamera2 videoCaptureCamera2, MeteringRectangle[] meteringRectangleArray) {
        videoCaptureCamera2.mAFAERegions = meteringRectangleArray;
        return meteringRectangleArray;
    }

    static /* synthetic */ void access$800(VideoCaptureCamera2 videoCaptureCamera2, CaptureRequest.Builder builder) {
        videoCaptureCamera2.addRegionsToCaptureRequestBuilder(builder);
    }

    static /* synthetic */ CameraCaptureSession access$900(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureSession;
    }

    static /* synthetic */ Object access$1000(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureSessionLock;
    }

    static /* synthetic */ CameraCaptureSession.CaptureCallback access$1100(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureCallback;
    }

    static /* synthetic */ MeteringRectangle[] access$1300() {
        return ZERO_WEIGHT_3A_REGION;
    }

    static /* synthetic */ CameraDevice access$1702(VideoCaptureCamera2 videoCaptureCamera2, CameraDevice cameraDevice) {
        videoCaptureCamera2.mCameraDevice = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ CameraCaptureSession access$902(VideoCaptureCamera2 videoCaptureCamera2, CameraCaptureSession cameraCaptureSession) {
        videoCaptureCamera2.mCaptureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ Object access$2100(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCameraStateLock;
    }

    static /* synthetic */ byte[] access$2200(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureData;
    }

    static /* synthetic */ ImageReader access$2300(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mImageReader;
    }

    static /* synthetic */ Object access$2400(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mImageReaderLock;
    }

    static /* synthetic */ void access$2500(Image image, byte[] byArray) {
        VideoCaptureCamera2.readImageIntoBuffer(image, byArray);
    }

    static /* synthetic */ int access$2600(VideoCaptureCamera2 videoCaptureCamera2) {
        return videoCaptureCamera2.mCaptureFormat;
    }

    static {
        MeteringRectangle meteringRectangle;
        MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[1];
        MeteringRectangle meteringRectangle2 = meteringRectangle;
        meteringRectangle = new MeteringRectangle(0, 0, 0, 0, 0);
        meteringRectangleArray[0] = meteringRectangle2;
        ZERO_WEIGHT_3A_REGION = meteringRectangleArray;
    }

    @Override
    public int UnRegisterNativeHandle() {
        this.mNativeVideoCaptureDeviceAndroid = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int allocate() {
        long l2;
        Object object;
        VideoCaptureCamera2 videoCaptureCamera22;
        block10: {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera22;
            object = videoCaptureCamera2.mCameraStateLock;
            // MONITORENTER : object
            if (videoCaptureCamera2.mCameraState == CameraState.OPENING) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring");
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object
            object = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera22.mContext, videoCaptureCamera22.mId);
            if (object != null) break block10;
            return -1;
        }
        if (VideoCapture.fetchCapability(videoCaptureCamera22.mId, videoCaptureCamera22.mContext, VideoCaptureCamera2.getCaptureName()) == null) {
            VideoCaptureCamera2.createCapabilities(videoCaptureCamera22.mId, videoCaptureCamera22.mContext);
        }
        if ((l2 = videoCaptureCamera22.mNativeVideoCaptureDeviceAndroid) != 0L) {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera22;
            videoCaptureCamera2.mIsAutoFaceFocusEnabled = videoCaptureCamera2.isAutoFaceFocusEnabled(l2);
            videoCaptureCamera2.faceDistaneEnabled = videoCaptureCamera2.isFaceDetectionEnabled(videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid);
        }
        Object object2 = object;
        videoCaptureCamera22.mCameraNativeOrientation = (Integer)object.get(CameraCharacteristics.SENSOR_ORIENTATION);
        videoCaptureCamera22.mManager = (CameraManager)videoCaptureCamera22.mContext.getSystemService("camera");
        object = (int[])object2.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        int n2 = (Integer)object2.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (((Object)object).length > 1 && n2 > 0) {
            videoCaptureCamera22.mFaceDetectSupported = true;
            int n3 = 0;
            int n4 = ((Object)object).length;
            for (int i2 = 0; i2 < n4; n3 += object[i2], ++i2) {
            }
            videoCaptureCamera22.mFaceDetectMode = n3 % 2 != 0 ? 1 : 2;
        }
        Logging.i(TAG, "allocate() face detection: " + videoCaptureCamera22.mFaceDetectMode + " " + n2 + " " + videoCaptureCamera22.mFaceDetectSupported);
        if (videoCaptureCamera22.mCameraStateThread == null) {
            videoCaptureCamera22.mCameraStateThread = new HandlerThread("CameraCallbackThread");
            videoCaptureCamera22.mCameraStateThread.start();
            videoCaptureCamera22.mStateHandler = new SafeHandler(videoCaptureCamera22.mCameraStateThread.getLooper());
        }
        VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera22;
        videoCaptureCamera22 = videoCaptureCamera2.mAvailabilityCallback;
        videoCaptureCamera22.mManager.registerAvailabilityCallback((CameraManager.AvailabilityCallback)videoCaptureCamera22, videoCaptureCamera2.mStateHandler);
        return 0;
    }

    @Override
    public int setCaptureFormat(int n2, int n3, boolean bl) {
        Logging.i(TAG, "setCaptureFormat: " + n2 + " type: " + n3 + " force texture oes: " + bl);
        VideoCapture.FORCE_TEXTURE_OES = bl;
        this.mCaptureOutputDataType = VideoCapture.translateToCaptureOutputDataType(n3);
        if (VideoCapture.translateToAndroidFormat(n2) != this.mCaptureFormat) {
            Logging.e(TAG, "For camera2 api, only YUV_420_888 format are supported");
            return -1;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int startCapture(int var1_1, int var2_4, int var3_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 9[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int stopCapture() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 10[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isTorchSupported() {
        Object object = VideoCaptureCamera2.getCameraCharacteristics(((VideoCapture)object).mContext, ((VideoCapture)object).mId);
        if (object == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (object = (Boolean)object.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)) == null ? false : (Boolean)object;
    }

    @Override
    public boolean isFocusSupported() {
        Object object = VideoCaptureCamera2.getCameraCharacteristics(((VideoCapture)object).mContext, ((VideoCapture)object).mId);
        if (object == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])object.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        object = nArray;
        if (nArray != null) {
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                if (1 != i2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExposureSupported() {
        Object object = VideoCaptureCamera2.getCameraCharacteristics(((VideoCapture)object).mContext, ((VideoCapture)object).mId);
        if (object == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] nArray = (int[])object.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        object = nArray;
        if (nArray != null) {
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                Logging.d(TAG, "isExposureSupported AE mode = " + (int)object[i2]);
                if (1 != i2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        VideoCaptureCamera2 videoCaptureCamera2 = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera2.mId);
        if (videoCaptureCamera2 == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return ((Float)videoCaptureCamera2.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue() > 1.0f;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!videoCaptureCamera2.isFocusSupported()) {
            return false;
        }
        VideoCaptureCamera2 videoCaptureCamera2 = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera2.mId);
        if (videoCaptureCamera2 == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        return (Integer)videoCaptureCamera2.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT) > 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int setZoom(float var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public float getMaxZoom() {
        if (this.mMaxZoom <= 0.0f) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1.0f;
            }
            this.mMaxZoom = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return this.mMaxZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setTorchMode(boolean bl) {
        block13: {
            block12: {
                Logging.d(TAG, "setFlashMode isTorchOn " + bl);
                Object object = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
                if (object == null) {
                    Logging.w(TAG, "warning cameraCharacteristics is null");
                    return -1;
                }
                if (this.mPreviewBuilder == null) {
                    return -1;
                }
                if (!((object = (Boolean)object.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)) == null ? false : (Boolean)object)) break block12;
                if (this.mPreviewThread == null || this.mPreviewBuilder == null || this.mCaptureSession == null) break block13;
                VideoCaptureCamera2 videoCaptureCamera2 = this;
                object = videoCaptureCamera2.mCaptureSessionLock;
                synchronized (object) {
                    Handler handler;
                    if (videoCaptureCamera2.mPreviewThread == null || this.mPreviewBuilder == null || this.mCaptureSession == null) break block13;
                    boolean bl2 = bl;
                    Handler handler2 = handler;
                    handler = new Handler(this.mPreviewThread.getLooper());
                    if (bl2) {
                        this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    } else {
                        this.mPreviewBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    }
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, handler2);
                    return 0;
                    {
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                    }
                }
            }
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int setFocus(float var1_1, float var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int setExposure(float var1_1, float var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setAutoFaceFocus(boolean bl) {
        block12: {
            block11: {
                Object object;
                boolean bl2 = videoCaptureCamera23.mIsAutoFaceFocusEnabled != bl;
                videoCaptureCamera23.mIsAutoFaceFocusEnabled = bl;
                if (!videoCaptureCamera23.mFaceDetectSupported || !bl2) break block11;
                if (videoCaptureCamera23.mPreviewThread == null || videoCaptureCamera23.mPreviewBuilder == null || (object = videoCaptureCamera23.mCaptureSessionLock) == null) break block12;
                synchronized (object) {
                    Handler handler;
                    if (videoCaptureCamera23.mPreviewThread == null || videoCaptureCamera23.mPreviewBuilder == null || videoCaptureCamera23.mCaptureSession == null) break block12;
                    VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera23;
                    Handler handler2 = handler;
                    handler = new Handler(videoCaptureCamera23.mPreviewThread.getLooper());
                    if (videoCaptureCamera2.mIsAutoFaceFocusEnabled) {
                        videoCaptureCamera23.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)videoCaptureCamera23.mFaceDetectMode);
                    } else {
                        if (videoCaptureCamera23.faceDistaneEnabled) {
                            Logging.w(TAG, "face detect did not turn off due to faceDistance on");
                            return 0;
                        }
                        videoCaptureCamera23.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                    }
                    VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera23;
                    VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera22.mPreviewBuilder.build();
                    videoCaptureCamera23.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera23, videoCaptureCamera22.mCaptureCallback, handler2);
                    return 0;
                    {
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                    }
                }
            }
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setFaceDetection(boolean bl) {
        block12: {
            block11: {
                boolean bl2 = videoCaptureCamera24.faceDistaneEnabled != bl;
                videoCaptureCamera24.faceDistaneEnabled = bl;
                if (!videoCaptureCamera24.mFaceDetectSupported || !bl2) break block11;
                if (videoCaptureCamera24.mPreviewThread == null || videoCaptureCamera24.mPreviewBuilder == null || videoCaptureCamera24.mCaptureSession == null) break block12;
                VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera24;
                Object object = videoCaptureCamera2.mCaptureSessionLock;
                synchronized (object) {
                    Handler handler;
                    if (videoCaptureCamera2.mPreviewThread == null || videoCaptureCamera24.mPreviewBuilder == null || videoCaptureCamera24.mCaptureSession == null) break block12;
                    VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera24;
                    Handler handler2 = handler;
                    handler = new Handler(videoCaptureCamera24.mPreviewThread.getLooper());
                    if (videoCaptureCamera22.faceDistaneEnabled) {
                        videoCaptureCamera24.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)videoCaptureCamera24.mFaceDetectMode);
                    } else {
                        if (videoCaptureCamera24.mIsAutoFaceFocusEnabled) {
                            Logging.w(TAG, "face detect did not turn off due to autoFocus on");
                            return 0;
                        }
                        videoCaptureCamera24.mPreviewBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                    }
                    VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera24;
                    VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23.mPreviewBuilder.build();
                    videoCaptureCamera24.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera24, videoCaptureCamera23.mCaptureCallback, handler2);
                    return 0;
                    {
                        catch (IllegalStateException illegalStateException) {
                            illegalStateException.printStackTrace();
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraAccessException.printStackTrace();
                        }
                    }
                }
            }
            Logging.w(TAG, "face detect no change");
        }
        return 0;
    }

    @Override
    public void deallocate() {
        CameraManager cameraManager = this.mManager;
        if (cameraManager != null) {
            cameraManager.unregisterAvailabilityCallback(this.mAvailabilityCallback);
            cameraManager = this.mCameraStateThread;
            if (cameraManager != null) {
                VideoCaptureCamera2 videoCaptureCamera2 = this;
                cameraManager.quitSafely();
                videoCaptureCamera2.mCameraStateThread = null;
                videoCaptureCamera2.mStateHandler = null;
            }
        }
    }

    @Override
    public void onTextureFrameAvailable(int n2, float[] fArray, long l2) {
        VideoCaptureCamera2 videoCaptureCamera2 = this;
        n2 = videoCaptureCamera2.getFrameOrientation();
        if (videoCaptureCamera2.mIsCameraFacingFront) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        fArray = RendererCommon.rotateTextureMatrix(fArray, 360 - n2);
        VideoCaptureCamera2 videoCaptureCamera22 = this;
        int n3 = videoCaptureCamera22.mCaptureWidth;
        int n4 = videoCaptureCamera22.mCaptureHeight;
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray);
        VideoFrame.TextureBuffer textureBuffer = this.mSurfaceTextureHelper.createTextureBuffer(n3, n4, matrix);
        this.onTextureBufferAvailable(textureBuffer, n2, l2);
        textureBuffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setAntiBandingMode(int n2) {
        int n3;
        block10: {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera27;
            videoCaptureCamera2.mAntiBandingMode = videoCaptureCamera2.toCamera2ABMode(n2);
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera27.mId);
            if (cameraCharacteristics == null) {
                return -1;
            }
            n3 = videoCaptureCamera27.mAntiBandingMode;
            int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES);
            if (nArray.length <= 0) break block10;
            int n4 = nArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                block11: {
                    if (nArray[i2] != n3) continue;
                    if (videoCaptureCamera27.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block11;
                    VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera27;
                    Object object = videoCaptureCamera22.mCaptureSessionLock;
                    synchronized (object) {
                        Handler handler;
                        if (videoCaptureCamera22.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block11;
                        VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera27;
                        VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23;
                        VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera23;
                        Handler handler2 = handler;
                        handler = new Handler(videoCaptureCamera27.mPreviewThread.getLooper());
                        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_ANTIBANDING_MODE;
                        videoCaptureCamera24.mPreviewBuilder.set(key, (Object)n3);
                        VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera27;
                        VideoCaptureCamera2 videoCaptureCamera27 = videoCaptureCamera26.mPreviewBuilder.build();
                        videoCaptureCamera25.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera27, videoCaptureCamera26.mCaptureCallback, handler2);
                        return 0;
                        {
                            catch (IllegalStateException illegalStateException) {
                                illegalStateException.printStackTrace();
                            }
                            catch (CameraAccessException cameraAccessException) {
                                cameraAccessException.printStackTrace();
                            }
                        }
                    }
                }
                Logging.i(TAG, "AgoraVideo set anti-banding = " + n3);
                return 0;
            }
        }
        Logging.i(TAG, "not supported anti-banding = " + n3);
        return -1;
    }

    @Override
    public int setExposureCompensation(int n2) {
        this.setExposureCompensation_l(n2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setNoiseReductionMode(int n2) {
        block9: {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera27;
            videoCaptureCamera2.mNoiseReductionMode = videoCaptureCamera2.toCamera2NoiseMode(n2);
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera27.mId);
            if (cameraCharacteristics == null) {
                return -1;
            }
            int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES);
            if (!VideoCaptureCamera2.isSupported(videoCaptureCamera27.mNoiseReductionMode, nArray) || videoCaptureCamera27.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
            VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera27;
            Object object = videoCaptureCamera22.mCaptureSessionLock;
            synchronized (object) {
                Handler handler;
                if (videoCaptureCamera22.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
                VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23;
                VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera23;
                Handler handler2 = handler;
                handler = new Handler(videoCaptureCamera27.mPreviewThread.getLooper());
                videoCaptureCamera24.mPreviewBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)videoCaptureCamera27.mNoiseReductionMode);
                Logging.i(TAG, "setNoiseReductionMode = " + n2);
                VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera27 = videoCaptureCamera26.mPreviewBuilder.build();
                videoCaptureCamera25.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera27, videoCaptureCamera26.mCaptureCallback, handler2);
                return 0;
                {
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported NoiseReductionMode = " + n2);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setEdgeEnhanceMode(int n2) {
        block9: {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera27;
            videoCaptureCamera2.mEdgeEnhanceMode = videoCaptureCamera2.toCamera2EdgeEnhanceMode(n2);
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera27.mId);
            if (cameraCharacteristics == null) {
                return -1;
            }
            int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.EDGE_AVAILABLE_EDGE_MODES);
            if (!VideoCaptureCamera2.isSupported(videoCaptureCamera27.mEdgeEnhanceMode, nArray) || videoCaptureCamera27.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
            VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera27;
            Object object = videoCaptureCamera22.mCaptureSessionLock;
            synchronized (object) {
                Handler handler;
                if (videoCaptureCamera22.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
                VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23;
                VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera23;
                Handler handler2 = handler;
                handler = new Handler(videoCaptureCamera27.mPreviewThread.getLooper());
                videoCaptureCamera24.mPreviewBuilder.set(CaptureRequest.EDGE_MODE, (Object)videoCaptureCamera27.mEdgeEnhanceMode);
                Logging.i(TAG, "setEdgeEnhanceMode = " + n2);
                VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera27 = videoCaptureCamera26.mPreviewBuilder.build();
                videoCaptureCamera25.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera27, videoCaptureCamera26.mCaptureCallback, handler2);
                return 0;
                {
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported EdgeEnhance Mode = " + n2);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setVideoStabilityMode(int n2) {
        block9: {
            VideoCaptureCamera2 videoCaptureCamera2 = videoCaptureCamera27;
            videoCaptureCamera2.mVideoStabilityMode = videoCaptureCamera2.toCamera2VideoStabilityMode(n2);
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(videoCaptureCamera2.mContext, videoCaptureCamera27.mId);
            if (cameraCharacteristics == null) {
                return -1;
            }
            int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            if (!VideoCaptureCamera2.isSupported(videoCaptureCamera27.mVideoStabilityMode, nArray) || videoCaptureCamera27.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
            VideoCaptureCamera2 videoCaptureCamera22 = videoCaptureCamera27;
            Object object = videoCaptureCamera22.mCaptureSessionLock;
            synchronized (object) {
                Handler handler;
                if (videoCaptureCamera22.mPreviewThread == null || videoCaptureCamera27.mPreviewBuilder == null || videoCaptureCamera27.mCaptureSession == null) break block9;
                VideoCaptureCamera2 videoCaptureCamera23 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera24 = videoCaptureCamera23;
                VideoCaptureCamera2 videoCaptureCamera25 = videoCaptureCamera23;
                Handler handler2 = handler;
                handler = new Handler(videoCaptureCamera27.mPreviewThread.getLooper());
                videoCaptureCamera24.mPreviewBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)videoCaptureCamera27.mVideoStabilityMode);
                Logging.i(TAG, "setVideoStabilityMode = " + n2);
                VideoCaptureCamera2 videoCaptureCamera26 = videoCaptureCamera27;
                VideoCaptureCamera2 videoCaptureCamera27 = videoCaptureCamera26.mPreviewBuilder.build();
                videoCaptureCamera25.mCaptureSession.setRepeatingRequest((CaptureRequest)videoCaptureCamera27, videoCaptureCamera26.mCaptureCallback, handler2);
                return 0;
                {
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                }
            }
        }
        Logging.e(TAG, "not supported VideoStability Mode = " + n2);
        return -1;
    }

    private class ImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private ImageReaderListener() {
        }

        /*
         * Exception decompiling
         */
        public void onImageAvailable(ImageReader var1_4) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 25[TRYBLOCK] [35 : 391->400)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class CaptureSessionListener
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionListener() {
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            CaptureSessionListener captureSessionListener = videoCaptureCamera2;
            VideoCaptureCamera2.access$902(captureSessionListener.VideoCaptureCamera2.this, cameraCaptureSession);
            if (captureSessionListener.VideoCaptureCamera2.this.createCaptureRequest() != 0) {
                CaptureSessionListener captureSessionListener2 = videoCaptureCamera2;
                captureSessionListener2.VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                VideoCaptureCamera2 videoCaptureCamera2 = captureSessionListener2.VideoCaptureCamera2.this;
                long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
                if (l2 != 0L) {
                    videoCaptureCamera2.onCameraError(l2, "Fail to setup capture session");
                }
            } else {
                ((CaptureSessionListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STARTED);
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Logging.e(VideoCaptureCamera2.TAG, "onConfigureFailed");
            if (((CaptureSessionListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                ((CaptureSessionListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            }
            VideoCaptureCamera2 videoCaptureCamera2 = ((CaptureSessionListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this;
            long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
            if (l2 != 0L) {
                videoCaptureCamera2.onCameraError(l2, "Camera session configuration error");
            }
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            CrStateListener crStateListener = videoCaptureCamera2;
            VideoCaptureCamera2.access$1702(crStateListener.VideoCaptureCamera2.this, cameraDevice);
            if (crStateListener.VideoCaptureCamera2.this.doStartCapture() < 0) {
                CrStateListener crStateListener2 = videoCaptureCamera2;
                crStateListener2.VideoCaptureCamera2.this.doStopCapture();
                if (crStateListener2.VideoCaptureCamera2.this.mCameraState != CameraState.EVICTED) {
                    ((CrStateListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                }
                Logging.e(VideoCaptureCamera2.TAG, "Camera startCapture failed!!");
                VideoCaptureCamera2 videoCaptureCamera2 = ((CrStateListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this;
                long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
                if (l2 != 0L) {
                    videoCaptureCamera2.onCameraError(l2, "Error configuring camera");
                }
            }
        }

        public void onDisconnected(CameraDevice object) {
            if (VideoCaptureCamera2.this.mCameraState != CameraState.STOPPED) {
                Logging.w(VideoCaptureCamera2.TAG, "camera client is evicted by other application");
                object = VideoCaptureCamera2.this;
                long l2 = ((VideoCapture)object).mNativeVideoCaptureDeviceAndroid;
                if (l2 != 0L) {
                    ((VideoCapture)object).onCameraError(l2, "Camera device evicted by other application");
                }
                Logging.i(VideoCaptureCamera2.TAG, "Camera device enter state: EVICTED");
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    CrStateListener crStateListener = this;
                    crStateListener.VideoCaptureCamera2.this.mCameraDevice.close();
                    VideoCaptureCamera2.access$1702(crStateListener.VideoCaptureCamera2.this, null);
                }
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.EVICTED);
                return;
            }
        }

        public void onError(CameraDevice cameraDevice, int n2) {
            if (((CrStateListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.mCameraState == CameraState.EVICTED) {
                return;
            }
            if (((CrStateListener)((Object)videoCaptureCamera2)).VideoCaptureCamera2.this.mCameraDevice != null) {
                CrStateListener crStateListener = videoCaptureCamera2;
                crStateListener.VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.access$1702(crStateListener.VideoCaptureCamera2.this, null);
            }
            CrStateListener crStateListener = videoCaptureCamera2;
            crStateListener.VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            Logging.e(VideoCaptureCamera2.TAG, "CameraDevice Error :" + Integer.toString(n2));
            VideoCaptureCamera2 videoCaptureCamera2 = crStateListener.VideoCaptureCamera2.this;
            long l2 = videoCaptureCamera2.mNativeVideoCaptureDeviceAndroid;
            if (l2 != 0L) {
                videoCaptureCamera2.onCameraError(l2, "Camera device error" + Integer.toString(n2));
            }
        }
    }

    private static class SafeHandler
    extends Handler {
        public SafeHandler(Looper looper) {
            super(looper);
        }

        public void dispatchMessage(Message message) {
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                Logging.e(VideoCaptureCamera2.TAG, "handler exception", throwable);
            }
        }
    }

    private static final class CameraState
    extends Enum<CameraState> {
        public static final /* enum */ CameraState OPENING;
        public static final /* enum */ CameraState STARTED;
        public static final /* enum */ CameraState EVICTED;
        public static final /* enum */ CameraState STOPPED;
        private static final /* synthetic */ CameraState[] $VALUES;

        public static CameraState[] values() {
            return (CameraState[])$VALUES.clone();
        }

        public static CameraState valueOf(String string2) {
            return Enum.valueOf(CameraState.class, string2);
        }

        static {
            CameraState cameraState;
            OPENING = new CameraState();
            STARTED = new CameraState();
            EVICTED = new CameraState();
            CameraState cameraState2 = cameraState;
            STOPPED = new CameraState();
            $VALUES = new CameraState[]{OPENING, STARTED, EVICTED, cameraState2};
        }
    }
}

