/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCapture;
import io.agora.rtc.video.VideoCaptureCamera;
import io.agora.rtc.video.VideoCaptureCamera2;

public class VideoCaptureFactory {
    private static final String TAG = "CAM-FACTORY";
    private static final int ANDROID_CAMERA_NOT_DEFINE = -1;
    private static final int ANDROID_CAMERA1 = 0;
    private static final int ANDROID_CAMERA2 = 1;

    public static boolean isLReleaseOrLater() {
        if ("ocean".equalsIgnoreCase(Build.DEVICE) && "oe106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("trident".equalsIgnoreCase(Build.DEVICE) && "de106".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("shark".equalsIgnoreCase(Build.DEVICE) && "skr-a0".equalsIgnoreCase(Build.MODEL)) {
            return false;
        }
        if ("hnnem-h".equalsIgnoreCase(Build.DEVICE)) {
            return false;
        }
        if ("on7xelte".equals(Build.DEVICE) && "SM-G610F".equals(Build.MODEL)) {
            return false;
        }
        if (!"m2c".equals(Build.DEVICE) && !"M578CA".equals(Build.MODEL)) {
            String string2;
            if ("samsung".equalsIgnoreCase(Build.MANUFACTURER) && (string2 = Build.MODEL) != null && (string2.contains("SM-G930") || Build.MODEL.contains("SM-G935") || Build.MODEL.contains("SM-G950") || Build.MODEL.contains("SM-G955") || "SC-02H".equals(Build.MODEL) || "SCV33".equals(Build.MODEL) || "SC-02J".equals(Build.MODEL) || "SCV36".equals(Build.MODEL) || "SM-G892A".equals(Build.MODEL) || "SM-G892U".equals(Build.MODEL) || "SC-03J".equals(Build.MODEL) || "SCV35".equals(Build.MODEL))) {
                return false;
            }
            if ("oneplus".equalsIgnoreCase(Build.MANUFACTURER) && !Build.MODEL.contains("ONEPLUS A6")) {
                return false;
            }
            return Build.VERSION.SDK_INT >= 21;
        }
        return false;
    }

    public static VideoCapture createVideoCapture(Context context, int n2, int n3, int n4, int n5, EglBase.Context context2, long l2) {
        Logging.i(TAG, "createVideoCapture id: " + n2 + " select: " + n3 + " pqFirst: " + n4 + " lowPowerFlag: " + n5);
        if (n5 != VideoCaptureFactory.fetchLowPowerFlag(context)) {
            Context context3 = context;
            VideoCaptureFactory.cacheLowPowerFlag(context3, n5);
            VideoCapture.clearCapabilityCache(context3);
        }
        if (VideoCaptureFactory.checkCamera2Availability(n2, context, n3)) {
            Logging.d(TAG, "create CAMERA2, id:" + n2);
            return new VideoCaptureCamera2(context, n2, n4, context2, l2);
        }
        Logging.d(TAG, "create CAMERA1, id:" + n2);
        return new VideoCaptureCamera(context, n2, n4, context2, l2);
    }

    public static int getNumberOfCameras(Context context) {
        return AndroidCameraInfo.getNumberOfCameras(context);
    }

    public static int getFrontCameraIndex(Context context) {
        int n2 = DeviceUtils.selectFrontCamera(context);
        Logging.i(TAG, "getFrontCameraIndex  = " + n2);
        return n2;
    }

    public static String getDeviceName(int n2, Context context, int n3) {
        if (VideoCaptureFactory.checkCamera2Availability(n2, context, n3)) {
            return VideoCaptureCamera2.getName(n2, context);
        }
        return VideoCaptureCamera.getName(n2);
    }

    public static boolean checkCamera2Availability(int n2, Context context, int n3) {
        return n3 == 1 && VideoCaptureFactory.isLReleaseOrLater() || n3 == -1 && VideoCaptureFactory.isLReleaseOrLater() && !VideoCaptureCamera2.isLegacyDevice(context, n2);
    }

    public static int getDeviceOrientation(int n2, Context context, int n3) {
        if (VideoCaptureFactory.checkCamera2Availability(n2, context, n3)) {
            return VideoCaptureCamera2.getSensorOrientation(n2, context);
        }
        return VideoCaptureCamera.getSensorOrientation(n2);
    }

    public static String getCapabilities(int n2, Context context, int n3) {
        String string2 = VideoCaptureFactory.checkCamera2Availability(n2, context, n3) ? VideoCapture.fetchCapability(n2, context, VideoCaptureCamera2.getCaptureName()) : VideoCapture.fetchCapability(n2, context, VideoCaptureCamera.getCaptureName());
        if (string2 == null) {
            Logging.e(TAG, "Capability hasn't been created");
        } else {
            VideoCaptureFactory.printCameraInfo(string2);
        }
        return string2;
    }

    public static void cacheLowPowerFlag(Context context, int n2) {
        SharedPreferences.Editor editor = context.getSharedPreferences("CamCapsLowPower", 0).edit();
        editor.putInt("Cam_LowPower", n2);
        editor.commit();
    }

    public static int fetchLowPowerFlag(Context context) {
        if ((context = context.getSharedPreferences("CamCapsLowPower", 0)) != null) {
            return context.getInt("Cam_LowPower", -1);
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public static int printCameraInfo(String var0) {
        var1_1 = 150;
        var2_2 = var0.length() / var1_1 + 1;
        for (var3_3 = 0; var3_3 < var2_2; ++var3_3) {
            block10: {
                var4_4 = "lines = " + var2_2 + ":";
                if (var3_3 != var2_2 - 1) break block10;
                v0 = new StringBuilder().append(var4_4);
                v1 = var0;
                var4_5 = var3_3 * var1_1;
                v2 = v0.append(v1.substring(var4_5, v1.length())).toString();
lbl13:
                // 2 sources

                while (true) {
                    var4_4 = v2;
                    ** GOTO lbl24
                    break;
                }
            }
            v3 = new StringBuilder().append(var4_4);
            v4 = var3_3;
            var4_6 = v4 * var1_1;
            try {
                v2 = v3.append(var0.substring(var4_6, (v4 + 1) * var1_1)).toString();
                ** continue;
lbl24:
                // 1 sources

                Logging.d("CameraInfo", var4_4);
                continue;
            }
            catch (IndexOutOfBoundsException v5) {
                v5.printStackTrace();
            }
        }
        return 0;
    }

    static class AndroidCameraInfo {
        AndroidCameraInfo() {
        }

        private static int getNumberOfCameras(Context context) {
            int n2;
            if (Build.VERSION.SDK_INT < 23 && context.getPackageManager().checkPermission("android.permission.CAMERA", context.getPackageName()) != 0) {
                int n3 = 0;
                Log.e((String)VideoCaptureFactory.TAG, (String)"Missing android.permission.CAMERA permission, no system camera available");
                n2 = n3;
            } else {
                n2 = 0;
                if (VideoCaptureFactory.isLReleaseOrLater()) {
                    n2 = VideoCaptureCamera2.getNumberOfCameras(context);
                }
                if (n2 == 0) {
                    n2 = VideoCaptureCamera.getNumberOfCameras();
                }
            }
            return n2;
        }
    }
}

