/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import java.nio.ByteBuffer;

public class VideoRenderer {
    long nativeVideoRenderer;

    public static native void nativeCopyPlane(ByteBuffer var0, int var1, int var2, int var3, ByteBuffer var4, int var5);

    public static void renderFrameDone(I420Frame i420Frame) {
        i420Frame.yuvPlanes = null;
        i420Frame.textureId = 0;
        if (i420Frame.nativeFramePointer != 0L) {
            I420Frame i420Frame2 = i420Frame;
            VideoRenderer.releaseNativeFrame(i420Frame2.nativeFramePointer);
            I420Frame.access$002(i420Frame2, 0L);
        }
    }

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeWrapVideoRenderer(callbacks);
    }

    private static native long nativeWrapVideoRenderer(Callbacks var0);

    private static native void freeWrappedVideoRenderer(long var0);

    private static native void releaseNativeFrame(long var0);

    public void dispose() {
        long l2 = this.nativeVideoRenderer;
        if (l2 == 0L) {
            return;
        }
        VideoRenderer.freeWrappedVideoRenderer(l2);
        this.nativeVideoRenderer = 0L;
    }

    public static interface Callbacks {
        public void renderFrame(I420Frame var1);
    }

    public static class I420Frame {
        public final int width;
        public final int height;
        public final int[] yuvStrides;
        public ByteBuffer[] yuvPlanes;
        public final boolean yuvFrame;
        public final float[] samplingMatrix;
        public int textureId;
        private long nativeFramePointer;
        public int rotationDegree;

        I420Frame(int n2, int n3, int n4, int[] nArray, ByteBuffer[] byteBufferArray, long l2) {
            I420Frame i420Frame = object;
            ((I420Frame)object).width = n2;
            ((I420Frame)object).height = n3;
            ((I420Frame)object).yuvStrides = nArray;
            i420Frame.yuvPlanes = byteBufferArray;
            i420Frame.yuvFrame = true;
            ((I420Frame)object).rotationDegree = n4;
            ((I420Frame)object).nativeFramePointer = l2;
            if (n4 % 90 == 0) {
                I420Frame i420Frame2 = object;
                float[] fArray = new float[16];
                Object object = fArray;
                fArray[0] = 1.0f;
                fArray[1] = 0.0f;
                fArray[2] = 0.0f;
                fArray[3] = 0.0f;
                fArray[4] = 0.0f;
                fArray[5] = -1.0f;
                fArray[6] = 0.0f;
                fArray[7] = 0.0f;
                fArray[8] = 0.0f;
                fArray[9] = 0.0f;
                fArray[10] = 1.0f;
                fArray[11] = 0.0f;
                fArray[12] = 0.0f;
                fArray[13] = 1.0f;
                fArray[14] = 0.0f;
                fArray[15] = 1.0f;
                i420Frame2.samplingMatrix = (float[])object;
                return;
            }
            throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
        }

        I420Frame(int n2, int n3, int n4, int n5, float[] fArray, long l2) {
            I420Frame i420Frame = this;
            I420Frame i420Frame2 = this;
            this.width = n2;
            i420Frame2.height = n3;
            i420Frame2.yuvStrides = null;
            i420Frame2.yuvPlanes = null;
            this.samplingMatrix = fArray;
            i420Frame.textureId = n5;
            i420Frame.yuvFrame = false;
            this.rotationDegree = n4;
            this.nativeFramePointer = l2;
            if (n4 % 90 == 0) {
                return;
            }
            throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
        }

        static /* synthetic */ long access$002(I420Frame i420Frame, long l2) {
            i420Frame.nativeFramePointer = l2;
            return l2;
        }

        public int rotatedWidth() {
            return this.rotationDegree % 180 == 0 ? this.width : this.height;
        }

        public int rotatedHeight() {
            return this.rotationDegree % 180 == 0 ? this.height : this.width;
        }

        public String toString() {
            return this.width + "x" + this.height + ":" + this.yuvStrides[0] + ":" + this.yuvStrides[1] + ":" + this.yuvStrides[2];
        }
    }
}

