/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import android.content.Context;
import io.agora.common.AgoraServiceJNI;
import io.agora.common.annotation.NonNull;
import io.agora.common.annotation.Nullable;
import io.agora.rtm.ChannelAttributeOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmAttribute;
import io.agora.rtm.RtmCallManager;
import io.agora.rtm.RtmChannel;
import io.agora.rtm.RtmChannelAttribute;
import io.agora.rtm.RtmChannelListener;
import io.agora.rtm.RtmChannelMemberCount;
import io.agora.rtm.RtmClientListener;
import io.agora.rtm.RtmFileMessage;
import io.agora.rtm.RtmImageMessage;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.RtmRequestId;
import io.agora.rtm.RtmServiceContext;
import io.agora.rtm.SendMessageOptions;
import io.agora.rtm.internal.RtmManager;
import io.agora.rtm.jni.SET_RTM_SERVICE_CONTEXT_ERR_CODE;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RtmClient {
    public static final int LOG_FILTER_OFF = 0;
    public static final int LOG_FILTER_INFO = 15;
    public static final int LOG_FILTER_WARNING = 14;
    public static final int LOG_FILTER_ERROR = 12;
    public static final int LOG_FILTER_CRITICAL = 8;
    public static final String AGORA_RTM_END_CALL_PREFIX = "AgoraRTMLegacyEndcallCompatibleMessagePrefix";

    public static RtmClient createInstance(@NonNull Context context, @NonNull String string2, @NonNull RtmClientListener rtmClientListener) throws Exception {
        return RtmManager.createRtmInstance(context, string2, rtmClientListener);
    }

    public static String getSdkVersion() {
        if (!AgoraServiceJNI.ensureNativeInitialized()) {
            return "";
        }
        return AgoraServiceJNI.nativeGetSdkVersion();
    }

    public static SET_RTM_SERVICE_CONTEXT_ERR_CODE setRtmServiceContext(RtmServiceContext rtmServiceContext) {
        return SET_RTM_SERVICE_CONTEXT_ERR_CODE.swigToEnum(RtmManager.setRtmServiceContext(rtmServiceContext));
    }

    static {
        RtmManager.initializeNative();
    }

    public abstract void release();

    public abstract void login(@Nullable String var1, @NonNull String var2, @Nullable ResultCallback<Void> var3);

    public abstract void logout(@Nullable ResultCallback<Void> var1);

    public abstract RtmMessage createMessage();

    public abstract RtmMessage createMessage(String var1);

    public abstract RtmMessage createMessage(byte[] var1);

    public abstract RtmMessage createMessage(byte[] var1, String var2);

    public abstract RtmFileMessage createFileMessageByMediaId(@NonNull String var1);

    public abstract RtmImageMessage createImageMessageByMediaId(@NonNull String var1);

    public abstract void createFileMessageByUploading(@NonNull String var1, RtmRequestId var2, ResultCallback<RtmFileMessage> var3);

    public abstract void createImageMessageByUploading(@NonNull String var1, RtmRequestId var2, ResultCallback<RtmImageMessage> var3);

    public abstract void downloadMediaToMemory(@NonNull String var1, RtmRequestId var2, ResultCallback<byte[]> var3);

    public abstract void downloadMediaToFile(@NonNull String var1, @NonNull String var2, RtmRequestId var3, ResultCallback<Void> var4);

    public abstract void cancelMediaUpload(RtmRequestId var1, ResultCallback<Void> var2);

    public abstract void cancelMediaDownload(RtmRequestId var1, ResultCallback<Void> var2);

    public abstract void sendMessageToPeer(@NonNull String var1, @NonNull RtmMessage var2, @Nullable ResultCallback<Void> var3);

    public abstract void sendMessageToPeer(@NonNull String var1, @NonNull RtmMessage var2, @NonNull SendMessageOptions var3, @Nullable ResultCallback<Void> var4);

    public abstract RtmChannel createChannel(@NonNull String var1, @NonNull RtmChannelListener var2) throws RuntimeException;

    public abstract RtmCallManager getRtmCallManager();

    public abstract void queryPeersOnlineStatus(Set<String> var1, ResultCallback<Map<String, Boolean>> var2);

    public abstract void subscribePeersOnlineStatus(Set<String> var1, ResultCallback<Void> var2);

    public abstract void unsubscribePeersOnlineStatus(Set<String> var1, ResultCallback<Void> var2);

    public abstract void queryPeersBySubscriptionOption(Integer var1, ResultCallback<Set<String>> var2);

    public abstract void renewToken(String var1, ResultCallback<Void> var2);

    public abstract void setLocalUserAttributes(List<RtmAttribute> var1, ResultCallback<Void> var2);

    public abstract void addOrUpdateLocalUserAttributes(List<RtmAttribute> var1, ResultCallback<Void> var2);

    public abstract void deleteLocalUserAttributesByKeys(List<String> var1, ResultCallback<Void> var2);

    public abstract void clearLocalUserAttributes(ResultCallback<Void> var1);

    public abstract void getUserAttributes(String var1, ResultCallback<List<RtmAttribute>> var2);

    public abstract void getUserAttributesByKeys(String var1, List<String> var2, ResultCallback<List<RtmAttribute>> var3);

    public abstract void setChannelAttributes(String var1, List<RtmChannelAttribute> var2, ChannelAttributeOptions var3, ResultCallback<Void> var4);

    public abstract void addOrUpdateChannelAttributes(String var1, List<RtmChannelAttribute> var2, ChannelAttributeOptions var3, ResultCallback<Void> var4);

    public abstract void deleteChannelAttributesByKeys(String var1, List<String> var2, ChannelAttributeOptions var3, ResultCallback<Void> var4);

    public abstract void clearChannelAttributes(String var1, ChannelAttributeOptions var2, ResultCallback<Void> var3);

    public abstract void getChannelAttributes(String var1, ResultCallback<List<RtmChannelAttribute>> var2);

    public abstract void getChannelAttributesByKeys(String var1, List<String> var2, ResultCallback<List<RtmChannelAttribute>> var3);

    public abstract void getChannelMemberCount(List<String> var1, ResultCallback<List<RtmChannelMemberCount>> var2);

    public abstract int setParameters(String var1);

    public abstract int setLogFile(String var1);

    public abstract int setLogFilter(int var1);

    public abstract int setLogFileSize(int var1);
}

