/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import io.agora.common.Logging;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgoraSysUtils {
    private static final String TAG = "AgoraSysUtils";

    public static String getAppStorageDir(Context context) {
        if (context == null) {
            return null;
        }
        if (context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            File file = new File(Environment.getExternalStorageDirectory().getAbsolutePath(), context.getApplicationInfo().packageName);
            file.mkdirs();
            return file.getAbsolutePath();
        }
        Logging.w(TAG, "write external storage is not granted");
        return null;
    }

    public static String getCacheDir(Context context) {
        return context.getCacheDir().getAbsolutePath();
    }

    public static String getNativeLibraryDir(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    public static String getDeviceId() {
        String string2 = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        Matcher matcher = Pattern.compile(".*[A-Z][A-M][0-9]$").matcher(Build.ID);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            string2 = "yeshen/simulator/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return string2;
    }

    public static String getDeviceInfo() {
        String string2 = Build.MANUFACTURER + "/" + Build.MODEL;
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    public static String getSystemInfo() {
        return "Android/" + Build.VERSION.RELEASE;
    }
}

