/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.LocalInvitation;
import io.agora.rtm.jni.ILocalCallInvitation;
import io.agora.rtm.jni.IRtmCallManager;

class LocalInvitationWrapper
implements LocalInvitation {
    private static final String TAG = "LocalInvitationWrapper";
    private String calleeId;
    private String content = "";
    private String channelId = "";
    ILocalCallInvitation invitationNative;

    private LocalInvitationWrapper(ILocalCallInvitation iLocalCallInvitation, String string2) {
        this.invitationNative = iLocalCallInvitation;
        this.calleeId = string2;
    }

    static LocalInvitationWrapper create(@NonNull IRtmCallManager object, String string2) {
        Object object2;
        if ((object = ((IRtmCallManager)object).createLocalCallInvitation(string2)) == null) {
            object2 = object = null;
        } else {
            LocalInvitationWrapper localInvitationWrapper;
            object2 = localInvitationWrapper;
            localInvitationWrapper = new LocalInvitationWrapper((ILocalCallInvitation)object, string2);
        }
        return object2;
    }

    private boolean isNativeNull() {
        if (this.invitationNative == null) {
            Logging.e(TAG, "native is null!");
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        LocalInvitationWrapper localInvitationWrapper = this;
        super.finalize();
        if (!localInvitationWrapper.isNativeNull()) {
            this.invitationNative.release();
        }
    }

    @Override
    public String getCalleeId() {
        return this.calleeId;
    }

    @Override
    public void setContent(String string2) {
        this.content = string2;
        if (!this.isNativeNull()) {
            this.invitationNative.setContent(string2);
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setChannelId(String string2) {
        this.channelId = string2;
        if (!this.isNativeNull()) {
            this.invitationNative.setChannelId(string2);
        }
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getResponse() {
        return this.isNativeNull() ? "" : this.invitationNative.getResponse();
    }

    @Override
    public int getState() {
        return this.isNativeNull() ? 0 : this.invitationNative.getState().swigValue();
    }

    public String toString() {
        return "localInvitation {callee: " + this.getCalleeId() + ", channelId: " + this.getChannelId() + "}";
    }
}

