/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.RemoteInvitation;
import io.agora.rtm.jni.IRemoteCallInvitation;

class RemoteInvitationWrapper
implements RemoteInvitation {
    private static final String TAG = "RemoteInvitationWrapper";
    private String callerId = "";
    private String response = "";
    IRemoteCallInvitation invitationNative;

    RemoteInvitationWrapper(@NonNull IRemoteCallInvitation iRemoteCallInvitation) {
        this.invitationNative = iRemoteCallInvitation;
    }

    private boolean isNativeNull() {
        if (this.invitationNative == null) {
            Logging.e(TAG, "native is null!");
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        RemoteInvitationWrapper remoteInvitationWrapper = this;
        super.finalize();
        if (!remoteInvitationWrapper.isNativeNull()) {
            this.invitationNative.release();
        }
    }

    @Override
    public String getCallerId() {
        String string2 = this.callerId;
        if (string2 == null || string2.isEmpty()) {
            string2 = this.isNativeNull() ? "" : this.invitationNative.getCallerId();
            this.callerId = string2;
        }
        return this.callerId;
    }

    @Override
    public String getContent() {
        return this.isNativeNull() ? "" : this.invitationNative.getContent();
    }

    @Override
    public String getChannelId() {
        return this.isNativeNull() ? "" : this.invitationNative.getChannelId();
    }

    @Override
    public void setResponse(String string2) {
        this.response = string2;
        if (!this.isNativeNull()) {
            this.invitationNative.setResponse(string2);
        }
    }

    @Override
    public String getResponse() {
        return this.response;
    }

    @Override
    public int getState() {
        return this.isNativeNull() ? 0 : this.invitationNative.getState().swigValue();
    }

    public String toString() {
        return "remoteInvitation {callerId: " + this.getCallerId() + ", channelId: " + this.getChannelId() + "}";
    }
}

