/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.LocalInvitation;
import io.agora.rtm.RemoteInvitation;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmCallEventListener;
import io.agora.rtm.RtmCallManager;
import io.agora.rtm.internal.LocalInvitationWrapper;
import io.agora.rtm.internal.RemoteInvitationWrapper;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.ILocalCallInvitation;
import io.agora.rtm.jni.INVITATION_API_CALL_ERR_CODE;
import io.agora.rtm.jni.IRemoteCallInvitation;
import io.agora.rtm.jni.IRtmCallEventHandler;
import io.agora.rtm.jni.IRtmCallManager;
import io.agora.rtm.jni.LOCAL_INVITATION_ERR_CODE;
import io.agora.rtm.jni.REMOTE_INVITATION_ERR_CODE;
import java.util.concurrent.atomic.AtomicReference;

class RtmCallManagerImpl
extends RtmCallManager {
    private static final String TAG = "RtmCallManagerImpl";
    private RtmClientImpl rtmClient;
    private AtomicReference<RtmCallEventListener> eventListenerAtomic = new AtomicReference();
    private IRtmCallManager callManagerNative;
    private CallEventHandlerNative callEventListenerNative;
    final byte[] lock = new byte[0];
    boolean isNativeAttached = false;
    private LruCache<Long, LocalInvitationWrapper> localInvitationLruCache = new LruCache(50);
    private LruCache<Long, RemoteInvitationWrapper> remoteInvitationLruCache = new LruCache(50);

    RtmCallManagerImpl() {
    }

    private static void handleApiCallResult(@NonNull INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE, ResultCallback<Void> object) {
        if (object == null) {
            return;
        }
        if (iNVITATION_API_CALL_ERR_CODE == INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_OK) {
            object.onSuccess(null);
        } else {
            ErrorInfo errorInfo;
            ResultCallback<Void> resultCallback = object;
            object = errorInfo;
            INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE2 = iNVITATION_API_CALL_ERR_CODE;
            int n2 = iNVITATION_API_CALL_ERR_CODE2.swigValue();
            errorInfo = new ErrorInfo(n2, iNVITATION_API_CALL_ERR_CODE2.toString());
            resultCallback.onFailure((ErrorInfo)object);
        }
    }

    private boolean nativeNotInitialized() {
        if (((RtmCallManagerImpl)this).callManagerNative != null && (this = ((RtmCallManagerImpl)this).rtmClient) != null && ((RtmClientImpl)this).mRtmServiceNative != null) {
            return false;
        }
        Logging.w(TAG, "rtm native not ready");
        return true;
    }

    @NonNull
    private static INVITATION_API_CALL_ERR_CODE valueToApiCallErrEnumSafe(int n2) {
        try {
            return INVITATION_API_CALL_ERR_CODE.swigToEnum(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.e("RTM_EXCEPTION", illegalArgumentException.getMessage());
            return INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean attach(RtmClientImpl object) {
        RtmClientImpl rtmClientImpl = object;
        RtmCallManagerImpl rtmCallManagerImpl = this;
        RtmClientImpl rtmClientImpl2 = object;
        object = this.lock;
        synchronized (this.lock) {
            CallEventHandlerNative callEventHandlerNative;
            rtmCallManagerImpl.rtmClient = rtmClientImpl2;
            Object object2 = callEventHandlerNative;
            rtmCallManagerImpl.callEventListenerNative = new CallEventHandlerNative();
            object2 = rtmClientImpl.mRtmServiceNative.getRtmCallManager((IRtmCallEventHandler)object2);
            RtmCallManagerImpl rtmCallManagerImpl2 = this;
            rtmCallManagerImpl2.callManagerNative = object2;
            rtmCallManagerImpl2.isNativeAttached = true;
            boolean bl = object2 != null;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void detach() {
        RtmCallManagerImpl rtmCallManagerImpl = this;
        byte[] byArray = rtmCallManagerImpl.lock;
        synchronized (rtmCallManagerImpl.lock) {
            if (rtmCallManagerImpl.callManagerNative != null) {
                this.callManagerNative.release();
                this.callManagerNative = null;
            }
            if (this.callEventListenerNative != null) {
                this.callEventListenerNative.delete();
                this.callEventListenerNative = null;
            }
            RtmCallManagerImpl rtmCallManagerImpl2 = this;
            rtmCallManagerImpl2.rtmClient = null;
            rtmCallManagerImpl2.isNativeAttached = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setEventListener(RtmCallEventListener rtmCallEventListener) {
        this.eventListenerAtomic.set(rtmCallEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LocalInvitation createLocalInvitation(String object) {
        RtmCallManagerImpl rtmCallManagerImpl = this;
        Logging.i(TAG, "create call invitation, callee: " + Logging.desensetize((String)object));
        byte[] byArray = rtmCallManagerImpl.lock;
        synchronized (rtmCallManagerImpl.lock) {
            block7: {
                if (rtmCallManagerImpl.nativeNotInitialized()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                if ((object = LocalInvitationWrapper.create(this.callManagerNative, (String)object)) == null) {
                    Logging.e(TAG, "failed to create invitation");
                    break block7;
                }
                this.localInvitationLruCache.put(AgoraRtmServiceJNI.getLocalInvitationKey(((LocalInvitationWrapper)object).invitationNative), (LocalInvitationWrapper)object);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void sendLocalInvitation(LocalInvitation localInvitation, ResultCallback<Void> resultCallback) {
        Object object;
        Logging.i(TAG, "send invite");
        if (!(localInvitation instanceof LocalInvitationWrapper)) {
            Logging.e(TAG, "[send] invalid invitation: " + localInvitation);
            object = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE;
            RtmCallManagerImpl rtmCallManagerImpl = object;
            localInvitation = (LocalInvitationWrapper)localInvitation;
            byte[] byArray = rtmCallManagerImpl.lock;
            // MONITORENTER : rtmCallManagerImpl.lock
            if (rtmCallManagerImpl.nativeNotInitialized()) {
                iNVITATION_API_CALL_ERR_CODE = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int n2 = ((RtmCallManagerImpl)object).callManagerNative.sendLocalInvitation(((LocalInvitationWrapper)localInvitation).invitationNative);
                Logging.i(TAG, "send invite to " + Logging.desensetize(((LocalInvitationWrapper)localInvitation).getCalleeId()) + " ret: " + n2);
                iNVITATION_API_CALL_ERR_CODE = RtmCallManagerImpl.valueToApiCallErrEnumSafe(n2);
            }
            object = iNVITATION_API_CALL_ERR_CODE;
        }
        RtmCallManagerImpl.handleApiCallResult((INVITATION_API_CALL_ERR_CODE)object, resultCallback);
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : byArray
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void acceptRemoteInvitation(RemoteInvitation object, ResultCallback<Void> resultCallback) {
        Object object2;
        Logging.i(TAG, "accept invitation");
        if (!(object instanceof RemoteInvitationWrapper)) {
            Logging.e(TAG, "invalid invitation: " + object);
            object2 = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE;
            Object object3 = object;
            object = ((RtmCallManagerImpl)object2).lock;
            // MONITORENTER : ((io.agora.rtm.internal.RtmCallManagerImpl)object2).lock
            RemoteInvitationWrapper remoteInvitationWrapper = (RemoteInvitationWrapper)object3;
            if (((RtmCallManagerImpl)object2).nativeNotInitialized()) {
                iNVITATION_API_CALL_ERR_CODE = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int n2 = ((RtmCallManagerImpl)object2).callManagerNative.acceptRemoteInvitation(remoteInvitationWrapper.invitationNative);
                Logging.i(TAG, "accept invite from " + Logging.desensetize(remoteInvitationWrapper.getCallerId()) + " ret: " + n2);
                iNVITATION_API_CALL_ERR_CODE = RtmCallManagerImpl.valueToApiCallErrEnumSafe(n2);
            }
            object2 = iNVITATION_API_CALL_ERR_CODE;
        }
        RtmCallManagerImpl.handleApiCallResult((INVITATION_API_CALL_ERR_CODE)object2, resultCallback);
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void refuseRemoteInvitation(RemoteInvitation object, ResultCallback<Void> resultCallback) {
        Object object2;
        Logging.i(TAG, "refuse invitation");
        if (!(object instanceof RemoteInvitationWrapper)) {
            Logging.e(TAG, "refuse invalid invitation: " + object);
            object2 = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE;
            Object object3 = object;
            object = ((RtmCallManagerImpl)object2).lock;
            // MONITORENTER : ((io.agora.rtm.internal.RtmCallManagerImpl)object2).lock
            RemoteInvitationWrapper remoteInvitationWrapper = (RemoteInvitationWrapper)object3;
            if (((RtmCallManagerImpl)object2).nativeNotInitialized()) {
                iNVITATION_API_CALL_ERR_CODE = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int n2 = ((RtmCallManagerImpl)object2).callManagerNative.refuseRemoteInvitation(remoteInvitationWrapper.invitationNative);
                Logging.i(TAG, "refuse invite from " + Logging.desensetize(remoteInvitationWrapper.getCallerId()) + " ret: " + n2);
                iNVITATION_API_CALL_ERR_CODE = RtmCallManagerImpl.valueToApiCallErrEnumSafe(n2);
            }
            object2 = iNVITATION_API_CALL_ERR_CODE;
        }
        RtmCallManagerImpl.handleApiCallResult((INVITATION_API_CALL_ERR_CODE)object2, resultCallback);
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelLocalInvitation(LocalInvitation object, ResultCallback<Void> resultCallback) {
        Object object2;
        Logging.i(TAG, "cancel invitation");
        if (!(object instanceof LocalInvitationWrapper)) {
            Logging.e(TAG, "invalid invitation: " + object);
            object2 = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            INVITATION_API_CALL_ERR_CODE iNVITATION_API_CALL_ERR_CODE;
            Object object3 = object;
            object = ((RtmCallManagerImpl)object2).lock;
            // MONITORENTER : ((io.agora.rtm.internal.RtmCallManagerImpl)object2).lock
            LocalInvitationWrapper localInvitationWrapper = (LocalInvitationWrapper)object3;
            if (((RtmCallManagerImpl)object2).nativeNotInitialized()) {
                iNVITATION_API_CALL_ERR_CODE = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int n2 = ((RtmCallManagerImpl)object2).callManagerNative.cancelLocalInvitation(localInvitationWrapper.invitationNative);
                Logging.i(TAG, "cancel invite to " + Logging.desensetize(localInvitationWrapper.getCalleeId()) + " ret: " + n2);
                iNVITATION_API_CALL_ERR_CODE = RtmCallManagerImpl.valueToApiCallErrEnumSafe(n2);
            }
            object2 = iNVITATION_API_CALL_ERR_CODE;
        }
        RtmCallManagerImpl.handleApiCallResult((INVITATION_API_CALL_ERR_CODE)object2, resultCallback);
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object
            throw throwable;
        }
    }

    private class CallEventHandlerNative
    extends IRtmCallEventHandler {
        private CallEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationReceivedByPeer(ILocalCallInvitation object) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "local invite received by peer");
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (LocalInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.localInvitationLruCache.get(AgoraRtmServiceJNI.getLocalInvitationKey((ILocalCallInvitation)object));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onLocalInvitationReceivedByPeer((LocalInvitation)object);
                        break block5;
                    }
                    Logging.e(TAG, "received by peer but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationAccepted(ILocalCallInvitation object, String string2) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "local invite accepted, response: " + Logging.desensetize(string2));
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (LocalInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey((ILocalCallInvitation)object));
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onLocalInvitationAccepted((LocalInvitation)object, string2);
                        break block5;
                    }
                    Logging.e(TAG, "accepted but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationRefused(ILocalCallInvitation object, String string2) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "local invite refused, response: " + Logging.desensetize(string2));
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (LocalInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey((ILocalCallInvitation)object));
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onLocalInvitationRefused((LocalInvitation)object, string2);
                        break block5;
                    }
                    Logging.e(TAG, "refused but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationCanceled(ILocalCallInvitation object) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "local invite canceled");
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (LocalInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey((ILocalCallInvitation)object));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onLocalInvitationCanceled((LocalInvitation)object);
                        break block5;
                    }
                    Logging.e(TAG, "canceled but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationFailure(ILocalCallInvitation object, LOCAL_INVITATION_ERR_CODE lOCAL_INVITATION_ERR_CODE) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "local invite failure: " + lOCAL_INVITATION_ERR_CODE);
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (LocalInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey((ILocalCallInvitation)object));
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onLocalInvitationFailure((LocalInvitation)object, lOCAL_INVITATION_ERR_CODE.swigValue());
                        break block5;
                    }
                    Logging.e(TAG, "failure but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationReceived(IRemoteCallInvitation iRemoteCallInvitation) {
            RemoteInvitationWrapper remoteInvitationWrapper;
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "remote invite received, caller: " + Logging.desensetize(iRemoteCallInvitation.getCallerId()));
            RemoteInvitationWrapper remoteInvitationWrapper2 = remoteInvitationWrapper;
            remoteInvitationWrapper = new RemoteInvitationWrapper(iRemoteCallInvitation);
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (byArray) {
                ((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.remoteInvitationLruCache.put(AgoraRtmServiceJNI.getRemoteInvitationKey(iRemoteCallInvitation), remoteInvitationWrapper2);
                // ** MonitorExit[v0.this$0.lock] (shouldn't be in output)
                RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)callEventHandlerNative.RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (rtmCallEventListener != null) {
                    rtmCallEventListener.onRemoteInvitationReceived(remoteInvitationWrapper2);
                } else {
                    Logging.e(TAG, "remote received but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationAccepted(IRemoteCallInvitation object) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "remote invite accepted");
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (RemoteInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey((IRemoteCallInvitation)object));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onRemoteInvitationAccepted((RemoteInvitation)object);
                        break block5;
                    }
                    Logging.e(TAG, "remote accepted but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationRefused(IRemoteCallInvitation object) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "remote invite refused");
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (RemoteInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey((IRemoteCallInvitation)object));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onRemoteInvitationRefused((RemoteInvitation)object);
                        break block5;
                    }
                    Logging.e(TAG, "remote refused but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationCanceled(IRemoteCallInvitation object) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "remote invitation canceled");
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (RemoteInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey((IRemoteCallInvitation)object));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onRemoteInvitationCanceled((RemoteInvitation)object);
                        break block5;
                    }
                    Logging.e(TAG, "remote canceled but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationFailure(IRemoteCallInvitation object, REMOTE_INVITATION_ERR_CODE rEMOTE_INVITATION_ERR_CODE) {
            CallEventHandlerNative callEventHandlerNative = rtmCallEventListener;
            Logging.i(TAG, "remote invite failure: " + rEMOTE_INVITATION_ERR_CODE);
            byte[] byArray = callEventHandlerNative.RtmCallManagerImpl.this.lock;
            synchronized (callEventHandlerNative.RtmCallManagerImpl.this.lock) {
                block5: {
                    block4: {
                        object = (RemoteInvitationWrapper)callEventHandlerNative.RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey((IRemoteCallInvitation)object));
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        RtmCallEventListener rtmCallEventListener = (RtmCallEventListener)((CallEventHandlerNative)((Object)rtmCallEventListener)).RtmCallManagerImpl.this.eventListenerAtomic.get();
                        if (object == null || rtmCallEventListener == null) break block4;
                        rtmCallEventListener.onRemoteInvitationFailure((RemoteInvitation)object, rEMOTE_INVITATION_ERR_CODE.swigValue());
                        break block5;
                    }
                    Logging.e(TAG, "remote failure but callback target lost!");
                }
                return;
            }
        }
    }
}

