/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmChannel;
import io.agora.rtm.RtmChannelAttribute;
import io.agora.rtm.RtmChannelListener;
import io.agora.rtm.RtmChannelMember;
import io.agora.rtm.RtmFileMessage;
import io.agora.rtm.RtmImageMessage;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.SendMessageOptions;
import io.agora.rtm.internal.RtmChannelMemberImpl;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.internal.RtmFileMessageImpl;
import io.agora.rtm.internal.RtmImageMessageImpl;
import io.agora.rtm.internal.RtmMessageImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.CHANNEL_MESSAGE_ERR_CODE;
import io.agora.rtm.jni.GET_MEMBERS_ERR;
import io.agora.rtm.jni.IChannel;
import io.agora.rtm.jni.IChannelEventHandler;
import io.agora.rtm.jni.IChannelMember;
import io.agora.rtm.jni.IFileMessage;
import io.agora.rtm.jni.IImageMessage;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.ISendMessageOptions;
import io.agora.rtm.jni.JOIN_CHANNEL_ERR;
import io.agora.rtm.jni.LEAVE_CHANNEL_ERR;
import io.agora.rtm.jni.MESSAGE_TYPE;
import java.util.ArrayList;
import java.util.List;

class RtmChannelImpl
extends RtmChannel {
    private static final String TAG = "RtmChannelImpl";
    private String mChannelId;
    private RtmClientImpl mRtmClient;
    private RtmChannelListener mChannelListener;
    private IChannel mChannelNative;
    private ChannelEventHandlerNative mChannelListenerNative;
    private final byte[] mChannelLock = new byte[0];
    private final byte[] mChannelCallbackLock = new byte[0];
    private ResultCallback<Void> mJoinChannelCallback;
    private ResultCallback<Void> mLeaveChannelCallback;
    private final LruCache<Long, ResultCallback<Void>> mSendChannelMessageCallbacks = new LruCache(10000);
    private ResultCallback<List<RtmChannelMember>> mGetMembersCallback;
    private boolean mIsReleased = false;

    RtmChannelImpl(String string2, RtmChannelListener rtmChannelListener) {
        this.mChannelId = string2;
        this.mChannelListener = rtmChannelListener;
    }

    private boolean isNativeReady() {
        if (((RtmChannelImpl)this).mChannelNative != null && (this = ((RtmChannelImpl)this).mRtmClient) != null && ((RtmClientImpl)this).mRtmServiceNative != null) {
            return true;
        }
        Logging.w(TAG, "rtm native not ready");
        return false;
    }

    static /* synthetic */ ResultCallback access$302(RtmChannelImpl rtmChannelImpl, ResultCallback resultCallback) {
        rtmChannelImpl.mJoinChannelCallback = resultCallback;
        return resultCallback;
    }

    static /* synthetic */ ResultCallback access$402(RtmChannelImpl rtmChannelImpl, ResultCallback resultCallback) {
        rtmChannelImpl.mLeaveChannelCallback = resultCallback;
        return resultCallback;
    }

    static /* synthetic */ ResultCallback access$802(RtmChannelImpl rtmChannelImpl, ResultCallback resultCallback) {
        rtmChannelImpl.mGetMembersCallback = resultCallback;
        return resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean attach(RtmClientImpl object) {
        RtmClientImpl rtmClientImpl = object;
        RtmChannelImpl rtmChannelImpl = this;
        RtmClientImpl rtmClientImpl2 = object;
        object = this.mChannelLock;
        synchronized (this.mChannelLock) {
            ChannelEventHandlerNative channelEventHandlerNative;
            rtmChannelImpl.mRtmClient = rtmClientImpl2;
            ChannelEventHandlerNative channelEventHandlerNative2 = channelEventHandlerNative;
            rtmChannelImpl.mChannelListenerNative = new ChannelEventHandlerNative();
            IChannel iChannel = rtmClientImpl.mRtmServiceNative.createChannel(this.mChannelId, channelEventHandlerNative2);
            this.mChannelNative = iChannel;
            boolean bl = iChannel != null;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void detach() {
        RtmChannelImpl rtmChannelImpl = this;
        byte[] byArray = rtmChannelImpl.mChannelLock;
        synchronized (rtmChannelImpl.mChannelLock) {
            if (rtmChannelImpl.mChannelNative != null) {
                this.mChannelNative.release();
                this.mChannelNative = null;
            }
            if (this.mChannelListenerNative != null) {
                this.mChannelListenerNative.delete();
                this.mChannelListenerNative = null;
            }
            if (this.mRtmClient != null) {
                this.mRtmClient.removeChannel(this);
                this.mRtmClient = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isChannelNativeReady() {
        RtmChannelImpl rtmChannelImpl = object;
        Object object = rtmChannelImpl.mChannelLock;
        synchronized (rtmChannelImpl.mChannelLock) {
            // ** MonitorExit[this] (shouldn't be in output)
            return rtmChannelImpl.isNativeReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void join(ResultCallback<Void> var1_1) {
        v0 = this;
        Logging.i(RtmChannelImpl.TAG, "join channel: " + Logging.desensetize(this.mChannelId));
        var2_3 = null;
        var3_4 = v0.mChannelLock;
        // MONITORENTER : v0.mChannelLock
        if (!v0.isNativeReady()) ** GOTO lbl27
        v1 = this;
        v2 = v1;
        var2_3 = v1.mChannelCallbackLock;
        {
            catch (Throwable v3) {
                // MONITOREXIT : var3_4
                throw v3;
            }
        }
        var4_5 = v2.mChannelNative.join();
        Logging.i(RtmChannelImpl.TAG, "join channel " + Logging.desensetize(this.mChannelId) + " ret: " + var4_5);
        var4_6 = RtmSdkContext.swigValueToEnumSafe(var4_5, JOIN_CHANNEL_ERR.class);
        if (var4_6 != JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_OK) ** GOTO lbl21
        try {
            this.mJoinChannelCallback = var1_1;
lbl21:
            // 2 sources

            // MONITOREXIT : var2_3
            ** GOTO lbl28
        }
        catch (Throwable v4) {
            block11: {
                // MONITOREXIT : var2_3
                throw v4;
lbl27:
                // 1 sources

                var4_6 = var2_3;
lbl28:
                // 2 sources

                // MONITOREXIT : var3_4
                if (var4_6 == JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_OK) return;
                if (var1_1 == null) return;
                if (var4_6 != null) break block11;
                var4_6 = JOIN_CHANNEL_ERR.JOIN_CHANNEL_ERR_REJECTED;
            }
            this = v5;
            v6 = var4_6;
            var1_2 = v6.swigValue();
            v5 = new ErrorInfo(var1_2, v6.toString());
            var1_1.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void leave(ResultCallback<Void> var1_1) {
        v0 = this;
        Logging.i(RtmChannelImpl.TAG, "leave channel: " + Logging.desensetize(this.mChannelId));
        var2_3 = null;
        var3_4 = v0.mChannelLock;
        // MONITORENTER : v0.mChannelLock
        if (!v0.isNativeReady()) ** GOTO lbl27
        v1 = this;
        v2 = v1;
        var2_3 = v1.mChannelCallbackLock;
        {
            catch (Throwable v3) {
                // MONITOREXIT : var3_4
                throw v3;
            }
        }
        var4_5 = v2.mChannelNative.leave();
        Logging.i(RtmChannelImpl.TAG, "leave channel " + Logging.desensetize(this.mChannelId) + " ret: " + var4_5);
        var4_6 = RtmSdkContext.swigValueToEnumSafe(var4_5, LEAVE_CHANNEL_ERR.class);
        if (var4_6 != LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) ** GOTO lbl21
        try {
            this.mLeaveChannelCallback = var1_1;
lbl21:
            // 2 sources

            // MONITOREXIT : var2_3
            ** GOTO lbl28
        }
        catch (Throwable v4) {
            block11: {
                // MONITOREXIT : var2_3
                throw v4;
lbl27:
                // 1 sources

                var4_6 = var2_3;
lbl28:
                // 2 sources

                // MONITOREXIT : var3_4
                if (var4_6 == LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) return;
                if (var1_1 == null) return;
                if (var4_6 != null) break block11;
                var4_6 = LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_REJECTED;
            }
            this = v5;
            v6 = var4_6;
            var1_2 = v6.swigValue();
            v5 = new ErrorInfo(var1_2, v6.toString());
            var1_1.onFailure(this);
            return;
        }
    }

    @Override
    public void sendMessage(RtmMessage rtmMessage, ResultCallback<Void> resultCallback) {
        this.sendMessage(rtmMessage, null, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void sendMessage(RtmMessage var1_1, SendMessageOptions var2_3, ResultCallback<Void> var3_5) {
        v0 = this;
        Logging.d(RtmChannelImpl.TAG, "send message to channel " + Logging.desensetize(this.mChannelId) + ", " + var2_3);
        var4_6 = null;
        var5_7 = v0.mChannelLock;
        synchronized (v0.mChannelLock) {
            block32: {
                block31: {
                    if (!v0.isNativeReady() || var1_1 == null) ** GOTO lbl116
                    var6_8 = null;
                    if (var1_1.getMessageType() != 1) break block31;
                    v1 = this.mRtmClient.mRtmServiceNative.createMessage(var1_1.getText());
lbl13:
                    // 3 sources

                    while (true) {
                        var6_8 = v1;
                        while (true) {
                            var7_10 = var6_8;
                            break block32;
                            break;
                        }
                        break;
                    }
                }
                if (var1_1.getMessageType() != 2) ** GOTO lbl38
                v2 = var1_1;
                v3 = v2;
                var6_8 = v2.getRawMessage();
                if (!v3.getText().isEmpty()) ** GOTO lbl31
                v4 = var6_8;
                v1 = this.mRtmClient.mRtmServiceNative.createMessage((byte[])v4, ((Object)v4).length);
                ** GOTO lbl13
lbl31:
                // 1 sources

                v5 = this.mRtmClient.mRtmServiceNative;
                v6 = var6_8;
                v7 = var1_1;
                var6_9 = ((Object)var6_8).length;
                v1 = v5.createMessage((byte[])v6, var6_9, v7.getText());
                ** continue;
lbl38:
                // 1 sources

                if (var1_1.getMessageType() != 3) ** GOTO lbl49
                v8 = this;
                var6_8 = (RtmFileMessage)var1_1;
                var7_10 = v8.mRtmClient.mRtmServiceNative.createFileMessageByMediaId(var6_8.getMediaId());
                var7_10.setText(var6_8.getText());
                var7_10.setFileName(var6_8.getFileName());
                var7_10.setThumbnail(var6_8.getThumbnail(), var6_8.getThumbnail().length);
                break block32;
lbl49:
                // 1 sources

                if (var1_1.getMessageType() != 4) ** continue;
                v9 = this;
                var6_8 = (RtmImageMessage)var1_1;
                var7_10 = v9.mRtmClient.mRtmServiceNative.createImageMessageByMediaId(var6_8.getMediaId());
                v10 = var6_8;
                v11 = var7_10;
                v12 = var6_8;
                v13 = var7_10;
                v14 = var6_8;
                v15 = var7_10;
                v16 = var6_8;
                v17 = var7_10;
                var7_10.setText(var6_8.getText());
                var7_10.setFileName(var6_8.getFileName());
                v18 = var6_8.getThumbnail();
                v19 = var6_8.getThumbnail().length;
                v17.setThumbnail(v18, v19);
                v15.setWidth(v16.getWidth());
                v13.setHeight(v14.getHeight());
                v11.setThumbnailWidth(v12.getThumbnailWidth());
                var7_10.setThumbnailHeight(v10.getThumbnailHeight());
            }
            if (var7_10 == null) ** GOTO lbl116
            v20 = var2_3;
            var7_10.setText(var1_1.getText());
            var1_1 = this.mChannelCallbackLock;
            ** synchronized (this.mChannelCallbackLock)
lbl-1000:
            // 1 sources

            {
                block34: {
                    block35: {
                        block33: {
                            block36: {
                                if (v20 != null) break block36;
                                v21 = this.mChannelNative.sendMessage(var7_10);
lbl85:
                                // 2 sources

                                while (true) {
                                    var2_4 = v21;
                                    ** GOTO lbl102
                                    break;
                                }
                            }
                            v22 = this;
                            {
                                catch (Throwable v23) {
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    throw v23;
                                }
                            }
                            var4_6 = v24;
                            v25 = var4_6;
                            v25();
                            v25.setEnableOfflineMessaging(false);
                            v24.setEnableHistoricalMessaging(var2_3.enableHistoricalMessaging);
                            v21 = v22.mChannelNative.sendMessage(var7_10, (ISendMessageOptions)var4_6);
                            ** continue;
lbl102:
                            // 1 sources

                            Logging.d(RtmChannelImpl.TAG, "send message to channel " + Logging.desensetize(this.mChannelId) + " ret: " + var2_4);
                            var4_6 = RtmSdkContext.swigValueToEnumSafe(var2_4, CHANNEL_MESSAGE_ERR_CODE.class);
                            if (var4_6 != CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK || var3_5 == null) break block33;
                            this.mSendChannelMessageCallbacks.put(var7_10.getMessageId(), var3_5);
                        }
                        v26 = var7_10;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        v26.release();
lbl116:
                        // 3 sources

                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        if (var4_6 == CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK || var3_5 == null) break block34;
                        if (var4_6 != null) break block35;
                        var4_6 = CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_FAILURE;
                    }
                    this = v27;
                    v28 = var4_6;
                    var1_2 = v28.swigValue();
                    v27 = new ErrorInfo(var1_2, v28.toString());
                    var3_5.onFailure(this);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getMembers(ResultCallback<List<RtmChannelMember>> var1_1) {
        if (var1_1 == null) {
            return;
        }
        v0 = this;
        Logging.i(RtmChannelImpl.TAG, "get members of channel " + Logging.desensetize(this.mChannelId));
        var2_3 = null;
        var3_4 = v0.mChannelLock;
        // MONITORENTER : v0.mChannelLock
        if (!v0.isNativeReady()) ** GOTO lbl29
        v1 = this;
        v2 = v1;
        var2_3 = v1.mChannelCallbackLock;
        {
            catch (Throwable v3) {
                // MONITOREXIT : var3_4
                throw v3;
            }
        }
        var4_5 = v2.mChannelNative.getMembers();
        Logging.i(RtmChannelImpl.TAG, "get members of channel " + Logging.desensetize(this.mChannelId) + " ret: " + var4_5);
        var4_6 = RtmSdkContext.swigValueToEnumSafe(var4_5, GET_MEMBERS_ERR.class);
        if (var4_6 != GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) ** GOTO lbl23
        try {
            this.mGetMembersCallback = var1_1;
lbl23:
            // 2 sources

            // MONITOREXIT : var2_3
            ** GOTO lbl30
        }
        catch (Throwable v4) {
            block12: {
                // MONITOREXIT : var2_3
                throw v4;
lbl29:
                // 1 sources

                var4_6 = var2_3;
lbl30:
                // 2 sources

                // MONITOREXIT : var3_4
                if (var4_6 == GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) return;
                if (var4_6 != null) break block12;
                var4_6 = GET_MEMBERS_ERR.GET_MEMBERS_ERR_FAILURE;
            }
            this = v5;
            v6 = var4_6;
            var1_2 = v6.swigValue();
            v5 = new ErrorInfo(var1_2, v6.toString());
            var1_1.onFailure(this);
            return;
        }
    }

    @Override
    public String getId() {
        return this.mChannelId;
    }

    @Override
    public void release() {
        if (!this.mIsReleased) {
            Logging.i(TAG, "release");
            this.detach();
            this.mIsReleased = true;
        }
    }

    protected void finalize() {
        Logging.i(TAG, "rtm channel is destoryed");
    }

    private class ChannelEventHandlerNative
    extends IChannelEventHandler {
        private ChannelEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinSuccess() {
            ChannelEventHandlerNative channelEventHandlerNative = this;
            Logging.i(TAG, "onJoinSuccess");
            ResultCallback resultCallback = null;
            byte[] byArray = channelEventHandlerNative.RtmChannelImpl.this.mChannelCallbackLock;
            synchronized (byArray) {
                block7: {
                    if (channelEventHandlerNative.RtmChannelImpl.this.mJoinChannelCallback == null) break block7;
                    ChannelEventHandlerNative channelEventHandlerNative2 = this;
                    ChannelEventHandlerNative channelEventHandlerNative3 = channelEventHandlerNative2;
                    resultCallback = channelEventHandlerNative2.RtmChannelImpl.this.mJoinChannelCallback;
                    RtmChannelImpl.access$302(channelEventHandlerNative3.RtmChannelImpl.this, null);
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                if (resultCallback != null) {
                    resultCallback.onSuccess(null);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onJoinFailure(JOIN_CHANNEL_ERR jOIN_CHANNEL_ERR) {
            block6: {
                ErrorInfo errorInfo;
                ErrorInfo errorInfo2;
                Logging.i(TAG, "onJoinFailure: " + jOIN_CHANNEL_ERR);
                if (jOIN_CHANNEL_ERR == null) {
                    return;
                }
                ChannelEventHandlerNative channelEventHandlerNative = errorInfo2;
                ResultCallback resultCallback = null;
                byte[] byArray = channelEventHandlerNative.RtmChannelImpl.this.mChannelCallbackLock;
                synchronized (byArray) {
                    if (channelEventHandlerNative.RtmChannelImpl.this.mJoinChannelCallback != null) {
                        ChannelEventHandlerNative channelEventHandlerNative2 = errorInfo2;
                        resultCallback = channelEventHandlerNative2.RtmChannelImpl.this.mJoinChannelCallback;
                        RtmChannelImpl.access$302(channelEventHandlerNative2.RtmChannelImpl.this, null);
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : byArray
                        if (resultCallback == null) break block6;
                    }
                }
                errorInfo2 = errorInfo;
                JOIN_CHANNEL_ERR jOIN_CHANNEL_ERR2 = jOIN_CHANNEL_ERR;
                int n2 = jOIN_CHANNEL_ERR2.swigValue();
                errorInfo = new ErrorInfo(n2, jOIN_CHANNEL_ERR2.toString());
                resultCallback.onFailure(errorInfo2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onLeave(LEAVE_CHANNEL_ERR lEAVE_CHANNEL_ERR) {
            ErrorInfo errorInfo;
            ResultCallback resultCallback;
            ErrorInfo errorInfo2;
            block6: {
                Logging.i(TAG, "onLeave: " + lEAVE_CHANNEL_ERR);
                if (lEAVE_CHANNEL_ERR == null) {
                    return;
                }
                ChannelEventHandlerNative channelEventHandlerNative = errorInfo2;
                resultCallback = null;
                byte[] byArray = channelEventHandlerNative.RtmChannelImpl.this.mChannelCallbackLock;
                synchronized (byArray) {
                    if (channelEventHandlerNative.RtmChannelImpl.this.mLeaveChannelCallback != null) {
                        ChannelEventHandlerNative channelEventHandlerNative2 = errorInfo2;
                        resultCallback = channelEventHandlerNative2.RtmChannelImpl.this.mLeaveChannelCallback;
                        RtmChannelImpl.access$402(channelEventHandlerNative2.RtmChannelImpl.this, null);
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : byArray
                        if (resultCallback == null) return;
                        if (lEAVE_CHANNEL_ERR != LEAVE_CHANNEL_ERR.LEAVE_CHANNEL_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        return;
                    }
                }
            }
            errorInfo2 = errorInfo;
            LEAVE_CHANNEL_ERR lEAVE_CHANNEL_ERR2 = lEAVE_CHANNEL_ERR;
            int n2 = lEAVE_CHANNEL_ERR2.swigValue();
            errorInfo = new ErrorInfo(n2, lEAVE_CHANNEL_ERR2.toString());
            resultCallback.onFailure(errorInfo2);
        }

        @Override
        public void onMessageReceived(String string2, IMessage object) {
            if (object != null && RtmChannelImpl.this.mChannelListener != null) {
                RtmChannelMemberImpl rtmChannelMemberImpl;
                Logging.d(TAG, "onMessageReceived from: " + Logging.desensetize(string2));
                RtmMessageImpl rtmMessageImpl = null;
                if (((IMessage)object).getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_TEXT) {
                    RtmMessageImpl rtmMessageImpl2;
                    rtmMessageImpl = rtmMessageImpl2;
                    IMessage iMessage = object;
                    object = iMessage.getText();
                    long l2 = iMessage.getServerReceivedTs();
                    boolean bl = iMessage.isOfflineMessage();
                    rtmMessageImpl2 = new RtmMessageImpl((String)object, l2, bl);
                } else if (((IMessage)object).getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_RAW) {
                    RtmMessageImpl rtmMessageImpl3;
                    rtmMessageImpl = rtmMessageImpl3;
                    Object object2 = object;
                    object = ((IMessage)object2).getRawMessageData();
                    String string3 = ((IMessage)object2).getText();
                    long l3 = ((IMessage)object2).getServerReceivedTs();
                    boolean bl = ((IMessage)object2).isOfflineMessage();
                    rtmMessageImpl3 = new RtmMessageImpl((byte[])object, string3, l3, bl);
                }
                object = rtmChannelMemberImpl;
                rtmChannelMemberImpl = new RtmChannelMemberImpl(string2, RtmChannelImpl.this.mChannelId);
                RtmChannelImpl.this.mChannelListener.onMessageReceived(rtmMessageImpl, (RtmChannelMember)object);
                return;
            }
            Logging.w(TAG, "empty message or channel listener");
        }

        @Override
        public void onImageMessageReceived(String string2, IImageMessage object) {
            if (object != null && RtmChannelImpl.this.mChannelListener != null) {
                RtmChannelMemberImpl rtmChannelMemberImpl;
                RtmImageMessageImpl rtmImageMessageImpl;
                Logging.d(TAG, "onImageMessageReceived from: " + Logging.desensetize(string2));
                RtmImageMessageImpl rtmImageMessageImpl2 = rtmImageMessageImpl;
                rtmImageMessageImpl2();
                rtmImageMessageImpl2.setText(((IMessage)object).getText());
                rtmImageMessageImpl2.setSize(((IImageMessage)object).getSize());
                rtmImageMessageImpl2.setFileName(((IImageMessage)object).getFileName());
                rtmImageMessageImpl2.setMediaId(((IImageMessage)object).getMediaId());
                rtmImageMessageImpl2.setThumbnail(((IImageMessage)object).getThumbnailData());
                rtmImageMessageImpl2.setHeight(((IImageMessage)object).getHeight());
                rtmImageMessageImpl2.setWidth(((IImageMessage)object).getWidth());
                rtmImageMessageImpl2.setThumbnailHeight(((IImageMessage)object).getThumbnailHeight());
                rtmImageMessageImpl2.setThumbnailWidth(((IImageMessage)object).getThumbnailWidth());
                rtmImageMessageImpl2.setServerReceivedTs(((IMessage)object).getServerReceivedTs());
                rtmImageMessageImpl.setIsOfflineMessage(((IMessage)object).isOfflineMessage());
                object = rtmChannelMemberImpl;
                rtmChannelMemberImpl = new RtmChannelMemberImpl(string2, RtmChannelImpl.this.mChannelId);
                RtmChannelImpl.this.mChannelListener.onImageMessageReceived(rtmImageMessageImpl2, (RtmChannelMember)object);
                return;
            }
            Logging.w(TAG, "empty image message or channel listener");
        }

        @Override
        public void onFileMessageReceived(String string2, IFileMessage object) {
            if (object != null && RtmChannelImpl.this.mChannelListener != null) {
                RtmChannelMemberImpl rtmChannelMemberImpl;
                RtmFileMessageImpl rtmFileMessageImpl;
                Logging.d(TAG, "onFileMessageReceived from: " + Logging.desensetize(string2));
                RtmFileMessageImpl rtmFileMessageImpl2 = rtmFileMessageImpl;
                rtmFileMessageImpl2();
                rtmFileMessageImpl2.setText(((IMessage)object).getText());
                rtmFileMessageImpl2.setSize(((IFileMessage)object).getSize());
                rtmFileMessageImpl2.setFileName(((IFileMessage)object).getFileName());
                rtmFileMessageImpl2.setMediaId(((IFileMessage)object).getMediaId());
                rtmFileMessageImpl2.setThumbnail(((IFileMessage)object).getThumbnailData());
                rtmFileMessageImpl2.setServerReceivedTs(((IMessage)object).getServerReceivedTs());
                rtmFileMessageImpl.setIsOfflineMessage(((IMessage)object).isOfflineMessage());
                object = rtmChannelMemberImpl;
                rtmChannelMemberImpl = new RtmChannelMemberImpl(string2, RtmChannelImpl.this.mChannelId);
                RtmChannelImpl.this.mChannelListener.onFileMessageReceived(rtmFileMessageImpl2, (RtmChannelMember)object);
                return;
            }
            Logging.w(TAG, "empty file message or channel listener");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendMessageResult(long l2, CHANNEL_MESSAGE_ERR_CODE cHANNEL_MESSAGE_ERR_CODE) {
            Logging.d(TAG, "onSendMessageResult id: " + l2 + " state: " + cHANNEL_MESSAGE_ERR_CODE);
            if (cHANNEL_MESSAGE_ERR_CODE == null) {
                return;
            }
            ChannelEventHandlerNative channelEventHandlerNative = object;
            byte[] byArray = channelEventHandlerNative.RtmChannelImpl.this.mChannelCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)channelEventHandlerNative.RtmChannelImpl.this.mSendChannelMessageCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (cHANNEL_MESSAGE_ERR_CODE != CHANNEL_MESSAGE_ERR_CODE.CHANNEL_MESSAGE_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        break block5;
                    }
                    object = errorInfo;
                    CHANNEL_MESSAGE_ERR_CODE cHANNEL_MESSAGE_ERR_CODE2 = cHANNEL_MESSAGE_ERR_CODE;
                    int n2 = cHANNEL_MESSAGE_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, cHANNEL_MESSAGE_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        @Override
        public void onMemberJoined(IChannelMember iChannelMember) {
            if (iChannelMember != null && ((ChannelEventHandlerNative)((Object)rtmChannelMemberImpl2)).RtmChannelImpl.this.mChannelListener != null) {
                RtmChannelMemberImpl rtmChannelMemberImpl;
                ChannelEventHandlerNative channelEventHandlerNative = rtmChannelMemberImpl2;
                RtmChannelMemberImpl rtmChannelMemberImpl2 = rtmChannelMemberImpl;
                rtmChannelMemberImpl = new RtmChannelMemberImpl(iChannelMember);
                Logging.d(TAG, "on member " + Logging.desensetize(rtmChannelMemberImpl2.getUserId()) + " joined " + Logging.desensetize(rtmChannelMemberImpl2.getChannelId()));
                channelEventHandlerNative.RtmChannelImpl.this.mChannelListener.onMemberJoined(rtmChannelMemberImpl2);
                return;
            }
            Logging.w(TAG, "empty member or channel listener");
        }

        @Override
        public void onMemberLeft(IChannelMember iChannelMember) {
            if (iChannelMember != null && ((ChannelEventHandlerNative)((Object)rtmChannelMemberImpl2)).RtmChannelImpl.this.mChannelListener != null) {
                RtmChannelMemberImpl rtmChannelMemberImpl;
                ChannelEventHandlerNative channelEventHandlerNative = rtmChannelMemberImpl2;
                RtmChannelMemberImpl rtmChannelMemberImpl2 = rtmChannelMemberImpl;
                rtmChannelMemberImpl = new RtmChannelMemberImpl(iChannelMember);
                Logging.i(TAG, "on member " + Logging.desensetize(rtmChannelMemberImpl2.getUserId()) + " left " + Logging.desensetize(rtmChannelMemberImpl2.getChannelId()));
                channelEventHandlerNative.RtmChannelImpl.this.mChannelListener.onMemberLeft(rtmChannelMemberImpl2);
                return;
            }
            Logging.w(TAG, "empty member or channel listener");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetMembers(List<IChannelMember> object, GET_MEMBERS_ERR object2) {
            Object object3 = TAG;
            Object object4 = new StringBuilder().append("onGetMembers size: ");
            int n2 = object != null ? object.size() : 0;
            Logging.i((String)object3, ((StringBuilder)object4).append(n2).append(" errorCode: ").append(object2).toString());
            if (object2 == null) {
                return;
            }
            ChannelEventHandlerNative channelEventHandlerNative = object5;
            object3 = null;
            byte[] byArray = channelEventHandlerNative.RtmChannelImpl.this.mChannelCallbackLock;
            object4 = byArray;
            synchronized (byArray) {
                block13: {
                    Object object5;
                    block12: {
                        ErrorInfo errorInfo;
                        block11: {
                            if (channelEventHandlerNative.RtmChannelImpl.this.mGetMembersCallback == null) break block11;
                            ChannelEventHandlerNative channelEventHandlerNative2 = object5;
                            ChannelEventHandlerNative channelEventHandlerNative3 = channelEventHandlerNative2;
                            object3 = channelEventHandlerNative2.RtmChannelImpl.this.mGetMembersCallback;
                            RtmChannelImpl.access$802(channelEventHandlerNative3.RtmChannelImpl.this, null);
                        }
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        if (object3 == null) {
                            return;
                        }
                        if (object2 == GET_MEMBERS_ERR.GET_MEMBERS_ERR_OK) break block12;
                        object5 = errorInfo;
                        GET_MEMBERS_ERR gET_MEMBERS_ERR = object2;
                        int n3 = gET_MEMBERS_ERR.swigValue();
                        errorInfo = new ErrorInfo(n3, gET_MEMBERS_ERR.toString());
                        object3.onFailure((ErrorInfo)object5);
                        break block13;
                    }
                    if (object == null) {
                        ErrorInfo errorInfo;
                        object5 = errorInfo;
                        errorInfo = new ErrorInfo(1);
                        object3.onFailure((ErrorInfo)object5);
                    } else {
                        ArrayList arrayList;
                        object5 = arrayList;
                        arrayList = new ArrayList();
                        object = object.iterator();
                        while (object.hasNext()) {
                            object2 = (IChannelMember)object.next();
                            ((ArrayList)object5).add(new RtmChannelMemberImpl((IChannelMember)object2));
                        }
                        object3.onSuccess(object5);
                    }
                }
                return;
            }
        }

        @Override
        public void onAttributesUpdated(List<IRtmChannelAttribute> arrayList) {
            Object object = TAG;
            Object object2 = new StringBuilder().append("onAttributesUpdated size: ");
            int n2 = arrayList != null ? arrayList.size() : 0;
            Logging.i((String)object, ((StringBuilder)object2).append(n2).toString());
            if (arrayList != null && RtmChannelImpl.this.mChannelListener != null) {
                ArrayList<RtmChannelAttribute> arrayList2;
                ArrayList<RtmChannelAttribute> arrayList3 = arrayList;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<RtmChannelAttribute>();
                object = arrayList3.iterator();
                while (object.hasNext()) {
                    Object object3 = object2 = (IRtmChannelAttribute)object.next();
                    object2 = ((IRtmChannelAttribute)object3).getKey();
                    String string2 = ((IRtmChannelAttribute)object3).getValue();
                    String string3 = ((IRtmChannelAttribute)object3).getLastUpdateUserId();
                    long l2 = ((IRtmChannelAttribute)object3).getLastUpdateTs();
                    arrayList.add(new RtmChannelAttribute((String)object2, string2, string3, l2));
                }
                RtmChannelImpl.this.mChannelListener.onAttributesUpdated(arrayList);
                return;
            }
            Logging.w(TAG, "empty attribute or channel listener");
        }

        @Override
        public void onMemberCountUpdated(int n2) {
            Logging.i(TAG, "onMemberCountUpdated membercount: " + n2);
            RtmChannelImpl.this.mChannelListener.onMemberCountUpdated(n2);
        }
    }
}

