/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.AgoraServiceJNI;
import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.ChannelAttributeOptions;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmAttribute;
import io.agora.rtm.RtmCallManager;
import io.agora.rtm.RtmChannel;
import io.agora.rtm.RtmChannelAttribute;
import io.agora.rtm.RtmChannelListener;
import io.agora.rtm.RtmChannelMemberCount;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmClientListener;
import io.agora.rtm.RtmFileMessage;
import io.agora.rtm.RtmImageMessage;
import io.agora.rtm.RtmMediaOperationProgress;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.RtmRequestId;
import io.agora.rtm.SendMessageOptions;
import io.agora.rtm.internal.RtmCallManagerImpl;
import io.agora.rtm.internal.RtmChannelImpl;
import io.agora.rtm.internal.RtmFileMessageImpl;
import io.agora.rtm.internal.RtmImageMessageImpl;
import io.agora.rtm.internal.RtmMessageImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.ATTRIBUTE_OPERATION_ERR;
import io.agora.rtm.jni.CANCEL_MEDIA_ERR_CODE;
import io.agora.rtm.jni.CONNECTION_CHANGE_REASON;
import io.agora.rtm.jni.CONNECTION_STATE;
import io.agora.rtm.jni.DOWNLOAD_MEDIA_ERR_CODE;
import io.agora.rtm.jni.GET_CHANNEL_MEMBER_COUNT_ERR;
import io.agora.rtm.jni.IChannelAttributeOptions;
import io.agora.rtm.jni.IFileMessage;
import io.agora.rtm.jni.IImageMessage;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmAttribute;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.IRtmChannelMemberCount;
import io.agora.rtm.jni.IRtmService;
import io.agora.rtm.jni.IRtmServiceEventHandler;
import io.agora.rtm.jni.ISendMessageOptions;
import io.agora.rtm.jni.LOGIN_ERR_CODE;
import io.agora.rtm.jni.LOGOUT_ERR_CODE;
import io.agora.rtm.jni.MESSAGE_TYPE;
import io.agora.rtm.jni.MediaOperationProgress;
import io.agora.rtm.jni.PEER_MESSAGE_ERR_CODE;
import io.agora.rtm.jni.PEER_ONLINE_STATE;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_OPTION;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_STATUS_ERR;
import io.agora.rtm.jni.PeerOnlineStatus;
import io.agora.rtm.jni.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR;
import io.agora.rtm.jni.QUERY_PEERS_ONLINE_STATUS_ERR;
import io.agora.rtm.jni.RENEW_TOKEN_ERR_CODE;
import io.agora.rtm.jni.SWIGTYPE_p_long_long;
import io.agora.rtm.jni.UPLOAD_MEDIA_ERR_CODE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class RtmClientImpl
extends RtmClient {
    private static final String TAG = "RtmClientImpl";
    private RtmClientListener mClientListener;
    IRtmService mRtmServiceNative;
    private long mRtmServiceNativeHandle;
    private RtmServiceEventHandlerNative mRtmEventHandlerNative;
    private HashSet<RtmChannelImpl> mRefChannels = new HashSet();
    private final byte[] mRtmLock = new byte[0];
    private final byte[] mRtmCallbackLock = new byte[0];
    private boolean mIsInitialized = false;
    private ResultCallback<Void> mLoginCallback;
    private ResultCallback<Void> mLogoutCallback;
    private final LruCache<String, ResultCallback<Void>> mRenewTokenCallbacks = new LruCache(50);
    private final LruCache<Long, ResultCallback<Void>> mSendPeerMessageCallbacks = new LruCache(10000);
    private final LruCache<Long, ResultCallback<Map<String, Boolean>>> mQueryOnlineStatusCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSubscribePeersOnlineStatusCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Set<String>>> mQueryPeersBySubscriptionOptionCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSetLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mAddOrUpdateLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDeleteLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mClearLocalUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmAttribute>>> mGetUserAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mSetChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mAddOrUpdateChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDeleteChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mClearChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmChannelAttribute>>> mGetChannelAttrCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<List<RtmChannelMemberCount>>> mGetChannelMemberCountCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<RtmFileMessage>> mUploadFileMediaCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<RtmImageMessage>> mUploadImageMediaCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<byte[]>> mDownloadMediaToMemoryCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mDownloadMediaToFileCallbacks = new LruCache(100);
    private final LruCache<Long, ResultCallback<Void>> mCancelMediaCallbacks = new LruCache(100);
    private RtmCallManagerImpl rtmCallManager;

    RtmClientImpl(@NonNull RtmSdkContext rtmSdkContext, @NonNull String string2, @NonNull RtmClientListener rtmClientListener) throws IllegalArgumentException {
        this.mClientListener = rtmClientListener;
        this.initRtmService(rtmSdkContext, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initRtmService(RtmSdkContext object, String string2) throws IllegalArgumentException {
        if (object != null && string2 != null && !string2.isEmpty()) {
            Object object2 = object;
            object = ((RtmSdkContext)object2).getConfigDir();
            String string3 = ((RtmSdkContext)object2).getDataDir();
            String string4 = ((RtmSdkContext)object2).getPluginDir();
            String string5 = ((RtmSdkContext)object2).getDeviceId();
            String string6 = ((RtmSdkContext)object2).getDeviceInfo();
            String string7 = ((RtmSdkContext)object2).getSystemInfo();
            Logging.i(TAG, "Initialize Agora RTM service deviceId '" + string5 + "' deviceInfo '" + string6 + "' systemInfo '" + string7 + "' dir '" + (String)object);
            byte[] byArray = this.mRtmLock;
            synchronized (byArray) {
                RtmServiceEventHandlerNative rtmServiceEventHandlerNative;
                long l2 = AgoraServiceJNI.createRtmService(string2, string5, string6, string7, (String)object, string3, string4);
                this.mRtmServiceNativeHandle = l2;
                this.mRtmServiceNative = new IRtmService(l2, true);
                object = rtmServiceEventHandlerNative;
                this.mRtmEventHandlerNative = new RtmServiceEventHandlerNative();
                int n2 = this.mRtmServiceNative.initialize(string2, (IRtmServiceEventHandler)object);
                if (n2 != 0) throw new IllegalArgumentException("cannot initialize Agora RTM Service, error: " + n2);
                this.mIsInitialized = true;
                Logging.d(TAG, "init done. appId: " + Logging.desensetize(string2) + " this: " + this);
                return;
            }
        }
        Logging.e(TAG, "empty context or appId!");
        throw new IllegalArgumentException();
    }

    private IRtmAttribute[] convertAttrListToInternal(@NonNull List<RtmAttribute> list) {
        IRtmAttribute[] iRtmAttributeArray = new IRtmAttribute[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IRtmAttribute iRtmAttribute;
            RtmAttribute rtmAttribute = list.get(i2);
            IRtmAttribute iRtmAttribute2 = iRtmAttribute;
            iRtmAttribute2();
            iRtmAttribute2.setKey(rtmAttribute.getKey());
            iRtmAttribute.setValue(rtmAttribute.getValue());
            iRtmAttributeArray[i2] = iRtmAttribute2;
        }
        return iRtmAttributeArray;
    }

    private IRtmChannelAttribute[] convertChannelAttrListToInternal(@NonNull List<RtmChannelAttribute> list) {
        IRtmChannelAttribute[] iRtmChannelAttributeArray = new IRtmChannelAttribute[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IRtmChannelAttribute iRtmChannelAttribute;
            RtmChannelAttribute rtmChannelAttribute = list.get(i2);
            IRtmChannelAttribute iRtmChannelAttribute2 = iRtmChannelAttribute;
            iRtmChannelAttribute2(this.mRtmServiceNativeHandle);
            iRtmChannelAttribute2.setKey(rtmChannelAttribute.getKey());
            iRtmChannelAttribute.setValue(rtmChannelAttribute.getValue());
            iRtmChannelAttributeArray[i2] = iRtmChannelAttribute2;
        }
        return iRtmChannelAttributeArray;
    }

    private IChannelAttributeOptions convertChannelAttrOptToInternal(@NonNull ChannelAttributeOptions channelAttributeOptions) {
        IChannelAttributeOptions iChannelAttributeOptions = new IChannelAttributeOptions();
        iChannelAttributeOptions.setEnableNotificationToChannelMembers(channelAttributeOptions.getEnableNotificationToChannelMembers());
        return iChannelAttributeOptions;
    }

    private void processAttrApiError(ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR, ResultCallback<?> resultCallback) {
        if (aTTRIBUTE_OPERATION_ERR != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK && resultCallback != null) {
            ErrorInfo errorInfo;
            if (aTTRIBUTE_OPERATION_ERR == null) {
                aTTRIBUTE_OPERATION_ERR = ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_FAILURE;
            }
            ErrorInfo errorInfo2 = errorInfo;
            ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR2 = aTTRIBUTE_OPERATION_ERR;
            int n2 = aTTRIBUTE_OPERATION_ERR2.swigValue();
            errorInfo = new ErrorInfo(n2, aTTRIBUTE_OPERATION_ERR2.toString());
            resultCallback.onFailure(errorInfo2);
            return;
        }
    }

    private void processGetChannelMemberCountApiError(GET_CHANNEL_MEMBER_COUNT_ERR gET_CHANNEL_MEMBER_COUNT_ERR, ResultCallback<?> resultCallback) {
        if (gET_CHANNEL_MEMBER_COUNT_ERR != GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK && resultCallback != null) {
            ErrorInfo errorInfo;
            if (gET_CHANNEL_MEMBER_COUNT_ERR == null) {
                gET_CHANNEL_MEMBER_COUNT_ERR = GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_FAILURE;
            }
            ErrorInfo errorInfo2 = errorInfo;
            GET_CHANNEL_MEMBER_COUNT_ERR gET_CHANNEL_MEMBER_COUNT_ERR2 = gET_CHANNEL_MEMBER_COUNT_ERR;
            int n2 = gET_CHANNEL_MEMBER_COUNT_ERR2.swigValue();
            errorInfo = new ErrorInfo(n2, gET_CHANNEL_MEMBER_COUNT_ERR2.toString());
            resultCallback.onFailure(errorInfo2);
            return;
        }
    }

    private boolean isNativeReady() {
        if (this.mRtmServiceNative == null) {
            Logging.w(TAG, "rtm native is not ready");
            return false;
        }
        return true;
    }

    private int setParameter(String string2, boolean bl) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = bl;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":%b}", objectArray3));
    }

    private int setParameter(String string2, int n2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = n2;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":%d}", objectArray3));
    }

    private int setParameter(String string2, long l2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = l2;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":%d}", objectArray3));
    }

    private int setParameter(String string2, double d2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = string2;
        objectArray2[1] = d2;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":%f}", objectArray3));
    }

    private int setParameter(String string2, String string3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":\"%s\"}", objectArray3));
    }

    private int setParameterObject(String string2, String string3) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        return objectArray.setParameters(RtmClientImpl.formatString("{\"%s\":%s}", objectArray3));
    }

    private static String formatString(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    private int covertPeerOnlineState(PEER_ONLINE_STATE pEER_ONLINE_STATE) {
        if (pEER_ONLINE_STATE == PEER_ONLINE_STATE.PEER_ONLINE_STATE_ONLINE) {
            return 0;
        }
        if (pEER_ONLINE_STATE == PEER_ONLINE_STATE.PEER_ONLINE_STATE_UNREACHABLE) {
            return 1;
        }
        if (pEER_ONLINE_STATE == PEER_ONLINE_STATE.PEER_ONLINE_STATE_OFFLINE) {
            return 2;
        }
        return -1;
    }

    static /* synthetic */ ResultCallback access$302(RtmClientImpl rtmClientImpl, ResultCallback resultCallback) {
        rtmClientImpl.mLoginCallback = resultCallback;
        return resultCallback;
    }

    static /* synthetic */ ResultCallback access$402(RtmClientImpl rtmClientImpl, ResultCallback resultCallback) {
        rtmClientImpl.mLogoutCallback = resultCallback;
        return resultCallback;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void release() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void finalize() {
        Logging.i(TAG, "rtm client is destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void login(String var1_1, String var2_4, ResultCallback<Void> var3_5) {
        var4_6 = RtmClientImpl.TAG;
        var5_7 = new StringBuilder().append("login token: ");
        if (var1_1 != null && var1_1.length() >= 8) {
            v0 = var1_1;
            var6_8 = var1_1.substring(0, 4) + "****" + v0.substring(v0.length() - 4);
        } else {
            var6_8 = "invalid!";
        }
        v1 = this;
        Logging.i((String)var4_6, var5_7.append(var6_8).append(" uid: ").append(Logging.desensetize(var2_4)).append(" cb: ").append(var3_5).toString());
        var4_6 = null;
        var5_7 = v1.mRtmLock;
        // MONITORENTER : v1.mRtmLock
        if (!v1.isNativeReady()) ** GOTO lbl34
        v2 = this;
        v3 = v2;
        var4_6 = v2.mRtmCallbackLock;
        {
            catch (Throwable v4) {
                // MONITOREXIT : var5_7
                throw v4;
            }
        }
        var1_2 = v3.mRtmServiceNative.login((String)var1_1, var2_4);
        Logging.i(RtmClientImpl.TAG, "login ret: " + var1_2);
        var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, LOGIN_ERR_CODE.class);
        if (var1_1 != LOGIN_ERR_CODE.LOGIN_ERR_OK) ** GOTO lbl28
        try {
            this.mLoginCallback = var3_5;
lbl28:
            // 2 sources

            // MONITOREXIT : var4_6
            ** GOTO lbl35
        }
        catch (Throwable v5) {
            block13: {
                // MONITOREXIT : var4_6
                throw v5;
lbl34:
                // 1 sources

                var1_1 = var4_6;
lbl35:
                // 2 sources

                // MONITOREXIT : var5_7
                if (var1_1 == LOGIN_ERR_CODE.LOGIN_ERR_OK) return;
                if (var3_5 == null) return;
                if (var1_1 != null) break block13;
                var1_1 = LOGIN_ERR_CODE.LOGIN_ERR_UNKNOWN;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var3_5.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void logout(ResultCallback<Void> var1_1) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "logout");
        var2_3 = null;
        var3_4 = v0.mRtmLock;
        // MONITORENTER : v0.mRtmLock
        Logging.i(RtmClientImpl.TAG, "clean up channels while logging out");
        for (RtmChannelImpl var5_7 : (HashSet)v0.mRefChannels.clone()) {
            if (var5_7 == null) continue;
            v1 = var5_7;
            Logging.i(RtmClientImpl.TAG, "force leave channel " + Logging.desensetize(var5_7.getId()));
            v1.leave(null);
            v1.detach();
        }
        v2 = this;
        v2.mRefChannels.clear();
        if (!v2.isNativeReady()) ** GOTO lbl37
        v3 = this;
        v4 = v3;
        var2_3 = v3.mRtmCallbackLock;
        {
            catch (Throwable v5) {
                // MONITOREXIT : var3_4
                throw v5;
            }
        }
        var4_6 = v4.mRtmServiceNative.logout();
        Logging.i(RtmClientImpl.TAG, "logout ret: " + var4_6);
        var4_5 = RtmSdkContext.swigValueToEnumSafe(var4_6, LOGOUT_ERR_CODE.class);
        if (var4_5 != LOGOUT_ERR_CODE.LOGOUT_ERR_OK) ** GOTO lbl31
        try {
            this.mLogoutCallback = var1_1;
lbl31:
            // 2 sources

            // MONITOREXIT : var2_3
            ** GOTO lbl38
        }
        catch (Throwable v6) {
            block13: {
                // MONITOREXIT : var2_3
                throw v6;
lbl37:
                // 1 sources

                var4_5 = var2_3;
lbl38:
                // 2 sources

                // MONITOREXIT : var3_4
                if (var4_5 == LOGOUT_ERR_CODE.LOGOUT_ERR_OK) return;
                if (var1_1 == null) return;
                if (var4_5 != null) break block13;
                var4_5 = LOGOUT_ERR_CODE.LOGOUT_ERR_REJECTED;
            }
            this = v7;
            v8 = var4_5;
            var1_2 = v8.swigValue();
            v7 = new ErrorInfo(var1_2, v8.toString());
            var1_1.onFailure(this);
            return;
        }
    }

    @Override
    public RtmMessage createMessage() {
        return new RtmMessageImpl("");
    }

    @Override
    public RtmMessage createMessage(String string2) {
        return new RtmMessageImpl(string2);
    }

    @Override
    public RtmMessage createMessage(byte[] byArray) {
        return new RtmMessageImpl(byArray);
    }

    @Override
    public RtmMessage createMessage(byte[] byArray, String string2) {
        return new RtmMessageImpl(byArray, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RtmFileMessage createFileMessageByMediaId(@NonNull String var1_1) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "createFileMessageByMediaId mediaId: " + (String)var1_1);
        var2_2 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            block9: {
                if (!v0.isNativeReady() || var1_1 == null) ** GOTO lbl30
                this = this.mRtmServiceNative.createFileMessageByMediaId((String)var1_1);
                if (this != null) break block9;
                Logging.e(RtmClientImpl.TAG, "createFileMessageByMediaId failed, mediaId maybe invalid");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            var1_1 = v2;
            var1_1();
            var1_1.setText(this.getText());
            var1_1.setSize(this.getSize());
            var1_1.setFileName(this.getFileName());
            var1_1.setMediaId(this.getMediaId());
            var1_1.setThumbnail(this.getThumbnailData());
            this.release();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return v2;
lbl30:
            // 1 sources

            if (!this.isNativeReady()) ** GOTO lbl36
            Logging.e(RtmClientImpl.TAG, "createFileMessageByMediaId failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
lbl36:
            // 1 sources

            throw new RuntimeException("RtmClient instance is released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RtmImageMessage createImageMessageByMediaId(@NonNull String var1_1) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "createImageMessageByMediaId mediaId: " + (String)var1_1);
        var2_2 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            block9: {
                if (!v0.isNativeReady() || var1_1 == null) ** GOTO lbl34
                this = this.mRtmServiceNative.createImageMessageByMediaId((String)var1_1);
                if (this != null) break block9;
                Logging.e(RtmClientImpl.TAG, "createImageMessageByMediaId failed, mediaId maybe invalid");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            var1_1 = v2;
            var1_1();
            var1_1.setText(this.getText());
            var1_1.setSize(this.getSize());
            var1_1.setFileName(this.getFileName());
            var1_1.setMediaId(this.getMediaId());
            var1_1.setThumbnail(this.getThumbnailData());
            var1_1.setHeight(this.getHeight());
            var1_1.setWidth(this.getWidth());
            var1_1.setThumbnailHeight(this.getThumbnailHeight());
            var1_1.setThumbnailWidth(this.getThumbnailWidth());
            this.release();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return v2;
lbl34:
            // 1 sources

            if (!this.isNativeReady()) ** GOTO lbl40
            Logging.e(RtmClientImpl.TAG, "createImageMessageByMediaId failed, mediaId is null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
lbl40:
            // 1 sources

            throw new RuntimeException("RtmClient instance is released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void createFileMessageByUploading(@NonNull String var1_1, RtmRequestId var2_4, ResultCallback<RtmFileMessage> var3_5) {
        block13: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "createFileMessageByUploading filePath:" + Logging.desensetize((String)var1_1));
            var4_6 = null;
            var5_7 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl35
            v1 = this;
            v2 = v1;
            var4_6 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var5_7
                    throw v3;
                }
            }
            var6_8 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var1_2 = v2.mRtmServiceNative.createFileMessageByUploading((String)var1_1, var6_8);
            var2_4.setRequestId(SWIGTYPE_p_long_long.dereference(var6_8));
            Logging.i(RtmClientImpl.TAG, "createFileMessageByUploading, ret: " + var1_2 + ", requestId: " + SWIGTYPE_p_long_long.dereference(var6_8));
            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, UPLOAD_MEDIA_ERR_CODE.class);
            if (var1_1 != UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK || var3_5 == null) break block13;
            this.mUploadFileMediaCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_8), var3_5);
        }
        try {
            // MONITOREXIT : var4_6
            ** GOTO lbl36
        }
        catch (Throwable v5) {
            block14: {
                // MONITOREXIT : var4_6
                throw v5;
lbl35:
                // 1 sources

                var1_1 = var4_6;
lbl36:
                // 2 sources

                // MONITOREXIT : var5_7
                if (var1_1 == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) return;
                if (var3_5 == null) return;
                if (var1_1 != null) break block14;
                var1_1 = UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_FAILURE;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var3_5.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void createImageMessageByUploading(@NonNull String var1_1, RtmRequestId var2_4, ResultCallback<RtmImageMessage> var3_5) {
        block13: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "createImageMessageByUploading, filePath:" + Logging.desensetize((String)var1_1));
            var4_6 = null;
            var5_7 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl35
            v1 = this;
            v2 = v1;
            var4_6 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var5_7
                    throw v3;
                }
            }
            var6_8 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var1_2 = v2.mRtmServiceNative.createImageMessageByUploading((String)var1_1, var6_8);
            var2_4.setRequestId(SWIGTYPE_p_long_long.dereference(var6_8));
            Logging.i(RtmClientImpl.TAG, "createImageMessageByUploading, ret: " + var1_2 + ", requestId: " + SWIGTYPE_p_long_long.dereference(var6_8));
            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, UPLOAD_MEDIA_ERR_CODE.class);
            if (var1_1 != UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK || var3_5 == null) break block13;
            this.mUploadImageMediaCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_8), var3_5);
        }
        try {
            // MONITOREXIT : var4_6
            ** GOTO lbl36
        }
        catch (Throwable v5) {
            block14: {
                // MONITOREXIT : var4_6
                throw v5;
lbl35:
                // 1 sources

                var1_1 = var4_6;
lbl36:
                // 2 sources

                // MONITOREXIT : var5_7
                if (var1_1 == UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) return;
                if (var3_5 == null) return;
                if (var1_1 != null) break block14;
                var1_1 = UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_FAILURE;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var3_5.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void downloadMediaToMemory(@NonNull String var1_1, RtmRequestId var2_4, ResultCallback<byte[]> var3_5) {
        block13: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "downloadMediaToMemory requestId: " + var2_4);
            var4_6 = null;
            var5_7 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl35
            v1 = this;
            v2 = v1;
            var4_6 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var5_7
                    throw v3;
                }
            }
            var6_8 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var1_2 = v2.mRtmServiceNative.downloadMediaToMemory((String)var1_1, var6_8);
            var2_4.setRequestId(SWIGTYPE_p_long_long.dereference(var6_8));
            Logging.i(RtmClientImpl.TAG, "downloadMediaToMemory, ret: " + var1_2 + ", requestId: " + SWIGTYPE_p_long_long.dereference(var6_8));
            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, DOWNLOAD_MEDIA_ERR_CODE.class);
            if (var1_1 != DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK || var3_5 == null) break block13;
            this.mDownloadMediaToMemoryCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_8), var3_5);
        }
        try {
            // MONITOREXIT : var4_6
            ** GOTO lbl36
        }
        catch (Throwable v5) {
            block14: {
                // MONITOREXIT : var4_6
                throw v5;
lbl35:
                // 1 sources

                var1_1 = var4_6;
lbl36:
                // 2 sources

                // MONITOREXIT : var5_7
                if (var1_1 == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) return;
                if (var3_5 == null) return;
                if (var1_1 != null) break block14;
                var1_1 = DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_FAILURE;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var3_5.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void downloadMediaToFile(@NonNull String var1_1, @NonNull String var2_4, RtmRequestId var3_5, ResultCallback<Void> var4_6) {
        block13: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "downloadMediaToFile mediaId: " + (String)var1_1 + ", filePath: " + Logging.desensetize(var2_4));
            var5_7 = null;
            var6_8 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl35
            v1 = this;
            v2 = v1;
            var5_7 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var6_8
                    throw v3;
                }
            }
            var7_9 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var1_2 = v2.mRtmServiceNative.downloadMediaToFile((String)var1_1, var2_4, var7_9);
            var3_5.setRequestId(SWIGTYPE_p_long_long.dereference(var7_9));
            Logging.i(RtmClientImpl.TAG, "downloadMediaToFile, ret: " + var1_2 + ", requestId: " + SWIGTYPE_p_long_long.dereference(var7_9));
            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, DOWNLOAD_MEDIA_ERR_CODE.class);
            if (var1_1 != DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK || var4_6 == null) break block13;
            this.mDownloadMediaToFileCallbacks.put(SWIGTYPE_p_long_long.dereference(var7_9), var4_6);
        }
        try {
            // MONITOREXIT : var5_7
            ** GOTO lbl36
        }
        catch (Throwable v5) {
            block14: {
                // MONITOREXIT : var5_7
                throw v5;
lbl35:
                // 1 sources

                var1_1 = var5_7;
lbl36:
                // 2 sources

                // MONITOREXIT : var6_8
                if (var1_1 == DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) return;
                if (var4_6 == null) return;
                if (var1_1 != null) break block14;
                var1_1 = DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_FAILURE;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var4_6.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelMediaUpload(RtmRequestId var1_1, ResultCallback<Void> var2_3) {
        block12: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "cancelMediaUpload requestId: " + var1_1.getRequestId());
            var3_4 = null;
            var4_5 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl30
            v1 = this;
            v2 = v1;
            var3_4 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var4_5
                    throw v3;
                }
            }
            var5_6 = v2.mRtmServiceNative.cancelMediaUpload(var1_1.getRequestId());
            Logging.i(RtmClientImpl.TAG, "cancelMediaUpload, ret: " + var5_6);
            var5_7 = RtmSdkContext.swigValueToEnumSafe(var5_6, CANCEL_MEDIA_ERR_CODE.class);
            if (var5_7 != CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK || var2_3 == null) break block12;
            this.mCancelMediaCallbacks.put(var1_1.getRequestId(), var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl31
        }
        catch (Throwable v4) {
            block13: {
                // MONITOREXIT : var3_4
                throw v4;
lbl30:
                // 1 sources

                var5_7 = var3_4;
lbl31:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_7 == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_7 != null) break block13;
                var5_7 = CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_FAILURE;
            }
            this = v5;
            v6 = var5_7;
            var1_2 = v6.swigValue();
            v5 = new ErrorInfo(var1_2, v6.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelMediaDownload(RtmRequestId var1_1, ResultCallback<Void> var2_3) {
        block12: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "cancelMediaDownload requestId: " + var1_1.getRequestId());
            var3_4 = null;
            var4_5 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl30
            v1 = this;
            v2 = v1;
            var3_4 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var4_5
                    throw v3;
                }
            }
            var5_6 = v2.mRtmServiceNative.cancelMediaDownload(var1_1.getRequestId());
            Logging.i(RtmClientImpl.TAG, "cancelMediaDownload, ret: " + var5_6);
            var5_7 = RtmSdkContext.swigValueToEnumSafe(var5_6, CANCEL_MEDIA_ERR_CODE.class);
            if (var5_7 != CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK || var2_3 == null) break block12;
            this.mCancelMediaCallbacks.put(var1_1.getRequestId(), var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl31
        }
        catch (Throwable v4) {
            block13: {
                // MONITOREXIT : var3_4
                throw v4;
lbl30:
                // 1 sources

                var5_7 = var3_4;
lbl31:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_7 == CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_7 != null) break block13;
                var5_7 = CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_FAILURE;
            }
            this = v5;
            v6 = var5_7;
            var1_2 = v6.swigValue();
            v5 = new ErrorInfo(var1_2, v6.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getMediaUploadingPercentage(RtmRequestId rtmRequestId) {
        RtmClientImpl rtmClientImpl = this;
        Logging.i(TAG, "getMediaUploadingPercentage requestId: " + rtmRequestId.getRequestId());
        byte[] byArray = rtmClientImpl.mRtmLock;
        synchronized (rtmClientImpl.mRtmLock) {
            if (rtmClientImpl.isNativeReady() && rtmRequestId != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mRtmServiceNative.getMediaUploadingPercentage(rtmRequestId.getRequestId());
            }
            if (this.isNativeReady()) {
                Logging.e(TAG, "getMediaUploadingPercentage failed, mediaId is null");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return 0.0;
            }
            throw new RuntimeException("RtmClient instance is released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getMediaDownloadingPercentage(RtmRequestId rtmRequestId) {
        RtmClientImpl rtmClientImpl = this;
        Logging.i(TAG, "getMediaDownloadingPercentage requestId: " + rtmRequestId.getRequestId());
        byte[] byArray = rtmClientImpl.mRtmLock;
        synchronized (rtmClientImpl.mRtmLock) {
            if (rtmClientImpl.isNativeReady() && rtmRequestId != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mRtmServiceNative.getMediaDownloadingPercentage(rtmRequestId.getRequestId());
            }
            if (this.isNativeReady()) {
                Logging.e(TAG, "getMediaDownloadingPercentage failed, mediaId is null");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return 0.0;
            }
            throw new RuntimeException("RtmClient instance is released!");
        }
    }

    @Override
    public void sendMessageToPeer(String string2, RtmMessage rtmMessage, ResultCallback<Void> resultCallback) {
        this.sendMessageToPeer(string2, rtmMessage, null, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void sendMessageToPeer(String var1_1, RtmMessage var2_3, SendMessageOptions var3_4, ResultCallback<Void> var4_6) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "sendMessageToPeer peerId: " + Logging.desensetize(var1_1) + " options: " + var3_4);
        var5_7 = null;
        var6_8 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            block32: {
                block31: {
                    if (!v0.isNativeReady() || var1_1 == null || var2_3 == null) ** GOTO lbl115
                    var7_9 = null;
                    if (var2_3.getMessageType() != 1) break block31;
                    v1 = this.mRtmServiceNative.createMessage(var2_3.getText());
lbl13:
                    // 3 sources

                    while (true) {
                        var7_9 = v1;
                        while (true) {
                            var8_11 = var7_9;
                            break block32;
                            break;
                        }
                        break;
                    }
                }
                if (var2_3.getMessageType() != 2) ** GOTO lbl38
                v2 = var2_3;
                v3 = v2;
                var7_9 = v2.getRawMessage();
                if (!v3.getText().isEmpty()) ** GOTO lbl31
                v4 = var7_9;
                v1 = this.mRtmServiceNative.createMessage((byte[])v4, ((Object)v4).length);
                ** GOTO lbl13
lbl31:
                // 1 sources

                v5 = this.mRtmServiceNative;
                v6 = var7_9;
                v7 = var2_3;
                var7_10 = ((Object)var7_9).length;
                v1 = v5.createMessage((byte[])v6, var7_10, v7.getText());
                ** continue;
lbl38:
                // 1 sources

                if (var2_3.getMessageType() != 3) ** GOTO lbl49
                v8 = this;
                var7_9 = (RtmFileMessage)var2_3;
                var8_11 = v8.mRtmServiceNative.createFileMessageByMediaId(var7_9.getMediaId());
                var8_11.setText(var7_9.getText());
                var8_11.setFileName(var7_9.getFileName());
                var8_11.setThumbnail(var7_9.getThumbnail(), var7_9.getThumbnail().length);
                break block32;
lbl49:
                // 1 sources

                if (var2_3.getMessageType() != 4) ** continue;
                v9 = this;
                var7_9 = (RtmImageMessage)var2_3;
                var8_11 = v9.mRtmServiceNative.createImageMessageByMediaId(var7_9.getMediaId());
                v10 = var7_9;
                v11 = var8_11;
                v12 = var7_9;
                v13 = var8_11;
                v14 = var7_9;
                v15 = var8_11;
                v16 = var7_9;
                v17 = var8_11;
                var8_11.setText(var7_9.getText());
                var8_11.setFileName(var7_9.getFileName());
                v18 = var7_9.getThumbnail();
                v19 = var7_9.getThumbnail().length;
                v17.setThumbnail(v18, v19);
                v15.setWidth(v16.getWidth());
                v13.setHeight(v14.getHeight());
                v11.setThumbnailWidth(v12.getThumbnailWidth());
                var8_11.setThumbnailHeight(v10.getThumbnailHeight());
            }
            if (var8_11 == null) ** GOTO lbl115
            v20 = var3_4;
            var8_11.setText(var2_3.getText());
            var2_3 = this.mRtmCallbackLock;
            ** synchronized (this.mRtmCallbackLock)
lbl-1000:
            // 1 sources

            {
                block34: {
                    block35: {
                        block33: {
                            block36: {
                                if (v20 != null) break block36;
                                v21 = this.mRtmServiceNative.sendMessageToPeer(var1_1, var8_11);
lbl85:
                                // 2 sources

                                while (true) {
                                    var3_5 = v21;
                                    ** GOTO lbl101
                                    break;
                                }
                            }
                            v22 = this;
                            {
                                catch (Throwable v23) {
                                    // ** MonitorExit[var2_3] (shouldn't be in output)
                                    throw v23;
                                }
                            }
                            var5_7 = v24;
                            var5_7();
                            var5_7.setEnableOfflineMessaging(var3_4.enableOfflineMessaging);
                            v24.setEnableHistoricalMessaging(var3_4.enableHistoricalMessaging);
                            v21 = v22.mRtmServiceNative.sendMessageToPeer(var1_1, var8_11, (ISendMessageOptions)var5_7);
                            ** continue;
lbl101:
                            // 1 sources

                            Logging.d(RtmClientImpl.TAG, "sendMessageToPeer peerId: " + Logging.desensetize(var1_1) + " ret: " + var3_5);
                            var5_7 = RtmSdkContext.swigValueToEnumSafe(var3_5, PEER_MESSAGE_ERR_CODE.class);
                            if (var5_7 != PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK || var4_6 == null) break block33;
                            this.mSendPeerMessageCallbacks.put(var8_11.getMessageId(), var4_6);
                        }
                        v25 = var8_11;
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        v25.release();
lbl115:
                        // 3 sources

                        // ** MonitorExit[var6_8] (shouldn't be in output)
                        if (var5_7 == PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK || var4_6 == null) break block34;
                        if (var5_7 != null) break block35;
                        var5_7 = PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_FAILURE;
                    }
                    this = v26;
                    v27 = var5_7;
                    var1_2 = v27.swigValue();
                    v26 = new ErrorInfo(var1_2, v27.toString());
                    var4_6.onFailure(this);
                }
                return;
            }
        }
    }

    public void removeChannel(RtmChannelImpl rtmChannelImpl) {
        if (rtmChannelImpl != null) {
            Logging.i(TAG, "remove channel " + Logging.desensetize(rtmChannelImpl.getId()) + " from rtm client");
            this.mRefChannels.remove(rtmChannelImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RtmChannel createChannel(String string2, RtmChannelListener rtmChannelListener) throws RuntimeException {
        RtmClientImpl rtmClientImpl = this;
        byte[] byArray = rtmClientImpl.mRtmLock;
        synchronized (rtmClientImpl.mRtmLock) {
            RtmChannelImpl rtmChannelImpl;
            RtmChannelImpl rtmChannelImpl2;
            RtmChannelImpl rtmChannelImpl3;
            block17: {
                block16: {
                    rtmChannelImpl3 = null;
                    Iterator<RtmChannelImpl> iterator = rtmClientImpl.mRefChannels.iterator();
                    while (true) {
                        if (!iterator.hasNext()) break block16;
                        rtmChannelImpl2 = iterator.next();
                        if (!rtmChannelImpl2.getId().equals(string2)) continue;
                        break;
                    }
                    if (!rtmChannelImpl2.isChannelNativeReady()) break block17;
                    Logging.w(TAG, "channel " + Logging.desensetize(string2) + " created already");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return rtmChannelImpl2;
                }
                rtmChannelImpl2 = rtmChannelImpl3;
            }
            if (rtmChannelImpl2 != null) {
                this.mRefChannels.remove(rtmChannelImpl2);
            }
            RtmClientImpl rtmClientImpl2 = this;
            Logging.i(TAG, "createChannel " + Logging.desensetize(string2));
            rtmChannelImpl3 = rtmChannelImpl;
            rtmChannelImpl = new RtmChannelImpl(string2, rtmChannelListener);
            if (!rtmClientImpl2.isNativeReady()) throw new RuntimeException("RtmClient instance is released!");
            if (!rtmChannelImpl3.attach(this)) throw new RuntimeException("not allowed to create the channel or size over limit!");
            RtmChannelImpl rtmChannelImpl4 = rtmChannelImpl3;
            byte[] byArray2 = byArray;
            this.mRefChannels.add(rtmChannelImpl3);
            // ** MonitorExit[v5] (shouldn't be in output)
            return rtmChannelImpl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public RtmCallManager getRtmCallManager() {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "getRtmCallManager");
        var1_1 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            if (v0.rtmCallManager == null) ** GOTO lbl27
            v1 = this;
            v2 = v1;
            var2_2 = v1.rtmCallManager.lock;
            ** synchronized (v1.rtmCallManager.lock)
lbl-1000:
            // 1 sources

            {
                block13: {
                    block12: {
                        if (!v2.rtmCallManager.isNativeAttached) ** GOTO lbl25
                        {
                            catch (Throwable v3) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                throw v3;
                            }
                        }
                        v4 = this.rtmCallManager;
                        v5 = var1_1;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        // ** MonitorExit[v5] (shouldn't be in output)
                        return v4;
lbl25:
                        // 1 sources

                        // ** MonitorExit[var2_2] (shouldn't be in output)
lbl27:
                        // 2 sources

                        this.rtmCallManager = new RtmCallManagerImpl();
                        if (!this.isNativeReady()) break block12;
                        if (!this.rtmCallManager.attach(this)) break block12;
                        v6 = true;
                        break block13;
                    }
                    v6 = false;
                }
                if (!v6) ** GOTO lbl43
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.rtmCallManager;
lbl43:
                // 1 sources

                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void queryPeersOnlineStatus(Set<String> var1_1, ResultCallback<Map<String, Boolean>> var2_3) {
        block14: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "queryPeersOnlineStatus");
            var3_4 = null;
            var4_5 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl38
            v1 = var1_1;
            var3_4 = this.mRtmCallbackLock;
            {
                catch (Throwable v2) {
                    // MONITOREXIT : var4_5
                    throw v2;
                }
            }
            var5_6 = new String[]{};
            if (v1 != null && !var1_1.isEmpty()) {
                var5_6 = var1_1.toArray(var5_6);
            }
            v3 = this;
            var1_1 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var5_7 = v3.mRtmServiceNative.queryPeersOnlineStatus(var5_6, var5_6.length, (SWIGTYPE_p_long_long)var1_1);
            Logging.i(RtmClientImpl.TAG, "queryPeersOnlineStatus, ret: " + var5_7);
            var5_8 = RtmSdkContext.swigValueToEnumSafe(var5_7, QUERY_PEERS_ONLINE_STATUS_ERR.class);
            if (var5_8 != QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK || var2_3 == null) break block14;
            this.mQueryOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference((SWIGTYPE_p_long_long)var1_1), var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl39
        }
        catch (Throwable v5) {
            block15: {
                // MONITOREXIT : var3_4
                throw v5;
lbl38:
                // 1 sources

                var5_8 = var3_4;
lbl39:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_8 == QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_8 != null) break block15;
                var5_8 = QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_FAILURE;
            }
            this = v6;
            v7 = var5_8;
            var1_2 = v7.swigValue();
            v6 = new ErrorInfo(var1_2, v7.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void subscribePeersOnlineStatus(Set<String> var1_1, ResultCallback<Void> var2_3) {
        block14: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "subscribePeersOnlineStatus");
            var3_4 = null;
            var4_5 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl38
            v1 = var1_1;
            var3_4 = this.mRtmCallbackLock;
            {
                catch (Throwable v2) {
                    // MONITOREXIT : var4_5
                    throw v2;
                }
            }
            var5_6 = new String[]{};
            if (v1 != null && !var1_1.isEmpty()) {
                var5_6 = var1_1.toArray(var5_6);
            }
            v3 = this;
            var1_1 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var5_7 = v3.mRtmServiceNative.subscribePeersOnlineStatus(var5_6, var5_6.length, (SWIGTYPE_p_long_long)var1_1);
            Logging.i(RtmClientImpl.TAG, "subscribePeersOnlineStatus, ret: " + var5_7);
            var5_8 = RtmSdkContext.swigValueToEnumSafe(var5_7, PEER_SUBSCRIPTION_STATUS_ERR.class);
            if (var5_8 != PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK || var2_3 == null) break block14;
            this.mSubscribePeersOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference((SWIGTYPE_p_long_long)var1_1), var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl39
        }
        catch (Throwable v5) {
            block15: {
                // MONITOREXIT : var3_4
                throw v5;
lbl38:
                // 1 sources

                var5_8 = var3_4;
lbl39:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_8 == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_8 != null) break block15;
                var5_8 = PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_FAILURE;
            }
            this = v6;
            v7 = var5_8;
            var1_2 = v7.swigValue();
            v6 = new ErrorInfo(var1_2, v7.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void unsubscribePeersOnlineStatus(Set<String> var1_1, ResultCallback<Void> var2_3) {
        block14: {
            v0 = this;
            Logging.i(RtmClientImpl.TAG, "subscribePeersOnlineStatus");
            var3_4 = null;
            var4_5 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl38
            v1 = var1_1;
            var3_4 = this.mRtmCallbackLock;
            {
                catch (Throwable v2) {
                    // MONITOREXIT : var4_5
                    throw v2;
                }
            }
            var5_6 = new String[]{};
            if (v1 != null && !var1_1.isEmpty()) {
                var5_6 = var1_1.toArray(var5_6);
            }
            v3 = this;
            var1_1 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var5_7 = v3.mRtmServiceNative.unsubscribePeersOnlineStatus(var5_6, var5_6.length, (SWIGTYPE_p_long_long)var1_1);
            Logging.i(RtmClientImpl.TAG, "unsubscribePeersOnlineStatus, ret: " + var5_7);
            var5_8 = RtmSdkContext.swigValueToEnumSafe(var5_7, PEER_SUBSCRIPTION_STATUS_ERR.class);
            if (var5_8 != PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK || var2_3 == null) break block14;
            this.mSubscribePeersOnlineStatusCallbacks.put(SWIGTYPE_p_long_long.dereference((SWIGTYPE_p_long_long)var1_1), var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl39
        }
        catch (Throwable v5) {
            block15: {
                // MONITOREXIT : var3_4
                throw v5;
lbl38:
                // 1 sources

                var5_8 = var3_4;
lbl39:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_8 == PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_8 != null) break block15;
                var5_8 = PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_FAILURE;
            }
            this = v6;
            v7 = var5_8;
            var1_2 = v7.swigValue();
            v6 = new ErrorInfo(var1_2, v7.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void queryPeersBySubscriptionOption(Integer var1_1, ResultCallback<Set<String>> var2_4) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "queryPeersBySubscriptionOption");
            if (var1_1.intValue() != 0) {
                Logging.e(RtmClientImpl.TAG, "invalid subscription option");
                return;
            }
            v0 = this;
            var1_1 = PEER_SUBSCRIPTION_OPTION.PEER_SUBSCRIPTION_OPTION_ONLINE_STATUS;
            var3_5 = null;
            var4_6 = v0.mRtmLock;
            // MONITORENTER : v0.mRtmLock
            if (!v0.isNativeReady()) ** GOTO lbl38
            v1 = this;
            v2 = v1;
            var3_5 = v1.mRtmCallbackLock;
            {
                catch (Throwable v3) {
                    // MONITOREXIT : var4_6
                    throw v3;
                }
            }
            var5_7 = v4;
            v4 = new SWIGTYPE_p_long_long();
            var1_2 = v2.mRtmServiceNative.queryPeersBySubscriptionOption((PEER_SUBSCRIPTION_OPTION)var1_1, var5_7);
            Logging.i(RtmClientImpl.TAG, "queryPeersBySubscriptionOption, ret: " + var1_2);
            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.class);
            if (var1_1 != QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK || var2_4 == null) break block14;
            this.mQueryPeersBySubscriptionOptionCallbacks.put(SWIGTYPE_p_long_long.dereference(var5_7), var2_4);
        }
        try {
            // MONITOREXIT : var3_5
            ** GOTO lbl39
        }
        catch (Throwable v5) {
            block15: {
                // MONITOREXIT : var3_5
                throw v5;
lbl38:
                // 1 sources

                var1_1 = var3_5;
lbl39:
                // 2 sources

                // MONITOREXIT : var4_6
                if (var1_1 == QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK) return;
                if (var2_4 == null) return;
                if (var1_1 != null) break block15;
                var1_1 = QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_FAILURE;
            }
            this = v6;
            v7 = var1_1;
            var1_3 = v7.swigValue();
            v6 = new ErrorInfo(var1_3, v7.toString());
            var2_4.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void renewToken(String var1_1, ResultCallback<Void> var2_3) {
        block14: {
            var3_4 = RtmClientImpl.TAG;
            var4_5 = new StringBuilder().append("renewToken: ");
            if (var1_1 != null && var1_1.length() >= 8) {
                v0 = var1_1;
                var5_6 = var1_1.substring(0, 4) + "****" + v0.substring(v0.length() - 4);
            } else {
                var5_6 = "invalid!";
            }
            v1 = this;
            Logging.i((String)var3_4, var4_5.append((String)var5_6).toString());
            var3_4 = null;
            var4_5 = v1.mRtmLock;
            // MONITORENTER : v1.mRtmLock
            if (!v1.isNativeReady()) ** GOTO lbl37
            v2 = this;
            v3 = v2;
            var3_4 = v2.mRtmCallbackLock;
            {
                catch (Throwable v4) {
                    // MONITOREXIT : var4_5
                    throw v4;
                }
            }
            var5_7 = v3.mRtmServiceNative.renewToken(var1_1);
            Logging.i(RtmClientImpl.TAG, "renewToken ret: " + var5_7);
            var5_6 = RtmSdkContext.swigValueToEnumSafe(var5_7, RENEW_TOKEN_ERR_CODE.class);
            if (var5_6 != RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK || var2_3 == null) break block14;
            this.mRenewTokenCallbacks.put(var1_1, var2_3);
        }
        try {
            // MONITOREXIT : var3_4
            ** GOTO lbl38
        }
        catch (Throwable v5) {
            block15: {
                // MONITOREXIT : var3_4
                throw v5;
lbl37:
                // 1 sources

                var5_6 = var3_4;
lbl38:
                // 2 sources

                // MONITOREXIT : var4_5
                if (var5_6 == RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK) return;
                if (var2_3 == null) return;
                if (var5_6 != null) break block15;
                var5_6 = RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_FAILURE;
            }
            this = v6;
            v7 = var5_6;
            var1_2 = v7.swigValue();
            v6 = new ErrorInfo(var1_2, v7.toString());
            var2_3.onFailure(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setLocalUserAttributes(List<RtmAttribute> var1_1, ResultCallback<Void> var2_3) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "setLocalUserAttributes");
            var3_4 = null;
            if (var1_1 == null || var1_1.isEmpty()) break block14;
            v0 = this;
            var1_1 = v0.convertAttrListToInternal((List<RtmAttribute>)var1_1);
            var4_5 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var5_6 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var3_4 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.setLocalUserAttributes((IRtmAttribute[])var1_1, var4_5);
                            Logging.i(RtmClientImpl.TAG, "setLocalUserAttributes ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var2_3 == null) break block13;
                            try {
                                this.mSetLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var3_4;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var2_3);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute list is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var2_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addOrUpdateLocalUserAttributes(List<RtmAttribute> var1_1, ResultCallback<Void> var2_3) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "addOrUpdateLocalUserAttributes");
            var3_4 = null;
            if (var1_1 == null || var1_1.isEmpty()) break block14;
            v0 = this;
            var1_1 = v0.convertAttrListToInternal((List<RtmAttribute>)var1_1);
            var4_5 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var5_6 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var3_4 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.addOrUpdateLocalUserAttributes((IRtmAttribute[])var1_1, var4_5);
                            Logging.i(RtmClientImpl.TAG, "addOrUpdateLocalUserAttributes ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var2_3 == null) break block13;
                            try {
                                this.mAddOrUpdateLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var3_4;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var2_3);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute list is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var2_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteLocalUserAttributesByKeys(List<String> var1_1, ResultCallback<Void> var2_3) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "deleteLocalUserAttributesByKeys");
            var3_4 = null;
            if (var1_1 == null || var1_1.isEmpty()) break block14;
            v0 = this;
            var4_5 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var5_6 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var3_4 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.deleteLocalUserAttributesByKeys(var1_1.toArray(new String[0]), var4_5);
                            Logging.i(RtmClientImpl.TAG, "deleteLocalUserAttributesByKeys ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var2_3 == null) break block13;
                            try {
                                this.mDeleteLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var3_4;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var2_3);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute keys is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var2_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearLocalUserAttributes(ResultCallback<Void> var1_1) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "clearLocalUserAttributes");
        var2_2 = null;
        var3_3 = v1;
        v1 = new SWIGTYPE_p_long_long();
        var4_4 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            if (v0.isNativeReady()) {
                v2 = this;
                v3 = v2;
                var2_2 = v2.mRtmCallbackLock;
            }
            ** GOTO lbl-1000
            {
                catch (Throwable v4) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    throw v4;
                }
                {
                    ** synchronized (v2.mRtmCallbackLock)
                }
lbl-1000:
                // 1 sources

                {
                    block13: {
                        var5_5 = v3.mRtmServiceNative.clearLocalUserAttributes(var3_3);
                        Logging.i(RtmClientImpl.TAG, "clearLocalUserAttributes ret: " + var5_5);
                        v5 = RtmSdkContext.swigValueToEnumSafe(var5_5, ATTRIBUTE_OPERATION_ERR.class);
                        var5_6 /* !! */  = (byte[])v5;
                        if (v5 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var1_1 == null) break block13;
                        try {
                            this.mClearLocalUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var3_3), var1_1);
                        }
                        catch (Throwable v6) {}
                        {
                            throw v6;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    ** GOTO lbl-1000
                }
            }
lbl-1000:
            // 1 sources

            {
                var5_6 /* !! */  = var2_2;
lbl-1000:
                // 2 sources

                {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var5_6 /* !! */ , var1_1);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getUserAttributes(String var1_1, ResultCallback<List<RtmAttribute>> var2_3) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "getUserAttributes");
        var3_4 = null;
        var4_5 = v1;
        v1 = new SWIGTYPE_p_long_long();
        var5_6 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            if (v0.isNativeReady()) {
                v2 = this;
                v3 = v2;
                var3_4 = v2.mRtmCallbackLock;
            }
            ** GOTO lbl-1000
            {
                catch (Throwable v4) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    throw v4;
                }
                {
                    ** synchronized (v2.mRtmCallbackLock)
                }
lbl-1000:
                // 1 sources

                {
                    block13: {
                        var1_2 = v3.mRtmServiceNative.getUserAttributes((String)var1_1, var4_5);
                        Logging.i(RtmClientImpl.TAG, "getUserAttributes ret: " + var1_2);
                        var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                        if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var2_3 == null) break block13;
                        try {
                            this.mGetUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                        }
                        catch (Throwable v5) {}
                        {
                            throw v5;
                        }
                    }
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    ** GOTO lbl-1000
                }
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = var3_4;
lbl-1000:
                // 2 sources

                {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var2_3);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getUserAttributesByKeys(String var1_1, List<String> var2_3, ResultCallback<List<RtmAttribute>> var3_4) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "getUserAttributesByKeys");
            var4_5 = null;
            if (var2_3 == null || var2_3.isEmpty()) break block14;
            v0 = this;
            var5_6 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var6_7 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var4_5 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.getUserAttributesByKeys((String)var1_1, var2_3.toArray(new String[0]), var5_6);
                            Logging.i(RtmClientImpl.TAG, "getUserAttributesByKeys ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var3_4 == null) break block13;
                            try {
                                this.mGetUserAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var5_6), var3_4);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var4_5;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var3_4);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute keys is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var3_4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setChannelAttributes(String var1_1, List<RtmChannelAttribute> var2_3, ChannelAttributeOptions var3_4, ResultCallback<Void> var4_5) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "setChannelAttributes");
            var5_6 = null;
            if (var2_3 == null || var2_3.isEmpty()) break block14;
            v0 = this;
            var2_3 = this.convertChannelAttrListToInternal((List<RtmChannelAttribute>)var2_3);
            var3_4 = v0.convertChannelAttrOptToInternal((ChannelAttributeOptions)var3_4);
            var6_7 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var7_8 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var5_6 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.setChannelAttributes((String)var1_1, var2_3, (IChannelAttributeOptions)var3_4, var6_7);
                            Logging.i(RtmClientImpl.TAG, "setChannelAttributes ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var4_5 == null) break block13;
                            try {
                                this.mSetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_7), var4_5);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var5_6;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var4_5);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute list is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var4_5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addOrUpdateChannelAttributes(String var1_1, List<RtmChannelAttribute> var2_3, ChannelAttributeOptions var3_4, ResultCallback<Void> var4_5) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "addOrUpdateChannelAttributes");
            var5_6 = null;
            if (var2_3 == null || var2_3.isEmpty()) break block14;
            v0 = this;
            var2_3 = this.convertChannelAttrListToInternal((List<RtmChannelAttribute>)var2_3);
            var3_4 = v0.convertChannelAttrOptToInternal((ChannelAttributeOptions)var3_4);
            var6_7 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var7_8 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var5_6 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.addOrUpdateChannelAttributes((String)var1_1, var2_3, (IChannelAttributeOptions)var3_4, var6_7);
                            Logging.i(RtmClientImpl.TAG, "addOrUpdateChannelAttributes ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var4_5 == null) break block13;
                            try {
                                this.mAddOrUpdateChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_7), var4_5);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var5_6;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var4_5);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute list is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var4_5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteChannelAttributesByKeys(String var1_1, List<String> var2_3, ChannelAttributeOptions var3_4, ResultCallback<Void> var4_5) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "deleteChannelAttributesByKeys");
            var5_6 = null;
            if (var2_3 == null || var2_3.isEmpty()) break block14;
            v0 = this;
            var3_4 = v0.convertChannelAttrOptToInternal((ChannelAttributeOptions)var3_4);
            var6_7 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var7_8 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var5_6 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.deleteChannelAttributesByKeys((String)var1_1, var2_3.toArray(new String[0]), (IChannelAttributeOptions)var3_4, var6_7);
                            Logging.i(RtmClientImpl.TAG, "deleteChannelAttributesByKeys ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var4_5 == null) break block13;
                            try {
                                this.mDeleteChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var6_7), var4_5);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var5_6;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var4_5);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute keys is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var4_5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearChannelAttributes(String var1_1, ChannelAttributeOptions var2_3, ResultCallback<Void> var3_4) {
        v0 = this;
        v1 = var2_3;
        Logging.i(RtmClientImpl.TAG, "clearChannelAttributes");
        var2_3 = null;
        var4_5 = v0.convertChannelAttrOptToInternal((ChannelAttributeOptions)v1);
        var5_6 = v2;
        v2 = new SWIGTYPE_p_long_long();
        var6_7 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            if (v0.isNativeReady()) {
                v3 = this;
                v4 = v3;
                var2_3 = v3.mRtmCallbackLock;
            }
            ** GOTO lbl-1000
            {
                catch (Throwable v5) {
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    throw v5;
                }
                {
                    ** synchronized (v3.mRtmCallbackLock)
                }
lbl-1000:
                // 1 sources

                {
                    block13: {
                        var1_2 = v4.mRtmServiceNative.clearChannelAttributes((String)var1_1, var4_5, var5_6);
                        Logging.i(RtmClientImpl.TAG, "clearChannelAttributes ret: " + var1_2);
                        var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                        if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var3_4 == null) break block13;
                        try {
                            this.mClearChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var5_6), var3_4);
                        }
                        catch (Throwable v6) {}
                        {
                            throw v6;
                        }
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    ** GOTO lbl-1000
                }
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = var2_3;
lbl-1000:
                // 2 sources

                {
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var3_4);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getChannelAttributes(String var1_1, ResultCallback<List<RtmChannelAttribute>> var2_3) {
        v0 = this;
        Logging.i(RtmClientImpl.TAG, "getChannelAttributes");
        var3_4 = null;
        var4_5 = v1;
        v1 = new SWIGTYPE_p_long_long();
        var5_6 = v0.mRtmLock;
        synchronized (v0.mRtmLock) {
            if (v0.isNativeReady()) {
                v2 = this;
                v3 = v2;
                var3_4 = v2.mRtmCallbackLock;
            }
            ** GOTO lbl-1000
            {
                catch (Throwable v4) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    throw v4;
                }
                {
                    ** synchronized (v2.mRtmCallbackLock)
                }
lbl-1000:
                // 1 sources

                {
                    block13: {
                        var1_2 = v3.mRtmServiceNative.getChannelAttributes((String)var1_1, var4_5);
                        Logging.i(RtmClientImpl.TAG, "getChannelAttributes ret: " + var1_2);
                        var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                        if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var2_3 == null) break block13;
                        try {
                            this.mGetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                        }
                        catch (Throwable v5) {}
                        {
                            throw v5;
                        }
                    }
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    ** GOTO lbl-1000
                }
            }
lbl-1000:
            // 1 sources

            {
                var1_1 = var3_4;
lbl-1000:
                // 2 sources

                {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var2_3);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getChannelAttributesByKeys(String var1_1, List<String> var2_3, ResultCallback<List<RtmChannelAttribute>> var3_4) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "getChannelAttributesByKeys");
            var4_5 = null;
            if (var2_3 == null || var2_3.isEmpty()) break block14;
            v0 = this;
            var5_6 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var6_7 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var4_5 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.getChannelAttributesByKeys((String)var1_1, var2_3.toArray(new String[0]), var5_6);
                            Logging.i(RtmClientImpl.TAG, "getChannelAttributesByKeys ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, ATTRIBUTE_OPERATION_ERR.class);
                            if (var1_1 != ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK || var3_4 == null) break block13;
                            try {
                                this.mGetChannelAttrCallbacks.put(SWIGTYPE_p_long_long.dereference(var5_6), var3_4);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var4_5;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        this.processAttrApiError((ATTRIBUTE_OPERATION_ERR)var1_1, var3_4);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "attribute keys is null or empty!");
        this.processAttrApiError(ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_INVALID_ARGUMENT, var3_4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getChannelMemberCount(List<String> var1_1, ResultCallback<List<RtmChannelMemberCount>> var2_3) {
        block14: {
            Logging.i(RtmClientImpl.TAG, "getChannelMemberCount");
            var3_4 = null;
            if (var1_1 == null || var1_1.isEmpty()) break block14;
            v0 = this;
            var4_5 = v1;
            v1 = new SWIGTYPE_p_long_long();
            var5_6 = v0.mRtmLock;
            synchronized (v0.mRtmLock) {
                if (v0.isNativeReady()) {
                    v2 = this;
                    v3 = v2;
                    var3_4 = v2.mRtmCallbackLock;
                }
                ** GOTO lbl-1000
                {
                    catch (Throwable v4) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        throw v4;
                    }
                    {
                        ** synchronized (v2.mRtmCallbackLock)
                    }
lbl-1000:
                    // 1 sources

                    {
                        block13: {
                            var1_2 = v3.mRtmServiceNative.getChannelMemberCount(var1_1.toArray(new String[0]), var4_5);
                            Logging.i(RtmClientImpl.TAG, "getChannelMemberCount ret: " + var1_2);
                            var1_1 = RtmSdkContext.swigValueToEnumSafe(var1_2, GET_CHANNEL_MEMBER_COUNT_ERR.class);
                            if (var1_1 != GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK || var2_3 == null) break block13;
                            try {
                                this.mGetChannelMemberCountCallbacks.put(SWIGTYPE_p_long_long.dereference(var4_5), var2_3);
                            }
                            catch (Throwable v5) {}
                            {
                                throw v5;
                            }
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        ** GOTO lbl-1000
                    }
                }
lbl-1000:
                // 1 sources

                {
                    var1_1 = var3_4;
lbl-1000:
                    // 2 sources

                    {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        this.processGetChannelMemberCountApiError((GET_CHANNEL_MEMBER_COUNT_ERR)var1_1, var2_3);
                        return;
                    }
                }
            }
        }
        Logging.e(RtmClientImpl.TAG, "channel Ids is null or empty!");
        this.processGetChannelMemberCountApiError(GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_INVALID_ARGUMENT, var2_3);
    }

    @Override
    public int setParameters(String string2) {
        return this.mRtmServiceNative.setParameters(string2);
    }

    @Override
    public int setLogFile(String string2) {
        return this.mRtmServiceNative.setLogFile(string2);
    }

    @Override
    public int setLogFilter(int n2) {
        return this.mRtmServiceNative.setLogFilter(n2);
    }

    @Override
    public int setLogFileSize(int n2) {
        return this.mRtmServiceNative.setLogFileSize(n2);
    }

    public String GetSessionId() {
        IRtmService iRtmService = ((RtmClientImpl)((Object)iRtmService)).mRtmServiceNative;
        if (iRtmService == null) {
            return "";
        }
        return iRtmService.GetSessionId();
    }

    private class RtmServiceEventHandlerNative
    extends IRtmServiceEventHandler {
        private RtmServiceEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAttrResultCallbackSimple(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR, LruCache<Long, ResultCallback<Void>> lruCache) {
            if (aTTRIBUTE_OPERATION_ERR == null) {
                Logging.e(TAG, "attr result callback with null error code!");
                return;
            }
            byte[] byArray = ((RtmServiceEventHandlerNative)object).RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                ResultCallback resultCallback;
                block7: {
                    resultCallback = (ResultCallback)lruCache.remove(l2);
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (resultCallback != null) break block7;
                    Logging.e(TAG, "attr result callback target lost!");
                    return;
                }
                if (aTTRIBUTE_OPERATION_ERR == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                    resultCallback.onSuccess(null);
                } else {
                    ErrorInfo errorInfo;
                    object = errorInfo;
                    ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR2 = aTTRIBUTE_OPERATION_ERR;
                    int n2 = aTTRIBUTE_OPERATION_ERR2.swigValue();
                    errorInfo = new ErrorInfo(n2, aTTRIBUTE_OPERATION_ERR2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoginSuccess() {
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = this;
            Logging.i(TAG, "onLoginSuccess");
            ResultCallback resultCallback = null;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            synchronized (byArray) {
                block7: {
                    if (rtmServiceEventHandlerNative.RtmClientImpl.this.mLoginCallback == null) break block7;
                    RtmServiceEventHandlerNative rtmServiceEventHandlerNative2 = this;
                    RtmServiceEventHandlerNative rtmServiceEventHandlerNative3 = rtmServiceEventHandlerNative2;
                    resultCallback = rtmServiceEventHandlerNative2.RtmClientImpl.this.mLoginCallback;
                    RtmClientImpl.access$302(rtmServiceEventHandlerNative3.RtmClientImpl.this, null);
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                if (resultCallback != null) {
                    resultCallback.onSuccess(null);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onLoginFailure(LOGIN_ERR_CODE lOGIN_ERR_CODE) {
            block6: {
                ErrorInfo errorInfo;
                ErrorInfo errorInfo2;
                Logging.e(TAG, "onLoginFailure, err: " + lOGIN_ERR_CODE);
                if (lOGIN_ERR_CODE == null) {
                    return;
                }
                RtmServiceEventHandlerNative rtmServiceEventHandlerNative = errorInfo2;
                ResultCallback resultCallback = null;
                byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
                synchronized (byArray) {
                    if (rtmServiceEventHandlerNative.RtmClientImpl.this.mLoginCallback != null) {
                        RtmServiceEventHandlerNative rtmServiceEventHandlerNative2 = errorInfo2;
                        resultCallback = rtmServiceEventHandlerNative2.RtmClientImpl.this.mLoginCallback;
                        RtmClientImpl.access$302(rtmServiceEventHandlerNative2.RtmClientImpl.this, null);
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : byArray
                        if (resultCallback == null) break block6;
                    }
                }
                errorInfo2 = errorInfo;
                LOGIN_ERR_CODE lOGIN_ERR_CODE2 = lOGIN_ERR_CODE;
                int n2 = lOGIN_ERR_CODE2.swigValue();
                errorInfo = new ErrorInfo(n2, lOGIN_ERR_CODE2.toString());
                resultCallback.onFailure(errorInfo2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onLogout(LOGOUT_ERR_CODE lOGOUT_ERR_CODE) {
            ErrorInfo errorInfo;
            ResultCallback resultCallback;
            ErrorInfo errorInfo2;
            block6: {
                Logging.i(TAG, "onLogout, err: " + lOGOUT_ERR_CODE);
                if (lOGOUT_ERR_CODE == null) {
                    return;
                }
                RtmServiceEventHandlerNative rtmServiceEventHandlerNative = errorInfo2;
                resultCallback = null;
                byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
                synchronized (byArray) {
                    if (rtmServiceEventHandlerNative.RtmClientImpl.this.mLogoutCallback != null) {
                        RtmServiceEventHandlerNative rtmServiceEventHandlerNative2 = errorInfo2;
                        resultCallback = rtmServiceEventHandlerNative2.RtmClientImpl.this.mLogoutCallback;
                        RtmClientImpl.access$402(rtmServiceEventHandlerNative2.RtmClientImpl.this, null);
                    }
                    {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : byArray
                        if (resultCallback == null) return;
                        if (lOGOUT_ERR_CODE != LOGOUT_ERR_CODE.LOGOUT_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        return;
                    }
                }
            }
            errorInfo2 = errorInfo;
            LOGOUT_ERR_CODE lOGOUT_ERR_CODE2 = lOGOUT_ERR_CODE;
            int n2 = lOGOUT_ERR_CODE2.swigValue();
            errorInfo = new ErrorInfo(n2, lOGOUT_ERR_CODE2.toString());
            resultCallback.onFailure(errorInfo2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendMessageResult(long l2, PEER_MESSAGE_ERR_CODE pEER_MESSAGE_ERR_CODE) {
            Logging.i(TAG, "onSendMessageResult, messageId: " + l2 + " err: " + pEER_MESSAGE_ERR_CODE);
            if (pEER_MESSAGE_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mSendPeerMessageCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (pEER_MESSAGE_ERR_CODE != PEER_MESSAGE_ERR_CODE.PEER_MESSAGE_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        break block5;
                    }
                    object = errorInfo;
                    PEER_MESSAGE_ERR_CODE pEER_MESSAGE_ERR_CODE2 = pEER_MESSAGE_ERR_CODE;
                    int n2 = pEER_MESSAGE_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, pEER_MESSAGE_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        @Override
        public void onConnectionStateChanged(CONNECTION_STATE cONNECTION_STATE, CONNECTION_CHANGE_REASON cONNECTION_CHANGE_REASON) {
            Logging.i(TAG, "onConnectionStateChanged, state: " + cONNECTION_STATE + " reason: " + cONNECTION_CHANGE_REASON);
            if (cONNECTION_STATE != null && cONNECTION_CHANGE_REASON != null) {
                if (RtmClientImpl.this.mClientListener == null) {
                    Logging.w(TAG, "empty client listener!");
                    return;
                }
                int n2 = cONNECTION_STATE.swigValue();
                RtmClientImpl.this.mClientListener.onConnectionStateChanged(n2, cONNECTION_CHANGE_REASON.swigValue());
                return;
            }
        }

        @Override
        public void onMessageReceivedFromPeer(String string2, IMessage object) {
            if (string2 != null && !string2.isEmpty() && object != null && RtmClientImpl.this.mClientListener != null) {
                RtmMessageImpl rtmMessageImpl = null;
                if (((IMessage)object).getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_TEXT) {
                    RtmMessageImpl rtmMessageImpl2;
                    rtmMessageImpl = rtmMessageImpl2;
                    IMessage iMessage = object;
                    object = iMessage.getText();
                    long l2 = iMessage.getServerReceivedTs();
                    boolean bl = iMessage.isOfflineMessage();
                    rtmMessageImpl2 = new RtmMessageImpl((String)object, l2, bl);
                } else if (((IMessage)object).getMessageType() == MESSAGE_TYPE.MESSAGE_TYPE_RAW) {
                    RtmMessageImpl rtmMessageImpl3;
                    rtmMessageImpl = rtmMessageImpl3;
                    Object object2 = object;
                    object = ((IMessage)object2).getRawMessageData();
                    String string3 = ((IMessage)object2).getText();
                    long l3 = ((IMessage)object2).getServerReceivedTs();
                    boolean bl = ((IMessage)object2).isOfflineMessage();
                    rtmMessageImpl3 = new RtmMessageImpl((byte[])object, string3, l3, bl);
                }
                Logging.i(TAG, "onMessageReceivedFromPeer, peerId: " + Logging.desensetize(string2));
                RtmClientImpl.this.mClientListener.onMessageReceived(rtmMessageImpl, string2);
                return;
            }
            Logging.w(TAG, "empty listener or invalid message received!");
        }

        @Override
        public void onImageMessageReceivedFromPeer(String string2, IImageMessage iImageMessage) {
            if (string2 != null && !string2.isEmpty() && iImageMessage != null && ((RtmServiceEventHandlerNative)((Object)rtmImageMessageImpl2)).RtmClientImpl.this.mClientListener != null) {
                RtmImageMessageImpl rtmImageMessageImpl;
                RtmServiceEventHandlerNative rtmServiceEventHandlerNative = rtmImageMessageImpl2;
                RtmImageMessageImpl rtmImageMessageImpl2 = rtmImageMessageImpl;
                rtmImageMessageImpl2();
                rtmImageMessageImpl2.setText(iImageMessage.getText());
                rtmImageMessageImpl2.setSize(iImageMessage.getSize());
                rtmImageMessageImpl2.setFileName(iImageMessage.getFileName());
                rtmImageMessageImpl2.setMediaId(iImageMessage.getMediaId());
                rtmImageMessageImpl2.setThumbnail(iImageMessage.getThumbnailData());
                rtmImageMessageImpl2.setHeight(iImageMessage.getHeight());
                rtmImageMessageImpl2.setWidth(iImageMessage.getWidth());
                rtmImageMessageImpl2.setThumbnailHeight(iImageMessage.getThumbnailHeight());
                rtmImageMessageImpl2.setThumbnailWidth(iImageMessage.getThumbnailWidth());
                rtmImageMessageImpl2.setServerReceivedTs(iImageMessage.getServerReceivedTs());
                rtmImageMessageImpl.setIsOfflineMessage(iImageMessage.isOfflineMessage());
                Logging.i(TAG, "onImageMessageReceivedFromPeer, peerId: " + Logging.desensetize(string2));
                rtmServiceEventHandlerNative.RtmClientImpl.this.mClientListener.onImageMessageReceivedFromPeer(rtmImageMessageImpl2, string2);
                return;
            }
            Logging.w(TAG, "empty listener or invalid message received!");
        }

        @Override
        public void onFileMessageReceivedFromPeer(String string2, IFileMessage iFileMessage) {
            if (string2 != null && !string2.isEmpty() && iFileMessage != null && ((RtmServiceEventHandlerNative)((Object)rtmFileMessageImpl2)).RtmClientImpl.this.mClientListener != null) {
                RtmFileMessageImpl rtmFileMessageImpl;
                RtmServiceEventHandlerNative rtmServiceEventHandlerNative = rtmFileMessageImpl2;
                RtmFileMessageImpl rtmFileMessageImpl2 = rtmFileMessageImpl;
                rtmFileMessageImpl2();
                rtmFileMessageImpl2.setText(iFileMessage.getText());
                rtmFileMessageImpl2.setSize(iFileMessage.getSize());
                rtmFileMessageImpl2.setFileName(iFileMessage.getFileName());
                rtmFileMessageImpl2.setMediaId(iFileMessage.getMediaId());
                rtmFileMessageImpl2.setThumbnail(iFileMessage.getThumbnailData());
                rtmFileMessageImpl2.setServerReceivedTs(iFileMessage.getServerReceivedTs());
                rtmFileMessageImpl.setIsOfflineMessage(iFileMessage.isOfflineMessage());
                Logging.i(TAG, "onFileMessageReceivedFromPeer, peerId: " + Logging.desensetize(string2));
                rtmServiceEventHandlerNative.RtmClientImpl.this.mClientListener.onFileMessageReceivedFromPeer(rtmFileMessageImpl2, string2);
                return;
            }
            Logging.w(TAG, "empty listener or invalid message received!");
        }

        @Override
        public void onMediaUploadingProgress(long l2, MediaOperationProgress mediaOperationProgress) {
            RtmMediaOperationProgress rtmMediaOperationProgress;
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = rtmMediaOperationProgress2;
            Logging.i(TAG, "onMediaUploadingProgress, requestId: " + l2 + ", totalSize: " + mediaOperationProgress.getTotalSize() + ", currentSize: " + mediaOperationProgress.getCurrentSize());
            RtmMediaOperationProgress rtmMediaOperationProgress2 = rtmMediaOperationProgress;
            rtmMediaOperationProgress2();
            rtmMediaOperationProgress2.totalSize = mediaOperationProgress.getTotalSize();
            rtmMediaOperationProgress.currentSize = mediaOperationProgress.getCurrentSize();
            rtmServiceEventHandlerNative.RtmClientImpl.this.mClientListener.onMediaUploadingProgress(rtmMediaOperationProgress2, l2);
        }

        @Override
        public void onMediaDownloadingProgress(long l2, MediaOperationProgress mediaOperationProgress) {
            RtmMediaOperationProgress rtmMediaOperationProgress;
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = rtmMediaOperationProgress2;
            Logging.i(TAG, "onMediaDownloadingProgress, requestId: " + l2 + ", totalSize: " + mediaOperationProgress.getTotalSize() + ", currentSize: " + mediaOperationProgress.getCurrentSize());
            RtmMediaOperationProgress rtmMediaOperationProgress2 = rtmMediaOperationProgress;
            rtmMediaOperationProgress2();
            rtmMediaOperationProgress2.totalSize = mediaOperationProgress.getTotalSize();
            rtmMediaOperationProgress.currentSize = mediaOperationProgress.getCurrentSize();
            rtmServiceEventHandlerNative.RtmClientImpl.this.mClientListener.onMediaDownloadingProgress(rtmMediaOperationProgress2, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFileMediaUploadResult(long l2, IFileMessage iFileMessage, UPLOAD_MEDIA_ERR_CODE uPLOAD_MEDIA_ERR_CODE) {
            Logging.i(TAG, "onFileMediaUploadResult, requestId: " + l2 + ", err: " + uPLOAD_MEDIA_ERR_CODE);
            if (uPLOAD_MEDIA_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        RtmFileMessageImpl rtmFileMessageImpl;
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mUploadFileMediaCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (uPLOAD_MEDIA_ERR_CODE != UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) break block6;
                        object = rtmFileMessageImpl;
                        ((RtmFileMessageImpl)object)();
                        ((RtmFileMessageImpl)object).setText(iFileMessage.getText());
                        ((RtmFileMessageImpl)object).setSize(iFileMessage.getSize());
                        ((RtmFileMessageImpl)object).setFileName(iFileMessage.getFileName());
                        ((RtmFileMessageImpl)object).setMediaId(iFileMessage.getMediaId());
                        rtmFileMessageImpl.setThumbnail(iFileMessage.getThumbnailData());
                        resultCallback.onSuccess(rtmFileMessageImpl);
                        break block5;
                    }
                    object = errorInfo;
                    UPLOAD_MEDIA_ERR_CODE uPLOAD_MEDIA_ERR_CODE2 = uPLOAD_MEDIA_ERR_CODE;
                    int n2 = uPLOAD_MEDIA_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, uPLOAD_MEDIA_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageMediaUploadResult(long l2, IImageMessage iImageMessage, UPLOAD_MEDIA_ERR_CODE uPLOAD_MEDIA_ERR_CODE) {
            Logging.i(TAG, "onImageMediaUploadResult, requestId: " + l2 + ", err: " + uPLOAD_MEDIA_ERR_CODE);
            if (uPLOAD_MEDIA_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        RtmImageMessageImpl rtmImageMessageImpl;
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mUploadImageMediaCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (uPLOAD_MEDIA_ERR_CODE != UPLOAD_MEDIA_ERR_CODE.UPLOAD_MEDIA_ERR_OK) break block6;
                        object = rtmImageMessageImpl;
                        ((RtmImageMessageImpl)object)();
                        ((RtmImageMessageImpl)object).setText(iImageMessage.getText());
                        ((RtmImageMessageImpl)object).setSize(iImageMessage.getSize());
                        ((RtmImageMessageImpl)object).setFileName(iImageMessage.getFileName());
                        ((RtmImageMessageImpl)object).setMediaId(iImageMessage.getMediaId());
                        ((RtmImageMessageImpl)object).setThumbnail(iImageMessage.getThumbnailData());
                        ((RtmImageMessageImpl)object).setHeight(iImageMessage.getHeight());
                        ((RtmImageMessageImpl)object).setWidth(iImageMessage.getWidth());
                        ((RtmImageMessageImpl)object).setThumbnailHeight(iImageMessage.getThumbnailHeight());
                        rtmImageMessageImpl.setThumbnailWidth(iImageMessage.getThumbnailWidth());
                        resultCallback.onSuccess(rtmImageMessageImpl);
                        break block5;
                    }
                    object = errorInfo;
                    UPLOAD_MEDIA_ERR_CODE uPLOAD_MEDIA_ERR_CODE2 = uPLOAD_MEDIA_ERR_CODE;
                    int n2 = uPLOAD_MEDIA_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, uPLOAD_MEDIA_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaDownloadToFileResult(long l2, DOWNLOAD_MEDIA_ERR_CODE dOWNLOAD_MEDIA_ERR_CODE) {
            Logging.i(TAG, "onMediaDownloadToFileResult, requestId: " + l2 + ", err: " + dOWNLOAD_MEDIA_ERR_CODE);
            if (dOWNLOAD_MEDIA_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mDownloadMediaToFileCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (dOWNLOAD_MEDIA_ERR_CODE != DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        break block5;
                    }
                    object = errorInfo;
                    DOWNLOAD_MEDIA_ERR_CODE dOWNLOAD_MEDIA_ERR_CODE2 = dOWNLOAD_MEDIA_ERR_CODE;
                    int n2 = dOWNLOAD_MEDIA_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, dOWNLOAD_MEDIA_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaDownloadToMemoryResult(long l2, byte[] byArray, DOWNLOAD_MEDIA_ERR_CODE dOWNLOAD_MEDIA_ERR_CODE) {
            Logging.i(TAG, "onMediaDownloadToMemoryResult, requestId: " + l2 + ", err: " + dOWNLOAD_MEDIA_ERR_CODE);
            if (dOWNLOAD_MEDIA_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray2 = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray2;
            synchronized (byArray2) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mDownloadMediaToMemoryCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (dOWNLOAD_MEDIA_ERR_CODE != DOWNLOAD_MEDIA_ERR_CODE.DOWNLOAD_MEDIA_ERR_OK) break block6;
                        resultCallback.onSuccess(byArray);
                        break block5;
                    }
                    object = errorInfo;
                    DOWNLOAD_MEDIA_ERR_CODE dOWNLOAD_MEDIA_ERR_CODE2 = dOWNLOAD_MEDIA_ERR_CODE;
                    int n2 = dOWNLOAD_MEDIA_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, dOWNLOAD_MEDIA_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaCancelResult(long l2, CANCEL_MEDIA_ERR_CODE cANCEL_MEDIA_ERR_CODE) {
            Logging.i(TAG, "onMediaCancelResult, requestId: " + l2 + ", err: " + cANCEL_MEDIA_ERR_CODE);
            if (cANCEL_MEDIA_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mCancelMediaCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (cANCEL_MEDIA_ERR_CODE != CANCEL_MEDIA_ERR_CODE.CANCEL_MEDIA_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        break block5;
                    }
                    object = errorInfo;
                    CANCEL_MEDIA_ERR_CODE cANCEL_MEDIA_ERR_CODE2 = cANCEL_MEDIA_ERR_CODE;
                    int n2 = cANCEL_MEDIA_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, cANCEL_MEDIA_ERR_CODE2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onQueryPeersOnlineStatusResult(long l2, PeerOnlineStatus[] peerOnlineStatusArray, int n2, QUERY_PEERS_ONLINE_STATUS_ERR object3) {
            Object object2;
            Logging.i(TAG, "onQueryPeersOnlineStatusResult, err: " + object3);
            if (object3 == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object2;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            object2 = byArray;
            synchronized (byArray) {
                block7: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block8: {
                        LinkedHashMap linkedHashMap;
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mQueryOnlineStatusCallbacks.remove(l2);
                        // ** MonitorExit[object2] (shouldn't be in output)
                        if (resultCallback == null) break block7;
                        if (object3 != QUERY_PEERS_ONLINE_STATUS_ERR.QUERY_PEERS_ONLINE_STATUS_ERR_OK) break block8;
                        object2 = linkedHashMap;
                        linkedHashMap = new LinkedHashMap(n2);
                        if (peerOnlineStatusArray != null) {
                            for (PeerOnlineStatus peerOnlineStatus : peerOnlineStatusArray) {
                                object2.put(peerOnlineStatus.getPeerId(), peerOnlineStatus.getIsOnline());
                            }
                        }
                        resultCallback.onSuccess(object2);
                        break block7;
                    }
                    object2 = errorInfo;
                    Object object = object3;
                    int n3 = ((QUERY_PEERS_ONLINE_STATUS_ERR)object).swigValue();
                    errorInfo = new ErrorInfo(n3, ((QUERY_PEERS_ONLINE_STATUS_ERR)object).toString());
                    resultCallback.onFailure((ErrorInfo)object2);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscriptionRequestResult(long l2, PEER_SUBSCRIPTION_STATUS_ERR pEER_SUBSCRIPTION_STATUS_ERR) {
            Logging.i(TAG, "onSubscriptionRequestResult, err: " + pEER_SUBSCRIPTION_STATUS_ERR);
            if (pEER_SUBSCRIPTION_STATUS_ERR == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block6: {
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mSubscribePeersOnlineStatusCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block5;
                        if (pEER_SUBSCRIPTION_STATUS_ERR != PEER_SUBSCRIPTION_STATUS_ERR.PEER_SUBSCRIPTION_STATUS_ERR_OK) break block6;
                        resultCallback.onSuccess(null);
                        break block5;
                    }
                    object = errorInfo;
                    PEER_SUBSCRIPTION_STATUS_ERR pEER_SUBSCRIPTION_STATUS_ERR2 = pEER_SUBSCRIPTION_STATUS_ERR;
                    int n2 = pEER_SUBSCRIPTION_STATUS_ERR2.swigValue();
                    errorInfo = new ErrorInfo(n2, pEER_SUBSCRIPTION_STATUS_ERR2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onQueryPeersBySubscriptionOptionResult(long l2, String[] stringArray, int n2, QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR) {
            Logging.i(TAG, "onQueryPeersBySubscriptionOptionResult, err: " + qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR);
            if (qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object = byArray;
            synchronized (byArray) {
                block6: {
                    ErrorInfo errorInfo;
                    ResultCallback resultCallback;
                    block7: {
                        HashSet hashSet;
                        resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mQueryPeersBySubscriptionOptionCallbacks.remove(l2);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (resultCallback == null) break block6;
                        if (qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR != QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR.QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR_OK) break block7;
                        object = hashSet;
                        hashSet = new HashSet(n2);
                        int n3 = stringArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            object.add(stringArray[n2]);
                        }
                        resultCallback.onSuccess(object);
                        break block6;
                    }
                    object = errorInfo;
                    QUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR2 = qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR;
                    int n4 = qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR2.swigValue();
                    errorInfo = new ErrorInfo(n4, qUERY_PEERS_BY_SUBSCRIPTION_OPTION_ERR2.toString());
                    resultCallback.onFailure((ErrorInfo)object);
                }
                return;
            }
        }

        @Override
        public void onPeersOnlineStatusChanged(PeerOnlineStatus[] peerOnlineStatusArray, int n2) {
            Logging.i(TAG, "onPeersOnlineStatusChanged");
            if (peerOnlineStatusArray != null && n2 > 0) {
                HashMap<String, Integer> hashMap;
                if (RtmClientImpl.this.mClientListener == null) {
                    Logging.w(TAG, "empty client listener!");
                    return;
                }
                HashMap<String, Integer> hashMap2 = hashMap;
                hashMap = new HashMap<String, Integer>();
                for (PeerOnlineStatus peerOnlineStatus : peerOnlineStatusArray) {
                    hashMap2.put(peerOnlineStatus.getPeerId(), RtmClientImpl.this.covertPeerOnlineState(peerOnlineStatus.getOnlineState()));
                }
                RtmClientImpl.this.mClientListener.onPeersOnlineStatusChanged(hashMap2);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRenewTokenResult(String object, RENEW_TOKEN_ERR_CODE rENEW_TOKEN_ERR_CODE) {
            Logging.i(TAG, "onRenewTokenResult, err: " + rENEW_TOKEN_ERR_CODE);
            if (rENEW_TOKEN_ERR_CODE == null) {
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object2;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object2 = byArray;
            synchronized (byArray) {
                block5: {
                    ErrorInfo errorInfo;
                    block6: {
                        object = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mRenewTokenCallbacks.remove(object);
                        // ** MonitorExit[this] (shouldn't be in output)
                        if (object == null) break block5;
                        if (rENEW_TOKEN_ERR_CODE != RENEW_TOKEN_ERR_CODE.RENEW_TOKEN_ERR_OK) break block6;
                        object.onSuccess(null);
                        break block5;
                    }
                    object2 = errorInfo;
                    RENEW_TOKEN_ERR_CODE rENEW_TOKEN_ERR_CODE2 = rENEW_TOKEN_ERR_CODE;
                    int n2 = rENEW_TOKEN_ERR_CODE2.swigValue();
                    errorInfo = new ErrorInfo(n2, rENEW_TOKEN_ERR_CODE2.toString());
                    object.onFailure((ErrorInfo)object2);
                }
                return;
            }
        }

        @Override
        public void onTokenExpired() {
            if (RtmClientImpl.this.mClientListener == null) {
                Logging.w(TAG, "no listener for token expiration!");
                return;
            }
            Logging.i(TAG, "token expired");
            RtmClientImpl.this.mClientListener.onTokenExpired();
        }

        @Override
        public void onSetLocalUserAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onSetLocalUserAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mSetLocalUserAttrCallbacks);
        }

        @Override
        public void onAddOrUpdateLocalUserAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onAddOrUpdateLocalUserAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mAddOrUpdateLocalUserAttrCallbacks);
        }

        @Override
        public void onDeleteLocalUserAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onDeleteLocalUserAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mDeleteLocalUserAttrCallbacks);
        }

        @Override
        public void onClearLocalUserAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onClearLocalUserAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mClearLocalUserAttrCallbacks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetUserAttributesResult(long l2, String object, IRtmAttribute[] iRtmAttributeArray, int n2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onGetUserAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            if (aTTRIBUTE_OPERATION_ERR == null) {
                Logging.e(TAG, "onGetUserAttributesResult: null error code!");
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object2;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object2 = byArray;
            synchronized (byArray) {
                ResultCallback resultCallback;
                block8: {
                    resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mGetUserAttrCallbacks.remove(l2);
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (resultCallback != null) break block8;
                    Logging.e(TAG, "onGetUserAttributesResult: callback target lost!");
                    return;
                }
                if (aTTRIBUTE_OPERATION_ERR == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                    ArrayList arrayList;
                    object2 = arrayList;
                    arrayList = new ArrayList();
                    for (int i2 = 0; i2 < iRtmAttributeArray.length; ++i2) {
                        RtmAttribute rtmAttribute;
                        object = iRtmAttributeArray[i2];
                        RtmAttribute rtmAttribute2 = rtmAttribute;
                        Object object3 = object;
                        object = ((IRtmAttribute)object3).getKey();
                        rtmAttribute = new RtmAttribute((String)object, ((IRtmAttribute)object3).getValue());
                        object2.add(rtmAttribute2);
                    }
                    resultCallback.onSuccess(object2);
                } else {
                    ErrorInfo errorInfo;
                    object2 = errorInfo;
                    ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR2 = aTTRIBUTE_OPERATION_ERR;
                    int n3 = aTTRIBUTE_OPERATION_ERR2.swigValue();
                    errorInfo = new ErrorInfo(n3, aTTRIBUTE_OPERATION_ERR2.toString());
                    resultCallback.onFailure((ErrorInfo)object2);
                }
                return;
            }
        }

        @Override
        public void onSetChannelAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onSetChannelAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mSetChannelAttrCallbacks);
        }

        @Override
        public void onAddOrUpdateChannelAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onAddOrUpdateChannelAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mAddOrUpdateChannelAttrCallbacks);
        }

        @Override
        public void onDeleteChannelAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onDeleteChannelAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mDeleteChannelAttrCallbacks);
        }

        @Override
        public void onClearChannelAttributesResult(long l2, ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR) {
            Logging.i(TAG, "onClearChannelAttributesResult: " + aTTRIBUTE_OPERATION_ERR);
            this.processAttrResultCallbackSimple(l2, aTTRIBUTE_OPERATION_ERR, RtmClientImpl.this.mClearChannelAttrCallbacks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetChannelAttributesResult(long l2, IRtmChannelAttribute[] iRtmChannelAttributeArray, int n2, ATTRIBUTE_OPERATION_ERR object) {
            Logging.i(TAG, "onGetChannelAttributesResult: " + object);
            if (object == null) {
                Logging.e(TAG, "onGetChannelAttributesResult: null error code!");
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object2;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object2 = byArray;
            synchronized (byArray) {
                ResultCallback resultCallback;
                block8: {
                    resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mGetChannelAttrCallbacks.remove(l2);
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (resultCallback != null) break block8;
                    Logging.e(TAG, "onGetChannelAttributesResult: callback target lost!");
                    return;
                }
                if (object == ATTRIBUTE_OPERATION_ERR.ATTRIBUTE_OPERATION_ERR_OK) {
                    ArrayList arrayList;
                    object2 = arrayList;
                    arrayList = new ArrayList();
                    for (int i2 = 0; i2 < iRtmChannelAttributeArray.length; ++i2) {
                        RtmChannelAttribute rtmChannelAttribute;
                        Object object3 = iRtmChannelAttributeArray[i2];
                        object = rtmChannelAttribute;
                        IRtmChannelAttribute iRtmChannelAttribute = object3;
                        object3 = iRtmChannelAttribute.getKey();
                        String string2 = iRtmChannelAttribute.getValue();
                        String string3 = iRtmChannelAttribute.getLastUpdateUserId();
                        long l3 = iRtmChannelAttribute.getLastUpdateTs();
                        rtmChannelAttribute = new RtmChannelAttribute((String)object3, string2, string3, l3);
                        object2.add(object);
                    }
                    resultCallback.onSuccess(object2);
                } else {
                    ErrorInfo errorInfo;
                    object2 = errorInfo;
                    ATTRIBUTE_OPERATION_ERR aTTRIBUTE_OPERATION_ERR = object;
                    int n3 = aTTRIBUTE_OPERATION_ERR.swigValue();
                    errorInfo = new ErrorInfo(n3, aTTRIBUTE_OPERATION_ERR.toString());
                    resultCallback.onFailure((ErrorInfo)object2);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetChannelMemberCountResult(long l2, IRtmChannelMemberCount[] iRtmChannelMemberCountArray, int n2, GET_CHANNEL_MEMBER_COUNT_ERR object) {
            Logging.i(TAG, "onGetChannelMemberCountResult: " + object);
            if (object == null) {
                Logging.e(TAG, "onGetChannelMemberCountResult: null error code!");
                return;
            }
            RtmServiceEventHandlerNative rtmServiceEventHandlerNative = object2;
            byte[] byArray = rtmServiceEventHandlerNative.RtmClientImpl.this.mRtmCallbackLock;
            Object object2 = byArray;
            synchronized (byArray) {
                ResultCallback resultCallback;
                block8: {
                    resultCallback = (ResultCallback)rtmServiceEventHandlerNative.RtmClientImpl.this.mGetChannelMemberCountCallbacks.remove(l2);
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (resultCallback != null) break block8;
                    Logging.e(TAG, "onGetChannelMemberCountResult: callback target lost!");
                    return;
                }
                if (object == GET_CHANNEL_MEMBER_COUNT_ERR.GET_CHANNEL_MEMBER_COUNT_ERR_OK) {
                    ArrayList arrayList;
                    object2 = arrayList;
                    arrayList = new ArrayList();
                    for (int i2 = 0; i2 < iRtmChannelMemberCountArray.length; ++i2) {
                        RtmChannelMemberCount rtmChannelMemberCount;
                        Object object3 = iRtmChannelMemberCountArray[i2];
                        object = rtmChannelMemberCount;
                        IRtmChannelMemberCount iRtmChannelMemberCount = object3;
                        object3 = iRtmChannelMemberCount.getChannelID();
                        rtmChannelMemberCount = new RtmChannelMemberCount((String)object3, iRtmChannelMemberCount.getMemberCount());
                        object2.add(object);
                    }
                    resultCallback.onSuccess(object2);
                } else {
                    ErrorInfo errorInfo;
                    object2 = errorInfo;
                    GET_CHANNEL_MEMBER_COUNT_ERR gET_CHANNEL_MEMBER_COUNT_ERR = object;
                    int n3 = gET_CHANNEL_MEMBER_COUNT_ERR.swigValue();
                    errorInfo = new ErrorInfo(n3, gET_CHANNEL_MEMBER_COUNT_ERR.toString());
                    resultCallback.onFailure((ErrorInfo)object2);
                }
                return;
            }
        }
    }
}

