/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.content.Context;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmClientListener;
import io.agora.rtm.RtmServiceContext;
import io.agora.rtm.internal.AgoraSysUtils;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.IRtmService;

public class RtmManager {
    private static final String RTM_SDK_LIBRARY_NAME = "agora-rtm-sdk-jni";

    public static void initializeNative() {
        RtmSdkContext.setLibraryName(RTM_SDK_LIBRARY_NAME);
    }

    public static RtmClient createRtmInstance(final @NonNull Context context, @NonNull String string2, @NonNull RtmClientListener rtmClientListener) throws Exception {
        RtmSdkContext rtmSdkContext;
        RtmSdkContext rtmSdkContext2 = rtmSdkContext;
        rtmSdkContext = new RtmSdkContext(){

            @Override
            public String getConfigDir() {
                return AgoraSysUtils.getAppStorageDir(context);
            }

            @Override
            public String getDataDir() {
                return AgoraSysUtils.getCacheDir(context);
            }

            @Override
            public String getPluginDir() {
                return AgoraSysUtils.getNativeLibraryDir(context);
            }

            @Override
            public String getDeviceId() {
                return AgoraSysUtils.getDeviceId();
            }

            @Override
            public String getDeviceInfo() {
                return AgoraSysUtils.getDeviceInfo();
            }

            @Override
            public String getSystemInfo() {
                return AgoraSysUtils.getSystemInfo();
            }
        };
        return new RtmClientImpl(rtmSdkContext2, string2, rtmClientListener);
    }

    public static int setRtmServiceContext(RtmServiceContext rtmServiceContext) {
        return IRtmService.setRtmServiceContext(rtmServiceContext);
    }

    public static String getRtmSessionId(@NonNull RtmClient rtmClient) {
        if (rtmClient == null) {
            return "";
        }
        return ((RtmClientImpl)rtmClient).GetSessionId();
    }
}

