/*
 * Decompiled with CFR 0.152.
 */
package com.ahmer.pdfium;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import com.ahmer.pdfium.PdfDocument;
import com.ahmer.pdfium.util.Size;
import com.ahmer.pdfium.util.SizeF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0016\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b3\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\u0018\u0000 \u0099\u00012\u00020\u0001:\u0002\u0099\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fJ4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00142\u0006\u0010\n\u001a\u00020\u000bJV\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u001e2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+2\u0006\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fJP\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207JF\u00109\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020*J\u0011\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020%H\u0082 J\u0011\u0010=\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0082 J\u0011\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020@H\u0082 Ja\u0010A\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+2\u0006\u0010D\u001a\u00020%2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0082 J!\u0010E\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020%2\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u000fH\u0086 J#\u0010H\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020\u000fH\u0086 J\u0011\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020%H\u0086 J\u0011\u0010N\u001a\u00020O2\u0006\u0010M\u001a\u00020%H\u0086 J)\u0010P\u001a\u00020%2\u0006\u0010,\u001a\u00020%2\u0006\u0010Q\u001a\u00020%2\u0006\u0010K\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020\u000fH\u0086 J\u0019\u0010S\u001a\u00020%2\u0006\u0010<\u001a\u00020%2\u0006\u0010T\u001a\u00020%H\u0082 J\u0013\u0010U\u001a\u0004\u0018\u00010J2\u0006\u0010T\u001a\u00020%H\u0082 JI\u0010V\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010W\u001a\u0002072\u0006\u0010X\u001a\u000207H\u0086 JS\u0010Y\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\b\u0010Z\u001a\u0004\u0018\u00010*2\u0006\u0010D\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020OH\u0086 J \u0010\\\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020%2\u0006\u0010]\u001a\u00020%H\u0082 \u00a2\u0006\u0002\u0010^J\u001b\u0010_\u001a\u0004\u0018\u00010J2\u0006\u0010<\u001a\u00020%2\u0006\u0010`\u001a\u00020JH\u0082 J\u0011\u0010a\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020%H\u0086 J\u0011\u0010b\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020%H\u0086 J\"\u0010c\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020%2\b\u0010T\u001a\u0004\u0018\u00010%H\u0082 \u00a2\u0006\u0002\u0010dJ1\u0010e\u001a\u00020%2\u0006\u0010$\u001a\u00020%2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0086 J\u0013\u0010f\u001a\u0004\u0018\u00010*2\u0006\u0010]\u001a\u00020%H\u0082 J\u001b\u0010g\u001a\u0004\u0018\u00010J2\u0006\u0010<\u001a\u00020%2\u0006\u0010]\u001a\u00020%H\u0082 JS\u0010h\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\b\u0010Z\u001a\u0004\u0018\u00010*2\u0006\u0010D\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020OH\u0086 J\u0011\u0010i\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020%H\u0082 J\u0019\u0010j\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010k\u001a\u00020\u000fH\u0082 J\u0011\u0010l\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0082 J\u0011\u0010m\u001a\u00020@2\u0006\u0010$\u001a\u00020%H\u0082 J\u0011\u0010n\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0082 J!\u0010o\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010k\u001a\u00020\u000fH\u0082 J\u0019\u0010p\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010k\u001a\u00020\u000fH\u0082 J\u0011\u0010q\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0082 JK\u0010r\u001a\u00020O2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020%2\b\u0010s\u001a\u0004\u0018\u00010*2\u0006\u0010t\u001a\u00020\u000fH\u0086 J \u0010u\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020%2\u0006\u0010T\u001a\u00020%H\u0082 \u00a2\u0006\u0002\u0010vJ\u0013\u0010w\u001a\u00020%2\b\u0010I\u001a\u0004\u0018\u00010JH\u0086 J\u0013\u0010x\u001a\u0004\u0018\u00010J2\u0006\u0010,\u001a\u00020%H\u0086 J\u0019\u0010y\u001a\u00020%2\u0006\u0010<\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000fH\u0082 J!\u0010z\u001a\u00020@2\u0006\u0010<\u001a\u00020%2\u0006\u0010{\u001a\u00020\u000f2\u0006\u0010|\u001a\u00020\u000fH\u0082 J\u0011\u0010}\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0086 J\u001a\u0010~\u001a\u00020%2\u0006\u0010\u007f\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020JH\u0082 J\u001d\u0010\u0081\u0001\u001a\u00020%2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0080\u0001\u001a\u00020JH\u0082 JL\u0010\u0084\u0001\u001a\u0004\u0018\u0001002\u0006\u0010$\u001a\u00020%2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0082 JG\u0010\u0085\u0001\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020\u000f2\u0007\u0010\u0089\u0001\u001a\u00020\u000f2\u0007\u0010\u008a\u0001\u001a\u00020OH\u0082 JG\u0010\u008b\u0001\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020\u000f2\u0007\u0010\u0089\u0001\u001a\u00020\u000f2\u0007\u0010\u008a\u0001\u001a\u00020OH\u0082 JO\u0010\u008b\u0001\u001a\u00020\t2\u0006\u0010<\u001a\u00020%2\u0006\u0010$\u001a\u00020%2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020\u000f2\u0007\u0010\u0089\u0001\u001a\u00020\u000f2\u0007\u0010\u008a\u0001\u001a\u00020OH\u0082 J\u0010\u0010\u008e\u0001\u001a\u00020\u000b2\u0007\u0010\u007f\u001a\u00030\u008f\u0001J\u001b\u0010\u008e\u0001\u001a\u00020\u000b2\u0007\u0010\u007f\u001a\u00030\u008f\u00012\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010JJ\u0011\u0010\u008e\u0001\u001a\u00020\u000b2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u001c\u0010\u008e\u0001\u001a\u00020\u000b2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010JJ\u0017\u0010\u0090\u0001\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000fJ\u001f\u0010\u0090\u0001\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010{\u001a\u00020\u000f2\u0006\u0010|\u001a\u00020\u000fJ\u000f\u0010\u0091\u0001\u001a\u00020%2\u0006\u0010$\u001a\u00020%J)\u0010\u0092\u0001\u001a\u00020\t2\u000e\u0010\u0093\u0001\u001a\t\u0012\u0004\u0012\u00020\"0\u0094\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020%H\u0002JC\u0010\u0095\u0001\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0096\u0001\u001a\u00020\u000f2\u0007\u0010\u0097\u0001\u001a\u00020\u000fJL\u0010\u0095\u0001\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0096\u0001\u001a\u00020\u000f2\u0007\u0010\u0097\u0001\u001a\u00020\u000f2\u0007\u0010\u008a\u0001\u001a\u00020OJC\u0010\u0098\u0001\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0096\u0001\u001a\u00020\u000f2\u0007\u0010\u0097\u0001\u001a\u00020\u000fJL\u0010\u0098\u0001\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0007\u0010\u0096\u0001\u001a\u00020\u000f2\u0007\u0010\u0097\u0001\u001a\u00020\u000f2\u0007\u0010\u008a\u0001\u001a\u00020OR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u009a\u0001"}, d2={"Lcom/ahmer/pdfium/PdfiumCore;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "context", "getContext", "()Landroid/content/Context;", "closeDocument", "", "doc", "Lcom/ahmer/pdfium/PdfDocument;", "getDocumentMeta", "Lcom/ahmer/pdfium/PdfDocument$Meta;", "getPageCount", "", "getPageHeight", "index", "getPageHeightPoint", "getPageLinks", "", "Lcom/ahmer/pdfium/PdfDocument$Link;", "pageIndex", "size", "Lcom/ahmer/pdfium/util/SizeF;", "posX", "", "posY", "getPageRotation", "getPageSize", "Lcom/ahmer/pdfium/util/Size;", "getPageWidth", "getPageWidthPoint", "getTableOfContents", "Lcom/ahmer/pdfium/PdfDocument$Bookmark;", "getTextRects", "pagePtr", "", "offsetY", "offsetX", "arr", "Ljava/util/ArrayList;", "Landroid/graphics/RectF;", "Lkotlin/collections/ArrayList;", "textPtr", "selSt", "selEd", "mapPageCoordsToDevice", "Landroid/graphics/Point;", "startX", "startY", "sizeX", "sizeY", "rotate", "pageX", "", "pageY", "mapRectToDevice", "coords", "nativeCloseDocument", "docPtr", "nativeClosePage", "nativeClosePages", "pagesPtr", "", "nativeCountAndGetRects", "width", "height", "tid", "nativeCountRects", "st", "ed", "nativeFindTextPage", "key", "", "flag", "nativeFindTextPageEnd", "searchPtr", "nativeFindTextPageNext", "", "nativeFindTextPageStart", "keyStr", "startIdx", "nativeGetBookmarkDestIndex", "bookmarkPtr", "nativeGetBookmarkTitle", "nativeGetCharIndexAtCoord", "tolX", "tolY", "nativeGetCharPos", "pt", "loose", "nativeGetDestPageIndex", "linkPtr", "(JJ)Ljava/lang/Integer;", "nativeGetDocumentMetaText", "tag", "nativeGetFindIdx", "nativeGetFindLength", "nativeGetFirstChildBookmark", "(JLjava/lang/Long;)Ljava/lang/Long;", "nativeGetLinkAtCoord", "nativeGetLinkRect", "nativeGetLinkURI", "nativeGetMixedLooseCharPos", "nativeGetPageCount", "nativeGetPageHeightPixel", "dpi", "nativeGetPageHeightPoint", "nativeGetPageLinks", "nativeGetPageRotation", "nativeGetPageSizeByIndex", "nativeGetPageWidthPixel", "nativeGetPageWidthPoint", "nativeGetRect", "rect", "idx", "nativeGetSiblingBookmark", "(JJ)Ljava/lang/Long;", "nativeGetStringChars", "nativeGetText", "nativeLoadPage", "nativeLoadPages", "fromIndex", "toIndex", "nativeLoadTextPage", "nativeOpenDocument", "fd", "password", "nativeOpenMemDocument", "data", "", "nativePageCoordsToDevice", "nativeRenderPage", "surface", "Landroid/view/Surface;", "drawSizeHor", "drawSizeVer", "annotation", "nativeRenderPageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "newDocument", "Landroid/os/ParcelFileDescriptor;", "openPage", "openText", "recursiveGetBookmark", "tree", "", "renderPage", "drawSizeX", "drawSizeY", "renderPageBitmap", "Companion", "libPdfium_release"})
@SourceDebugExtension(value={"SMAP\nPdfiumCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfiumCore.kt\ncom/ahmer/pdfium/PdfiumCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n1#2:507\n*E\n"})
public final class PdfiumCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private static final Object lock = new Object();
    private static final String TAG = PdfiumCore.class.getName();
    private static int mCurrentDpi;

    public PdfiumCore(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        mCurrentDpi = mContext.getResources().getDisplayMetrics().densityDpi;
        Log.d((String)TAG, (String)"Starting AhmerPdfium...");
        this.context = mContext;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final native int nativeCountRects(long var1, int var3, int var4);

    public final native int nativeFindTextPage(long var1, @Nullable String var3, int var4);

    public final native void nativeFindTextPageEnd(long var1);

    public final native boolean nativeFindTextPageNext(long var1);

    public final native long nativeFindTextPageStart(long var1, long var3, int var5, int var6);

    public final native int nativeGetCharIndexAtCoord(long var1, int var3, int var4, long var5, int var7, int var8, double var9, double var11);

    public final native int nativeGetCharPos(long var1, int var3, int var4, int var5, int var6, @Nullable RectF var7, long var8, int var10, boolean var11);

    public final native int nativeGetFindIdx(long var1);

    public final native int nativeGetFindLength(long var1);

    public final native long nativeGetLinkAtCoord(long var1, int var3, int var4, int var5, int var6);

    public final native int nativeGetMixedLooseCharPos(long var1, int var3, int var4, int var5, int var6, @Nullable RectF var7, long var8, int var10, boolean var11);

    public final native boolean nativeGetRect(long var1, int var3, int var4, int var5, int var6, long var7, @Nullable RectF var9, int var10);

    public final native long nativeGetStringChars(@Nullable String var1);

    @Nullable
    public final native String nativeGetText(long var1);

    public final native long nativeLoadTextPage(long var1);

    private final native void nativeCloseDocument(long var1);

    private final native void nativeClosePage(long var1);

    private final native void nativeClosePages(long[] var1);

    private final native int nativeCountAndGetRects(long var1, int var3, int var4, int var5, int var6, ArrayList<RectF> var7, long var8, int var10, int var11);

    private final native long nativeGetBookmarkDestIndex(long var1, long var3);

    private final native String nativeGetBookmarkTitle(long var1);

    private final native Integer nativeGetDestPageIndex(long var1, long var3);

    private final native String nativeGetDocumentMetaText(long var1, String var3);

    private final native Long nativeGetFirstChildBookmark(long var1, Long var3);

    private final native RectF nativeGetLinkRect(long var1);

    private final native String nativeGetLinkURI(long var1, long var3);

    private final native int nativeGetPageCount(long var1);

    private final native int nativeGetPageHeightPixel(long var1, int var3);

    private final native int nativeGetPageHeightPoint(long var1);

    private final native long[] nativeGetPageLinks(long var1);

    private final native int nativeGetPageRotation(long var1);

    private final native Size nativeGetPageSizeByIndex(long var1, int var3, int var4);

    private final native int nativeGetPageWidthPixel(long var1, int var3);

    private final native int nativeGetPageWidthPoint(long var1);

    private final native Long nativeGetSiblingBookmark(long var1, long var3);

    private final native long nativeLoadPage(long var1, int var3);

    private final native long[] nativeLoadPages(long var1, int var3, int var4);

    private final native long nativeOpenDocument(int var1, String var2);

    private final native long nativeOpenMemDocument(byte[] var1, String var2);

    private final native Point nativePageCoordsToDevice(long var1, int var3, int var4, int var5, int var6, int var7, double var8, double var10);

    private final native void nativeRenderPage(long var1, Surface var3, int var4, int var5, int var6, int var7, boolean var8);

    private final native void nativeRenderPageBitmap(long var1, long var3, Bitmap var5, int var6, int var7, int var8, int var9, boolean var10);

    private final native void nativeRenderPageBitmap(long var1, Bitmap var3, int var4, int var5, int var6, int var7, boolean var8);

    @NotNull
    public final PdfDocument newDocument(@NotNull ParcelFileDescriptor fd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        return this.newDocument(fd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final PdfDocument newDocument(@NotNull ParcelFileDescriptor fd, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fd, (String)"fd");
        PdfDocument document = new PdfDocument();
        document.setParcelFileDescriptor(fd);
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            PdfDocument pdfDocument = document;
            String string = password;
            if (string != null) {
                void it;
                String string2 = string;
                PdfDocument pdfDocument2 = pdfDocument;
                boolean bl2 = false;
                l = this.nativeOpenDocument(fd.getFd(), (String)it);
                pdfDocument = pdfDocument2;
            } else {
                l = null;
            }
            Intrinsics.checkNotNull(l);
            pdfDocument.setMNativeDocPtr(l);
            Unit unit = Unit.INSTANCE;
        }
        return document;
    }

    @NotNull
    public final PdfDocument newDocument(@NotNull byte[] data) throws IOException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.newDocument(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final PdfDocument newDocument(@NotNull byte[] data, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PdfDocument document = new PdfDocument();
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            PdfDocument pdfDocument = document;
            String string = password;
            if (string != null) {
                void it;
                String string2 = string;
                PdfDocument pdfDocument2 = pdfDocument;
                boolean bl2 = false;
                l = this.nativeOpenMemDocument(data, (String)it);
                pdfDocument = pdfDocument2;
            } else {
                l = null;
            }
            Intrinsics.checkNotNull(l);
            pdfDocument.setMNativeDocPtr(l);
            Unit unit = Unit.INSTANCE;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPageCount(@NotNull PdfDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.nativeGetPageCount(doc.getMNativeDocPtr());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long openPage(@NotNull PdfDocument doc, int pageIndex) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            long pagePtr = this.nativeLoadPage(doc.getMNativeDocPtr(), pageIndex);
            Integer n = pageIndex;
            Long l = pagePtr;
            doc.getMNativePagesPtr().put(n, l);
            long l2 = pagePtr;
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final long[] openPage(@NotNull PdfDocument doc, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            long[] pagesPtr = this.nativeLoadPages(doc.getMNativeDocPtr(), fromIndex, toIndex);
            int pageIndex = fromIndex;
            int n = pagesPtr.length;
            for (int i = 0; i < n; ++i) {
                long page = pagesPtr[i];
                if (pageIndex > toIndex) break;
                Integer n2 = pageIndex;
                Long l = page;
                doc.getMNativePagesPtr().put(n2, l);
                ++pageIndex;
            }
            long[] lArray = pagesPtr;
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long openText(long pagePtr) {
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            long l = this.nativeLoadTextPage(pagePtr);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTextRects(long pagePtr, int offsetY, int offsetX, @NotNull Size size, @NotNull ArrayList<RectF> arr, long textPtr, int selSt, int selEd) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.nativeCountAndGetRects(pagePtr, offsetY, offsetX, size.getWidth(), size.getHeight(), arr, textPtr, selSt, selEd);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPageWidth(@NotNull PdfDocument doc, int index) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            long pagePtr = 0L;
            pagePtr = -1L;
            Long l2 = doc.getMNativePagesPtr().get(index);
            if (l2 != null) {
                Long l3 = l2;
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                pagePtr = it;
                l = l3;
            } else {
                l = null;
            }
            int n = l != null ? this.nativeGetPageWidthPixel(pagePtr, mCurrentDpi) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPageHeight(@NotNull PdfDocument doc, int index) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            long pagePtr = 0L;
            pagePtr = -1L;
            Long l2 = doc.getMNativePagesPtr().get(index);
            if (l2 != null) {
                Long l3 = l2;
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                pagePtr = it;
                l = l3;
            } else {
                l = null;
            }
            int n = l != null ? this.nativeGetPageHeightPixel(pagePtr, mCurrentDpi) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPageWidthPoint(@NotNull PdfDocument doc, int index) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            long pagePtr = 0L;
            pagePtr = -1L;
            Long l2 = doc.getMNativePagesPtr().get(index);
            if (l2 != null) {
                Long l3 = l2;
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                pagePtr = it;
                l = l3;
            } else {
                l = null;
            }
            int n = l != null ? this.nativeGetPageWidthPoint(pagePtr) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPageHeightPoint(@NotNull PdfDocument doc, int index) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            Long l;
            boolean bl = false;
            long pagePtr = 0L;
            pagePtr = -1L;
            Long l2 = doc.getMNativePagesPtr().get(index);
            if (l2 != null) {
                Long l3 = l2;
                long it = ((Number)l3).longValue();
                boolean bl2 = false;
                pagePtr = it;
                l = l3;
            } else {
                l = null;
            }
            int n = l != null ? this.nativeGetPageHeightPoint(pagePtr) : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Size getPageSize(@NotNull PdfDocument doc, int index) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            Size size = this.nativeGetPageSizeByIndex(doc.getMNativeDocPtr(), index, mCurrentDpi);
            return size;
        }
    }

    public final void renderPage(@NotNull PdfDocument doc, @NotNull Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.renderPage(doc, surface, pageIndex, startX, startY, drawSizeX, drawSizeY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderPage(@NotNull PdfDocument doc, @NotNull Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean annotation) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Long mDoc = doc.getMNativePagesPtr().get(pageIndex);
        if (mDoc != null) {
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                try {
                    this.nativeRenderPage(mDoc, surface, startX, startY, drawSizeX, drawSizeY, annotation);
                }
                catch (NullPointerException e) {
                    Log.e((String)TAG, (String)"mContext may be null");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception throw from native");
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void renderPageBitmap(@NotNull PdfDocument doc, @NotNull Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.renderPageBitmap(doc, bitmap, pageIndex, startX, startY, drawSizeX, drawSizeY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderPageBitmap(@NotNull PdfDocument doc, @NotNull Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean annotation) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Long mDoc = doc.getMNativePagesPtr().get(pageIndex);
        if (mDoc != null) {
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                try {
                    this.nativeRenderPageBitmap(mDoc, bitmap, startX, startY, drawSizeX, drawSizeY, annotation);
                }
                catch (NullPointerException e) {
                    Log.e((String)TAG, (String)"mContext may be null");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Exception throw from native");
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeDocument(@NotNull PdfDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Iterator<Integer> iterator = doc.getMNativePagesPtr().keySet().iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            Long l = doc.getMNativePagesPtr().get(index);
            if (l == null) continue;
            long it = ((Number)l).longValue();
            boolean bl = false;
            this.nativeClosePage(it);
        }
        doc.getMNativePagesPtr().clear();
        this.nativeCloseDocument(doc.getMNativeDocPtr());
        if (doc.getParcelFileDescriptor() != null) {
            try {
                ParcelFileDescriptor parcelFileDescriptor = doc.getParcelFileDescriptor();
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
                doc.setParcelFileDescriptor(null);
            }
            catch (IOException iOException) {
            }
            finally {
                doc.setParcelFileDescriptor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PdfDocument.Meta getDocumentMeta(@NotNull PdfDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            PdfDocument.Meta meta = new PdfDocument.Meta(null, null, null, null, null, null, null, null, 0, 511, null);
            meta.setTitle(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Title"));
            meta.setAuthor(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Author"));
            meta.setSubject(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Subject"));
            meta.setKeywords(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Keywords"));
            meta.setCreator(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Creator"));
            meta.setProducer(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "Producer"));
            meta.setCreationDate(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "CreationDate"));
            meta.setModDate(this.nativeGetDocumentMetaText(doc.getMNativeDocPtr(), "ModDate"));
            meta.setTotalPages(this.getPageCount(doc));
            PdfDocument.Meta meta2 = meta;
            return meta2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PdfDocument.Bookmark> getTableOfContents(@NotNull PdfDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Object object = lock;
        synchronized (object) {
            Long first;
            boolean bl = false;
            List topLevel = new ArrayList();
            Long l = first = this.nativeGetFirstChildBookmark(doc.getMNativeDocPtr(), null);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                this.recursiveGetBookmark(topLevel, doc, it);
            }
            List list = topLevel;
            return list;
        }
    }

    private final void recursiveGetBookmark(List<PdfDocument.Bookmark> tree, PdfDocument doc, long bookmarkPtr) {
        block1: {
            Long sibling;
            PdfDocument.Bookmark bookmark = new PdfDocument.Bookmark(null, 0L, 0L, null, 15, null);
            bookmark.setMNativePtr(bookmarkPtr);
            bookmark.setTitle(this.nativeGetBookmarkTitle(bookmarkPtr));
            bookmark.setPageIdx(this.nativeGetBookmarkDestIndex(doc.getMNativeDocPtr(), bookmarkPtr));
            tree.add(bookmark);
            Long child = this.nativeGetFirstChildBookmark(doc.getMNativeDocPtr(), bookmarkPtr);
            if (child != null) {
                this.recursiveGetBookmark(bookmark.getChildren(), doc, child);
            }
            Long l = sibling = this.nativeGetSiblingBookmark(doc.getMNativeDocPtr(), bookmarkPtr);
            if (l == null) break block1;
            long it = ((Number)l).longValue();
            boolean bl = false;
            this.recursiveGetBookmark(tree, doc, it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PdfDocument.Link> getPageLinks(@NotNull PdfDocument doc, int pageIndex, @NotNull SizeF size, float posX, float posY) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            List mLinks = new ArrayList();
            Long l = doc.getMNativePagesPtr().get(pageIndex);
            if (l == null) {
                List list = mLinks;
                return list;
            }
            long l2 = l;
            long mPagePtr = l2;
            long[] mPageLinks = this.nativeGetPageLinks(mPagePtr);
            long mLinkAtCoordinate = this.nativeGetLinkAtCoord(mPagePtr, (int)size.getWidth(), (int)size.getHeight(), (int)posX, (int)posY);
            for (long linkPtr : mPageLinks) {
                Integer mIndex = this.nativeGetDestPageIndex(doc.getMNativeDocPtr(), mLinkAtCoordinate);
                String mUri = this.nativeGetLinkURI(doc.getMNativeDocPtr(), linkPtr);
                RectF mBound = this.nativeGetLinkRect(linkPtr);
                if (mUri == null) {
                    String uri = this.nativeGetLinkURI(doc.getMNativeDocPtr(), mLinkAtCoordinate);
                    mLinks.add(new PdfDocument.Link(mBound, mIndex, uri));
                    continue;
                }
                mLinks.add(new PdfDocument.Link(mBound, mIndex, mUri));
            }
            List list = mLinks;
            return list;
        }
    }

    @Nullable
    public final Point mapPageCoordsToDevice(@NotNull PdfDocument doc, int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, double pageX, double pageY) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Long mDoc = doc.getMNativePagesPtr().get(pageIndex);
        Point point = null;
        if (mDoc != null) {
            point = this.nativePageCoordsToDevice(mDoc, startX, startY, sizeX, sizeY, rotate, pageX, pageY);
        }
        return point;
    }

    @NotNull
    public final RectF mapRectToDevice(@NotNull PdfDocument doc, int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, @NotNull RectF coords) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Point leftTop = this.mapPageCoordsToDevice(doc, pageIndex, startX, startY, sizeX, sizeY, rotate, coords.left, coords.top);
        Point rightBottom = this.mapPageCoordsToDevice(doc, pageIndex, startX, startY, sizeX, sizeY, rotate, coords.right, coords.bottom);
        Point point = leftTop;
        Intrinsics.checkNotNull((Object)point);
        float f = point.x;
        float f2 = leftTop.y;
        Point point2 = rightBottom;
        Intrinsics.checkNotNull((Object)point2);
        return new RectF(f, f2, (float)point2.x, (float)rightBottom.y);
    }

    public final int getPageRotation(int pageIndex) {
        return this.nativeGetPageRotation(pageIndex);
    }

    static {
        System.loadLibrary("pdfsdk");
        System.loadLibrary("pdfsdk_jni");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ahmer/pdfium/PdfiumCore$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "lock", "getLock", "()Ljava/lang/Object;", "mCurrentDpi", "", "libPdfium_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getLock() {
            return lock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

