/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.threedsecurity;

import android.content.Context;
import com.airwallex.android.core.SecurityConnector;
import com.airwallex.android.core.SecurityTokenListener;
import com.airwallex.android.core.log.Logger;
import com.threatmetrix.TrustDefender.RL.TMXConfig;
import com.threatmetrix.TrustDefender.RL.TMXProfiling;
import com.threatmetrix.TrustDefender.RL.TMXProfilingConnections.TMXProfilingConnections;
import com.threatmetrix.TrustDefender.RL.TMXProfilingConnectionsInterface;
import com.threatmetrix.TrustDefender.RL.TMXProfilingHandle;
import com.threatmetrix.TrustDefender.RL.TMXProfilingOptions;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/airwallex/android/threedsecurity/AirwallexSecurityConnector;", "Lcom/airwallex/android/core/SecurityConnector;", "()V", "profilingHandle", "Lcom/threatmetrix/TrustDefender/RL/TMXProfilingHandle;", "doProfile", "", "paymentIntentId", "", "securityTokenListener", "Lcom/airwallex/android/core/SecurityTokenListener;", "retrieveSecurityToken", "applicationContext", "Landroid/content/Context;", "Companion", "security-3ds_release"})
public final class AirwallexSecurityConnector
implements SecurityConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TMXProfilingHandle profilingHandle;
    @NotNull
    private static final String TAG = "TrustDefender";

    public void retrieveSecurityToken(@NotNull String paymentIntentId, @NotNull Context applicationContext, @NotNull SecurityTokenListener securityTokenListener) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)securityTokenListener, (String)"securityTokenListener");
        Logger.debug$default((Logger)Logger.INSTANCE, (String)TAG, (String)"Start init TrustDefender", null, (int)4, null);
        TMXProfilingConnections tMXProfilingConnections = new TMXProfilingConnections().setConnectionTimeout(20, TimeUnit.SECONDS).setRetryTimes(3);
        Intrinsics.checkNotNullExpressionValue((Object)tMXProfilingConnections, (String)"TMXProfilingConnections(\u2026        .setRetryTimes(3)");
        TMXProfilingConnectionsInterface profilingConnections = (TMXProfilingConnectionsInterface)tMXProfilingConnections;
        TMXConfig tMXConfig = new TMXConfig().setOrgId("1snn5n9w").setContext(applicationContext);
        Intrinsics.checkNotNullExpressionValue((Object)tMXConfig, (String)"TMXConfig().setOrgId(Bui\u2026ntext(applicationContext)");
        TMXConfig config = tMXConfig;
        config.setProfilingConnections(profilingConnections);
        TMXProfiling.getInstance().init(config);
        Logger.debug$default((Logger)Logger.INSTANCE, (String)TAG, (String)"Successfully init init-ed", null, (int)4, null);
        this.doProfile(paymentIntentId, securityTokenListener);
    }

    private final void doProfile(String paymentIntentId, SecurityTokenListener securityTokenListener) {
        String fraudSessionId = paymentIntentId + System.currentTimeMillis();
        String sessionID = "airwallex_cybs" + fraudSessionId;
        TMXProfilingOptions tMXProfilingOptions = new TMXProfilingOptions().setSessionID(sessionID);
        Intrinsics.checkNotNullExpressionValue((Object)tMXProfilingOptions, (String)"TMXProfilingOptions().setSessionID(sessionID)");
        TMXProfilingOptions options = tMXProfilingOptions;
        this.profilingHandle = TMXProfiling.getInstance().profile(options, arg_0 -> AirwallexSecurityConnector.doProfile$lambda$0(this, arg_0));
        Logger.debug$default((Logger)Logger.INSTANCE, (String)TAG, (String)("Response sessionID " + sessionID), null, (int)4, null);
        securityTokenListener.onResponse(sessionID);
    }

    private static final void doProfile$lambda$0(AirwallexSecurityConnector this$0, TMXProfilingHandle.Result result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.debug$default((Logger)Logger.INSTANCE, (String)TAG, (String)("Session id: " + result.getSessionID() + ", Session status: " + result.getStatus()), null, (int)4, null);
        TMXProfilingHandle tMXProfilingHandle = this$0.profilingHandle;
        if (tMXProfilingHandle != null) {
            tMXProfilingHandle.cancel();
        }
        this$0.profilingHandle = null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/airwallex/android/threedsecurity/AirwallexSecurityConnector$Companion;", "", "()V", "TAG", "", "security-3ds_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

