/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.threedsecurity;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexApiRepository;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.AirwallexPlugins;
import com.airwallex.android.core.CardNextActionModel;
import com.airwallex.android.core.exception.AirwallexException;
import com.airwallex.android.core.log.Logger;
import com.airwallex.android.core.model.Device;
import com.airwallex.android.core.model.NextAction;
import com.airwallex.android.core.model.Options;
import com.airwallex.android.core.model.PaymentIntent;
import com.airwallex.android.core.model.PaymentIntentContinueRequest;
import com.airwallex.android.core.model.PaymentIntentContinueType;
import com.airwallex.android.core.model.ThreeDSecure;
import com.airwallex.android.threedsecurity.ThreeDSecureWebViewClient;
import com.airwallex.android.threedsecurity.exception.ThreeDSException;
import com.airwallex.android.threedsecurity.exception.WebViewConnectionException;
import com.airwallex.android.ui.AirwallexActivity;
import com.airwallex.android.ui.AirwallexWebView;
import com.airwallex.android.ui.WebViewExtensionKt;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/airwallex/android/threedsecurity/ThreeDSecurityManager;", "", "()V", "build3DSContinuePaymentIntentOptions", "Lcom/airwallex/android/core/AirwallexApiRepository$ContinuePaymentIntentOptions;", "device", "Lcom/airwallex/android/core/model/Device;", "paymentIntentId", "", "clientSecret", "threeDSecure", "Lcom/airwallex/android/core/model/ThreeDSecure;", "handleThreeDSFlow", "", "activity", "Landroid/app/Activity;", "nextAction", "Lcom/airwallex/android/core/model/NextAction;", "cardNextActionModel", "Lcom/airwallex/android/core/CardNextActionModel;", "listener", "Lcom/airwallex/android/core/Airwallex$PaymentResultListener;", "security-3ds_release"})
public final class ThreeDSecurityManager {
    @NotNull
    public static final ThreeDSecurityManager INSTANCE = new ThreeDSecurityManager();

    private ThreeDSecurityManager() {
    }

    public final void handleThreeDSFlow(@NotNull String paymentIntentId, @NotNull Activity activity, @NotNull NextAction nextAction, @NotNull CardNextActionModel cardNextActionModel, @NotNull Airwallex.PaymentResultListener listener) {
        AirwallexWebView airwallexWebView;
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)nextAction, (String)"nextAction");
        Intrinsics.checkNotNullParameter((Object)cardNextActionModel, (String)"cardNextActionModel");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String url = nextAction.getUrl();
        Map data = nextAction.getData();
        if (url == null || data == null) {
            listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new ThreeDSException("3DS Failed. Missing data in response.")));
            return;
        }
        ViewGroup container = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        AirwallexWebView $this$handleThreeDSFlow_u24lambda_u240 = airwallexWebView = new AirwallexWebView((Context)activity);
        boolean bl = false;
        if (nextAction.getStage() == NextAction.NextActionStage.WAITING_USER_INFO_INPUT) {
            $this$handleThreeDSFlow_u24lambda_u240.setVisibility(0);
            AirwallexActivity.setLoadingProgress$default((AirwallexActivity)((AirwallexActivity)activity), (boolean)false, (boolean)false, (int)2, null);
        } else {
            $this$handleThreeDSFlow_u24lambda_u240.setVisibility(4);
        }
        $this$handleThreeDSFlow_u24lambda_u240.setWebViewClient((WebViewClient)new ThreeDSecureWebViewClient(new ThreeDSecureWebViewClient.Callbacks($this$handleThreeDSFlow_u24lambda_u240, activity, cardNextActionModel, paymentIntentId, listener){
            final /* synthetic */ AirwallexWebView $this_apply;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ CardNextActionModel $cardNextActionModel;
            final /* synthetic */ String $paymentIntentId;
            final /* synthetic */ Airwallex.PaymentResultListener $listener;
            {
                this.$this_apply = $receiver;
                this.$activity = $activity;
                this.$cardNextActionModel = $cardNextActionModel;
                this.$paymentIntentId = $paymentIntentId;
                this.$listener = $listener;
            }

            public void onWebViewConfirmation(@NotNull String payload) {
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                Logger.debug$default((Logger)Logger.INSTANCE, (String)("onWebViewConfirmation " + payload), null, (int)2, null);
                this.$this_apply.setVisibility(4);
                Activity activity = this.$activity;
                Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type com.airwallex.android.ui.AirwallexActivity");
                ((AirwallexActivity)activity).setLoadingProgress(true, false);
                this.$cardNextActionModel.getPaymentManager().startOperation((Options)ThreeDSecurityManager.access$build3DSContinuePaymentIntentOptions(ThreeDSecurityManager.INSTANCE, this.$cardNextActionModel.getDevice(), this.$paymentIntentId, this.$cardNextActionModel.getClientSecret(), new ThreeDSecure.Builder().setAcsResponse(payload).setReturnUrl(AirwallexPlugins.INSTANCE.getEnvironment().threeDsReturnUrl()).build()), (Airwallex.PaymentListener)new Airwallex.PaymentListener<PaymentIntent>(this.$this_apply, this.$listener, this.$paymentIntentId, this.$activity, this.$cardNextActionModel){
                    final /* synthetic */ AirwallexWebView $this_apply;
                    final /* synthetic */ Airwallex.PaymentResultListener $listener;
                    final /* synthetic */ String $paymentIntentId;
                    final /* synthetic */ Activity $activity;
                    final /* synthetic */ CardNextActionModel $cardNextActionModel;
                    {
                        this.$this_apply = $receiver;
                        this.$listener = $listener;
                        this.$paymentIntentId = $paymentIntentId;
                        this.$activity = $activity;
                        this.$cardNextActionModel = $cardNextActionModel;
                    }

                    public void onSuccess(@NotNull PaymentIntent response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        Logger.debug$default((Logger)Logger.INSTANCE, (String)("onSuccess " + response), null, (int)2, null);
                        WebViewExtensionKt.destroyWebView((WebView)((WebView)this.$this_apply));
                        NextAction continueNextAction = response.getNextAction();
                        if (continueNextAction == null) {
                            Logger.debug$default((Logger)Logger.INSTANCE, (String)("3DS finished, doesn't need challenge. Status: " + response.getStatus() + ", NextAction: " + continueNextAction), null, (int)2, null);
                            this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Success(response.getId(), null, 2, null));
                            return;
                        }
                        ThreeDSecurityManager.INSTANCE.handleThreeDSFlow(this.$paymentIntentId, this.$activity, continueNextAction, this.$cardNextActionModel, this.$listener);
                    }

                    public void onFailed(@NotNull AirwallexException exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        WebViewExtensionKt.destroyWebView((WebView)((WebView)this.$this_apply));
                        this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure(exception));
                    }
                });
            }

            public void onWebViewError(@NotNull WebViewConnectionException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Logger.INSTANCE.error("onWebViewError", (Throwable)((Object)error));
                WebViewExtensionKt.destroyWebView((WebView)((WebView)this.$this_apply));
                this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)error));
            }

            public void onPageFinished(@Nullable String url) {
                Logger.debug$default((Logger)Logger.INSTANCE, (String)("onPageFinished " + url), null, (int)2, null);
            }

            public void onPageStarted(@Nullable String url) {
                Logger.debug$default((Logger)Logger.INSTANCE, (String)("onPageStarted " + url), null, (int)2, null);
            }
        }));
        StringBuilder postResult = new StringBuilder();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String string = postResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"postResult.toString()");
            if (((CharSequence)string).length() > 0) {
                postResult.append("&");
            }
            postResult.append(key);
            postResult.append("=");
            postResult.append(URLEncoder.encode(String.valueOf(value), "UTF-8"));
        }
        String string = postResult.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"postResult.toString()");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$handleThreeDSFlow_u24lambda_u240.postUrl(url, byArray);
        AirwallexWebView webView2 = airwallexWebView;
        container.addView((View)webView2);
    }

    private final AirwallexApiRepository.ContinuePaymentIntentOptions build3DSContinuePaymentIntentOptions(Device device, String paymentIntentId, String clientSecret, ThreeDSecure threeDSecure) {
        PaymentIntentContinueRequest request = new PaymentIntentContinueRequest(UUID.randomUUID().toString(), PaymentIntentContinueType.THREE_DS_CONTINUE, threeDSecure, device, null, 16, null);
        return new AirwallexApiRepository.ContinuePaymentIntentOptions(clientSecret, paymentIntentId, request);
    }

    public static final /* synthetic */ AirwallexApiRepository.ContinuePaymentIntentOptions access$build3DSContinuePaymentIntentOptions(ThreeDSecurityManager $this, Device device, String paymentIntentId, String clientSecret, ThreeDSecure threeDSecure) {
        return $this.build3DSContinuePaymentIntentOptions(device, paymentIntentId, clientSecret, threeDSecure);
    }
}

