/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.card;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import com.airwallex.android.card.CardComponentProvider;
import com.airwallex.android.card.DccCallback;
import com.airwallex.android.card.exception.DccException;
import com.airwallex.android.card.view.DccActivityLaunch;
import com.airwallex.android.core.ActionComponent;
import com.airwallex.android.core.ActionComponentProvider;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexApiRepository;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.CardNextActionModel;
import com.airwallex.android.core.SecurityTokenListener;
import com.airwallex.android.core.exception.AirwallexCheckoutException;
import com.airwallex.android.core.exception.AirwallexException;
import com.airwallex.android.core.model.NextAction;
import com.airwallex.android.core.model.Options;
import com.airwallex.android.core.model.PaymentIntent;
import com.airwallex.android.threedsecurity.AirwallexSecurityConnector;
import com.airwallex.android.threedsecurity.ThreeDSecurityManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J<\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/airwallex/android/card/CardComponent;", "Lcom/airwallex/android/core/ActionComponent;", "()V", "dccCallback", "Lcom/airwallex/android/card/DccCallback;", "handleActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "handleDccData", "", "callback", "handlePaymentIntentResponse", "paymentIntentId", "", "nextAction", "Lcom/airwallex/android/core/model/NextAction;", "activity", "Landroid/app/Activity;", "applicationContext", "Landroid/content/Context;", "cardNextActionModel", "Lcom/airwallex/android/core/CardNextActionModel;", "listener", "Lcom/airwallex/android/core/Airwallex$PaymentResultListener;", "retrieveSecurityToken", "securityTokenListener", "Lcom/airwallex/android/core/SecurityTokenListener;", "Companion", "card_release"})
public final class CardComponent
implements ActionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DccCallback dccCallback;
    @NotNull
    private static final ActionComponentProvider<CardComponent> PROVIDER = new CardComponentProvider();

    public void handlePaymentIntentResponse(@NotNull String paymentIntentId, @Nullable NextAction nextAction, @NotNull Activity activity, @NotNull Context applicationContext, @Nullable CardNextActionModel cardNextActionModel, @NotNull Airwallex.PaymentResultListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (cardNextActionModel == null) {
            listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new AirwallexCheckoutException(null, null, 0, "Card payment info not found", null, 23, null)));
            return;
        }
        Fragment fragment = cardNextActionModel.getFragment();
        DccActivityLaunch dccActivityLaunch = fragment != null ? new DccActivityLaunch(fragment) : new DccActivityLaunch(activity);
        NextAction nextAction2 = nextAction;
        Object object = nextAction2 != null ? nextAction2.getType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                NextAction.DccData dcc = nextAction.getDcc();
                if (dcc == null) {
                    listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new AirwallexCheckoutException(null, null, 0, "Dcc data not found", null, 23, null)));
                    return;
                }
                this.dccCallback = new DccCallback(this, listener){
                    final /* synthetic */ CardComponent this$0;
                    final /* synthetic */ Airwallex.PaymentResultListener $listener;
                    {
                        this.this$0 = $receiver;
                        this.$listener = $listener;
                    }

                    public void onSuccess(@NotNull String paymentIntentId) {
                        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
                        CardComponent.access$setDccCallback$p(this.this$0, null);
                        this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Success(paymentIntentId, null, 2, null));
                    }

                    public void onFailed(@NotNull Exception exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        CardComponent.access$setDccCallback$p(this.this$0, null);
                        this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new AirwallexCheckoutException(null, null, 0, null, (Throwable)exception, 15, null)));
                    }
                };
                dccActivityLaunch.startForResult(new DccActivityLaunch.Args(dcc, cardNextActionModel.getPaymentIntentId(), cardNextActionModel.getCurrency(), cardNextActionModel.getAmount(), cardNextActionModel.getClientSecret()));
                break;
            }
            case 2: {
                ThreeDSecurityManager.INSTANCE.handleThreeDSFlow(paymentIntentId, activity, nextAction, cardNextActionModel, listener);
                break;
            }
            default: {
                Airwallex.PaymentListener<PaymentIntent> retrievePaymentIntentListener2 = new Airwallex.PaymentListener<PaymentIntent>(listener){
                    final /* synthetic */ Airwallex.PaymentResultListener $listener;
                    {
                        this.$listener = $listener;
                    }

                    public void onSuccess(@NotNull PaymentIntent response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Success(response.getId(), null, 2, null));
                    }

                    public void onFailed(@NotNull AirwallexException exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                        this.$listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure(exception));
                    }
                };
                cardNextActionModel.getPaymentManager().startOperation((Options)new AirwallexApiRepository.RetrievePaymentIntentOptions(cardNextActionModel.getClientSecret(), cardNextActionModel.getPaymentIntentId()), (Airwallex.PaymentListener)retrievePaymentIntentListener2);
            }
        }
    }

    public boolean handleActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 1005) {
            DccCallback dccCallback = this.dccCallback;
            if (dccCallback != null) {
                DccCallback it = dccCallback;
                boolean bl = false;
                try {
                    this.handleDccData(data, resultCode, it);
                }
                catch (Exception e) {
                    String string;
                    String string2;
                    String string3 = string2 = e.getLocalizedMessage();
                    if (string3 == null) {
                        string = "Dcc failed.";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"e.localizedMessage ?: \"Dcc failed.\"");
                        string = string2;
                    }
                    it.onFailed((Exception)((Object)new DccException(string)));
                }
            }
            return true;
        }
        return false;
    }

    public void retrieveSecurityToken(@NotNull String paymentIntentId, @NotNull Context applicationContext, @NotNull SecurityTokenListener securityTokenListener) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)securityTokenListener, (String)"securityTokenListener");
        new AirwallexSecurityConnector().retrieveSecurityToken(paymentIntentId, applicationContext, securityTokenListener);
    }

    private final void handleDccData(Intent data, int resultCode, DccCallback callback) {
        switch (resultCode) {
            case -1: {
                String paymentIntentId;
                DccActivityLaunch.Result result;
                DccActivityLaunch.Result result2 = result = DccActivityLaunch.Result.Companion.fromIntent(data);
                String string = paymentIntentId = result2 != null ? result2.getPaymentIntentId() : null;
                if (paymentIntentId != null) {
                    callback.onSuccess(paymentIntentId);
                    break;
                }
                DccActivityLaunch.Result result3 = result;
                if (result3 == null || (result3 = result3.getException()) == null) {
                    result3 = new DccException("Dcc failed.");
                }
                callback.onFailed((Exception)((Object)result3));
                break;
            }
            case 0: {
                callback.onFailed((Exception)((Object)new DccException("Dcc failed. Reason: User cancel the Dcc")));
            }
        }
    }

    public static final /* synthetic */ void access$setDccCallback$p(CardComponent $this, DccCallback dccCallback) {
        $this.dccCallback = dccCallback;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/airwallex/android/card/CardComponent$Companion;", "", "()V", "PROVIDER", "Lcom/airwallex/android/core/ActionComponentProvider;", "Lcom/airwallex/android/card/CardComponent;", "getPROVIDER", "()Lcom/airwallex/android/core/ActionComponentProvider;", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionComponentProvider<CardComponent> getPROVIDER() {
            return PROVIDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextAction.NextActionType.values().length];
            try {
                nArray[NextAction.NextActionType.DCC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextAction.NextActionType.REDIRECT_FORM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

