/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.card.view;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.res.ResourcesCompat;
import com.airwallex.android.card.databinding.WidgetCurrencyBinding;
import com.airwallex.android.core.util.CurrencyUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/airwallex/android/card/view/CurrencyWidget;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currency", "", "getCurrency", "()Ljava/lang/String;", "price", "getPrice", "viewBinding", "Lcom/airwallex/android/card/databinding/WidgetCurrencyBinding;", "updateCurrency", "", "amount", "Ljava/math/BigDecimal;", "card_release"})
public final class CurrencyWidget
extends FrameLayout {
    @NotNull
    private final WidgetCurrencyBinding viewBinding;

    public CurrencyWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        WidgetCurrencyBinding widgetCurrencyBinding = WidgetCurrencyBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)widgetCurrencyBinding, (String)"inflate(\n        LayoutI\u2026 this,\n        true\n    )");
        this.viewBinding = widgetCurrencyBinding;
    }

    @NotNull
    public final String getCurrency() {
        return ((Object)this.viewBinding.tvCurrency.getText()).toString();
    }

    @NotNull
    public final String getPrice() {
        return ((Object)this.viewBinding.tvPrice.getText()).toString();
    }

    public final void updateCurrency(@NotNull String currency, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        this.viewBinding.tvCurrency.setText((CharSequence)currency);
        this.viewBinding.tvPrice.setText((CharSequence)CurrencyUtils.INSTANCE.formatPrice(currency, amount));
        try {
            String country = (String)CurrencyUtils.INSTANCE.getCurrencyToCountryMap().get(currency);
            if (country == null) {
                this.viewBinding.icon.setVisibility(8);
            } else {
                Resources resources = this.getResources();
                String string = "ic_flag_%s";
                Object[] objectArray = new Object[1];
                String string2 = country;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                int resourceId = resources.getIdentifier(string3, "drawable", this.getContext().getPackageName());
                this.viewBinding.icon.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)resourceId, null));
            }
        }
        catch (Exception e) {
            this.viewBinding.icon.setVisibility(8);
        }
    }
}

