/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.googlepay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.airwallex.android.core.ActionComponent;
import com.airwallex.android.core.ActionComponentProvider;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.AirwallexSession;
import com.airwallex.android.core.CardNextActionModel;
import com.airwallex.android.core.GooglePayOptions;
import com.airwallex.android.core.SecurityTokenListener;
import com.airwallex.android.core.exception.AirwallexCheckoutException;
import com.airwallex.android.core.exception.AirwallexException;
import com.airwallex.android.core.log.Logger;
import com.airwallex.android.core.model.AvailablePaymentMethodType;
import com.airwallex.android.core.model.Billing;
import com.airwallex.android.core.model.NextAction;
import com.airwallex.android.googlepay.GooglePayComponent;
import com.airwallex.android.googlepay.GooglePayComponentProvider;
import com.airwallex.android.googlepay.PaymentsUtil;
import com.airwallex.android.threedsecurity.AirwallexSecurityConnector;
import com.airwallex.android.threedsecurity.ThreeDSecurityManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020\u0010H\u0002J\"\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J<\u0010,\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J \u00103\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fRe\u0010\r\u001aM\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00067"}, d2={"Lcom/airwallex/android/googlepay/GooglePayComponent;", "Lcom/airwallex/android/core/ActionComponent;", "()V", "listener", "Lcom/airwallex/android/core/Airwallex$PaymentResultListener;", "paymentIntentId", "", "paymentMethodType", "Lcom/airwallex/android/core/model/AvailablePaymentMethodType;", "getPaymentMethodType", "()Lcom/airwallex/android/core/model/AvailablePaymentMethodType;", "setPaymentMethodType", "(Lcom/airwallex/android/core/model/AvailablePaymentMethodType;)V", "resolvePaymentRequest", "Lkotlin/Function3;", "Lcom/google/android/gms/tasks/Task;", "Lcom/google/android/gms/wallet/PaymentData;", "Lkotlin/ParameterName;", "name", "task", "Landroid/app/Activity;", "activity", "", "requestCode", "", "getResolvePaymentRequest", "()Lkotlin/jvm/functions/Function3;", "setResolvePaymentRequest", "(Lkotlin/jvm/functions/Function3;)V", "session", "Lcom/airwallex/android/core/AirwallexSession;", "getSession", "()Lcom/airwallex/android/core/AirwallexSession;", "setSession", "(Lcom/airwallex/android/core/AirwallexSession;)V", "createPaymentSuccessInfo", "", "", "paymentData", "handleActivityResult", "", "resultCode", "data", "Landroid/content/Intent;", "handlePaymentIntentResponse", "nextAction", "Lcom/airwallex/android/core/model/NextAction;", "applicationContext", "Landroid/content/Context;", "cardNextActionModel", "Lcom/airwallex/android/core/CardNextActionModel;", "retrieveSecurityToken", "securityTokenListener", "Lcom/airwallex/android/core/SecurityTokenListener;", "Companion", "googlepay_release"})
public final class GooglePayComponent
implements ActionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Function3<? super Task<PaymentData>, ? super Activity, ? super Integer, Unit> resolvePaymentRequest = resolvePaymentRequest.1.INSTANCE;
    @Nullable
    private Airwallex.PaymentResultListener listener;
    @Nullable
    private String paymentIntentId;
    public AvailablePaymentMethodType paymentMethodType;
    public AirwallexSession session;
    @NotNull
    private static final ActionComponentProvider<GooglePayComponent> PROVIDER = new GooglePayComponentProvider();
    private static final int loadPaymentDataRequestCode = 991;
    @NotNull
    private static final String errorTag = "Google Pay loadPaymentData failed";

    @NotNull
    public final Function3<Task<PaymentData>, Activity, Integer, Unit> getResolvePaymentRequest() {
        return this.resolvePaymentRequest;
    }

    public final void setResolvePaymentRequest(@NotNull Function3<? super Task<PaymentData>, ? super Activity, ? super Integer, Unit> function3) {
        Intrinsics.checkNotNullParameter(function3, (String)"<set-?>");
        this.resolvePaymentRequest = function3;
    }

    @NotNull
    public final AvailablePaymentMethodType getPaymentMethodType() {
        AvailablePaymentMethodType availablePaymentMethodType = this.paymentMethodType;
        if (availablePaymentMethodType != null) {
            return availablePaymentMethodType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"paymentMethodType");
        return null;
    }

    public final void setPaymentMethodType(@NotNull AvailablePaymentMethodType availablePaymentMethodType) {
        Intrinsics.checkNotNullParameter((Object)availablePaymentMethodType, (String)"<set-?>");
        this.paymentMethodType = availablePaymentMethodType;
    }

    @NotNull
    public final AirwallexSession getSession() {
        AirwallexSession airwallexSession = this.session;
        if (airwallexSession != null) {
            return airwallexSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        return null;
    }

    public final void setSession(@NotNull AirwallexSession airwallexSession) {
        Intrinsics.checkNotNullParameter((Object)airwallexSession, (String)"<set-?>");
        this.session = airwallexSession;
    }

    public void handlePaymentIntentResponse(@NotNull String paymentIntentId, @Nullable NextAction nextAction, @NotNull Activity activity, @NotNull Context applicationContext, @Nullable CardNextActionModel cardNextActionModel, @NotNull Airwallex.PaymentResultListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        NextAction nextAction2 = nextAction;
        if ((nextAction2 != null ? nextAction2.getType() : null) == NextAction.NextActionType.REDIRECT_FORM) {
            if (cardNextActionModel == null) {
                listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new AirwallexCheckoutException(null, null, 0, "Card payment info not found", null, 23, null)));
                return;
            }
            ThreeDSecurityManager.INSTANCE.handleThreeDSFlow(paymentIntentId, activity, nextAction, cardNextActionModel, listener);
        } else {
            this.paymentIntentId = paymentIntentId;
            this.listener = listener;
            GooglePayOptions googlePayOptions = this.getSession().getGooglePayOptions();
            if (googlePayOptions == null) {
                return;
            }
            GooglePayOptions googlePayOptions2 = googlePayOptions;
            JSONObject jSONObject = PaymentsUtil.INSTANCE.getPaymentDataRequest(this.getSession().getAmount(), this.getSession().getCountryCode(), this.getSession().getCurrency(), googlePayOptions2, this.getPaymentMethodType().getCardSchemes());
            if (jSONObject == null) {
                GooglePayComponent $this$handlePaymentIntentResponse_u24lambda_u240 = this;
                boolean bl = false;
                listener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure((AirwallexException)new AirwallexCheckoutException(null, null, 0, "Can't serialize Google Pay payment data request", null, 23, null)));
                return;
            }
            JSONObject paymentDataRequestJson = jSONObject;
            PaymentDataRequest paymentDataRequest = PaymentDataRequest.fromJson((String)paymentDataRequestJson.toString());
            Intrinsics.checkNotNullExpressionValue((Object)paymentDataRequest, (String)"fromJson(paymentDataRequestJson.toString())");
            PaymentDataRequest request = paymentDataRequest;
            PaymentsClient paymentClient = PaymentsUtil.INSTANCE.createPaymentsClient(activity);
            Task task = paymentClient.loadPaymentData(request);
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"paymentClient.loadPaymentData(request)");
            this.resolvePaymentRequest.invoke((Object)task, (Object)activity, (Object)991);
        }
    }

    public boolean handleActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 991) {
            switch (resultCode) {
                case -1: {
                    String string = this.paymentIntentId;
                    if (string == null) {
                        GooglePayComponent $this$handleActivityResult_u24lambda_u241 = this;
                        boolean bl = false;
                        Logger.error$default((Logger)Logger.INSTANCE, (String)errorTag, (String)"Invalid payment intent ID", null, (int)4, null);
                        Airwallex.PaymentResultListener paymentResultListener = $this$handleActivityResult_u24lambda_u241.listener;
                        if (paymentResultListener != null) {
                            paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                        }
                        return true;
                    }
                    String id = string;
                    Intent intent = data;
                    if (intent != null) {
                        Unit unit;
                        Intent intent2 = intent;
                        boolean bl = false;
                        PaymentData paymentData = PaymentData.getFromIntent((Intent)intent2);
                        if (paymentData != null) {
                            Map<String, Object> successInfo = this.createPaymentSuccessInfo(paymentData);
                            if (successInfo != null) {
                                Airwallex.PaymentResultListener paymentResultListener = this.listener;
                                if (paymentResultListener != null) {
                                    paymentResultListener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Success(id, successInfo));
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                            } else {
                                Airwallex.PaymentResultListener paymentResultListener = this.listener;
                                if (paymentResultListener != null) {
                                    paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                            }
                        } else {
                            Airwallex.PaymentResultListener paymentResultListener = this.listener;
                            if (paymentResultListener != null) {
                                paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                        }
                        intent = unit;
                        if (unit != null) break;
                    }
                    Airwallex.PaymentResultListener paymentResultListener = this.listener;
                    if (paymentResultListener != null) {
                        paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                        intent = Unit.INSTANCE;
                        break;
                    }
                    intent = null;
                    break;
                }
                case 0: {
                    Airwallex.PaymentResultListener paymentResultListener = this.listener;
                    if (paymentResultListener != null) {
                        paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                    }
                    break;
                }
                case 1: {
                    Status status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                    if (status != null) {
                        Status it = status;
                        boolean bl = false;
                        String string = "Error code: %d";
                        Object[] objectArray = new Object[]{it.getStatusCode()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                        Logger.error$default((Logger)Logger.INSTANCE, (String)errorTag, (String)string2, null, (int)4, null);
                    }
                    Airwallex.PaymentResultListener paymentResultListener = this.listener;
                    if (paymentResultListener == null) break;
                    paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void retrieveSecurityToken(@NotNull String paymentIntentId, @NotNull Context applicationContext, @NotNull SecurityTokenListener securityTokenListener) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)securityTokenListener, (String)"securityTokenListener");
        new AirwallexSecurityConnector().retrieveSecurityToken(paymentIntentId, applicationContext, securityTokenListener);
    }

    private final Map<String, Object> createPaymentSuccessInfo(PaymentData paymentData) {
        Map map;
        String string = paymentData.toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"paymentData.toJson()");
        String paymentInformation = string;
        Map $this$createPaymentSuccessInfo_u24lambda_u246 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        try {
            JSONObject paymentMethodData = new JSONObject(paymentInformation).getJSONObject("paymentMethodData");
            $this$createPaymentSuccessInfo_u24lambda_u246.put("payment_data_type", "encrypted_payment_token");
            String string2 = paymentMethodData.getJSONObject("tokenizationData").getString("token");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"paymentMethodData.getJSO\u2026Data\").getString(\"token\")");
            $this$createPaymentSuccessInfo_u24lambda_u246.put("encrypted_payment_token", string2);
            JSONObject jSONObject = paymentMethodData.optJSONObject("info").optJSONObject("billingAddress");
            if (jSONObject != null) {
                JSONObject billingAddress = jSONObject;
                boolean bl2 = false;
                Billing billing = PaymentsUtil.INSTANCE.getBilling(billingAddress);
                if (billing != null) {
                    Billing it = billing;
                    boolean bl3 = false;
                    $this$createPaymentSuccessInfo_u24lambda_u246.put("billing", it);
                }
            }
        }
        catch (JSONException e) {
            Logger.error$default((Logger)Logger.INSTANCE, (String)errorTag, (String)("Error: " + e.getMessage()), null, (int)4, null);
            return null;
        }
        Map info = map;
        return info;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/airwallex/android/googlepay/GooglePayComponent$Companion;", "", "()V", "PROVIDER", "Lcom/airwallex/android/core/ActionComponentProvider;", "Lcom/airwallex/android/googlepay/GooglePayComponent;", "getPROVIDER", "()Lcom/airwallex/android/core/ActionComponentProvider;", "errorTag", "", "loadPaymentDataRequestCode", "", "googlepay_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionComponentProvider<GooglePayComponent> getPROVIDER() {
            return PROVIDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

