/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.googlepay;

import android.app.Activity;
import com.airwallex.android.core.AirwallexPlugins;
import com.airwallex.android.core.BillingAddressParameters;
import com.airwallex.android.core.GooglePayOptions;
import com.airwallex.android.core.ShippingAddressParameters;
import com.airwallex.android.core.TokenManager;
import com.airwallex.android.core.model.Address;
import com.airwallex.android.core.model.Billing;
import com.airwallex.android.core.model.CardScheme;
import com.airwallex.android.googlepay.Constants;
import com.airwallex.android.googlepay.EnvironmentExtensionKt;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0004J8\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\bJ(\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\b\u00a8\u0006\u001d"}, d2={"Lcom/airwallex/android/googlepay/PaymentsUtil;", "", "()V", "baseCardPaymentMethod", "Lorg/json/JSONObject;", "googlePayOptions", "Lcom/airwallex/android/core/GooglePayOptions;", "cardList", "", "", "baseRequest", "cardPaymentMethod", "createPaymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "activity", "Landroid/app/Activity;", "gatewayTokenizationSpecification", "getBilling", "Lcom/airwallex/android/core/model/Billing;", "payload", "getPaymentDataRequest", "price", "Ljava/math/BigDecimal;", "countryCode", "currency", "supportedCardSchemes", "Lcom/airwallex/android/core/model/CardScheme;", "getTransactionInfo", "isReadyToPayRequest", "googlepay_release"})
public final class PaymentsUtil {
    @NotNull
    public static final PaymentsUtil INSTANCE = new PaymentsUtil();

    private PaymentsUtil() {
    }

    private final JSONObject baseRequest() {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject $this$baseRequest_u24lambda_u241 = jSONObject2 = new JSONObject();
        boolean bl = false;
        JSONObject $this$baseRequest_u24lambda_u241_u24lambda_u240 = jSONObject = $this$baseRequest_u24lambda_u241;
        boolean bl2 = false;
        $this$baseRequest_u24lambda_u241_u24lambda_u240.put("apiVersion", 2);
        $this$baseRequest_u24lambda_u241_u24lambda_u240.put("apiVersionMinor", 0);
        return jSONObject2;
    }

    private final JSONObject gatewayTokenizationSpecification() {
        JSONObject jSONObject;
        JSONObject $this$gatewayTokenizationSpecification_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$gatewayTokenizationSpecification_u24lambda_u242.put("type", (Object)"PAYMENT_GATEWAY");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"gateway", (Object)"airwallex");
        String string = TokenManager.INSTANCE.getAccountId();
        if (string == null) {
            string = "";
        }
        pairArray[1] = TuplesKt.to((Object)"gatewayMerchantId", (Object)string);
        $this$gatewayTokenizationSpecification_u24lambda_u242.put("parameters", (Object)new JSONObject(MapsKt.mapOf((Pair[])pairArray)));
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject baseCardPaymentMethod(GooglePayOptions googlePayOptions, List<String> cardList) {
        boolean it;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject $this$baseCardPaymentMethod_u24lambda_u2412 = jSONObject2 = new JSONObject();
        boolean bl = false;
        JSONObject $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411 = jSONObject = new JSONObject();
        boolean bl2 = false;
        List<String> list = googlePayOptions.getAllowedCardAuthMethods();
        if (list == null) {
            list = Constants.INSTANCE.getDEFAULT_SUPPORTED_METHODS();
        }
        $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("allowedAuthMethods", (Object)new JSONArray((Collection)list));
        List<String> list2 = cardList;
        if (list2 == null) {
            list2 = Constants.INSTANCE.getDEFAULT_SUPPORTED_CARD_NETWORKS();
        }
        $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("allowedCardNetworks", (Object)new JSONArray((Collection)list2));
        Boolean bl3 = googlePayOptions.getAllowPrepaidCards();
        if (bl3 != null) {
            it = bl3;
            boolean bl4 = false;
            $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("allowPrepaidCards", it);
        }
        Boolean bl5 = googlePayOptions.getAllowCreditCards();
        if (bl5 != null) {
            it = bl5;
            boolean bl6 = false;
            $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("allowCreditCards", it);
        }
        Boolean bl7 = googlePayOptions.getAssuranceDetailsRequired();
        if (bl7 != null) {
            it = bl7;
            boolean bl8 = false;
            $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("assuranceDetailsRequired", it);
        }
        Boolean bl9 = googlePayOptions.getBillingAddressRequired();
        if (bl9 != null) {
            it = bl9;
            boolean bl10 = false;
            $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411.put("billingAddressRequired", it);
        }
        BillingAddressParameters billingAddressParameters = googlePayOptions.getBillingAddressParameters();
        if (billingAddressParameters != null) {
            void $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249;
            JSONObject jSONObject3;
            BillingAddressParameters billingParams = billingAddressParameters;
            boolean bl11 = false;
            JSONObject jSONObject4 = jSONObject3 = new JSONObject();
            String string = "billingAddressParameters";
            JSONObject jSONObject5 = $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411;
            boolean bl12 = false;
            BillingAddressParameters.Format format = billingParams.getFormat();
            if (format != null) {
                BillingAddressParameters.Format it2 = format;
                boolean bl13 = false;
                $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("format", (Object)it2.name());
            }
            Boolean bl14 = billingParams.getPhoneNumberRequired();
            if (bl14 != null) {
                boolean it3 = bl14;
                boolean bl15 = false;
                $this$baseCardPaymentMethod_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("phoneNumberRequired", it3);
            }
            Unit unit = Unit.INSTANCE;
            jSONObject5.put(string, (Object)jSONObject3);
        }
        JSONObject parameters = jSONObject;
        $this$baseCardPaymentMethod_u24lambda_u2412.put("type", (Object)"CARD");
        $this$baseCardPaymentMethod_u24lambda_u2412.put("parameters", (Object)parameters);
        return jSONObject2;
    }

    private final JSONObject cardPaymentMethod(GooglePayOptions googlePayOptions, List<String> cardList) {
        JSONObject cardPaymentMethod = this.baseCardPaymentMethod(googlePayOptions, cardList);
        cardPaymentMethod.put("tokenizationSpecification", (Object)this.gatewayTokenizationSpecification());
        return cardPaymentMethod;
    }

    @NotNull
    public final PaymentsClient createPaymentsClient(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Wallet.WalletOptions walletOptions = new Wallet.WalletOptions.Builder().setEnvironment(EnvironmentExtensionKt.googlePayEnvironment(AirwallexPlugins.INSTANCE.getEnvironment())).build();
        Intrinsics.checkNotNullExpressionValue((Object)walletOptions, (String)"Builder()\n            .s\u2026t())\n            .build()");
        Wallet.WalletOptions walletOptions2 = walletOptions;
        PaymentsClient paymentsClient = Wallet.getPaymentsClient((Activity)activity, (Wallet.WalletOptions)walletOptions2);
        Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(activity, walletOptions)");
        return paymentsClient;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSONObject isReadyToPayRequest(@NotNull GooglePayOptions googlePayOptions, @Nullable List<CardScheme> supportedCardSchemes) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)googlePayOptions, (String)"googlePayOptions");
        try {
            Collection<String> collection;
            JSONObject $this$isReadyToPayRequest_u24lambda_u2414 = jSONObject = this.baseRequest();
            boolean bl = false;
            JSONObject jSONObject2 = $this$isReadyToPayRequest_u24lambda_u2414;
            String string = "allowedPaymentMethods";
            JSONArray jSONArray = new JSONArray();
            PaymentsUtil paymentsUtil = INSTANCE;
            GooglePayOptions googlePayOptions2 = googlePayOptions;
            List<CardScheme> list = supportedCardSchemes;
            if (list != null) {
                Collection<String> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list;
                GooglePayOptions googlePayOptions3 = googlePayOptions2;
                PaymentsUtil paymentsUtil2 = paymentsUtil;
                JSONArray jSONArray2 = jSONArray;
                String string2 = string;
                JSONObject jSONObject3 = jSONObject2;
                boolean $i$f$map = false;
                void var13_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CardScheme cardScheme = (CardScheme)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    String string3 = it.getName().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    collection2.add(string3);
                }
                collection2 = (List)destination$iv$iv;
                jSONObject2 = jSONObject3;
                string = string2;
                jSONArray = jSONArray2;
                paymentsUtil = paymentsUtil2;
                googlePayOptions2 = googlePayOptions3;
                collection = collection2;
            } else {
                collection = null;
            }
            jSONObject2.put(string, (Object)jSONArray.put((Object)paymentsUtil.baseCardPaymentMethod(googlePayOptions2, (List<String>)collection)));
        }
        catch (JSONException e) {
            jSONObject = null;
        }
        return jSONObject;
    }

    private final JSONObject getTransactionInfo(String price, String countryCode, String currency, GooglePayOptions googlePayOptions) {
        JSONObject jSONObject;
        block2: {
            String string;
            String it;
            JSONObject $this$getTransactionInfo_u24lambda_u2417 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$getTransactionInfo_u24lambda_u2417.put("totalPrice", (Object)price);
            $this$getTransactionInfo_u24lambda_u2417.put("totalPriceStatus", (Object)"FINAL");
            $this$getTransactionInfo_u24lambda_u2417.put("countryCode", (Object)countryCode);
            $this$getTransactionInfo_u24lambda_u2417.put("currencyCode", (Object)currency);
            String string2 = googlePayOptions.getTransactionId();
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                $this$getTransactionInfo_u24lambda_u2417.put("transactionId", (Object)it);
            }
            if ((string = googlePayOptions.getTotalPriceLabel()) == null) {
                string = "order.total";
            }
            $this$getTransactionInfo_u24lambda_u2417.put("totalPriceLabel", (Object)string);
            String string3 = googlePayOptions.getCheckoutOption();
            if (string3 == null) break block2;
            it = string3;
            boolean bl3 = false;
            $this$getTransactionInfo_u24lambda_u2417.put("checkoutOption", (Object)it);
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSONObject getPaymentDataRequest(@NotNull BigDecimal price, @NotNull String countryCode, @NotNull String currency, @NotNull GooglePayOptions googlePayOptions, @Nullable List<CardScheme> supportedCardSchemes) {
        JSONObject jSONObject;
        block10: {
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)googlePayOptions, (String)"googlePayOptions");
            try {
                void $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425;
                JSONObject jSONObject2;
                Collection<String> collection;
                JSONObject $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2419_u24lambda_u2418;
                JSONObject jSONObject3;
                String string;
                String it;
                JSONObject $this$getPaymentDataRequest_u24lambda_u2427 = jSONObject = this.baseRequest();
                boolean bl = false;
                String string2 = googlePayOptions.getMerchantName();
                if (string2 != null) {
                    JSONObject jSONObject4;
                    it = string2;
                    boolean bl2 = false;
                    JSONObject jSONObject5 = jSONObject4 = new JSONObject();
                    string = "merchantInfo";
                    jSONObject3 = $this$getPaymentDataRequest_u24lambda_u2427;
                    boolean bl3 = false;
                    $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2419_u24lambda_u2418.put("merchantName", (Object)it);
                    Unit unit = Unit.INSTANCE;
                    jSONObject3.put(string, (Object)jSONObject4);
                }
                JSONObject jSONObject6 = $this$getPaymentDataRequest_u24lambda_u2427;
                String string3 = "allowedPaymentMethods";
                JSONArray jSONArray = new JSONArray();
                PaymentsUtil paymentsUtil = INSTANCE;
                GooglePayOptions googlePayOptions2 = googlePayOptions;
                List<CardScheme> list = supportedCardSchemes;
                if (list != null) {
                    Collection<String> collection2;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = list;
                    GooglePayOptions googlePayOptions3 = googlePayOptions2;
                    PaymentsUtil paymentsUtil2 = paymentsUtil;
                    JSONArray jSONArray2 = jSONArray;
                    String string4 = string3;
                    JSONObject jSONObject7 = jSONObject6;
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        jSONObject3 = (CardScheme)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl4 = false;
                        String string5 = it2.getName().toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                        collection2.add(string5);
                    }
                    collection2 = (List)destination$iv$iv;
                    jSONObject6 = jSONObject7;
                    string3 = string4;
                    jSONArray = jSONArray2;
                    paymentsUtil = paymentsUtil2;
                    googlePayOptions2 = googlePayOptions3;
                    collection = collection2;
                } else {
                    collection = null;
                }
                jSONObject6.put(string3, (Object)jSONArray.put((Object)paymentsUtil.cardPaymentMethod(googlePayOptions2, (List<String>)collection)));
                String string6 = price.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"price.toString()");
                $this$getPaymentDataRequest_u24lambda_u2427.put("transactionInfo", (Object)INSTANCE.getTransactionInfo(string6, countryCode, currency, googlePayOptions));
                Boolean bl5 = googlePayOptions.getEmailRequired();
                if (bl5 != null) {
                    boolean it3 = bl5;
                    boolean bl6 = false;
                    $this$getPaymentDataRequest_u24lambda_u2427.put("emailRequired", it3);
                }
                Boolean bl7 = googlePayOptions.getShippingAddressRequired();
                if (bl7 != null) {
                    boolean it4 = bl7;
                    boolean bl8 = false;
                    $this$getPaymentDataRequest_u24lambda_u2427.put("shippingAddressRequired", it4);
                }
                ShippingAddressParameters shippingAddressParameters = googlePayOptions.getShippingAddressParameters();
                if (shippingAddressParameters == null) break block10;
                ShippingAddressParameters shippingParams = shippingAddressParameters;
                boolean bl9 = false;
                $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2419_u24lambda_u2418 = jSONObject2 = new JSONObject();
                string = "shippingAddressParameters";
                jSONObject3 = $this$getPaymentDataRequest_u24lambda_u2427;
                boolean bl10 = false;
                List list2 = shippingParams.getAllowedCountryCodes();
                if (list2 != null) {
                    List it5 = list2;
                    boolean bl11 = false;
                    $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.put("allowedCountryCodes", (Object)new JSONArray((Collection)it5));
                }
                Boolean bl12 = shippingParams.getPhoneNumberRequired();
                if (bl12 != null) {
                    boolean it6 = bl12;
                    boolean bl13 = false;
                    $this$getPaymentDataRequest_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.put("phoneNumberRequired", it6);
                }
                Unit unit = Unit.INSTANCE;
                jSONObject3.put(string, (Object)jSONObject2);
            }
            catch (JSONException e) {
                jSONObject = null;
            }
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Billing getBilling(@NotNull JSONObject payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String name = payload.optString("name");
        String countryCode = payload.optString("countryCode");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (((CharSequence)name).length() > 0) {
            Intrinsics.checkNotNullExpressionValue((Object)countryCode, (String)"countryCode");
            if (((CharSequence)countryCode).length() > 0) {
                String string;
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                Object object = new String[]{payload.optString("address1"), payload.optString("address2"), payload.optString("address3")};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$filterNot = false;
                String[] stringArray = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (((CharSequence)it).length() == 0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String street = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                String it = string = payload.optString("locality");
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String locality = ((CharSequence)it).length() > 0 ? string : null;
                Billing.Builder builder = new Billing.Builder();
                Address.Builder builder2 = new Address.Builder();
                String string2 = locality;
                if (string2 == null) {
                    string2 = countryCode;
                }
                Billing.Builder builder3 = builder.setAddress(builder2.setCity(string2).setCountryCode(countryCode).setPostcode(payload.optString("postalCode", null)).setState(payload.optString("administrativeArea", null)).setStreet(street).build());
                stringArray = new String[]{" "};
                String string3 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (string3 == null) {
                    string3 = "";
                }
                Billing.Builder builder4 = builder3.setFirstName(string3);
                stringArray = new String[]{" "};
                String string4 = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
                if (string4 == null) {
                    string4 = "";
                }
                return builder4.setLastName(string4).setEmail(payload.optString("email", null)).build();
            }
        }
        return null;
    }
}

