/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android;

import android.app.Activity;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.AirwallexSession;
import com.airwallex.android.core.AirwallexShippingStatus;
import com.airwallex.android.core.model.Shipping;
import com.airwallex.android.view.PaymentMethodsActivityLaunch;
import com.airwallex.android.view.PaymentShippingActivityLaunch;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/airwallex/android/AirwallexStarter;", "", "()V", "Companion", "airwallex_release"})
public final class AirwallexStarter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static Airwallex.ShippingResultListener shippingResultListener;
    @Nullable
    private static Airwallex.PaymentResultListener paymentResultListener;
    @NotNull
    private static final Set<Integer> VALID_REQUEST_CODES;

    static {
        Object[] objectArray = new Integer[]{1001, 1003};
        VALID_REQUEST_CODES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tJ \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/airwallex/android/AirwallexStarter$Companion;", "", "()V", "VALID_REQUEST_CODES", "", "", "paymentResultListener", "Lcom/airwallex/android/core/Airwallex$PaymentResultListener;", "shippingResultListener", "Lcom/airwallex/android/core/Airwallex$ShippingResultListener;", "handlePaymentData", "", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "presentPaymentFlow", "", "activity", "Landroid/app/Activity;", "session", "Lcom/airwallex/android/core/AirwallexSession;", "fragment", "Landroidx/fragment/app/Fragment;", "launch", "Lcom/airwallex/android/view/PaymentMethodsActivityLaunch;", "presentShippingFlow", "shipping", "Lcom/airwallex/android/core/model/Shipping;", "Lcom/airwallex/android/view/PaymentShippingActivityLaunch;", "airwallex_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void presentShippingFlow(@NotNull Fragment fragment, @Nullable Shipping shipping2, @NotNull Airwallex.ShippingResultListener shippingResultListener) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)shippingResultListener, (String)"shippingResultListener");
            this.presentShippingFlow(new PaymentShippingActivityLaunch(fragment), shipping2, shippingResultListener);
        }

        public final void presentShippingFlow(@NotNull Activity activity, @Nullable Shipping shipping2, @NotNull Airwallex.ShippingResultListener shippingResultListener) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)shippingResultListener, (String)"shippingResultListener");
            this.presentShippingFlow(new PaymentShippingActivityLaunch(activity), shipping2, shippingResultListener);
        }

        private final void presentShippingFlow(PaymentShippingActivityLaunch launch, Shipping shipping2, Airwallex.ShippingResultListener shippingResultListener) {
            AirwallexStarter.shippingResultListener = shippingResultListener;
            launch.startForResult(new PaymentShippingActivityLaunch.Args.Builder().setShipping(shipping2).build());
        }

        public final void presentPaymentFlow(@NotNull Fragment fragment, @NotNull AirwallexSession session2, @NotNull Airwallex.PaymentResultListener paymentResultListener) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)paymentResultListener, (String)"paymentResultListener");
            this.presentPaymentFlow(new PaymentMethodsActivityLaunch(fragment), session2, paymentResultListener);
        }

        public final void presentPaymentFlow(@NotNull Activity activity, @NotNull AirwallexSession session2, @NotNull Airwallex.PaymentResultListener paymentResultListener) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)paymentResultListener, (String)"paymentResultListener");
            this.presentPaymentFlow(new PaymentMethodsActivityLaunch(activity), session2, paymentResultListener);
        }

        private final void presentPaymentFlow(PaymentMethodsActivityLaunch launch, AirwallexSession session2, Airwallex.PaymentResultListener paymentResultListener) {
            AirwallexStarter.paymentResultListener = paymentResultListener;
            launch.startForResult(new PaymentMethodsActivityLaunch.Args.Builder().setAirwallexSession(session2).build());
        }

        public final boolean handlePaymentData(int requestCode, int resultCode, @Nullable Intent data) {
            if (!VALID_REQUEST_CODES.contains(requestCode)) {
                return false;
            }
            switch (resultCode) {
                case -1: {
                    boolean bl;
                    switch (requestCode) {
                        case 1003: {
                            PaymentShippingActivityLaunch.Result result = PaymentShippingActivityLaunch.Result.Companion.fromIntent(data);
                            if (result == null) {
                                return true;
                            }
                            PaymentShippingActivityLaunch.Result result2 = result;
                            Airwallex.ShippingResultListener shippingResultListener = shippingResultListener;
                            if (shippingResultListener != null) {
                                shippingResultListener.onCompleted((AirwallexShippingStatus)new AirwallexShippingStatus.Success(result2.getShipping()));
                            }
                            AirwallexStarter.shippingResultListener = null;
                            bl = true;
                            break;
                        }
                        case 1001: {
                            PaymentMethodsActivityLaunch.Result result = PaymentMethodsActivityLaunch.Result.Companion.fromIntent(data);
                            if (result == null) {
                                return true;
                            }
                            PaymentMethodsActivityLaunch.Result result3 = result;
                            if (result3.getException() != null) {
                                Airwallex.PaymentResultListener paymentResultListener = paymentResultListener;
                                if (paymentResultListener != null) {
                                    paymentResultListener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Failure(result3.getException()));
                                }
                            } else if (result3.getPaymentIntentId() != null) {
                                if (result3.isRedirecting()) {
                                    Airwallex.PaymentResultListener paymentResultListener = paymentResultListener;
                                    if (paymentResultListener != null) {
                                        paymentResultListener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.InProgress(result3.getPaymentIntentId()));
                                    }
                                } else {
                                    Airwallex.PaymentResultListener paymentResultListener = paymentResultListener;
                                    if (paymentResultListener != null) {
                                        paymentResultListener.onCompleted((AirwallexPaymentStatus)new AirwallexPaymentStatus.Success(result3.getPaymentIntentId(), null, 2, null));
                                    }
                                }
                            }
                            AirwallexStarter.paymentResultListener = null;
                            bl = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    return bl;
                }
                case 0: {
                    boolean bl;
                    switch (requestCode) {
                        case 1003: {
                            Airwallex.ShippingResultListener shippingResultListener = shippingResultListener;
                            if (shippingResultListener != null) {
                                shippingResultListener.onCompleted((AirwallexShippingStatus)AirwallexShippingStatus.Cancel.INSTANCE);
                            }
                            AirwallexStarter.shippingResultListener = null;
                            bl = true;
                            break;
                        }
                        case 1001: {
                            Airwallex.PaymentResultListener paymentResultListener = paymentResultListener;
                            if (paymentResultListener != null) {
                                paymentResultListener.onCompleted((AirwallexPaymentStatus)AirwallexPaymentStatus.Cancel.INSTANCE);
                            }
                            AirwallexStarter.paymentResultListener = null;
                            bl = true;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    return bl;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

