/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view;

import android.app.Application;
import androidx.annotation.StringRes;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.airwallex.android.R;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexPaymentSession;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.AirwallexSession;
import com.airwallex.android.core.ClientSecretRepository;
import com.airwallex.android.core.exception.AirwallexCheckoutException;
import com.airwallex.android.core.exception.AirwallexException;
import com.airwallex.android.core.exception.InvalidParamsException;
import com.airwallex.android.core.model.Billing;
import com.airwallex.android.core.model.CardScheme;
import com.airwallex.android.core.model.ClientSecret;
import com.airwallex.android.core.model.CreatePaymentConsentParams;
import com.airwallex.android.core.model.CreatePaymentMethodParams;
import com.airwallex.android.core.model.PaymentConsent;
import com.airwallex.android.core.model.PaymentMethod;
import com.airwallex.android.core.model.PaymentMethodType;
import com.airwallex.android.view.AddPaymentMethodViewModel;
import com.airwallex.android.view.CardBrand;
import com.airwallex.android.view.util.CardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "airwallex", "Lcom/airwallex/android/core/Airwallex;", "session", "Lcom/airwallex/android/core/AirwallexSession;", "supportedCardSchemes", "", "Lcom/airwallex/android/core/model/CardScheme;", "(Landroid/app/Application;Lcom/airwallex/android/core/Airwallex;Lcom/airwallex/android/core/AirwallexSession;Ljava/util/List;)V", "checkoutWithSavedCard", "Lcom/airwallex/android/core/AirwallexPaymentStatus;", "card", "Lcom/airwallex/android/core/model/PaymentMethod$Card;", "billing", "Lcom/airwallex/android/core/model/Billing;", "(Lcom/airwallex/android/core/model/PaymentMethod$Card;Lcom/airwallex/android/core/model/Billing;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOneOffCardPaymentMethod", "Landroidx/lifecycle/LiveData;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "createPaymentMethod", "createStoredCardPaymentMethod", "getValidationResult", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult;", "cardNumber", "", "Factory", "PaymentMethodResult", "ValidationResult", "airwallex_release"})
public final class AddPaymentMethodViewModel
extends AndroidViewModel {
    @NotNull
    private final Airwallex airwallex;
    @NotNull
    private final AirwallexSession session;
    @NotNull
    private final List<CardScheme> supportedCardSchemes;

    public AddPaymentMethodViewModel(@NotNull Application application, @NotNull Airwallex airwallex2, @NotNull AirwallexSession session2, @NotNull List<CardScheme> supportedCardSchemes2) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)airwallex2, (String)"airwallex");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(supportedCardSchemes2, (String)"supportedCardSchemes");
        super(application);
        this.airwallex = airwallex2;
        this.session = session2;
        this.supportedCardSchemes = supportedCardSchemes2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ValidationResult getValidationResult(@NotNull String cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        if (((CharSequence)cardNumber).length() == 0) {
            return new ValidationResult.Error(R.string.airwallex_empty_card_number);
        }
        if (CardUtils.INSTANCE.isValidCardNumber(cardNumber)) {
            void $this$mapTo$iv$iv;
            CardBrand cardBrand = CardUtils.INSTANCE.getPossibleCardBrand(cardNumber, true);
            Iterable $this$map$iv = this.supportedCardSchemes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CardScheme cardScheme = (CardScheme)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CardBrand.Companion.fromType(it.getName()));
            }
            List supportedCardBrands = (List)destination$iv$iv;
            return supportedCardBrands.contains((Object)cardBrand) ? (ValidationResult)ValidationResult.Success.INSTANCE : (ValidationResult)new ValidationResult.Error(R.string.airwallex_unsupported_card_number);
        }
        return new ValidationResult.Error(R.string.airwallex_invalid_card_number);
    }

    @NotNull
    public final LiveData<PaymentMethodResult> createPaymentMethod(@NotNull PaymentMethod.Card card, @Nullable Billing billing) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Billing resolvedBilling = this.session.isBillingInformationRequired() ? billing : null;
        return this.session instanceof AirwallexPaymentSession ? this.createOneOffCardPaymentMethod(card, resolvedBilling) : this.createStoredCardPaymentMethod(card, resolvedBilling);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkoutWithSavedCard(@NotNull PaymentMethod.Card var1_1, @Nullable Billing var2_2, @NotNull Continuation<? super AirwallexPaymentStatus> var3_3) {
        if (!(var3_3 instanceof checkoutWithSavedCard.1)) ** GOTO lbl-1000
        var16_4 = var3_3;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AddPaymentMethodViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkoutWithSavedCard(null, null, (Continuation<? super AirwallexPaymentStatus>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                billingOrNull = this.session.isBillingInformationRequired() != false ? billing : null;
                oneOffPaymentMethod = new PaymentMethod.Builder().setType(PaymentMethodType.CARD.getValue()).setCard(card).setBilling(billingOrNull).build();
                v0 = this.session.getCustomerId();
                if (v0 == null) {
                    var8_9 = "Required value was null.";
                    throw new IllegalArgumentException(var8_9.toString());
                }
                customerId = v0;
                $continuation.L$0 = this;
                $continuation.L$1 = card;
                $continuation.L$2 = billingOrNull;
                $continuation.L$3 = oneOffPaymentMethod;
                $continuation.L$4 = customerId;
                $continuation.label = 1;
                v1 = ClientSecretRepository.Companion.getInstance().retrieveClientSecret(customerId, (Continuation)$continuation);
                ** if (v1 != var17_6) goto lbl30
lbl29:
                // 1 sources

                return var17_6;
lbl30:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                customerId = (String)$continuation.L$4;
                oneOffPaymentMethod = (PaymentMethod)$continuation.L$3;
                billingOrNull = (Billing)$continuation.L$2;
                card = (PaymentMethod.Card)$continuation.L$1;
                this = (AddPaymentMethodViewModel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    var8_10 = (ClientSecret)v1;
                }
                catch (AirwallexCheckoutException e) {
                    return new AirwallexPaymentStatus.Failure((AirwallexException)e);
                }
                clientSecret = var8_10;
                $continuation.L$0 = this;
                $continuation.L$1 = card;
                $continuation.L$2 = oneOffPaymentMethod;
                $continuation.L$3 = customerId;
                $continuation.L$4 = clientSecret;
                $continuation.label = 2;
                v2 = this.airwallex.createPaymentMethod(new CreatePaymentMethodParams(clientSecret.getValue(), customerId, card, billingOrNull), (Continuation)$continuation);
                ** if (v2 != var17_6) goto lbl57
lbl56:
                // 1 sources

                return var17_6;
lbl57:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                clientSecret = (ClientSecret)$continuation.L$4;
                customerId = (String)$continuation.L$3;
                oneOffPaymentMethod = (PaymentMethod)$continuation.L$2;
                card = (PaymentMethod.Card)$continuation.L$1;
                this = (AddPaymentMethodViewModel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl68:
                    // 2 sources

                    e = (PaymentMethod)v2;
                }
                catch (Throwable var10_16) {
                    e = oneOffPaymentMethod;
                }
                paymentMethod = e;
                var10_17 = CreatePaymentConsentParams.Companion;
                var11_19 = clientSecret.getValue();
                v3 = paymentMethod.getId();
                if (v3 == null) {
                    var14_21 = "Required value was null.";
                    throw new IllegalArgumentException(var14_21.toString());
                }
                var12_22 = v3;
                var13_24 = PaymentConsent.NextTriggeredBy.CUSTOMER;
                $continuation.L$0 = this;
                $continuation.L$1 = card;
                $continuation.L$2 = oneOffPaymentMethod;
                $continuation.L$3 = paymentMethod;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v4 = this.airwallex.createPaymentConsent(var10_17.createCardParams(var11_19, customerId, var12_22, var13_24, null, true), (Continuation)$continuation);
                ** if (v4 != var17_6) goto lbl92
lbl91:
                // 1 sources

                return var17_6;
lbl92:
                // 1 sources

                ** GOTO lbl102
            }
            case 3: {
                paymentMethod = (PaymentMethod)$continuation.L$3;
                oneOffPaymentMethod = (PaymentMethod)$continuation.L$2;
                card = (PaymentMethod.Card)$continuation.L$1;
                this = (AddPaymentMethodViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl102:
                // 2 sources

                consent = (PaymentConsent)v4;
                $continuation.L$0 = this;
                $continuation.L$1 = card;
                $continuation.L$2 = oneOffPaymentMethod;
                $continuation.L$3 = paymentMethod;
                $continuation.L$4 = consent;
                $continuation.label = 4;
                var10_17 = (Continuation)$continuation;
                var11_19 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var10_17));
                cont = (Continuation)var11_19;
                $i$a$-suspendCoroutine-AddPaymentMethodViewModel$checkoutWithSavedCard$2 = false;
                Airwallex.checkout$default((Airwallex)this.airwallex, (AirwallexSession)this.session, (PaymentMethod)paymentMethod, (String)consent.getId(), (String)card.getCvc(), null, null, (Airwallex.PaymentResultListener)new Airwallex.PaymentResultListener((Continuation<? super AirwallexPaymentStatus>)cont){
                    final /* synthetic */ Continuation<AirwallexPaymentStatus> $cont;
                    {
                        this.$cont = $cont;
                    }

                    public void onCompleted(@NotNull AirwallexPaymentStatus status) {
                        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                        this.$cont.resumeWith(Result.constructor-impl((Object)status));
                    }
                }, (int)48, null);
                v5 = var11_19.getOrThrow();
                if (v5 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)$continuation));
                }
                v6 = v5;
                if (v5 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl135
            }
            case 4: {
                (PaymentConsent)$continuation.L$4;
                (PaymentMethod)$continuation.L$3;
                oneOffPaymentMethod = (PaymentMethod)$continuation.L$2;
                card = (PaymentMethod.Card)$continuation.L$1;
                this = (AddPaymentMethodViewModel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl135:
                    // 2 sources

                    return v6;
                }
                catch (Throwable var9_14) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = card;
                    $continuation.L$2 = oneOffPaymentMethod;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.label = 5;
                    var10_18 = $continuation;
                    var11_20 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var10_18));
                    cont = (Continuation)var11_20;
                    $i$a$-suspendCoroutine-AddPaymentMethodViewModel$checkoutWithSavedCard$3 = false;
                    Airwallex.checkout$default((Airwallex)this.airwallex, (AirwallexSession)this.session, (PaymentMethod)oneOffPaymentMethod, null, (String)card.getCvc(), null, null, (Airwallex.PaymentResultListener)new Airwallex.PaymentResultListener((Continuation<? super AirwallexPaymentStatus>)cont){
                        final /* synthetic */ Continuation<AirwallexPaymentStatus> $cont;
                        {
                            this.$cont = $cont;
                        }

                        public void onCompleted(@NotNull AirwallexPaymentStatus status) {
                            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                            this.$cont.resumeWith(Result.constructor-impl((Object)status));
                        }
                    }, (int)52, null);
                    v7 = var11_20.getOrThrow();
                    if (v7 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                    }
                    v8 = v7;
                    if (v7 == var17_6) {
                        return var17_6;
                    }
                    ** GOTO lbl166
                }
            }
            case 5: {
                (PaymentMethod)$continuation.L$2;
                (PaymentMethod.Card)$continuation.L$1;
                (AddPaymentMethodViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl166:
                // 2 sources

                return v8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final LiveData<PaymentMethodResult> createOneOffCardPaymentMethod(PaymentMethod.Card card, Billing billing) {
        MutableLiveData resultData = new MutableLiveData();
        try {
            String string2 = card.getCvc();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            resultData.setValue((Object)new PaymentMethodResult.Success(new PaymentMethod.Builder().setType(PaymentMethodType.CARD.getValue()).setCard(card).setBilling(billing).build(), string2));
        }
        catch (IllegalArgumentException e) {
            InvalidParamsException exception = new InvalidParamsException("Card CVC missing");
            resultData.setValue((Object)new PaymentMethodResult.Error((AirwallexException)exception));
        }
        return (LiveData)resultData;
    }

    private final LiveData<PaymentMethodResult> createStoredCardPaymentMethod(PaymentMethod.Card card, Billing billing) {
        MutableLiveData resultData = new MutableLiveData();
        try {
            String string2 = this.session.getCustomerId();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            ClientSecretRepository.Companion.getInstance().retrieveClientSecret(string2, new ClientSecretRepository.ClientSecretRetrieveListener(this, card, billing, (MutableLiveData<PaymentMethodResult>)resultData){
                final /* synthetic */ AddPaymentMethodViewModel this$0;
                final /* synthetic */ PaymentMethod.Card $card;
                final /* synthetic */ Billing $billing;
                final /* synthetic */ MutableLiveData<PaymentMethodResult> $resultData;
                {
                    this.this$0 = $receiver;
                    this.$card = $card;
                    this.$billing = $billing;
                    this.$resultData = $resultData;
                }

                public void onClientSecretRetrieve(@NotNull ClientSecret clientSecret) {
                    Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                    String string2 = AddPaymentMethodViewModel.access$getSession$p(this.this$0).getCustomerId();
                    if (string2 == null) {
                        String string3 = "Required value was null.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    AddPaymentMethodViewModel.access$getAirwallex$p(this.this$0).createPaymentMethod(new CreatePaymentMethodParams(clientSecret.getValue(), string2, this.$card, this.$billing), (Airwallex.PaymentListener)new Airwallex.PaymentListener<PaymentMethod>(this.$resultData, this.$card){
                        final /* synthetic */ MutableLiveData<PaymentMethodResult> $resultData;
                        final /* synthetic */ PaymentMethod.Card $card;
                        {
                            this.$resultData = $resultData;
                            this.$card = $card;
                        }

                        public void onSuccess(@NotNull PaymentMethod response) {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            String string2 = this.$card.getCvc();
                            if (string2 == null) {
                                String string3 = "Required value was null.";
                                throw new IllegalArgumentException(string3.toString());
                            }
                            this.$resultData.setValue((Object)new PaymentMethodResult.Success(response, string2));
                        }

                        public void onFailed(@NotNull AirwallexException exception) {
                            Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                            this.$resultData.setValue((Object)new PaymentMethodResult.Error(exception));
                        }
                    });
                }

                public void onClientSecretError(@NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    this.$resultData.setValue((Object)new PaymentMethodResult.Error((AirwallexException)((Object)new AirwallexCheckoutException(null, null, 0, errorMessage, null, 23, null))));
                }
            });
        }
        catch (AirwallexCheckoutException e) {
            resultData.setValue((Object)new PaymentMethodResult.Error((AirwallexException)((Object)e)));
        }
        return (LiveData)resultData;
    }

    public static final /* synthetic */ Airwallex access$getAirwallex$p(AddPaymentMethodViewModel $this) {
        return $this.airwallex;
    }

    public static final /* synthetic */ AirwallexSession access$getSession$p(AddPaymentMethodViewModel $this) {
        return $this.session;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "", "()V", "Error", "Success", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Error;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Success;", "airwallex_release"})
    public static abstract class PaymentMethodResult {
        private PaymentMethodResult() {
        }

        public /* synthetic */ PaymentMethodResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Success;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "paymentMethod", "Lcom/airwallex/android/core/model/PaymentMethod;", "cvc", "", "(Lcom/airwallex/android/core/model/PaymentMethod;Ljava/lang/String;)V", "getCvc", "()Ljava/lang/String;", "getPaymentMethod", "()Lcom/airwallex/android/core/model/PaymentMethod;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "airwallex_release"})
        public static final class Success
        extends PaymentMethodResult {
            @NotNull
            private final PaymentMethod paymentMethod;
            @NotNull
            private final String cvc;

            public Success(@NotNull PaymentMethod paymentMethod2, @NotNull String cvc) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod2, (String)"paymentMethod");
                Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
                super(null);
                this.paymentMethod = paymentMethod2;
                this.cvc = cvc;
            }

            @NotNull
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @NotNull
            public final String getCvc() {
                return this.cvc;
            }

            @NotNull
            public final PaymentMethod component1() {
                return this.paymentMethod;
            }

            @NotNull
            public final String component2() {
                return this.cvc;
            }

            @NotNull
            public final Success copy(@NotNull PaymentMethod paymentMethod2, @NotNull String cvc) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod2, (String)"paymentMethod");
                Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
                return new Success(paymentMethod2, cvc);
            }

            public static /* synthetic */ Success copy$default(Success success, PaymentMethod paymentMethod2, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentMethod2 = success.paymentMethod;
                }
                if ((n & 2) != 0) {
                    string2 = success.cvc;
                }
                return success.copy(paymentMethod2, string2);
            }

            @NotNull
            public String toString() {
                return "Success(paymentMethod=" + this.paymentMethod + ", cvc=" + this.cvc + ')';
            }

            public int hashCode() {
                int result = this.paymentMethod.hashCode();
                result = result * 31 + this.cvc.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)success.paymentMethod)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cvc, (Object)success.cvc);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Error;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "exception", "Lcom/airwallex/android/core/exception/AirwallexException;", "(Lcom/airwallex/android/core/exception/AirwallexException;)V", "getException", "()Lcom/airwallex/android/core/exception/AirwallexException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "airwallex_release"})
        public static final class Error
        extends PaymentMethodResult {
            @NotNull
            private final AirwallexException exception;

            public Error(@NotNull AirwallexException exception) {
                Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                super(null);
                this.exception = exception;
            }

            @NotNull
            public final AirwallexException getException() {
                return this.exception;
            }

            @NotNull
            public final AirwallexException component1() {
                return this.exception;
            }

            @NotNull
            public final Error copy(@NotNull AirwallexException exception) {
                Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                return new Error(exception);
            }

            public static /* synthetic */ Error copy$default(Error error, AirwallexException airwallexException, int n, Object object) {
                if ((n & 1) != 0) {
                    airwallexException = error.exception;
                }
                return error.copy(airwallexException);
            }

            @NotNull
            public String toString() {
                return "Error(exception=" + (Object)((Object)this.exception) + ')';
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)((Object)this.exception), (Object)((Object)error.exception));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ'\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "airwallex", "Lcom/airwallex/android/core/Airwallex;", "session", "Lcom/airwallex/android/core/AirwallexSession;", "supportedCardSchemes", "", "Lcom/airwallex/android/core/model/CardScheme;", "(Landroid/app/Application;Lcom/airwallex/android/core/Airwallex;Lcom/airwallex/android/core/AirwallexSession;Ljava/util/List;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "airwallex_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Application application;
        @NotNull
        private final Airwallex airwallex;
        @NotNull
        private final AirwallexSession session;
        @NotNull
        private final List<CardScheme> supportedCardSchemes;

        public Factory(@NotNull Application application, @NotNull Airwallex airwallex2, @NotNull AirwallexSession session2, @NotNull List<CardScheme> supportedCardSchemes2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)airwallex2, (String)"airwallex");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter(supportedCardSchemes2, (String)"supportedCardSchemes");
            this.application = application;
            this.airwallex = airwallex2;
            this.session = session2;
            this.supportedCardSchemes = supportedCardSchemes2;
        }

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            return (T)((ViewModel)new AddPaymentMethodViewModel(this.application, this.airwallex, this.session, this.supportedCardSchemes));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult;", "", "()V", "Error", "Success", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult$Error;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult$Success;", "airwallex_release"})
    public static abstract class ValidationResult {
        private ValidationResult() {
        }

        public /* synthetic */ ValidationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult$Success;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult;", "()V", "airwallex_release"})
        public static final class Success
        extends ValidationResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult$Error;", "Lcom/airwallex/android/view/AddPaymentMethodViewModel$ValidationResult;", "message", "", "(I)V", "getMessage", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "airwallex_release"})
        public static final class Error
        extends ValidationResult {
            private final int message;

            public Error(@StringRes int message) {
                super(null);
                this.message = message;
            }

            public final int getMessage() {
                return this.message;
            }

            public final int component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@StringRes int message) {
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = error.message;
                }
                return error.copy(n);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ')';
            }

            public int hashCode() {
                return Integer.hashCode(this.message);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return this.message == error.message;
            }
        }
    }
}

