/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view;

import android.app.Application;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.airwallex.android.core.Airwallex;
import com.airwallex.android.core.AirwallexPaymentSession;
import com.airwallex.android.core.AirwallexPaymentStatus;
import com.airwallex.android.core.AirwallexSession;
import com.airwallex.android.core.exception.AirwallexCheckoutException;
import com.airwallex.android.core.exception.AirwallexException;
import com.airwallex.android.core.model.AirwallexPaymentRequestFlow;
import com.airwallex.android.core.model.BankResponse;
import com.airwallex.android.core.model.PaymentIntent;
import com.airwallex.android.core.model.PaymentMethod;
import com.airwallex.android.core.model.PaymentMethodTypeInfo;
import com.airwallex.android.core.model.RetrieveBankParams;
import com.airwallex.android.core.model.RetrievePaymentMethodTypeInfoParams;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJL\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\n2\u0006\u0010\u0018\u001a\u00020\u000f\u00f8\u0001\u0000J\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00160\n2\u0006\u0010\u0018\u001a\u00020\u000f\u00f8\u0001\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/airwallex/android/view/AirwallexCheckoutViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "airwallex", "Lcom/airwallex/android/core/Airwallex;", "session", "Lcom/airwallex/android/core/AirwallexSession;", "(Landroid/app/Application;Lcom/airwallex/android/core/Airwallex;Lcom/airwallex/android/core/AirwallexSession;)V", "checkout", "Landroidx/lifecycle/LiveData;", "Lcom/airwallex/android/core/AirwallexPaymentStatus;", "paymentMethod", "Lcom/airwallex/android/core/model/PaymentMethod;", "paymentConsentId", "", "cvc", "additionalInfo", "", "flow", "Lcom/airwallex/android/core/model/AirwallexPaymentRequestFlow;", "retrieveBanks", "Lkotlin/Result;", "Lcom/airwallex/android/core/model/BankResponse;", "paymentMethodTypeName", "retrievePaymentMethodTypeInfo", "Lcom/airwallex/android/core/model/PaymentMethodTypeInfo;", "Factory", "airwallex_release"})
public final class AirwallexCheckoutViewModel
extends AndroidViewModel {
    @NotNull
    private final Airwallex airwallex;
    @NotNull
    private final AirwallexSession session;

    public AirwallexCheckoutViewModel(@NotNull Application application, @NotNull Airwallex airwallex2, @NotNull AirwallexSession session2) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)airwallex2, (String)"airwallex");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(application);
        this.airwallex = airwallex2;
        this.session = session2;
    }

    @NotNull
    public final LiveData<AirwallexPaymentStatus> checkout(@NotNull PaymentMethod paymentMethod2, @Nullable String paymentConsentId2, @Nullable String cvc, @Nullable Map<String, String> additionalInfo, @Nullable AirwallexPaymentRequestFlow flow) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod2, (String)"paymentMethod");
        MutableLiveData resultData = new MutableLiveData();
        Airwallex.PaymentResultListener listener2 = new Airwallex.PaymentResultListener((MutableLiveData<AirwallexPaymentStatus>)resultData){
            final /* synthetic */ MutableLiveData<AirwallexPaymentStatus> $resultData;
            {
                this.$resultData = $resultData;
            }

            public void onCompleted(@NotNull AirwallexPaymentStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$resultData.setValue((Object)status);
            }
        };
        this.airwallex.checkout(this.session, paymentMethod2, paymentConsentId2, cvc, additionalInfo, flow, listener2);
        return (LiveData)resultData;
    }

    public static /* synthetic */ LiveData checkout$default(AirwallexCheckoutViewModel airwallexCheckoutViewModel, PaymentMethod paymentMethod2, String string2, String string3, Map map, AirwallexPaymentRequestFlow airwallexPaymentRequestFlow, int n, Object object) {
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            airwallexPaymentRequestFlow = null;
        }
        return airwallexCheckoutViewModel.checkout(paymentMethod2, string2, string3, map, airwallexPaymentRequestFlow);
    }

    @NotNull
    public final LiveData<Result<BankResponse>> retrieveBanks(@NotNull String paymentMethodTypeName) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodTypeName, (String)"paymentMethodTypeName");
        MutableLiveData resultData = new MutableLiveData();
        if (this.session instanceof AirwallexPaymentSession) {
            PaymentIntent paymentIntent2 = ((AirwallexPaymentSession)this.session).getPaymentIntent();
            String string2 = paymentIntent2.getClientSecret();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            this.airwallex.retrieveBanks(new RetrieveBankParams.Builder(string2, paymentMethodTypeName).setCountryCode(this.session.getCountryCode()).build(), (Airwallex.PaymentListener)new Airwallex.PaymentListener<BankResponse>((MutableLiveData<Result<BankResponse>>)resultData){
                final /* synthetic */ MutableLiveData<Result<BankResponse>> $resultData;
                {
                    this.$resultData = $resultData;
                }

                public void onFailed(@NotNull AirwallexException exception) {
                    Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                    this.$resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exception))));
                }

                public void onSuccess(@NotNull BankResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)response)));
                }
            });
        } else {
            resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new AirwallexCheckoutException(null, null, 0, paymentMethodTypeName + " just support one-off payment", null, 23, null)))));
        }
        return (LiveData)resultData;
    }

    @NotNull
    public final LiveData<Result<PaymentMethodTypeInfo>> retrievePaymentMethodTypeInfo(@NotNull String paymentMethodTypeName) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodTypeName, (String)"paymentMethodTypeName");
        MutableLiveData resultData = new MutableLiveData();
        if (this.session instanceof AirwallexPaymentSession) {
            PaymentIntent paymentIntent2 = ((AirwallexPaymentSession)this.session).getPaymentIntent();
            String string2 = paymentIntent2.getClientSecret();
            if (string2 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
            this.airwallex.retrievePaymentMethodTypeInfo(new RetrievePaymentMethodTypeInfoParams.Builder(string2, paymentMethodTypeName).setFlow(AirwallexPaymentRequestFlow.IN_APP).build(), (Airwallex.PaymentListener)new Airwallex.PaymentListener<PaymentMethodTypeInfo>((MutableLiveData<Result<PaymentMethodTypeInfo>>)resultData){
                final /* synthetic */ MutableLiveData<Result<PaymentMethodTypeInfo>> $resultData;
                {
                    this.$resultData = $resultData;
                }

                public void onFailed(@NotNull AirwallexException exception) {
                    Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                    this.$resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exception))));
                }

                public void onSuccess(@NotNull PaymentMethodTypeInfo response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)response)));
                }
            });
        } else {
            resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new AirwallexCheckoutException(null, null, 0, paymentMethodTypeName + " just support one-off payment", null, 23, null)))));
        }
        return (LiveData)resultData;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0002H\n\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/airwallex/android/view/AirwallexCheckoutViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "airwallex", "Lcom/airwallex/android/core/Airwallex;", "session", "Lcom/airwallex/android/core/AirwallexSession;", "(Landroid/app/Application;Lcom/airwallex/android/core/Airwallex;Lcom/airwallex/android/core/AirwallexSession;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "airwallex_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Application application;
        @NotNull
        private final Airwallex airwallex;
        @NotNull
        private final AirwallexSession session;

        public Factory(@NotNull Application application, @NotNull Airwallex airwallex2, @NotNull AirwallexSession session2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)airwallex2, (String)"airwallex");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.application = application;
            this.airwallex = airwallex2;
            this.session = session2;
        }

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            return (T)((ViewModel)new AirwallexCheckoutViewModel(this.application, this.airwallex, this.session));
        }
    }
}

