/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.airwallex.android.R;
import com.airwallex.android.view.PaymentMethodsAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\b'\u0018\u00002\u00020\u0001:\u0002<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0002J6\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0'2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0016J*\u00100\u001a\u00020 2\b\u0010-\u001a\u0004\u0018\u00010.2\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\b\u0012\u0004\u0012\u00020\u000b`\u0010H&J@\u00102\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020\b2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u000206H\u0016J \u00107\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u00108\u001a\u00020.H\u0016J\u0018\u00109\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0006\u0010:\u001a\u00020\u000eH\u0016J\b\u0010;\u001a\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\b\u0012\u0004\u0012\u00020\u000b`\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00188\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/airwallex/android/view/PaymentMethodSwipeCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$SimpleCallback;", "context", "Landroid/content/Context;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "(Landroid/content/Context;Landroidx/recyclerview/widget/RecyclerView;)V", "buttonWidth", "", "buttons", "", "Lcom/airwallex/android/view/PaymentMethodSwipeCallback$UnderlayButton;", "buttonsBuffer", "", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getContext", "()Landroid/content/Context;", "gestureDetector", "Landroid/view/GestureDetector;", "gestureListener", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "onTouchListener", "Landroid/view/View$OnTouchListener;", "recoverQueue", "Ljava/util/LinkedList;", "rect", "Landroid/graphics/Rect;", "swipeThreshold", "swipedPosition", "attachSwipe", "", "drawButtons", "c", "Landroid/graphics/Canvas;", "itemView", "Landroid/view/View;", "buffer", "", "position", "dX", "getSwipeEscapeVelocity", "defaultValue", "getSwipeThreshold", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getSwipeVelocityThreshold", "instantiateUnderlayButton", "underlayButtons", "onChildDraw", "dY", "actionState", "isCurrentlyActive", "", "onMove", "target", "onSwiped", "direction", "recoverSwipedItem", "UnderlayButton", "UnderlayButtonClickListener", "airwallex_release"})
@SuppressLint(value={"ClickableViewAccessibility"})
public abstract class PaymentMethodSwipeCallback
extends ItemTouchHelper.SimpleCallback {
    @NotNull
    private final Context context;
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private List<UnderlayButton> buttons;
    private int swipedPosition;
    private float swipeThreshold;
    private final float buttonWidth;
    @NotNull
    private final Rect rect;
    @NotNull
    private final LinkedList<Integer> recoverQueue;
    @NotNull
    private final GestureDetector.SimpleOnGestureListener gestureListener;
    @SuppressLint(value={"ClickableViewAccessibility"})
    @NotNull
    private final View.OnTouchListener onTouchListener;
    @NotNull
    private final GestureDetector gestureDetector;
    @NotNull
    private final Map<Integer, ArrayList<UnderlayButton>> buttonsBuffer;

    public PaymentMethodSwipeCallback(@NotNull Context context, @NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super(0, 4);
        this.context = context;
        this.recyclerView = recyclerView;
        this.buttons = new ArrayList();
        this.swipedPosition = -1;
        this.swipeThreshold = 0.5f;
        this.buttonWidth = this.context.getResources().getDimension(R.dimen.swipe_button_width);
        this.rect = new Rect();
        this.recoverQueue = new LinkedList<Integer>(){

            public boolean add(int element) {
                return this.contains((Object)element) ? false : super.add(element);
            }
        };
        this.gestureListener = new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ PaymentMethodSwipeCallback this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
                UnderlayButton button;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterator<E> iterator = PaymentMethodSwipeCallback.access$getButtons$p(this.this$0).iterator();
                while (iterator.hasNext() && !(button = (UnderlayButton)iterator.next()).onClick(e.getX(), e.getY())) {
                }
                return true;
            }
        };
        this.onTouchListener = (arg_0, arg_1) -> PaymentMethodSwipeCallback.onTouchListener$lambda$0(this, arg_0, arg_1);
        this.gestureDetector = new GestureDetector(this.context, (GestureDetector.OnGestureListener)this.gestureListener);
        this.buttonsBuffer = new HashMap();
        this.recyclerView.setOnTouchListener(this.onTouchListener);
        this.attachSwipe();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int pos = viewHolder.getAdapterPosition();
        if (this.swipedPosition != pos) {
            this.recoverQueue.add(this.swipedPosition);
        }
        this.swipedPosition = pos;
        if (this.buttonsBuffer.containsKey(this.swipedPosition)) {
            ArrayList<UnderlayButton> arrayList = this.buttonsBuffer.get(this.swipedPosition);
            Intrinsics.checkNotNull(arrayList);
            this.buttons = arrayList;
        } else {
            this.buttons.clear();
        }
        this.buttonsBuffer.clear();
        this.swipeThreshold = 0.5f * (float)this.buttons.size() * this.buttonWidth;
        this.recoverSwipedItem();
    }

    public float getSwipeThreshold(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        return this.swipeThreshold;
    }

    public float getSwipeEscapeVelocity(float defaultValue) {
        return 0.1f * defaultValue;
    }

    public float getSwipeVelocityThreshold(float defaultValue) {
        return 5.0f * defaultValue;
    }

    public void onChildDraw(@NotNull Canvas c, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        if (!(viewHolder instanceof PaymentMethodsAdapter.PaymentConsentHolder)) {
            return;
        }
        int pos = ((PaymentMethodsAdapter.PaymentConsentHolder)viewHolder).getAdapterPosition();
        float translationX = dX;
        View view = viewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
        View itemView = view;
        if (pos < 0) {
            this.swipedPosition = pos;
            return;
        }
        if (actionState == 1 && dX < 0.0f) {
            ArrayList<UnderlayButton> buffer = new ArrayList<UnderlayButton>();
            if (!this.buttonsBuffer.containsKey(pos)) {
                this.instantiateUnderlayButton(viewHolder, buffer);
                Integer n = pos;
                this.buttonsBuffer.put(n, buffer);
            } else {
                ArrayList<UnderlayButton> arrayList = this.buttonsBuffer.get(pos);
                Intrinsics.checkNotNull(arrayList);
                buffer = arrayList;
            }
            translationX = dX * (float)buffer.size() * this.buttonWidth / (float)itemView.getWidth();
            this.drawButtons(c, itemView, (List<UnderlayButton>)buffer, pos, translationX);
        }
        super.onChildDraw(c, recyclerView, viewHolder, translationX, dY, actionState, isCurrentlyActive);
    }

    private final synchronized void recoverSwipedItem() {
        while (!this.recoverQueue.isEmpty()) {
            Integer position = this.recoverQueue.poll();
            if (position == null || position <= -1) continue;
            RecyclerView.Adapter adapter2 = this.recyclerView.getAdapter();
            if (adapter2 == null) continue;
            adapter2.notifyItemChanged(position.intValue());
        }
    }

    private final void drawButtons(Canvas c, View itemView, List<UnderlayButton> buffer, int position, float dX) {
        float right = itemView.getRight();
        float dButtonWidth = (float)-1 * dX / (float)buffer.size();
        for (UnderlayButton button : buffer) {
            float left = right - dButtonWidth;
            button.onDraw(c, new RectF(left, (float)itemView.getTop(), right, (float)itemView.getBottom()), position);
            right = left;
        }
    }

    private final void attachSwipe() {
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this);
        itemTouchHelper.attachToRecyclerView(this.recyclerView);
    }

    public abstract void instantiateUnderlayButton(@Nullable RecyclerView.ViewHolder var1, @NotNull ArrayList<UnderlayButton> var2);

    private static final boolean onTouchListener$lambda$0(PaymentMethodSwipeCallback this$0, View view, MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.swipedPosition < 0) {
            return false;
        }
        Point point = new Point((int)e.getRawX(), (int)e.getRawY());
        RecyclerView.ViewHolder viewHolder = this$0.recyclerView.findViewHolderForAdapterPosition(this$0.swipedPosition);
        if (viewHolder == null) {
            return false;
        }
        RecyclerView.ViewHolder swipedViewHolder = viewHolder;
        View view2 = swipedViewHolder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"swipedViewHolder.itemView");
        View swipedItem = view2;
        swipedItem.getGlobalVisibleRect(this$0.rect);
        if (e.getAction() == 0 || e.getAction() == 1 || e.getAction() == 2) {
            if (this$0.rect.top < point.y && this$0.rect.bottom > point.y) {
                this$0.gestureDetector.onTouchEvent(e);
            } else {
                this$0.recoverQueue.add(this$0.swipedPosition);
                this$0.swipedPosition = -1;
                this$0.recoverSwipedItem();
            }
        }
        return false;
    }

    public static final /* synthetic */ List access$getButtons$p(PaymentMethodSwipeCallback $this) {
        return $this.buttons;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/airwallex/android/view/PaymentMethodSwipeCallback$UnderlayButton;", "", "text", "", "textSize", "", "color", "clickListener", "Lcom/airwallex/android/view/PaymentMethodSwipeCallback$UnderlayButtonClickListener;", "(Ljava/lang/String;IILcom/airwallex/android/view/PaymentMethodSwipeCallback$UnderlayButtonClickListener;)V", "clickRegion", "Landroid/graphics/RectF;", "position", "onClick", "", "x", "", "y", "onDraw", "", "c", "Landroid/graphics/Canvas;", "rect", "pos", "airwallex_release"})
    public static final class UnderlayButton {
        @NotNull
        private final String text;
        private final int textSize;
        private final int color;
        @NotNull
        private final UnderlayButtonClickListener clickListener;
        private int position;
        @Nullable
        private RectF clickRegion;

        public UnderlayButton(@NotNull String text, int textSize, int color, @NotNull UnderlayButtonClickListener clickListener) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
            this.text = text;
            this.textSize = textSize;
            this.color = color;
            this.clickListener = clickListener;
        }

        public final boolean onClick(float x, float y) {
            if (this.clickRegion != null) {
                RectF rectF = this.clickRegion;
                Intrinsics.checkNotNull((Object)rectF);
                if (rectF.contains(x, y)) {
                    this.clickListener.onClick(this.position);
                    return true;
                }
            }
            return false;
        }

        public final void onDraw(@NotNull Canvas c, @NotNull RectF rect, int pos) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Paint p = new Paint();
            p.setColor(this.color);
            c.drawRect(rect, p);
            p.setColor(-1);
            p.setTextSize((float)this.textSize);
            Rect r = new Rect();
            float cHeight = rect.height();
            float cWidth = rect.width();
            p.setTextAlign(Paint.Align.LEFT);
            p.getTextBounds(this.text, 0, this.text.length(), r);
            float x = cWidth / 2.0f - (float)r.width() / 2.0f - (float)r.left;
            float y = cHeight / 2.0f + (float)r.height() / 2.0f - (float)r.bottom;
            c.drawText(this.text, rect.left + x, rect.top + y, p);
            this.clickRegion = rect;
            this.position = pos;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/airwallex/android/view/PaymentMethodSwipeCallback$UnderlayButtonClickListener;", "", "onClick", "", "position", "", "airwallex_release"})
    public static interface UnderlayButtonClickListener {
        public void onClick(int var1);
    }
}

