/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view.inputs;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import androidx.appcompat.R;
import com.airwallex.android.R;
import com.airwallex.android.view.CardBrand;
import com.airwallex.android.view.inputs.CardNumberEditText;
import com.airwallex.android.view.util.CardUtils;
import com.google.android.material.textfield.TextInputEditText;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010*\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020\fH\u0002J-\u0010-\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b1R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR7\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0012\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\f0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010&R(\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000e\"\u0004\b)\u0010\u0010\u00a8\u00063"}, d2={"Lcom/airwallex/android/view/inputs/CardNumberEditText;", "Lcom/google/android/material/textfield/TextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "brandChangeCallback", "Lkotlin/Function1;", "Lcom/airwallex/android/view/CardBrand;", "", "getBrandChangeCallback$airwallex_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$airwallex_release", "(Lkotlin/jvm/functions/Function1;)V", "cardNumber", "", "getCardNumber$airwallex_release", "()Ljava/lang/String;", "completionCallback", "Lkotlin/Function0;", "getCompletionCallback$airwallex_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$airwallex_release", "(Lkotlin/jvm/functions/Function0;)V", "errorCallback", "Lkotlin/ParameterName;", "name", "errorMessage", "getErrorCallback$airwallex_release", "setErrorCallback$airwallex_release", "ignoreTextChanges", "", "validationMessage", "getValidationMessage$airwallex_release", "setValidationMessage$airwallex_release", "(Ljava/lang/String;)V", "validationMessageCallback", "getValidationMessageCallback$airwallex_release", "setValidationMessageCallback$airwallex_release", "createFormattedNumber", "cardBrand", "listenForTextChanges", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "updateSelectionIndex$airwallex_release", "Companion", "airwallex_release"})
public final class CardNumberEditText
extends TextInputEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Function1<? super String, String> validationMessageCallback;
    @NotNull
    private Function1<? super CardBrand, Unit> brandChangeCallback;
    @NotNull
    private Function1<? super String, Unit> errorCallback;
    @NotNull
    private Function0<Unit> completionCallback;
    @Nullable
    private String validationMessage;
    private boolean ignoreTextChanges;
    private static final int BRAND_PREFIX_LENGTH = 4;
    private static final int INPUT_MAX_LENGTH = CardBrand.Unknown.getSpacingPattern().size() - 1 + CardUtils.INSTANCE.getMaxCardNumberLength();

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.validationMessageCallback = validationMessageCallback.1.INSTANCE;
        this.brandChangeCallback = brandChangeCallback.1.INSTANCE;
        this.errorCallback = errorCallback.1.INSTANCE;
        this.completionCallback = completionCallback.1.INSTANCE;
        this.validationMessage = this.getResources().getString(R.string.airwallex_empty_card_number);
        this.setMaxLines(1);
        InputFilter[] inputFilterArray = new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(INPUT_MAX_LENGTH)};
        this.setFilters(inputFilterArray);
        this.setInputType(2);
        this.listenForTextChanges();
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final Function1<String, String> getValidationMessageCallback$airwallex_release() {
        return this.validationMessageCallback;
    }

    public final void setValidationMessageCallback$airwallex_release(@NotNull Function1<? super String, String> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.validationMessageCallback = function1;
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$airwallex_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$airwallex_release(@NotNull Function1<? super CardBrand, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.brandChangeCallback = function1;
    }

    @NotNull
    public final Function1<String, Unit> getErrorCallback$airwallex_release() {
        return this.errorCallback;
    }

    public final void setErrorCallback$airwallex_release(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.errorCallback = function1;
    }

    @Nullable
    public final String getCardNumber$airwallex_release() {
        String string2;
        if (this.validationMessage == null) {
            Editable editable = this.getText();
            String string3 = editable != null ? editable.toString() : null;
            if (string3 == null) {
                string3 = "";
            }
            string2 = CardUtils.INSTANCE.removeSpacesAndHyphens(string3);
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$airwallex_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$airwallex_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    @Nullable
    public final String getValidationMessage$airwallex_release() {
        return this.validationMessage;
    }

    public final void setValidationMessage$airwallex_release(@Nullable String string2) {
        this.validationMessage = string2;
    }

    public final int updateSelectionIndex$airwallex_release(@NotNull CardBrand cardBrand, int newLength, int editActionStart, int editActionAddition) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardBrand), (String)"cardBrand");
        int gapsJumped = 0;
        boolean skipBack = false;
        Iterable $this$forEach$iv = CardUtils.INSTANCE.getSpacePositions(cardBrand);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int gap = ((Number)element$iv).intValue();
            boolean bl = false;
            if (editActionStart <= gap && editActionStart + editActionAddition > gap) {
                ++gapsJumped;
            }
            if (editActionAddition != 0 || editActionStart != gap + 1) continue;
            skipBack = true;
        }
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newLength ? newPosition : newLength;
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(this){
            private int latestChangeStart;
            private int latestInsertionSize;
            @Nullable
            private Integer cursorPosition;
            @Nullable
            private String formattedNumber;
            @NotNull
            private CardBrand currentBrand;
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                this.currentBrand = CardBrand.Unknown;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                if (!CardNumberEditText.access$getIgnoreTextChanges$p(this.this$0)) {
                    this.latestChangeStart = start;
                    this.latestInsertionSize = after;
                }
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                String inputText;
                if (CardNumberEditText.access$getIgnoreTextChanges$p(this.this$0)) {
                    return;
                }
                CharSequence charSequence = s;
                String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
                if (string2 == null) {
                    string2 = inputText = "";
                }
                if (start > CardUtils.INSTANCE.getMaxCardNumberLength()) {
                    return;
                }
                if (start < 4) {
                    CardBrand brand;
                    this.currentBrand = brand = CardUtils.INSTANCE.getPossibleCardBrand(inputText, true);
                    this.this$0.getBrandChangeCallback$airwallex_release().invoke((Object)((Object)brand));
                }
                String string3 = CardUtils.INSTANCE.removeSpacesAndHyphens(inputText);
                if (string3 == null) {
                    return;
                }
                String spaceLessNumber = string3;
                String formatNumber = CardNumberEditText.access$createFormattedNumber(this.this$0, spaceLessNumber, this.currentBrand);
                this.cursorPosition = this.this$0.updateSelectionIndex$airwallex_release(this.currentBrand, formatNumber.length(), this.latestChangeStart, this.latestInsertionSize);
                this.formattedNumber = formatNumber;
            }

            public void afterTextChanged(@Nullable Editable s) {
                String cardNumber;
                if (CardNumberEditText.access$getIgnoreTextChanges$p(this.this$0)) {
                    return;
                }
                CardNumberEditText.access$setIgnoreTextChanges$p(this.this$0, true);
                if (this.formattedNumber != null) {
                    this.this$0.setText(this.formattedNumber);
                    Integer n = this.cursorPosition;
                    if (n != null) {
                        Integer n2 = n;
                        CardNumberEditText cardNumberEditText = this.this$0;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        cardNumberEditText.setSelection(it);
                    }
                }
                this.formattedNumber = null;
                this.cursorPosition = null;
                CardNumberEditText.access$setIgnoreTextChanges$p(this.this$0, false);
                Editable editable = this.this$0.getText();
                String string2 = editable != null ? editable.toString() : null;
                if (string2 == null) {
                    string2 = "";
                }
                if (CardUtils.INSTANCE.isValidCardLength$airwallex_release(cardNumber = string2, true) || cardNumber.length() == CardNumberEditText.access$getINPUT_MAX_LENGTH$cp()) {
                    String previousMessage = this.this$0.getValidationMessage$airwallex_release();
                    this.this$0.setValidationMessage$airwallex_release((String)this.this$0.getValidationMessageCallback$airwallex_release().invoke((Object)cardNumber));
                    this.this$0.getErrorCallback$airwallex_release().invoke((Object)this.this$0.getValidationMessage$airwallex_release());
                    if (previousMessage != null && this.this$0.getValidationMessage$airwallex_release() == null) {
                        this.this$0.getCompletionCallback$airwallex_release().invoke();
                    }
                } else {
                    this.this$0.setValidationMessage$airwallex_release((String)this.this$0.getValidationMessageCallback$airwallex_release().invoke((Object)cardNumber));
                    this.this$0.getErrorCallback$airwallex_release().invoke(null);
                }
            }
        });
    }

    private final String createFormattedNumber(String cardNumber, CardBrand cardBrand) {
        String formattedNumber = null;
        formattedNumber = cardNumber;
        Set<Integer> spacePositions = CardUtils.INSTANCE.getSpacePositions(cardBrand);
        Iterable $this$forEach$iv = spacePositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int index = ((Number)element$iv).intValue();
            boolean bl = false;
            if (formattedNumber.length() <= index) continue;
            String string2 = formattedNumber;
            CharSequence charSequence = " ";
            formattedNumber = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)index, (int)index, (CharSequence)charSequence)).toString();
        }
        return formattedNumber;
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreTextChanges$p(CardNumberEditText $this) {
        return $this.ignoreTextChanges;
    }

    public static final /* synthetic */ String access$createFormattedNumber(CardNumberEditText $this, String cardNumber, CardBrand cardBrand) {
        return $this.createFormattedNumber(cardNumber, cardBrand);
    }

    public static final /* synthetic */ void access$setIgnoreTextChanges$p(CardNumberEditText $this, boolean bl) {
        $this.ignoreTextChanges = bl;
    }

    public static final /* synthetic */ int access$getINPUT_MAX_LENGTH$cp() {
        return INPUT_MAX_LENGTH;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/airwallex/android/view/inputs/CardNumberEditText$Companion;", "", "()V", "BRAND_PREFIX_LENGTH", "", "INPUT_MAX_LENGTH", "airwallex_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

