/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view.util;

import com.airwallex.android.view.CardBrand;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\bJ!\u0010\u0010\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0017\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/airwallex/android/view/util/CardUtils;", "", "()V", "maxCardNumberLength", "", "getMaxCardNumberLength", "()I", "getPossibleCardBrand", "Lcom/airwallex/android/view/CardBrand;", "cardNumber", "", "shouldNormalize", "", "getSpacePositions", "", "cardBrand", "isValidCardLength", "isValidCardLength$airwallex_release", "isValidCardNumber", "isValidLuhnNumber", "number", "isValidLuhnNumber$airwallex_release", "removeSpacesAndHyphens", "cardNumberWithSpaces", "airwallex_release"})
public final class CardUtils {
    @NotNull
    public static final CardUtils INSTANCE = new CardUtils();
    private static final int maxCardNumberLength;

    private CardUtils() {
    }

    public final int getMaxCardNumberLength() {
        return maxCardNumberLength;
    }

    public final boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = this.removeSpacesAndHyphens(cardNumber);
        return this.isValidLuhnNumber$airwallex_release(normalizedNumber) && CardUtils.isValidCardLength$airwallex_release$default(this, normalizedNumber, false, 2, null);
    }

    public final boolean isValidLuhnNumber$airwallex_release(@Nullable String number) {
        if (number == null) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; -1 < index; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            isOdd = !isOdd;
            int digitInteger = Character.getNumericValue(c);
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    public final boolean isValidCardLength$airwallex_release(@Nullable String cardNumber, boolean shouldNormalize) {
        boolean bl;
        if (cardNumber == null) {
            return false;
        }
        String normalizeCardNumber = shouldNormalize ? this.removeSpacesAndHyphens(cardNumber) : cardNumber;
        CardBrand brand = this.getPossibleCardBrand(normalizeCardNumber, false);
        if (WhenMappings.$EnumSwitchMapping$0[brand.ordinal()] == 1) {
            bl = false;
        } else {
            IntRange intRange = brand.getLengthRange();
            String string2 = normalizeCardNumber;
            Integer n = string2 != null ? Integer.valueOf(string2.length()) : null;
            bl = n != null && intRange.contains(n.intValue());
        }
        return bl;
    }

    public static /* synthetic */ boolean isValidCardLength$airwallex_release$default(CardUtils cardUtils, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cardUtils.isValidCardLength$airwallex_release(string2, bl);
    }

    @NotNull
    public final CardBrand getPossibleCardBrand(@Nullable String cardNumber, boolean shouldNormalize) {
        CharSequence charSequence = cardNumber;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CardBrand.Unknown;
        }
        String normalizeCardNumber = shouldNormalize ? this.removeSpacesAndHyphens(cardNumber) : cardNumber;
        return CardBrand.Companion.fromCardNumber(normalizeCardNumber);
    }

    @Nullable
    public final String removeSpacesAndHyphens(@Nullable String cardNumberWithSpaces) {
        String string2;
        String string3;
        CharSequence charSequence;
        String it = charSequence = cardNumberWithSpaces;
        boolean bl = false;
        CharSequence charSequence2 = it;
        String string4 = string3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? charSequence : null;
        if (string3 != null) {
            charSequence = string3;
            Regex regex = new Regex("\\s|-");
            String string5 = "";
            string2 = regex.replace(charSequence, string5);
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final Set<Integer> getSpacePositions(@NotNull CardBrand cardBrand) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardBrand), (String)"cardBrand");
        Set spacePostions = new LinkedHashSet();
        int lastPosition = 0;
        for (int spaceIndex = 0; spaceIndex < cardBrand.getSpacingPattern().size() - 1; ++spaceIndex) {
            lastPosition += ((Number)cardBrand.getSpacingPattern().get(spaceIndex)).intValue();
            if (spaceIndex > 0) {
                ++lastPosition;
            }
            spacePostions.add(lastPosition);
        }
        return spacePostions;
    }

    static {
        CardBrand[] cardBrandArray = CardBrand.values();
        if (cardBrandArray.length == 0) {
            throw new NoSuchElementException();
        }
        CardBrand it = cardBrandArray[0];
        boolean bl = false;
        int n = it.getLengthRange().getLast();
        IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((Object[])cardBrandArray)).iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.nextInt();
            CardBrand it2 = cardBrandArray[n2];
            $i$a$-maxOf-CardUtils$maxCardNumberLength$1 = false;
            int n3 = it2.getLengthRange().getLast();
            if (n >= n3) continue;
            n = n3;
        }
        maxCardNumberLength = n;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardBrand.values().length];
            try {
                nArray[CardBrand.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

