/*
 * Decompiled with CFR 0.152.
 */
package com.airwallex.android.view.util;

import androidx.annotation.Size;
import java.util.Calendar;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\tJ%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/airwallex/android/view/util/ExpiryDateUtils;", "", "()V", "MAX_VALID_YEAR", "", "isExpiryDateValid", "", "expiryMonth", "expiryYear", "isExpiryDateValid$airwallex_release", "calendar", "Ljava/util/Calendar;", "isValidMonth", "monthString", "", "separateDateInput", "", "expiryInput", "(Ljava/lang/String;)[Ljava/lang/String;", "airwallex_release"})
public final class ExpiryDateUtils {
    @NotNull
    public static final ExpiryDateUtils INSTANCE = new ExpiryDateUtils();
    private static final int MAX_VALID_YEAR = 99;

    private ExpiryDateUtils() {
    }

    public final boolean isValidMonth(@Nullable String monthString) {
        boolean bl;
        try {
            IntRange intRange = new IntRange(1, 12);
            String string2 = monthString;
            Integer n = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
            bl = n != null && intRange.contains(n.intValue());
        }
        catch (NumberFormatException numEx) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String[] separateDateInput(@Size(max=4L) @NotNull String expiryInput) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)expiryInput, (String)"expiryInput");
        if (expiryInput.length() >= 2) {
            Object[] objectArray = new String[2];
            Intrinsics.checkNotNullExpressionValue((Object)expiryInput.substring(0, 2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)expiryInput.substring(2), (String)"this as java.lang.String).substring(startIndex)");
            Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            stringArray = stringArray2;
        } else {
            Object $this$toTypedArray$iv = new String[]{expiryInput, ""};
            $this$toTypedArray$iv = CollectionsKt.listOf((Object[])$this$toTypedArray$iv);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public final boolean isExpiryDateValid$airwallex_release(int expiryMonth, int expiryYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance()");
        return this.isExpiryDateValid$airwallex_release(expiryMonth, expiryYear, calendar);
    }

    public final boolean isExpiryDateValid$airwallex_release(int expiryMonth, int expiryYear, @NotNull Calendar calendar) {
        int readableMonth;
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        if (expiryMonth < 1 || expiryMonth > 12) {
            return false;
        }
        if (expiryYear < 0 || expiryYear > 99) {
            return false;
        }
        int currentYear = calendar.get(1) % 100;
        return expiryYear < currentYear ? false : (expiryYear > currentYear ? true : expiryMonth >= (readableMonth = calendar.get(2) + 1));
    }
}

