/*
 * Decompiled with CFR 0.152.
 */
package io.github.alaugks.spring.messagesource.catalog;

import io.github.alaugks.spring.messagesource.catalog.TransUnitsCatalog;
import io.github.alaugks.spring.messagesource.catalog.catalog.Catalog;
import io.github.alaugks.spring.messagesource.catalog.catalog.CatalogCache;
import io.github.alaugks.spring.messagesource.catalog.catalog.CatalogInterface;
import io.github.alaugks.spring.messagesource.catalog.records.TransUnitInterface;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;

public class CatalogMessageSourceBuilder
extends AbstractMessageSource {
    private final CatalogInterface catalog;

    private CatalogMessageSourceBuilder(CatalogInterface catalog) {
        this.catalog = catalog;
    }

    public static Builder builder(List<TransUnitInterface> transUnits, Locale defaultLocale) {
        Assert.notNull(transUnits, (String)"Argument transUnits must not be null");
        return CatalogMessageSourceBuilder.builder(new TransUnitsCatalog(transUnits), defaultLocale);
    }

    public static Builder builder(CatalogInterface catalogSource, Locale defaultLocale) {
        Assert.notNull((Object)catalogSource, (String)"Argument catalogSource must not be null");
        return new Builder(catalogSource, defaultLocale);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        String value = this.catalog.resolveCode(code, locale);
        if (value != null) {
            return new MessageFormat(value, locale);
        }
        return null;
    }

    public static final class Builder {
        private final Locale defaultLocale;
        private final CatalogInterface catalogSource;
        private String defaultDomain = "messages";

        public Builder(CatalogInterface catalogSource, Locale defaultLocale) {
            Assert.notNull((Object)defaultLocale, (String)"Argument defaultLocale must not be null");
            this.catalogSource = catalogSource;
            this.defaultLocale = defaultLocale;
        }

        public Builder defaultDomain(String defaultDomain) {
            Assert.notNull((Object)defaultDomain, (String)"Argument defaultDomain must not be null");
            this.defaultDomain = defaultDomain;
            return this;
        }

        public CatalogMessageSourceBuilder build() {
            CatalogCache catalogChain = new CatalogCache();
            catalogChain.nextCatalog(new Catalog(this.defaultLocale, this.defaultDomain)).nextCatalog(this.catalogSource);
            catalogChain.build();
            return new CatalogMessageSourceBuilder(catalogChain);
        }
    }
}

