/*
 * Decompiled with CFR 0.152.
 */
package io.github.alaugks.spring.messagesource.catalog.catalog;

import io.github.alaugks.spring.messagesource.catalog.catalog.AbstractCatalog;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class CatalogCache
extends AbstractCatalog {
    private final Map<Locale, Map<String, String>> cacheMap = new ConcurrentHashMap<Locale, Map<String, String>>();

    @Override
    public String resolveCode(String code, Locale locale) {
        if (locale.toString().isEmpty() || code.isEmpty()) {
            return null;
        }
        Optional<String> value = this.resolveFromCacheMap(code, locale);
        if (value.isPresent()) {
            return value.get();
        }
        String resolvedValue = super.resolveCode(code, locale);
        this.put(locale, code, resolvedValue);
        return resolvedValue;
    }

    @Override
    public void build() {
        super.build();
        super.getTransUnits().forEach(t -> {
            if (Objects.equals(t.domain(), "messages")) {
                this.put(t.locale(), t.code(), t.value());
            }
            this.put(t.locale(), CatalogCache.concatCode(t.domain(), t.code()), t.value());
        });
    }

    private Optional<String> resolveFromCacheMap(String code, Locale locale) {
        Map<String, String> map = this.cacheMap.get(locale);
        if (map != null) {
            return Optional.ofNullable(map.get(code));
        }
        return Optional.empty();
    }

    private void put(Locale locale, String code, String targetValue) {
        if (targetValue != null) {
            this.cacheMap.computeIfAbsent(locale, l -> new ConcurrentHashMap()).put(code, targetValue);
        }
    }
}

