/*
 * Decompiled with CFR 0.152.
 */
package io.github.alaugks.spring.messagesource.catalog.records;

import io.github.alaugks.spring.messagesource.catalog.exception.CatalogMessageSourceRuntimeException;
import java.util.IllformedLocaleException;
import java.util.Locale;

public record Filename(String domain, String language, String region) {
    public boolean hasLocale() {
        Locale locale = this.locale();
        return locale != null && !locale.toString().isEmpty();
    }

    public Locale locale() {
        try {
            if (this.language != null && !this.language.isEmpty()) {
                Locale.Builder localeBuilder = new Locale.Builder();
                localeBuilder.setLanguage(this.language);
                if (this.region != null && !this.region.isEmpty()) {
                    localeBuilder.setRegion(this.region);
                }
                return localeBuilder.build();
            }
            return null;
        }
        catch (IllformedLocaleException e) {
            throw new CatalogMessageSourceRuntimeException(e);
        }
    }
}

