/*
 * Decompiled with CFR 0.152.
 */
package io.github.alaugks.spring.messagesource.catalog.resources;

import io.github.alaugks.spring.messagesource.catalog.exception.CatalogMessageSourceRuntimeException;
import io.github.alaugks.spring.messagesource.catalog.records.Filename;
import io.github.alaugks.spring.messagesource.catalog.records.TranslationFile;
import io.github.alaugks.spring.messagesource.catalog.resources.LocationPattern;
import io.github.alaugks.spring.messagesource.catalog.resources.ResourcesFileNameParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class ResourcesLoader {
    private final Locale defaultLocale;
    private final Set<String> locationPatterns;
    private final List<String> fileExtensions;

    public ResourcesLoader(Locale defaultLocale, LocationPattern locationPattern, List<String> fileExtensions) {
        this(defaultLocale, locationPattern.getLocationPatterns(), fileExtensions);
    }

    @Deprecated(since="0.6.0")
    public ResourcesLoader(Locale defaultLocale, Set<String> locationPatterns, List<String> fileExtensions) {
        Assert.notNull((Object)defaultLocale, (String)"Argument defaultLocale must not be null");
        Assert.notNull(locationPatterns, (String)"Argument locationPatterns must not be null");
        Assert.notNull(fileExtensions, (String)"Argument fileExtensions must not be null");
        this.defaultLocale = defaultLocale;
        this.locationPatterns = locationPatterns;
        this.fileExtensions = fileExtensions;
    }

    public List<TranslationFile> getTranslationFiles() {
        try {
            ArrayList<TranslationFile> files = new ArrayList<TranslationFile>();
            PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
            for (String locationPattern : this.locationPatterns) {
                Resource[] resources;
                for (Resource resource : resources = resourceLoader.getResources(locationPattern)) {
                    TranslationFile translationFile;
                    if (!this.isFileExtensionSupported(resource) || (translationFile = this.parseFileName(resource)) == null) continue;
                    files.add(translationFile);
                }
            }
            return files;
        }
        catch (IOException e) {
            throw new CatalogMessageSourceRuntimeException(e);
        }
    }

    private TranslationFile parseFileName(Resource resource) throws IOException {
        Filename filename = new ResourcesFileNameParser(resource.getFilename()).parse();
        if (filename != null) {
            return new TranslationFile(filename.domain(), filename.hasLocale() ? filename.locale() : this.defaultLocale, resource.getInputStream());
        }
        return null;
    }

    private boolean isFileExtensionSupported(Resource resource) {
        String fileName = resource.getFilename();
        if (fileName == null) {
            return false;
        }
        return this.fileExtensions.contains(fileName.substring(fileName.lastIndexOf(".") + 1));
    }
}

