/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.util.logging.LoggerFactory;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class DisplayThreadExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DisplayThreadExecutor.class);
    private final Widget widget;
    private final Mode mode;

    public DisplayThreadExecutor(Widget widget, Mode mode) {
        if (widget == null) {
            throw new NullPointerException("widget cannot be null");
        }
        if (mode == null) {
            throw new NullPointerException("mode cannot be null");
        }
        this.widget = widget;
        this.mode = mode;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void onError(Exception e) {
        if (e != null && !(e instanceof SWTException)) {
            log.log(Level.SEVERE, "Error in SWT thread:", e);
        }
    }

    @Override
    public void execute(final Runnable command) {
        if (this.widget != null) {
            try {
                if (this.widget.getDisplay().equals(Display.getCurrent())) {
                    command.run();
                } else {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                command.run();
                            }
                            catch (RuntimeException e) {
                                DisplayThreadExecutor.this.onError(e);
                            }
                        }
                    };
                    switch (this.mode) {
                        case ASYNC: {
                            this.widget.getDisplay().asyncExec(runnable);
                            break;
                        }
                        case SYNC: {
                            this.widget.getDisplay().syncExec(runnable);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Invalid mode: " + (Object)((Object)this.mode));
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                this.onError(e);
            }
        }
    }

    public static enum Mode {
        SYNC,
        ASYNC;

    }
}

