/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.util.ExceptionUtils;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class EnhancedErrorDialog
extends ErrorDialog {
    private static final Logger log = LoggerFactory.getLogger(EnhancedErrorDialog.class);
    private static final String NESTING_INDENT = "  ";
    private final Image[] images;

    public EnhancedErrorDialog(Shell parent, String title, String message, IStatus status, int displayMask, Image ... images) {
        super(parent, title, message, status, displayMask);
        this.message = message == null ? status.getMessage() : JFaceMessages.get("lbl.error.dialog.reason", message, status.getMessage());
        this.images = images;
    }

    public static int openError(Shell parent, String title, String message, IStatus status, int displayMask, Image ... images) {
        return new EnhancedErrorDialog(parent, title, message, status, displayMask, images).open();
    }

    public EnhancedErrorDialog(Shell parent, String title, String message, int severity, Throwable throwable, Image ... images) {
        this(parent, title, message, (IStatus)EnhancedErrorDialog.createMultiStatus(severity, throwable), images);
    }

    public static int openError(Shell parent, String title, String message, int severity, Throwable throwable, Image ... images) {
        return new EnhancedErrorDialog(parent, title, message, severity, throwable, images).open();
    }

    public EnhancedErrorDialog(Shell parent, String title, String message, IStatus status, Image ... images) {
        this(parent, title, message, status, 7, images);
    }

    public static int openError(Shell parent, String title, String message, IStatus status, Image ... images) {
        return new EnhancedErrorDialog(parent, title, message, status, images).open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.images != null && this.images.length > 0) {
            shell.setImages(this.images);
        }
    }

    protected List createDropDownList(Composite parent) {
        List list = super.createDropDownList(parent);
        if (list.getMenu() != null) {
            for (final MenuItem item : list.getMenu().getItems()) {
                if (!item.getText().equals(JFaceResources.getString((String)"copy"))) continue;
                item.setText(JFaceMessages.get("lbl.menu.item.copy") + SwtUtils.getMod1ShortcutLabel('c'));
                item.setAccelerator(SWT.MOD1 | 0x63);
                list.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (SWT.MOD1 == e.stateMask && 99 == e.keyCode) {
                            e.doit = false;
                            item.notifyListeners(13, null);
                        }
                    }
                });
                break;
            }
        }
        return list;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceMessages.get("lbl.button.ok"), true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        super.createDetailsButton(parent);
        if (this.shouldShowDetailsButton()) {
            final Button detailsButton = this.getButton(13);
            this.localizeDetailsButton(detailsButton);
            detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    EnhancedErrorDialog.this.localizeDetailsButton(detailsButton);
                }
            });
        }
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            Button detailsButton = this.getButton(id);
            if (detailsButton != null && !detailsButton.isDisposed()) {
                detailsButton.setRedraw(false);
            }
            super.buttonPressed(id);
            if (detailsButton != null && !detailsButton.isDisposed()) {
                detailsButton.setRedraw(true);
            }
        } else {
            super.buttonPressed(id);
        }
    }

    protected void localizeDetailsButton(Button detailsButton) {
        if (!detailsButton.isDisposed()) {
            if (IDialogConstants.SHOW_DETAILS_LABEL.equals(detailsButton.getText())) {
                detailsButton.setText(JFaceMessages.get("lbl.button.details.show"));
            } else if (IDialogConstants.HIDE_DETAILS_LABEL.equals(detailsButton.getText())) {
                detailsButton.setText(JFaceMessages.get("lbl.button.details.hide"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiStatus createMultiStatus(int severity, Throwable throwable) {
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        if (throwable != null) {
            StringReader sr = null;
            BufferedReader br = null;
            try {
                String line;
                sr = new StringReader(ExceptionUtils.getStackTrace(throwable));
                br = new BufferedReader(sr);
                while ((line = br.readLine()) != null) {
                    Status status = new Status(severity, throwable.getClass().getName(), line.replace("\t", NESTING_INDENT));
                    childStatuses.add(status);
                }
            }
            catch (IOException e) {
                try {
                    log.log(Level.WARNING, "An error occurred while collecting statuses:", e);
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(br, sr);
                    throw throwable2;
                }
                IOUtils.closeQuietly(br, sr);
            }
            IOUtils.closeQuietly(br, sr);
        }
        return new MultiStatus(EnhancedErrorDialog.class.getPackage().getName(), severity, childStatuses.toArray(new IStatus[childStatuses.size()]), String.valueOf(throwable), throwable);
    }
}

