/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.eclipse.swt.widgets.Event;

public class Events {
    private static final String EVENT_NAMES_RESOURCE_NAME = "event-names.properties";
    private static final Properties eventNames = new Properties();

    private Events() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static String getName(int type) {
        return eventNames.getProperty(Integer.toString(type));
    }

    @Nullable
    public static String getName(@Nullable Event event) {
        return event != null ? Events.getName(event.type) : null;
    }

    static {
        InputStream is = null;
        try {
            is = Events.class.getResourceAsStream(EVENT_NAMES_RESOURCE_NAME);
            eventNames.load(is);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Events.class).log(Level.WARNING, "Unable to load resource event-names.properties", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
    }
}

