/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import java.util.Arrays;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class Formatter {
    private static final char SAMPLE_CHAR = '9';
    private final String symbolicName;

    public Formatter(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public Formatter(Class<?> clazz) {
        this.symbolicName = clazz.getName();
    }

    public void updateFontStyle(Text text, Object defaultValue) {
        this.updateFontStyle(text, String.valueOf(defaultValue));
    }

    public void updateFontStyle(Text text, String defaultValue) {
        this.updateFontStyle((Control)text, defaultValue, text.getText());
    }

    public void updateFontStyle(Control control, String defaultValue, String actualValue) {
        if (this.checkControl(control)) {
            if (!defaultValue.equals(actualValue)) {
                this.setBoldFontStyle(control);
            } else {
                this.setNormalFontStyle(control);
            }
        }
    }

    private boolean checkControl(Control control) {
        return control != null && !control.isDisposed() && control.getFont() != null && !control.getFont().isDisposed() && control.getFont().getFontData() != null && control.getFont().getFontData().length != 0;
    }

    public void setNormalFontStyle(Control control) {
        this.registerFont(control);
        Font normal = JFaceResources.getFontRegistry().get(this.symbolicName);
        if (!Arrays.equals(normal.getFontData(), control.getFont().getFontData())) {
            control.setFont(normal);
            this.fixTextControlHeight(control);
        }
    }

    public void setBoldFontStyle(Control control) {
        this.registerFont(control);
        Font bold = JFaceResources.getFontRegistry().getBold(this.symbolicName);
        if (!Arrays.equals(bold.getFontData(), control.getFont().getFontData())) {
            control.setFont(bold);
            this.fixTextControlHeight(control);
        }
    }

    public int computeWidth(Control control, int size, int weight) {
        return this.computeWidth(control, size, weight, Character.toString('9'));
    }

    public int computeWidth(Control control, int size, int weight, char character) {
        return this.computeWidth(control, size, weight, Character.toString(character));
    }

    public int computeWidth(Control control, int weight, String string) {
        return this.computeWidth(control, 1, weight, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeWidth(Control control, int multiplier, int weight, String string) {
        if (control != null && !control.isDisposed()) {
            Font font = control.getFont();
            GC gc = null;
            try {
                if (weight == 1) {
                    this.setBoldFontStyle(control);
                } else {
                    this.setNormalFontStyle(control);
                }
                gc = new GC((Drawable)control);
                gc.setFont(control.getFont());
                Point extent = gc.textExtent(string);
                int n = (int)((double)(multiplier * extent.x) * 1.1);
                return n;
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                control.setFont(font);
            }
        }
        return -1;
    }

    private void registerFont(Control control) {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        if (!fontRegistry.hasValueFor(this.symbolicName)) {
            fontRegistry.put(this.symbolicName, control.getFont().getFontData());
        }
    }

    private void fixTextControlHeight(Control control) {
        if (Util.isCocoa() && control instanceof Text) {
            control.getParent().layout(new Control[]{control});
        }
    }
}

